/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.SafeClock;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import java.awt.Robot;
import utils.ostools.OS;

public class DoubleClickSimulator {
    private boolean nativeForOSX = false;
    long mostRecentMouseDown = 0L;
    long mostRecentMouseUp = 0L;

    private static boolean isAppleJVM() {
        String value = System.getProperty("java.vendor");
        if (value != null && value.toLowerCase().contains("apple")) {
            return true;
        }
        value = System.getProperty("java.vm.vendor");
        return value != null && value.toLowerCase().contains("apple");
    }

    public static boolean useNativeMouseEventsForOSX() {
        if (!OS.isMacOS()) {
            return false;
        }
        if (DoubleClickSimulator.isAppleJVM()) {
            return false;
        }
        String user = System.getProperty("user.name");
        return user != null && user.equals("root");
    }

    public boolean isUsingOSXNative() {
        return this.nativeForOSX;
    }

    public DoubleClickSimulator() {
        if (OS.isMacOS()) {
            this.nativeForOSX = DoubleClickSimulator.useNativeMouseEventsForOSX();
            System.out.println("[DoubleClickSimulator] Using native for OS X is " + this.nativeForOSX);
        }
    }

    public void mouseDown(NativeUtils nutils, Robot robot, long doubleClickTime, int buttons, int nativebuttons, boolean isDoubleClick) {
        long doubleClickOkTime = 0L;
        long doubleClickSimulateAfter = 0L;
        if (isDoubleClick) {
            doubleClickOkTime = this.mostRecentMouseDown + doubleClickTime;
            doubleClickSimulateAfter = this.mostRecentMouseUp + doubleClickTime;
            doubleClickOkTime -= 100L;
            doubleClickSimulateAfter += 100L;
        }
        this.mostRecentMouseDown = SafeClock.currentTimeMillis();
        long mustWait = this.mostRecentMouseUp + 130L - this.mostRecentMouseDown;
        if (mustWait > 0L) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] 2nd down stroke has come too fast, must delay it by " + mustWait);
            }
            try {
                Thread.sleep(mustWait);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int clicks = 1;
        if (isDoubleClick) {
            long tnow;
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] double click is required");
            }
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] consecutive clicks must be within " + doubleClickTime);
            }
            if ((tnow = SafeClock.currentTimeMillis()) > doubleClickOkTime) {
                long waitMillis = doubleClickSimulateAfter - tnow;
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] waiting " + waitMillis + " until we can simulate a separate double click");
                }
                if (waitMillis > 0L) {
                    try {
                        Thread.sleep(waitMillis);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                clicks = 2;
            } else if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] message has been received quickly enough to serve as 2nd part of double click");
            }
        } else if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[DoubleClickSimulator] not part 2 of a double click");
        }
        for (int i = 0; i < clicks; ++i) {
            if (i > 0) {
                try {
                    Thread.sleep(130L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] issuing mouse down (" + (isDoubleClick ? "down-up-double" : "normal") + ") (" + i + "/" + clicks + ")");
            }
            if (nutils != null && nativebuttons != -1) {
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] mouseDown (native) " + nativebuttons);
                }
                nutils.mouseDown(nativebuttons);
                if (!isDoubleClick) continue;
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] mouseUp (native) - done automatically for double click - " + nativebuttons);
                }
                nutils.mouseUp(nativebuttons);
                continue;
            }
            if (this.nativeForOSX) {
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] mouseDown (nativeForOSX) " + nativebuttons);
                }
                NativeScreenUtil.getInstance().mousePressed(nativebuttons);
            } else if (robot != null) {
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] mouseDown (robot) " + buttons);
                }
                robot.mousePress(buttons);
            }
            if (!isDoubleClick) continue;
            if (this.nativeForOSX) {
                if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                    System.out.println("[DoubleClickSimulator] mouseUp (nativeForOSX) - done automatically for double click - " + nativebuttons);
                }
                NativeScreenUtil.getInstance().mouseRelease(nativebuttons);
                continue;
            }
            if (robot == null) continue;
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] mouseUp (robot) - done automatically for double click - " + buttons);
            }
            robot.mouseRelease(buttons);
        }
        if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
            System.out.println("[DoubleClickSimulator] done clicks");
        }
    }

    public void mouseUp(NativeUtils nutils, Robot robot, long doubleClickTime, int buttons, int nativebuttons) {
        if (nutils != null && nativebuttons != -1) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] mouseUp (native) " + nativebuttons);
            }
            nutils.mouseUp(nativebuttons);
        } else if (this.nativeForOSX) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] mouseUp (nativeForOSX) " + nativebuttons);
            }
            NativeScreenUtil.getInstance().mouseRelease(nativebuttons);
        } else if (robot != null) {
            if (CentralDebugging.VERBOSE_MOUSE_INPUT) {
                System.out.println("[DoubleClickSimulator] mouseUp (robot) " + buttons);
            }
            robot.mouseRelease(buttons);
        }
        this.mostRecentMouseUp = SafeClock.currentTimeMillis();
    }
}

