/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.gui;

import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.interfaces.ServerController;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.util.TranscriptSaver;
import com.aem.sdesktop.util.ui.ChatPanel;
import com.aem.sdesktop.util.ui.FinishedPanel;
import com.aem.shelp.common.CommonHelpUtil;
import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.files.FileUtil;
import utils.swing.SwingUtil;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.jdialog.MessageDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class ServerChatPanel
extends ChatPanel
implements FinishedPanel.FinishListener {
    private final CommonHelpUtil.RemoteSupportReconnectListener reconnectListener;
    private ServerController controller;
    private GbPanel button_panel_text;
    private GbPanel button_panel_notext;
    private JButton clearNoText;
    private JButton clearText;
    public JButton saveNoText;
    public JButton saveText;
    private JButton quitNoText;
    private JButton quitText;
    private int requiredWidthForTextButtons;
    private JPanel button_panel;
    private ServerUserInterface ui;
    private boolean hideChat;
    private JButton minimizeNoText;
    private JButton minimizeText;
    private FinishedPanel finishedPanel;
    private boolean isAccessSession;

    public ServerChatPanel(ServerUserInterface ui, RootPaneContainer rpc, ServerController controller, String displayName, boolean hideChat, boolean isAccessSession, CommonHelpUtil.RemoteSupportReconnectListener reconnectListener) {
        super(rpc, displayName, true);
        this.reconnectListener = reconnectListener;
        this.isAccessSession = isAccessSession;
        this.controller = controller;
        this.ui = ui;
        this.hideChat = hideChat;
        this.initServerChatPanelEventHandling();
    }

    @Override
    public void setAvatar(byte[] avatarBytes, String username, String displayName) {
        super.setAvatar(avatarBytes, username, displayName);
        this.finishedPanel.setTechnicianName(displayName);
    }

    public void showEndOfSession() {
        if (!this.isAccessSession) {
            this.chatEntryCardLayout.show(this.chatEntryCardPanel, "FINISHED");
            this.chatEntryCardPanel.repaint();
        }
    }

    public void connectionTerminated() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerChatPanel.this.showEndOfSession();
            }
        });
        this.saveNoText.setEnabled(true);
        this.saveText.setEnabled(true);
        this.quitNoText.setEnabled(false);
        this.quitText.setEnabled(false);
    }

    @Override
    public void setInputEnabled(boolean b) {
        super.setInputEnabled(b);
        this.clearNoText.setEnabled(b);
        this.clearText.setEnabled(b);
        this.saveNoText.setEnabled(b);
        this.saveText.setEnabled(b);
    }

    @Override
    protected void sendMessage(String message) {
        if (this.controller != null) {
            this.controller.broadcastMessage(message, this.displayName, "server");
        }
    }

    public void setDirty(boolean b) {
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.quitNoText = new JButton(Language.get("CLOSE_SESSION"));
        this.quitText = new JButton(Language.get("CLOSE_SESSION"));
        SHButtonUI.makeButtonRed((JButton)this.quitText);
        SHButtonUI.makeButtonRed((JButton)this.quitNoText);
        this.clearText = new JButton(Language.get("CHAT_CLEAR"));
        this.saveText = new JButton(Language.get("CHAT_TRANSCRIPT"));
        this.clearNoText = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/eraser.svg,16"));
        this.clearNoText.setToolTipText(Language.get("CHAT_CLEAR"));
        this.saveNoText = new JButton(ImageLoader.getImageIcon((String)"images/svg/computing/window-code.svg,16"));
        this.saveNoText.setToolTipText(Language.get("CHAT_TRANSCRIPT"));
        this.minimizeText = new JButton(ImageLoader.getImageIcon((String)"images/svg/computing/minimize.svg,16"));
        this.minimizeNoText = new JButton(ImageLoader.getImageIcon((String)"images/svg/computing/minimize.svg,16"));
        this.button_panel = new JPanel(new GridLayout(1, 1));
        this.button_panel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)4, (int)0));
        this.button_panel.addComponentListener(new ResizeComponentListener());
        this.button_panel.setBackground(this.getEntryPanelBackground());
        this.button_panel_notext = new GbPanel();
        this.button_panel_text = new GbPanel();
        SwingUtil.setWidth((JComponent)this.minimizeText, (int)SimpleHelpLookAndFeel.scale((int)26));
        SwingUtil.setWidth((JComponent)this.minimizeNoText, (int)SimpleHelpLookAndFeel.scale((int)26));
        this.finishedPanel = new FinishedPanel(this);
        this.finishedPanel.setBackground(this.getEntryPanelBackground());
        this.chatEntryCardPanel.add(this.finishedPanel.getRootComponent(), "FINISHED");
        if (!this.hideChat) {
            this.button_panel_text.setBackground(this.getEntryPanelBackground());
            this.button_panel_notext.setBackground(this.getEntryPanelBackground());
            this.chatEntryPanel.getRootComponent().add((Component)this.button_panel, "South");
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.clearText, this.saveText});
            SwingUtil.setSizesToWidest((JComponent[])new JComponent[]{this.clearText, this.saveText, this.quitText});
            this.button_panel_text.add((Component)this.clearText, 0, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(0, 5, 2, 0));
            this.button_panel_text.add((Component)this.saveText, 1, 0, 1, 1, 0, 0, 17, 3, (Insets)new ScaledInsets(0, 0, 2, 0));
            this.button_panel_text.add((Component)this.minimizeText, 2, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(0, 5, 2, 5));
            this.button_panel_text.add((Component)this.quitText, 3, 0, 1, 1, 1, 0, 13, 3, (Insets)new ScaledInsets(0, 0, 2, 5));
            this.requiredWidthForTextButtons = this.clearText.getPreferredSize().width * 3 + SimpleHelpLookAndFeel.scale((int)20) + this.minimizeText.getPreferredSize().width;
            SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.clearNoText, this.saveNoText});
            this.button_panel_notext.add((Component)this.clearNoText, 0, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(0, 5, 2, 0));
            this.button_panel_notext.add((Component)this.saveNoText, 1, 0, 1, 1, 0, 0, 17, 3, (Insets)new ScaledInsets(0, 0, 2, 0));
            this.button_panel_notext.add((Component)this.minimizeNoText, 2, 0, 1, 1, 0, 0, 13, 3, (Insets)new ScaledInsets(0, 5, 2, 5));
            this.button_panel_notext.add((Component)this.quitNoText, 3, 0, 1, 1, 1, 0, 13, 3, (Insets)new ScaledInsets(0, 0, 2, 5));
            this.button_panel.add((Component)this.button_panel_text);
        } else {
            this.chatEntryPanel.getRootComponent().add((Component)this.button_panel, "South");
            this.button_panel_text.add((Component)this.quitText, 1, 0, 1, 1, 1, 0, 10, 3, (Insets)new ScaledInsets(0, 0, 0, 0));
            this.requiredWidthForTextButtons = this.quitText.getPreferredSize().width + SimpleHelpLookAndFeel.scale((int)20);
            this.button_panel_notext.add((Component)this.quitNoText, 1, 0, 1, 1, 1, 0, 10, 3, (Insets)new ScaledInsets(0, 0, 0, 0));
            this.button_panel.add((Component)this.button_panel_text);
        }
    }

    protected void initServerChatPanelEventHandling() {
        ButtonActionHandler handler = new ButtonActionHandler();
        this.clearText.addActionListener(handler);
        this.clearNoText.addActionListener(handler);
        this.saveText.addActionListener(handler);
        this.saveNoText.addActionListener(handler);
        this.quitNoText.addActionListener(handler);
        this.quitText.addActionListener(handler);
        this.minimizeText.addActionListener(handler);
        this.minimizeNoText.addActionListener(handler);
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
        Language.loadTranslations();
        System.out.println("CONFIRM_CLOSE_CUSTOMER = " + Language.get("CONFIRM_CLOSE_CUSTOMER"));
        File avatarFile = new File("avatar.png");
        byte[] avatar = null;
        if (avatarFile.exists()) {
            avatar = FileUtil.readFile((File)avatarFile);
        }
        final ServerChatPanel chatPanel = new ServerChatPanel(null, null, null, null, false, false, null);
        chatPanel.setAvatar(avatar, "localhost", "localhost");
        frame.getContentPane().add(chatPanel.getRootComponent());
        frame.setVisible(true);
        new Thread(){

            @Override
            public void run() {
                chatPanel.addMessage("Customer names can also be very long especially if they are default remote access service names with all the guff", "server", "This is a very long message. The idea is that this is the sort of thing that you might see frequently when someone is unhappy.");
                boolean alternate = true;
                int alternator = 0;
                while (true) {
                    ++alternator;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!alternate) {
                        if (System.currentTimeMillis() % 5L == 0L) {
                            chatPanel.addMessage("Customer names can also be very long especially if they are default remote access service names with all the guff", "server", "This is a very long message. The idea is that this is the sort of thing that you might see frequently when someone is unhappy.");
                        } else {
                            chatPanel.addMessage("localhost", "localhost", "Customer names can also be very long especially if they are default remote access service names with all the guff. Customer names can also be very long especially if they are default remote access service names with all the guff");
                        }
                    } else if (alternator % 2 == 0) {
                        chatPanel.addMessage("Customer names can also be very long especially if they are default remote access service names with all the guff", "server", "This is a very long message. The idea is that this is the sort of thing that you might see frequently when someone is unhappy.");
                    } else {
                        chatPanel.addMessage("localhost", "localhost", "Customer names can also be very long especially if they are default remote access service names with all the guff. Customer names can also be very long especially if they are default remote access service names with all the guff");
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    System.out.println("Update is typing...");
                    String s = "w lkasjd lkajs ldjasl kdjlaks jdlaksj dlkajs ldkjasl kdjlaskj dlakjs ldkasj ldkals kdjlaksj ldkjas lkdjal ksjdlkajs ldkjals kdjla ksjooooot";
                    if (s.length() > 40) {
                        s = s.substring(0, 40);
                    }
                    chatPanel.updateIsTyping(s + " " + Language.get("IS_TYPING"));
                }
            }
        }.start();
    }

    @Override
    protected boolean isTechnicianMessage(String user_name, String host_name) {
        return !host_name.equals("server");
    }

    @Override
    public void notifyKeyTyped() {
        if (this.controller != null) {
            this.controller.notifyThatUserIsTyping(this.displayName);
        }
    }

    @Override
    public void saveTranscript() {
        TranscriptSaver.saveTranscript(this.getRootComponent(), ServerChatPanel.super.getChatDocument());
    }

    @Override
    public void reconnect() {
        this.reconnectListener.reconnect();
    }

    @Override
    public void finish() {
        if (this.rpc != null && this.rpc instanceof JFrame) {
            ((JFrame)this.rpc).setVisible(false);
        }
        this.controller.disconnect(true);
    }

    class ButtonActionHandler
    implements ActionListener {
        ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object o = e.getSource();
            if (o == ServerChatPanel.this.saveText || o == ServerChatPanel.this.saveNoText) {
                ServerChatPanel.this.saveTranscript();
            } else if (o == ServerChatPanel.this.clearText || o == ServerChatPanel.this.clearNoText) {
                ServerChatPanel.this.clearMessages();
            } else if (o == ServerChatPanel.this.quitText || o == ServerChatPanel.this.quitNoText) {
                new QuitThread(e.getSource());
            } else if ((o == ServerChatPanel.this.minimizeNoText || o == ServerChatPanel.this.minimizeText) && ServerChatPanel.this.rpc != null && ServerChatPanel.this.rpc instanceof JFrame) {
                JFrame frame = (JFrame)ServerChatPanel.this.rpc;
                int width = 300;
                int height = 400;
                frame.setSize(width, height);
                Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                Dimension dim = defaultToolkit.getScreenSize();
                Insets screenInsets = defaultToolkit.getScreenInsets(frame.getGraphicsConfiguration());
                int x = dim.width - screenInsets.right - width;
                int y = dim.height - screenInsets.bottom - height;
                frame.setLocation(x, y);
            }
        }
    }

    class QuitThread
    extends Thread {
        private Object source;

        public QuitThread(Object source) {
            this.source = source;
            this.start();
        }

        @Override
        public void run() {
            Frame frame = null;
            if (this.source instanceof Component) {
                frame = SwingUtil.getParentFrame((Component)((Component)this.source));
            }
            MessageDialog dialog = MessageDialog.getDecoratedDialog(frame, 420, Language.get("CONFIRM_CLOSE_CUSTOMER"), Language.get("CONFIRM_CLOSE_TITLE"), Language.get("CLOSE_SESSION"), Language.get("CANCEL"), ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"));
            try {
                dialog.setDialogIconImage(ClientBranding.get().getLogo32(true).getImage());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            dialog.showDialog();
            if (dialog.isOKResult()) {
                ServerChatPanel.this.controller.disconnect(false);
            }
        }
    }

    class ResizeComponentListener
    extends ComponentAdapter {
        private boolean textVisible = true;

        ResizeComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Component c = (Component)e.getSource();
            if (ServerChatPanel.this.requiredWidthForTextButtons > c.getWidth() && this.textVisible) {
                this.textVisible = false;
                ServerChatPanel.this.button_panel.removeAll();
                ServerChatPanel.this.button_panel.add((Component)ServerChatPanel.this.button_panel_notext);
                ServerChatPanel.this.button_panel.revalidate();
                ServerChatPanel.this.button_panel.repaint();
            } else if (ServerChatPanel.this.requiredWidthForTextButtons <= c.getWidth() && !this.textVisible) {
                this.textVisible = true;
                ServerChatPanel.this.button_panel.removeAll();
                ServerChatPanel.this.button_panel.add((Component)ServerChatPanel.this.button_panel_text);
                ServerChatPanel.this.button_panel.revalidate();
                ServerChatPanel.this.button_panel.repaint();
            }
        }
    }
}

