/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.gui;

import com.aem.shelp.common.Invitation;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.windows.AmIAdministrator;
import java.util.ArrayList;
import java.util.HashMap;
import utils.swing.cui.types.ResultPair;

public class ConnectionSettings {
    public static final String NULL_INVITATION_ID = "-";
    public String host = "";
    public int port = -1;
    public String url = "";
    public boolean ftp = true;
    public boolean rdp = true;
    public boolean chat = true;
    public String queuePassword;
    public String technicianFilter;
    public String technicianGroupFilter;
    public String invitationID = null;
    public String requestElevation = null;
    public boolean remoteAccessMustRequestConnection = false;
    public long remoteAccessMustRequestConnectionTimeout = 0L;
    private Customer customer;

    public ConnectionSettings(Customer customer) {
        this.customer = customer;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public String getConnectString() {
        if (this.port == -1) {
            return this.host;
        }
        return this.host + ":" + this.port;
    }

    public void setCollectedDetails(ResultPair[] result) {
        String[] keys = new String[result.length];
        String[] values = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            keys[i] = result[i].getKey();
            values[i] = result[i].getValue();
        }
        this.customer.setDetailsKeys(keys);
        this.customer.setDetailsValues(values);
    }

    public void parseAutoConnectInformation(HashMap autoparams) {
        if (autoparams == null) {
            autoparams = new HashMap();
        }
        ArrayList<ResultPair> resultPairs = new ArrayList<ResultPair>();
        for (String key : autoparams.keySet()) {
            if (key.toLowerCase().equals("queuepassword")) {
                this.queuePassword = autoparams.get("queuepassword").toString();
                continue;
            }
            String value = (String)autoparams.get(key);
            ResultPair newPair = new ResultPair(key, value);
            resultPairs.add(newPair);
        }
        ResultPair[] results = new ResultPair[resultPairs.size()];
        resultPairs.toArray(results);
        for (int i = 0; i < results.length; ++i) {
            System.out.println("[ConnectionSettings] " + results[i]);
        }
        this.setCollectedDetails(results);
    }

    public boolean shouldElevateMouseMover() {
        if (this.requestElevation == null) {
            return true;
        }
        if (this.requestElevation.equalsIgnoreCase("admin")) {
            return AmIAdministrator.amIAdministrator();
        }
        return !this.requestElevation.equalsIgnoreCase("no") && !this.requestElevation.equalsIgnoreCase("off") && !this.requestElevation.equalsIgnoreCase("false");
    }

    public void copySettingsFrom(Invitation invitation) {
        String[] keys = new String[invitation.customerDetailLabels.size()];
        String[] values = new String[invitation.customerDetailValues.size()];
        invitation.customerDetailLabels.toArray(keys);
        invitation.customerDetailValues.toArray(values);
        this.customer.setDetailsKeys(keys);
        this.customer.setDetailsValues(values);
    }
}

