/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.terminal.process.AbstractTerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.JPtyTerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.TerminalOutputHandler;
import com.aem.sdesktop.client.gui.terminal.process.TerminalProcess;
import com.aem.sdesktop.client.gui.terminal.process.WinPtyTerminalProcess;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.utils.Debugger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.ostools.OS;
import utils.switches.Switches;

public class TerminalServer
extends Thread
implements MSG,
TerminalOutputHandler {
    MessageReader min;
    MessageWriter mout;
    SDesktopServerInstance instance;
    SDesktopServerController controller;
    private ServerUserInterface sui;
    boolean die = false;
    private AbstractTerminalProcess terminalProcess;

    public void die() {
        this.die = true;
    }

    public void cleanup(boolean lastConnectionAlive) {
        this.die = true;
    }

    public TerminalServer(SDesktopServerInstance instance, ServerUserInterface sui, SDesktopServerController controller, InputStream input, OutputStream output) {
        super("TerminalServer");
        System.out.println("[TerminalServer] Initialising terminal server...");
        this.controller = controller;
        this.instance = instance;
        this.sui = sui;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        try {
            this.terminalProcess = OS.isLinux() || OS.isMacOS() ? new JPtyTerminalProcess(this) : (Switches.WINPTY_SUPPORT ? new WinPtyTerminalProcess(this, true) : new TerminalProcess(this));
        }
        catch (Throwable t) {
            System.out.println("[TerminalServer] [ERROR] Unable to start terminal server.");
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        Message m = null;
        System.out.println("[TerminalServer] Starting...");
        try {
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("TerminalServer LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[TerminalServer] " + e);
            }
            System.out.println("[TerminalServer] Connection terminated");
        }
        catch (Throwable e) {
            System.out.println("[TerminalServer] An unclassified error occurred in AsyncServer: " + Debugger.getStackTrace(e));
            System.out.println("[TerminalServer] LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public void handleMessage(Message m) {
        int type = m.getType();
        System.out.println("[TerminalServer] Received " + m);
        switch (type) {
            case 655364: {
                int cols = m.getNextInt();
                int rows = m.getNextInt();
                try {
                    this.terminalProcess.setWinSize(cols, rows);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                break;
            }
            case 655362: {
                byte[] dat = (byte[])m.get(0);
                try {
                    this.terminalProcess.writeCommand(dat);
                    break;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    @Override
    public void write(byte[] data, int off, int len) {
        System.out.println("[TerminalServer] Sending back " + len + " bytes of data");
        Message m = new Message(655363);
        m.append(data, off, len);
        try {
            this.mout.write(m);
        }
        catch (Exception x) {
            System.out.println("[TerminalServer] [ERROR] Unable to send terminal data: " + x);
        }
    }
}

