/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import bcutil.SingleStringKeyHashProvider;
import com.aem.BuildDateUtil;
import com.aem.CentralDebugging;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.common.CachedSplashLoader;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sdesktop.interfaces.ConnectionCountProvider;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerConnection;
import com.aem.sdesktop.interfaces.ServerController;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.SimpleDesktopServer;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.server.controller.ScreenServer;
import com.aem.sdesktop.server.controller.ToolServer;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.TransportCommsLine;
import com.aem.sdesktop.util.UniqueIDUtil;
import com.aem.sdesktop.util.ui.AvatarMap;
import com.aem.shelp.common.Invitation;
import com.aem.shelp.common.Language;
import com.aem.shelp.customer.MobileCustomerSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.ChainedLinkStatusListener;
import com.aem.shelp.util.PasswordStorage;
import com.aem.shelp.util.PopupNotificationWindow;
import com.aem.shelp.util.PropertiesToMessage;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.SHelpUdpNlNatHpMk2;
import com.aem.shelp.util.security.SecurityUtil;
import com.aem.utils.Debugger;
import com.aem.utils.Pair;
import com.aem.utils.StreamUtils;
import com.aem.utils.blowfish.Blowfish;
import com.aem.utils.blowfish.BlowfishDecryptionStream;
import com.aem.utils.blowfish.BlowfishEncryptionStream;
import com.aem.utils.entropy.EntropyGatherer;
import com.aem.utils.multiplex.MultiplexerInputStream;
import com.aem.utils.multiplex.MultiplexerOutputStream;
import com.aem.utils.random.GenericRandom;
import com.aem.utils.rsa.RSAEncryptor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import jwrapper.failover.FailoverMonitor;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;

public class SDesktopServerController
implements ServerController,
MSG,
ConnectionCountProvider {
    public Customer currentCustomer;
    private boolean requestedEndSession = false;
    private MobileCustomerSession mobSession;
    private int last_valid_port = 2603;
    private boolean ON = false;
    private boolean REMOTE_CONTROL = true;
    private boolean REMOTE_SERVER_CONTROL = false;
    private final Object POOL_LOCK = new Object();
    private final ArrayList<SocketServer> server_pool = new ArrayList();
    private final Object DATA_LOCK = new Object();
    private boolean ban_hosts;
    private final ArrayList<Pair> port_ranges = new ArrayList();
    private final ArrayList hosts = new ArrayList();
    private final SocketServerThreadGroup sstg = new SocketServerThreadGroup();
    private boolean mmoveRequiredButFailed = false;
    private boolean sdemoConnection = false;
    private boolean mobileConnection = false;
    private ServerUserInterface gui;
    private int waitingCount = 0;
    private final Object instances_lock = new Object();
    private final ArrayList<SDesktopServerInstance> instances = new ArrayList();
    private final ArrayList<String> regusers = new ArrayList();
    private final HashMap<String, String> userhosts = new HashMap();
    private final Object backSock_LOCK = new Object();
    private ArrayList<NodeLink> backSocks = new ArrayList();
    private boolean FTP;
    private boolean RDP;
    private boolean CHAT;
    private ConnectionSettings previousConnectionSettings;
    private NodeLinkStatusListener previousStatus;
    private NodeLinkStatusListener popupStatus;
    private final MultipleSocketLinkListener multistatus = new MultipleSocketLinkListener();
    Object banned_lock = new Object();
    HashMap banned_hosts = new HashMap();

    public String getCustomerID() {
        return this.currentCustomer.getCustomerID();
    }

    public boolean isRemoteAccessSession() {
        return this.currentCustomer.isSG();
    }

    public SDesktopServerController(ResourceBundle lang) {
    }

    @Override
    public int getFirstAccessiblePort() {
        return this.last_valid_port;
    }

    public void setMobileCustomerSession(MobileCustomerSession mobSession) {
        this.mobileConnection = mobSession != null;
        this.mobSession = mobSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image[] getWhiteboards() {
        Image[] images;
        Object object = this.instances_lock;
        synchronized (object) {
            images = new Image[this.instances.size()];
            for (int i = 0; i < images.length; ++i) {
                images[i] = this.instances.get(i).getWhiteboard();
            }
        }
        return images;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getUsers() {
        String[] users;
        Object object = this.instances_lock;
        synchronized (object) {
            users = new String[this.instances.size()];
            for (int i = 0; i < users.length; ++i) {
                users[i] = this.instances.get(i).getUser();
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getUserWhiteboard(String user) {
        Object object = this.instances_lock;
        synchronized (object) {
            for (SDesktopServerInstance instance : this.instances) {
                if (!user.equals(instance.getUser())) continue;
                return instance.getWhiteboard();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLiveConnectionCount(ServerConnection notIncluding) {
        int live = 0;
        Object object = this.instances_lock;
        synchronized (object) {
            for (SDesktopServerInstance instance : this.instances) {
                SDesktopServerInstance gsc = instance;
                if (!gsc.isAlive() || gsc == notIncluding) continue;
                ++live;
            }
        }
        return live;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConnections() {
        Object object = this.instances_lock;
        synchronized (object) {
            try {
                Object[] users = this.getRegisteredUsers();
                String[] usernames = new String[users.length];
                for (int i = 0; i < users.length; ++i) {
                    String cuser = "" + users[i];
                    usernames[i] = cuser + " (" + this.getUserHost(cuser) + ")";
                }
                this.gui.setUserList(usernames);
            }
            catch (Exception users) {
                // empty catch block
            }
            int siz = this.instances.size();
            for (int i = 0; i < this.instances.size(); ++i) {
                ServerConnection gsc = this.instances.get(i);
                if (gsc.isAlive()) continue;
                this.gui.printToConnectionLog(gsc, System.currentTimeMillis(), "connection to technician terminated");
                this.removeAndCleanup(gsc);
                --i;
            }
            if (this.instances.size() == 0 && this.waitingCount == 0) {
                if (this.waitingCount == 0) {
                    this.gui.setFinished();
                } else {
                    this.gui.setWaiting();
                }
            }
            if (this.instances.size() != siz) {
                this.gui.setCurrentConnections(this.instances);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAndCleanup(ServerConnection gsc) {
        Object object = this.instances_lock;
        synchronized (object) {
            if (gsc != null) {
                this.instances.remove(gsc);
                gsc.setWhiteboard(null);
                gsc.cleanUp();
                this.gui.setTechnicianConnectedStatus(false, gsc.getUser(), gsc.getHost(), gsc.getConnectionTime());
            }
        }
    }

    @Override
    public void broadcastMessage(String msg, String username, String hostname) {
        Message m = new Message(327681);
        m.append(msg);
        m.append(username);
        m.append(hostname);
        this.broadcastMessage(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastMessage(Message m) {
        if (CentralDebugging.CHAT_VERBOSE) {
            System.out.println("[Chat] Incoming chat message received (" + m.toString() + ")");
        }
        Object object = this.instances_lock;
        synchronized (object) {
            int siz = this.instances.size();
            try {
                if (CentralDebugging.CHAT_VERBOSE) {
                    System.out.println("[Chat] Adding to GUI");
                }
                this.gui.receiveMessage((String)m.get(0), (String)m.get(1), (String)m.get(2));
            }
            catch (Exception e) {
                Debugger.error("could not send message to server chat panel", e);
            }
            try {
                if (this.mobSession != null) {
                    this.mobSession.receiveTechMessage((String)m.get(0), (String)m.get(1), (String)m.get(2));
                }
            }
            catch (Exception x) {
                System.out.println("Error - could not send message to mobile chat panel");
            }
            for (int i = 0; i < this.instances.size(); ++i) {
                SDesktopServerInstance instance = this.instances.get(i);
                try {
                    if (CentralDebugging.CHAT_VERBOSE) {
                        System.out.println("[Chat] Notifying instance " + i);
                    }
                    instance.broadcastMessage(m);
                    continue;
                }
                catch (Throwable t) {
                    if (CentralDebugging.CHAT_VERBOSE) {
                        System.out.println("[Chat] Something bad happened: " + t.getMessage());
                    }
                    this.gui.printToConnectionLog(instance, System.currentTimeMillis(), "connection terminated");
                    this.removeAndCleanup(instance);
                    --i;
                }
            }
            if (this.instances.size() != siz) {
                if (CentralDebugging.CHAT_VERBOSE) {
                    System.out.println("[Chat] Updating current connections");
                }
                this.gui.setCurrentConnections(this.instances);
            }
            if (CentralDebugging.CHAT_VERBOSE) {
                System.out.println("[Chat] Done broadcast");
            }
        }
    }

    public void registerUser(String user, String host) {
        this.regusers.add(user);
        this.userhosts.put(user, host);
    }

    public void unregisterUser(String user) {
        this.regusers.remove(user);
        this.userhosts.remove(user);
    }

    private String getUserHost(String user) {
        if (user.equals("serveruser")) {
            return "server";
        }
        return "" + this.userhosts.get(user);
    }

    private Object[] getRegisteredUsers() {
        Object[] tmp = new Object[this.regusers.size() + 1];
        this.regusers.toArray(tmp);
        tmp[tmp.length - 1] = "serveruser";
        return tmp;
    }

    public void setGUI(ServerUserInterface gui) {
        this.gui = gui;
    }

    public void setMouseMoverFailed(boolean b) {
        this.mmoveRequiredButFailed = b;
    }

    public void setSimpleDemoConnection(boolean b) {
        this.sdemoConnection = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collapsePortRanges() {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (this.port_ranges.size() == 0) {
                return;
            }
            Collections.sort(this.port_ranges, new RangeComparator());
            Pair prev = this.port_ranges.get(0);
            for (int i = 1; i < this.port_ranges.size(); ++i) {
                Pair curr = this.port_ranges.get(i);
                if ((Integer)prev.last >= (Integer)curr.first) {
                    prev.last = Math.max((Integer)prev.last, (Integer)curr.last);
                    this.port_ranges.remove(i--);
                }
                prev = curr;
            }
        }
    }

    public void serverRestart() {
        if (this.gui != null) {
            this.gui.printToLog("Restarting server");
        }
        if (this.ON) {
            this.serverOFF();
            this.serverON();
        }
    }

    public void serverUpdate() {
        if (this.ON) {
            this.serverON();
        }
    }

    public boolean isServerON() {
        return this.ON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getServedSockets() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        Object object = this.POOL_LOCK;
        synchronized (object) {
            Object object2 = this.DATA_LOCK;
            synchronized (object2) {
                for (SocketServer server : this.server_pool) {
                    list.add(server.sport);
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopBackwardsConnection() {
        Object object = this.backSock_LOCK;
        synchronized (object) {
            System.out.println("[SDServerController] " + this.backSocks.size() + " NL connections to stop");
            for (NodeLink bs : this.backSocks) {
                System.out.println("[SDServerController] Stopping NL: " + bs);
                try {
                    bs.stop("SDServerController stop session");
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            this.backSocks = new ArrayList();
        }
    }

    public ConnectionSettings getPreviousConnectionSettings() {
        return this.previousConnectionSettings;
    }

    public NodeLinkStatusListener getPreviousStatusListener() {
        return this.previousStatus;
    }

    @Override
    public void backwardsConnection(ConnectionSettings settings, NodeLinkStatusListener status) throws Exception {
        this.stopBackwardsConnection();
        this.newBackwardsConnection(settings, status);
    }

    @Override
    public void duplicateBackwardsConnection() throws Exception {
        this.newBackwardsConnection(this.previousConnectionSettings, this.previousStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newBackwardsConnection(ConnectionSettings settings, NodeLinkStatusListener status) throws Exception, ConnectionTerminatedException {
        Object in;
        Object out;
        this.previousConnectionSettings = settings;
        this.previousStatus = status;
        this.currentCustomer = settings.getCustomer();
        this.RDP = settings.rdp;
        this.FTP = settings.ftp;
        this.CHAT = settings.chat;
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session Controller] Trying to connect to host " + settings.host + ", port " + settings.port);
        }
        System.out.println("[SDesktopServerController] Trying to connect to host " + settings.host + ", port " + settings.port);
        NodeLink sock = SHelpNodelinkConnector.getConnection(settings.host, settings.port, this.multistatus);
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session Controller] Got NodeLink connection");
        }
        this.multistatus.addNodeLink(sock);
        sock.setFriendlyName("EOL / Initial unpatched non-UDP");
        sock.addLinkStatusListener(this.multistatus);
        sock.addOutOfBandListener(new ChainedLinkStatusListener(this.multistatus, Language.get("TECHNICIAN_LINK_DOWN")));
        ServerOptions serverOptions = new ServerOptions();
        System.out.println("[SDesktopServerController] Connected OK (" + SimpleDesktopServer.callback_via_proxy_server + ")");
        BCUtil bcu = null;
        if (SimpleDesktopServer.callback_via_proxy_server) {
            this.gui.printToLog("Connected OK");
            out = sock.getOutputStream();
            StreamUtils.writeLong((OutputStream)out, BuildDateUtil.getCustMagicBuildDate());
            in = sock.getInputStream();
            try {
                if (BuildDateUtil.getCustMagicBuildDate() != StreamUtils.readLong((InputStream)in)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
            }
            System.out.println("[SDesktopServerController] Setting up encryption (BCU)");
            String pkhash = JWLaunchProperties.getProperty((String)"shpkhash");
            if (!JWLaunchProperties.isJWrapperSetup()) {
                pkhash = null;
            }
            if (pkhash != null && pkhash.length() == 0) {
                pkhash = null;
            }
            System.out.println("[SDesktopServerController] Expected server pkhash: " + pkhash);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] Doing BCUtil handshake");
            }
            bcu = new BCUtil();
            if (pkhash == null) {
                bcu.setValidHashRequired(false);
            } else {
                bcu.setClientRsaKeyPairHashNoRecovery((BCUtil.PublicKeyHashProvider)new SingleStringKeyHashProvider(pkhash));
            }
            bcu.handshake(sock.getInputStream(), sock.getOutputStream(), true, null);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] BCUtil handshake done");
            }
            System.out.println("[SDesktopServerController] Encryption set up OK");
            System.out.println("[SDesktopServerController] Invitation: " + settings.invitationID);
            Message m = new Message();
            if (settings.invitationID == null || settings.invitationID.length() == 0 || this.mobileConnection) {
                m.setType(60000);
            } else {
                m.setType(61000);
                m.append(settings.invitationID);
            }
            m.append(settings.getCustomer().toMessage());
            m.append(settings.host);
            m.append(settings.port);
            m.append(settings.url);
            m.append(settings.queuePassword);
            m.append(settings.technicianFilter);
            m.append(settings.technicianGroupFilter);
            m.append(settings.remoteAccessMustRequestConnection);
            m.append(settings.remoteAccessMustRequestConnectionTimeout);
            System.out.println("[SDesktopServerController] Sending connect request message");
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] Sending connect request message");
            }
            BCUtilMessenger.writeMsg(bcu, (OutputStream)out, m);
            ((OutputStream)out).flush();
            Message serv_info = BCUtilMessenger.readMsg(bcu, (InputStream)in);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] Got response to connect request message");
            }
            System.out.println("[SDesktopServerController] Got response to connect request");
            if (serv_info.getType() == 62000) {
                throw new BadInvitationException();
            }
            if (serv_info.getType() == 63000) {
                throw new ExpiredInvitationException();
            }
            if (serv_info.getType() == 64000) {
                throw new IncorrectPasswordException();
            }
            if (serv_info.getType() == 64100) {
                System.out.println("[SDesktopServerController] Connection request received");
                String technicianUsername = serv_info.getNextString();
                long timeout = serv_info.getNextLong();
                ImageIcon avatarIcon = null;
                try {
                    if (serv_info.hasNext()) {
                        byte[] avatar = serv_info.getNextByteArray();
                        if (avatar != null) {
                            BufferedImage avatarImage = ImageIO.read(new ByteArrayInputStream(avatar));
                            avatarImage = AvatarMap.getScaledAvatar(avatarImage);
                            avatarIcon = new ImageIcon(avatarImage);
                        } else {
                            System.out.println("[SDesktopServerController] No avatar loaded");
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println("[SDesktopServerController] Technician name is " + technicianUsername + " Timeout:" + timeout + " Avatar:" + (avatarIcon != null));
                PopupNotificationWindow.ClosablePopupNotificationWindow popup = new PopupNotificationWindow.ClosablePopupNotificationWindow();
                boolean ok = false;
                this.popupStatus = popup;
                try {
                    ImageIcon imageIcon = null;
                    try {
                        BufferedImage icon = CachedSplashLoader.getSplashFromCache(SimpleHelpLookAndFeel.scale((int)96), SimpleHelpLookAndFeel.scale((int)96));
                        if (icon != null) {
                            imageIcon = new ImageIcon(icon);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    ok = popup.showMessage(imageIcon, avatarIcon, technicianUsername + " " + Language.DEFLANG.getString("REQUESTING_ACCESS"), timeout);
                }
                catch (PopupNotificationWindow.NotificationTimedOut nto) {
                    ok = timeout > 0L;
                }
                finally {
                    this.popupStatus = null;
                }
                if (!ok) {
                    Message responseError = new Message(-1);
                    BCUtilMessenger.writeMsg(bcu, (OutputStream)out, responseError);
                    Thread.sleep(1000L);
                    throw new AccessDeniedException();
                }
                Message responseOK = new Message(64100);
                BCUtilMessenger.writeMsg(bcu, (OutputStream)out, responseOK);
                serv_info = BCUtilMessenger.readMsg(bcu, (InputStream)in);
            }
            serverOptions.showTechPresenceDialog = serv_info.getNextBoolean();
            boolean applyFailoverUrlOverride = serv_info.getNextBoolean();
            String failoverUrl = serv_info.getNextString();
            if (applyFailoverUrlOverride && !this.mobileConnection) {
                FailoverMonitor.overrideFailoverURL((String)failoverUrl);
                try {
                    if (Switches.SH_failoverCheckAfterOverride) {
                        FailoverMonitor.checkSetup((boolean)true);
                    }
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
            }
            if (serv_info.getType() == 61000) {
                Invitation invitation = Invitation.fromMessage(serv_info.getNextMessage());
                settings.copySettingsFrom(invitation);
                if (invitation.hasTechnicianFilter()) {
                    settings.technicianFilter = invitation.getTechnicianFilter();
                }
                if (invitation.hasTechnicianGroupFilter()) {
                    settings.technicianGroupFilter = invitation.getTechnicianGroupFilter();
                }
            }
            serverOptions.endOfSessionOption = serv_info.getNextString();
            if (serverOptions.endOfSessionOption != null && serverOptions.endOfSessionOption.equals("URL")) {
                serverOptions.endOfSessionURL = serv_info.getNextString();
                serverOptions.endOfSessionURLSupport = serv_info.getNextBoolean();
                serverOptions.endOfSessionURLAccess = serv_info.getNextBoolean();
                System.out.println("[SDesktopServerController] End of session option is to open a browser to " + serverOptions.endOfSessionURL + " (" + serverOptions.endOfSessionURLSupport + "," + serverOptions.endOfSessionURLAccess + ")");
            }
            System.out.println("[SDesktopServerController] Done checking tech presence dialog");
            this.gui.printToLog("Sent ID to Proxy Server");
        }
        if (Switches.SH_1767_remoteSupportCloseGracefullyOnQueueExit) {
            out = this.backSock_LOCK;
            synchronized (out) {
                this.backSocks.add(sock);
            }
        }
        try {
            int insts = 0;
            in = this.instances_lock;
            synchronized (in) {
                insts = this.instances.size();
            }
            if (insts < 1) {
                this.gui.setWaiting();
            }
            ++this.waitingCount;
            if (this.mobileConnection) {
                System.out.println("[MobileCustomerSession] Beginning live test wait");
            }
            in = sock.getInputStream();
            OutputStream out2 = sock.getOutputStream();
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] Waiting for session to start (PC.LIVE_TESTS_DONE)");
            }
            long test = StreamUtils.readLong((InputStream)in);
            while (test != 825885312420231L) {
                StreamUtils.writeLong(out2, 158865753896782215L);
                out2.flush();
                test = StreamUtils.readLong((InputStream)in);
            }
            if (this.mobileConnection) {
                System.out.println("[MobileCustomerSession] Tech joining now");
            }
            if (!this.mobileConnection) {
                System.out.println("Read live tests done, writing live tests done response");
            }
            StreamUtils.writeLong(out2, 825885312420231L);
            out2.flush();
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[Session Controller] Session is ready to begin");
            }
            if (!this.mobileConnection) {
                System.out.println("Reading centralised switches");
            }
            Message cdbgProps = MessageUtils.readMessage((InputStream)in);
            if (!this.mobileConnection) {
                Properties unencryptedDebugProps = PropertiesToMessage.toProperties(cdbgProps);
                CentralDebugging.loadCentralisedSwitchesFromProperties(unencryptedDebugProps);
            }
            if (!this.mobileConnection) {
                System.out.println("Ready");
            }
        }
        catch (IOException ex) {
            throw new ConnectionTerminatedException();
        }
        finally {
            --this.waitingCount;
        }
        SHelpNodelinkPatcher patcherDirect = SHelpNodelinkPatcher.establishConnection(settings.host, settings.port);
        SHelpNodelinkPatcher patcherReplace = SHelpNodelinkPatcher.establishConnection(settings.host, settings.port);
        if (LocalSwitches.DEV_acculogSessionLaunch) {
            Acculog.log("[Session Controller] Running SocketSetup");
        }
        SocketSetup setup = new SocketSetup(patcherDirect, patcherReplace, sock, settings.port, settings.host, settings.port, serverOptions, bcu, this.multistatus);
        setup.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverON() {
        if (this.gui != null) {
            this.gui.printToLog("Starting server");
        }
        System.out.println("[SDesktopServerController] Server ON");
        Object object = this.POOL_LOCK;
        synchronized (object) {
            Object object2 = this.DATA_LOCK;
            synchronized (object2) {
                ArrayList<SocketServer> old_pool = new ArrayList<SocketServer>();
                old_pool.addAll(this.server_pool);
                Iterator<Pair> iterator = this.port_ranges.iterator();
                while (iterator.hasNext()) {
                    Pair pair;
                    Pair range = pair = iterator.next();
                    int lower = (Integer)range.first;
                    int higher = (Integer)range.last;
                    for (int k = lower; k <= higher; ++k) {
                        boolean found = false;
                        for (int z = 0; z < old_pool.size(); ++z) {
                            SocketServer ssock = (SocketServer)old_pool.get(z);
                            if (ssock.serv.getLocalPort() != k) continue;
                            found = true;
                            old_pool.remove(z);
                            break;
                        }
                        if (found) continue;
                        try {
                            SocketServer ss = new SocketServer(k, this.sstg, "Socket Server (PORT:" + k + ")");
                            ss.start();
                            this.server_pool.add(ss);
                            this.last_valid_port = k;
                            if (this.gui == null) continue;
                            this.gui.printToLog("Server on port " + k + " started");
                            continue;
                        }
                        catch (Exception e) {
                            if (this.gui != null) {
                                this.gui.printToLog("Server on port " + k + " failed!");
                            }
                            Debugger.warning("SocketServer failed " + e);
                        }
                    }
                    this.gui.setLivePortRange(true, range);
                }
                for (Pair pair : old_pool) {
                    SocketServer ss = (SocketServer)((Object)pair);
                    ss.die = true;
                }
                for (int i = 0; i < old_pool.size(); ++i) {
                    SocketServer socketServer = (SocketServer)old_pool.get(i);
                    try {
                        socketServer.join();
                        System.out.println("[SDesktopServerController] Shutdown SocketServer " + socketServer.getName());
                        if (this.gui == null) continue;
                        this.gui.printToLog("Server on port " + socketServer.serv.getLocalPort() + " shut down");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Error joining to " + socketServer.getName());
                        if (this.gui != null) {
                            this.gui.printToLog("Server on port " + i + " failed to shut down!");
                        }
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.gui != null) {
            this.gui.printToLog("Server is ON");
        }
        this.ON = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serverOFF() {
        if (this.gui != null) {
            this.gui.printToLog("Stopping server");
        }
        System.out.println("[SDesktopServerController] Server OFF");
        if (this.ON) {
            Object object = this.POOL_LOCK;
            synchronized (object) {
                Iterator<SocketServer> iterator = this.server_pool.iterator();
                while (iterator.hasNext()) {
                    SocketServer aServer_pool;
                    SocketServer ss = aServer_pool = iterator.next();
                    ss.die = true;
                }
                for (int i = 0; i < this.server_pool.size(); ++i) {
                    SocketServer ss = this.server_pool.get(i);
                    try {
                        ss.join();
                        System.out.println("[SDesktopServerController] Shutdown SocketServer " + ss.getName());
                        if (this.gui == null) continue;
                        this.gui.printToLog("Server on port " + ss.serv.getLocalPort() + " shut down");
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println("Error joining to " + ss.getName());
                        if (this.gui != null) {
                            this.gui.printToLog("Server on port " + i + " failed to shut down!");
                        }
                        e.printStackTrace();
                    }
                }
                this.server_pool.clear();
                if (this.gui != null) {
                    this.gui.clearLivePorts();
                }
            }
        }
        if (this.gui != null) {
            this.gui.printToLog("Server is OFF");
        }
        this.ON = false;
    }

    @Override
    public boolean isRemoteControlON() {
        return this.REMOTE_CONTROL;
    }

    @Override
    public boolean isRemoteServerControlON() {
        return this.REMOTE_SERVER_CONTROL;
    }

    @Override
    public void remoteControlON() {
        if (this.gui != null) {
            this.gui.printToLog("Remote control is ON");
        }
        System.out.println("[SDesktopServerController] Server remote control ON");
        this.REMOTE_CONTROL = true;
    }

    @Override
    public void remoteControlOFF() {
        if (this.gui != null) {
            this.gui.printToLog("Remote control is OFF");
        }
        System.out.println("[SDesktopServerController] Server remote control OFF");
        this.REMOTE_CONTROL = false;
    }

    @Override
    public void remoteServerControlON() {
        if (this.gui != null) {
            this.gui.printToLog("Remote server control is ON");
        }
        System.out.println("[SDesktopServerController] Server remote server control ON");
        this.REMOTE_SERVER_CONTROL = true;
    }

    @Override
    public void remoteServerControlOFF() {
        if (this.gui != null) {
            this.gui.printToLog("Remote server control is OFF");
        }
        System.out.println("[SDesktopServerController] Server remote server control OFF");
        this.REMOTE_SERVER_CONTROL = false;
    }

    @Override
    public boolean verifyHost(String hostname, String hostip, boolean ban_mentioned, Iterator rules) {
        boolean result = false;
        result = ban_mentioned;
        while (rules.hasNext()) {
            String host = (String)rules.next();
            if (host.endsWith("*")) {
                host = host.substring(0, host.length() - 1);
                if (!hostname.startsWith(host = host.toLowerCase()) && !hostip.startsWith(host)) continue;
                result = !result;
                break;
            }
            if (!hostname.equalsIgnoreCase(host) && !hostip.equalsIgnoreCase(host)) continue;
            result = !result;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableTechnicianReconnects() {
        Object object = this.instances_lock;
        synchronized (object) {
            System.out.println("[SDesktopServerController] Disabling technician reconnects.");
            for (SDesktopServerInstance instance : this.instances) {
                if (instance == null) continue;
                new SDesktopServerInstance.ReconnectStopper(instance).start();
            }
        }
    }

    @Override
    public void notifyTechnicianCustomerDisconnect() {
        for (SDesktopServerInstance instance : this.instances) {
            if (instance == null) continue;
            try {
                instance.asyncserver.notifyTechnicianCustomerDisconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean userRequestedEndSession() {
        return this.requestedEndSession;
    }

    @Override
    public void disconnect(boolean andDie) {
        System.out.println("[SDesktopServerController] Disconnecting now.");
        System.out.flush();
        try {
            this.requestedEndSession = true;
            System.out.println("[SDesktopServerController] Disabling technician reconnects");
            this.disableTechnicianReconnects();
            System.out.println("[SDesktopServerController] Notifying technician customer of disconnect");
            this.notifyTechnicianCustomerDisconnect();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            System.out.println("[SDesktopServerController] Stopping backwards connection");
            this.stopBackwardsConnection();
        }
        finally {
            System.out.println("[SDesktopServerController] Finishing shutdown (" + andDie + ")");
            if (andDie) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Throwable throwable) {}
                System.exit(0);
            }
        }
    }

    @Override
    public void notifyThatUserIsTyping(String displayName) {
        for (SDesktopServerInstance instance : this.instances) {
            if (instance == null) continue;
            try {
                instance.asyncserver.notifyThatUserIsTyping(displayName);
            }
            catch (Throwable throwable) {}
        }
    }

    public class AccessDeniedException
    extends Exception {
    }

    public class BadInvitationException
    extends Exception {
    }

    public static class ConnectionTerminatedException
    extends Exception {
    }

    public class ExpiredInvitationException
    extends Exception {
    }

    public class IncorrectPasswordException
    extends Exception {
    }

    class MultipleSocketLinkListener
    implements NodeLinkStatusListener {
        final Object LOCK = new Object();
        final HashMap<NodeLink, NodeLink> started = new HashMap();
        final HashMap<NodeLink, NodeLink> down = new HashMap();

        MultipleSocketLinkListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateStatus() {
            Object object = this.LOCK;
            synchronized (object) {
                Object[] nls;
                for (Object o : nls = this.started.keySet().toArray()) {
                    NodeLink nl = (NodeLink)o;
                    if (nl.isAlive()) continue;
                    this.started.remove(nl);
                    this.down.remove(nl);
                    System.out.println("[SDServerStatus] " + this.started.size() + " connections remaining alive");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addNodeLink(NodeLink link) {
            if (link == null) {
                return;
            }
            Object object = this.LOCK;
            synchronized (object) {
                System.out.println("[SDServerStatus] Connection started: " + link);
                this.started.put(link, link);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void linkDown(NodeLink link, Throwable reason) {
            if (link == null) {
                return;
            }
            this.updateStatus();
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.started.containsKey(link)) {
                    System.out.println("[SDServerStatus] Ignoring downed connection " + link);
                    if (this.down.size() > 0) {
                        System.out.println("[SDServerStatus] " + this.down.size() + " out of " + this.started.size() + " connections are DOWN: " + link);
                    }
                    return;
                }
                this.down.put(link, link);
                if (this.down.size() > 0) {
                    System.out.println("[SDServerStatus] " + this.down.size() + " out of " + this.started.size() + " connections are DOWN: " + link);
                }
            }
            System.out.println("[SDServerStatus] Notifying upstream that connection is DOWN: " + link);
            if (SDesktopServerController.this.previousStatus != null) {
                SDesktopServerController.this.previousStatus.linkDown(link, reason);
            }
            if (SDesktopServerController.this.popupStatus != null) {
                SDesktopServerController.this.popupStatus.linkDown(link, reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void linkOK(NodeLink link) {
            boolean allOK;
            if (link == null) {
                return;
            }
            this.updateStatus();
            Object object = this.LOCK;
            synchronized (object) {
                this.addNodeLink(link);
                this.down.remove(link);
                allOK = this.down.isEmpty();
                if (this.down.size() > 0) {
                    System.out.println("[SDServerStatus] " + this.down.size() + " out of " + this.started.size() + " connections are DOWN: " + link);
                }
            }
            if (allOK) {
                System.out.println("[SDServerStatus] Notifying upstream that all connections are OK: " + link);
                if (SDesktopServerController.this.previousStatus != null) {
                    SDesktopServerController.this.previousStatus.linkOK(link);
                }
                if (SDesktopServerController.this.popupStatus != null) {
                    SDesktopServerController.this.popupStatus.linkOK(link);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void linkDead(NodeLink link, String reason) {
            boolean allDead;
            if (link == null) {
                return;
            }
            this.updateStatus();
            Object object = this.LOCK;
            synchronized (object) {
                this.started.remove(link);
                this.down.remove(link);
                System.out.println("[SDServerStatus] " + this.started.size() + " connections remaining alive: " + link);
                allDead = this.started.size() == 0;
            }
            if (allDead) {
                System.out.println("[SDServerStatus] Notifying upstream that all connections are DEAD: " + link);
                if (SDesktopServerController.this.previousStatus != null) {
                    SDesktopServerController.this.previousStatus.linkDead(link, reason);
                }
                if (SDesktopServerController.this.popupStatus != null) {
                    SDesktopServerController.this.popupStatus.linkDead(link, reason);
                }
            }
        }
    }

    class PreSessionLoaderThread
    extends Thread {
        private final ScreenServer preloadedScreenServer;
        private final Message toolsDesiredInitialState;
        private final ToolServer toolServer;

        public PreSessionLoaderThread(ToolServer toolServer, ScreenServer preloadedScreenServer, Message toolsDesiredInitialState) {
            this.toolServer = toolServer;
            this.preloadedScreenServer = preloadedScreenServer;
            this.toolsDesiredInitialState = toolsDesiredInitialState;
        }

        @Override
        public void run() {
            if (this.toolsDesiredInitialState != null) {
                System.out.println("[PreSessionLoader] Preloading tool desired states");
                for (int i = 0; i < this.toolsDesiredInitialState.length(); ++i) {
                    try {
                        Message toolMessage = (Message)this.toolsDesiredInitialState.get(i);
                        this.toolServer.processToolMessage(toolMessage, false);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            System.out.println("[PreSessionLoader] Done preloading tools.");
            System.out.println("[PreSessionLoader] Cranking ScreenGrabber");
            this.preloadedScreenServer.initMK1_ScreenGrabber();
            System.out.println("[PreSessionLoader] ScreenGrabber running");
        }
    }

    private class RangeComparator
    implements Comparator<Pair> {
        private RangeComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            int i = ((Integer)p1.first).compareTo((Integer)p2.first);
            if (i == 0) {
                i = ((Integer)p1.last).compareTo((Integer)p2.last);
            }
            return i;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    private static class SecurityConfig {
        boolean encrypted_sockets;
        int pubpriv_keysize;
        int sym_keysize;
        GenericRandom cprng;
        EntropyGatherer ent;
        boolean gather_at_start;

        private SecurityConfig() {
        }
    }

    public class ServerOptions {
        public boolean showTechPresenceDialog;
        public String endOfSessionOption;
        public String endOfSessionURL;
        public boolean endOfSessionURLSupport;
        public boolean endOfSessionURLAccess;

        public boolean openBrowserAtEndOfSession(boolean supportSession) {
            if (this.endOfSessionURL != null && this.endOfSessionURL.trim().length() > 0) {
                if (supportSession && this.endOfSessionURLSupport) {
                    return true;
                }
                if (!supportSession && this.endOfSessionURLAccess) {
                    return true;
                }
            }
            return false;
        }
    }

    class SocketServer
    extends Thread {
        int sport;
        final ThreadGroup tg;
        boolean die;
        ServerSocket serv;

        public SocketServer(int port, ThreadGroup tg, String name) throws Exception {
            super(tg, name);
            this.sport = 0;
            this.tg = tg;
            this.sport = port;
            try {
                this.serv = new ServerSocket(port, 10);
            }
            catch (Exception e) {
                System.out.println("Error listening on port " + port);
                throw e;
            }
        }

        public void cleanup() {
            try {
                this.serv.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            this.die = false;
            try {
                this.serv.setSoTimeout(2000);
                System.out.println("[SDesktopServerController] listening on " + this.serv.getLocalPort());
                while (!this.die) {
                    try {
                        throw new IOException("NOT IMPLEMENTED");
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                    }
                    catch (IOException e) {
                        Thread.sleep(1000L);
                    }
                }
                System.out.println("Server on socket " + this.serv.getLocalPort() + " told to shut down gracefully");
            }
            catch (SecurityException e) {
                System.out.println("Server on socket " + this.serv.getLocalPort() + " failed with following security exception");
                e.printStackTrace();
                SDesktopServerController.this.gui.printToLog("Server on socket " + this.serv.getLocalPort() + " failed due to security exception");
                this.tg.uncaughtException(this, e);
                this.cleanup();
            }
            catch (Throwable e) {
                System.out.println("Server on socket " + this.serv.getLocalPort() + " failed with following exception");
                e.printStackTrace();
                SDesktopServerController.this.gui.printToLog("Server on socket " + this.serv.getLocalPort() + " failed due to unknown exception");
                this.tg.uncaughtException(this, e);
                this.cleanup();
            }
            this.cleanup();
        }
    }

    static class SocketServerThreadGroup
    extends ThreadGroup {
        public SocketServerThreadGroup() {
            super("Socket Server Thread Group");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            e.printStackTrace();
        }
    }

    class SocketSetup
    extends Thread {
        final int MAX_SOCKET_COUNT = 100;
        final int MIN_RESPONSE_SLEEP = 1500;
        Node assocNode;
        NodeLink sock;
        NodeLink directSocket;
        String user;
        byte[] blowfish_key;
        Blowfish blowfish;
        final int locport;
        final String connected_host;
        final int connected_port;
        final ServerOptions serverOptions;
        final BCUtil bcu;
        final SHelpNodelinkPatcher patcherDirect;
        final SHelpNodelinkPatcher patcherReplace;
        final MultipleSocketLinkListener status;

        public SocketSetup(SHelpNodelinkPatcher patcherDirect, SHelpNodelinkPatcher patcherReplace, NodeLink s, int locport, String connected_host, int connected_port, ServerOptions serverOptions, BCUtil bcu, MultipleSocketLinkListener status) {
            this.patcherDirect = patcherDirect;
            this.patcherReplace = patcherReplace;
            this.connected_host = connected_host;
            this.connected_port = connected_port;
            this.sock = s;
            this.locport = locport;
            this.serverOptions = serverOptions;
            this.bcu = bcu;
            this.status = status;
        }

        @Override
        public void run() {
            try {
                OutputStream fout = this.sock.getOutputStream();
                InputStream fin = this.sock.getInputStream();
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Session Controller] Establishing encryption");
                }
                System.out.println("[SDServer] Establishing session encryption");
                byte[][] secKeys = null;
                Object[] streams = null;
                if (CentralDebugging.USE_BCU_FOR_SESSION) {
                    fin = new BCUtilInputStream(fin, this.bcu);
                    fout = new BCUtilOutputStream(fout, this.bcu);
                    System.out.println("[SDServer] Streams created");
                    fout.write(8);
                    fout.flush();
                    System.out.println("[SDServer] Read Check: " + fin.read());
                } else {
                    this.setupStaticEncryption(fin, fout);
                    secKeys = this.createMoreSecureKeys(fin, fout, 4);
                    streams = this.secureStreams(fin, fout, secKeys[1], secKeys[0]);
                    fin = (InputStream)streams[0];
                    fout = (OutputStream)streams[1];
                }
                ScreenServer preloadedScreenServer = null;
                ToolServer toolServer = null;
                if (!SDesktopServerController.this.mobileConnection) {
                    preloadedScreenServer = new ScreenServer();
                    toolServer = new ToolServer(SDesktopServerController.this.sdemoConnection);
                }
                Message uniqueIDMessage = new Message();
                String id = UniqueIDUtil.generateOrLoadUniqueID();
                uniqueIDMessage.append(id);
                OS.isWindows();
                uniqueIDMessage.append(OS.base_type);
                uniqueIDMessage.append(OS.variant);
                MessageUtils.writeMessage((OutputStream)fout, (Message)uniqueIDMessage);
                System.out.println("[SDesktopServerController] Sent unique ID (" + id + ")");
                int ret = StreamUtils.readInt(fin);
                long maxFileTransferSize = -1L;
                if (ret == 1195447384) {
                    Message bits = MessageUtils.readMessage((InputStream)fin);
                    int sessionMode = bits.getNextInt();
                    maxFileTransferSize = bits.getNextLong();
                    OpusConfig.bitRate = bits.getNextInt();
                    Message toolsDesiredInitialState = bits.getNextMessage();
                    CentralDebugging.DEBUG_NL_PACKET_LOSS_LONG = bits.getNextBoolean();
                    CentralDebugging.DEBUG_NL_PACKET_LOSS_VERY_LONG = bits.getNextBoolean();
                    if (CentralDebugging.DEBUG_NL_PACKET_LOSS_VERY_LONG) {
                        NodeLink.setDebugPacketLoss(300);
                    } else if (CentralDebugging.DEBUG_NL_PACKET_LOSS_LONG) {
                        NodeLink.setDebugPacketLoss(60);
                    }
                    PreSessionLoaderThread pt = new PreSessionLoaderThread(toolServer, preloadedScreenServer, toolsDesiredInitialState);
                    if (sessionMode == 0) {
                        pt.start();
                    } else {
                        preloadedScreenServer.setInitialisationThread(pt);
                    }
                    ret = StreamUtils.readInt(fin);
                }
                TransportCommsLine transport_line = new TransportCommsLine();
                if (ret == 1195447392) {
                    this.assocNode = this.sock.getMyNode();
                    transport_line.in = fin;
                    transport_line.out = fout;
                    int fwdID = StreamUtils.readInt(fin);
                    StreamUtils.writeInt(fout, fwdID);
                    fout.flush();
                    if (LocalSwitches.DEV_acculogSessionLaunch) {
                        Acculog.log("[Session Controller] Keeping transport line, establishing data line");
                    }
                    if (Switches.SH_2198_removeNlListenersEarly) {
                        this.sock.setFriendlyName("EOL / InitialSetupNonPatchedTransportLine");
                        this.sock.removeAllLinkStatusListeners();
                    }
                    System.out.println("[Controller] Trying to establish basic patched connection under fwdID " + fwdID);
                    this.directSocket = this.patcherDirect.finishPatch(true, fwdID, null, fin, fout, this.assocNode, false);
                    this.directSocket.setFriendlyName("PatchedDirectDataLine");
                    fin = this.directSocket.getInputStream();
                    fout = this.directSocket.getOutputStream();
                    if (CentralDebugging.USE_BCU_FOR_SESSION) {
                        fin = new BCUtilInputStream(fin, this.bcu);
                        fout = new BCUtilOutputStream(fout, this.bcu);
                    } else {
                        streams = this.secureStreams(fin, fout, secKeys[3], secKeys[2]);
                        fin = (InputStream)streams[0];
                        fout = (OutputStream)streams[1];
                    }
                    if (LocalSwitches.DEV_acculogSessionLaunch) {
                        Acculog.log("[Session Controller] Data line ready");
                    }
                    fwdID = StreamUtils.readInt(fin);
                    StreamUtils.writeInt(fout, fwdID);
                    fout.flush();
                    System.out.println("[Controller] Trying to establish replacement patched connection under fwdID " + fwdID);
                    NodeLink sockReplace = this.patcherReplace.finishPatch(true, fwdID, null, fin, fout, this.assocNode, true);
                    transport_line.in = new BCUtilInputStream(sockReplace.getInputStream(), this.bcu);
                    transport_line.out = new BCUtilOutputStream(sockReplace.getOutputStream(), this.bcu);
                    sockReplace.setFriendlyName("Session Communications Only");
                    sockReplace.addLinkStatusListener(this.status);
                    StreamUtils.writeStringUTF8(transport_line.out, "Hello Controller");
                    transport_line.out.flush();
                    System.out.println(StreamUtils.readStringUTF8(transport_line.in));
                    if (!Switches.SH_2198_removeNlListenersEarly) {
                        this.sock.setFriendlyName("EOL / InitialSetupNonPatchedTransportLine");
                        this.sock.removeAllLinkStatusListeners();
                    }
                    this.sock.stopImmediate("replace transport line with patched");
                    this.sock = sockReplace;
                    this.directSocket.terminateInTandem(this.sock);
                    this.directSocket.addLinkStatusListener(this.status);
                    SDesktopServerController.this.backSocks.add(sockReplace);
                    SDesktopServerController.this.backSocks.add(this.directSocket);
                    System.out.println("[Controller] Got basic connections");
                    ret = StreamUtils.readInt(fin);
                }
                if (ret == 1195447382) {
                    if (CentralDebugging.ATTEMPT_UDP_DIRECT) {
                        NodeLink direct = SHelpUdpNlNatHpMk2.establishProxiedUDP(null, this.connected_host, this.connected_port, fin, fout);
                        if (direct != null) {
                            System.out.println("Switching to Proxied UDP NL");
                            fin = direct.getInputStream();
                            fout = direct.getOutputStream();
                            if (CentralDebugging.USE_BCU_FOR_SESSION) {
                                fin = new BCUtilInputStream(fin, this.bcu);
                                fout = new BCUtilOutputStream(fout, this.bcu);
                            } else {
                                streams = this.secureStreams(fin, fout, secKeys[3], secKeys[2]);
                                fin = (InputStream)streams[0];
                                fout = (OutputStream)streams[1];
                            }
                            direct.terminateInTandem(this.sock);
                        } else {
                            System.out.println("[SDServerController] Unable to switch to Direct NL");
                        }
                    }
                } else if (ret == 1195447383) {
                    System.out.println("[SDServerController] Told to not attempt Direct NL");
                }
                MultiplexerInputStream mxin = new MultiplexerInputStream(fin, "SDServerController-SessionDemultiplexer");
                MultiplexerOutputStream mxout = new MultiplexerOutputStream(fout);
                fin = mxin.getInputStream((short)0, "Socket Setup");
                fout = mxout.getOutputStream((short)0);
                System.out.println("[SDServerController] Sending acceptance on mxout:0 (" + fout + ")");
                if (PasswordStorage.PASSWORD != null) {
                    System.out.println("[SDServerController] Requiring machine password");
                    StreamUtils.writeInt(fout, -572662307);
                } else {
                    System.out.println("[SDServerController] OK to proceed");
                    StreamUtils.writeInt(fout, -4517462);
                }
                fout.flush();
                boolean encryption_on = true;
                int REAL_SOCKET_COUNT = StreamUtils.readInt(fin);
                System.out.println("[SDServerController] Building channels (" + REAL_SOCKET_COUNT + ")");
                if (REAL_SOCKET_COUNT < 0 || REAL_SOCKET_COUNT > 100) {
                    StreamUtils.writeInt(fout, 0x1122EEEE);
                    fout.flush();
                    SDesktopServerController.this.gui.printToLog("Connection attempt denied! Bad socket count!");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sock.stop("bad multiplexer socket count in connection attempt");
                    throw new SocketTimeoutException("bad socket count");
                }
                StreamUtils.writeInt(fout, -286348613);
                fout.flush();
                if (encryption_on) {
                    System.out.println("[SDServerController] Setting up encryption");
                    StreamUtils.writeInt(fout, -17895697);
                    fout.flush();
                } else {
                    StreamUtils.writeInt(fout, 0xAAAAAA0);
                    fout.flush();
                }
                SDesktopServerController.this.gui.printToLog("Connection attempt, checking user");
                if (!this.verifyUser(fout, fin, false)) {
                    StreamUtils.writeInt(fout, -1146478063);
                    fout.flush();
                    SDesktopServerController.this.gui.printToLog("Connection attempt denied! Invalid user!");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.sock.stop("invalid user in connection attempt");
                    throw new SocketTimeoutException("user not allowed");
                }
                StreamUtils.writeInt(fout, 287484603);
                fout.flush();
                SDesktopServerController.this.gui.printToLog("Connection attempt, verifying password");
                while (!this.verifyPassword(fout, fin)) {
                    StreamUtils.writeInt(fout, 1126292666);
                    fout.flush();
                    SDesktopServerController.this.gui.printToLog("Connection attempt denied! Invalid password!");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception exception) {}
                }
                StreamUtils.writeInt(fout, -1412623820);
                fout.flush();
                System.out.println("[SDServerController] Encryption OK");
                SDesktopServerController.this.gui.printToLog("Connection attempt complete (accepted)");
                boolean licensed = true;
                int eval_uses = 100;
                int eval_wait = 1;
                if (licensed) {
                    StreamUtils.writeInt(fout, 0x1ECE1ECE);
                    StreamUtils.writeInt(fout, eval_uses);
                    StreamUtils.writeInt(fout, eval_wait);
                    fout.flush();
                } else {
                    StreamUtils.writeInt(fout, 0x1EA11EA1);
                    StreamUtils.writeInt(fout, eval_uses);
                    StreamUtils.writeInt(fout, eval_wait);
                    fout.flush();
                    try {
                        Thread.sleep(eval_uses * eval_wait);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                StreamUtils.writeInt(fout, 0x1ECE1ECE);
                fout.flush();
                System.out.println("[SDServerController] Building channels");
                System.out.println("[SDServerController] Starting all servers");
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[Session Controller] Starting session servers, matched to controllers");
                }
                SDesktopServerInstance instance = new SDesktopServerInstance(SDesktopServerController.this.gui, SDesktopServerController.this, this.sock, this.directSocket, encryption_on, mxin, mxout, this.user, this.connected_host, SDesktopServerController.this.FTP, SDesktopServerController.this.RDP, SDesktopServerController.this.CHAT, this.connected_host, this.connected_port, SDesktopServerController.this.mmoveRequiredButFailed, preloadedScreenServer, transport_line, this.assocNode, maxFileTransferSize, SDesktopServerController.this.sdemoConnection, SDesktopServerController.this.mobSession);
                if (toolServer != null) {
                    toolServer.setServerInstance(instance);
                }
                SDesktopServerController.this.instances.add(instance);
                SDesktopServerController.this.gui.setCurrentConnections(SDesktopServerController.this.instances);
                SDesktopServerController.this.gui.setTechnicianConnectedStatus(true, instance.getUser(), instance.getHost(), instance.getConnectionTime());
                SDesktopServerController.this.gui.setServerOptions(this.serverOptions);
                try {
                    this.technicianConnected();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            catch (Throwable t) {
                System.out.println("Attempted connection failed:");
                t.printStackTrace();
            }
        }

        private void technicianConnected() {
            File launcher;
            String launcherPath;
            boolean doDelete;
            String deleteLauncher = JWSystem.getAppLaunchProperty((String)"delete");
            boolean bl = doDelete = deleteLauncher != null && (Boolean.parseBoolean(deleteLauncher) || deleteLauncher.equalsIgnoreCase("yes") || deleteLauncher.equalsIgnoreCase("on"));
            if (doDelete && (launcherPath = JWSystem.getAppLaunchProperty((String)"launched_from_dynprops")) != null && launcherPath.length() > 0 && (launcher = new File(launcherPath)).exists()) {
                System.out.println("[SDesktopServerController] Asked to delete launcher '" + launcher + "'");
                if (OS.isMacOS()) {
                    File dotApp = JWMacOS.getDotAppLauncher();
                    if (dotApp == null) {
                        System.out.println("[SDesktopServerController] Unable to identify .app.");
                        return;
                    }
                    if (dotApp.exists()) {
                        if (launcherPath.startsWith("/Volumes")) {
                            File volume = dotApp.getParentFile();
                            RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"hdiutil", "unmount", volume.getAbsolutePath()});
                            System.out.println("[SDesktopServerController] Unmounted parent DMG");
                        } else {
                            FileUtil.deleteDir((File)dotApp);
                            System.out.println("[SDesktopServerController] Launcher deleted succesfully.");
                        }
                    }
                } else {
                    try {
                        if (launcher.delete()) {
                            System.out.println("[SDesktopServerController] Launcher deleted succesfully.");
                        } else {
                            System.out.println("[SDesktopServerController] [WARNING] Launcher delete failed");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }

        public boolean verifyPassword(OutputStream fout, InputStream fin) throws IOException {
            byte[] enc_passhash = StreamUtils.readNBytes(fin, 100000);
            if (!PasswordStorage.REQUIRED) {
                return true;
            }
            byte[] dec_passhash = CentralDebugging.USE_BCU_FOR_SESSION ? enc_passhash : this.blowfish.decryptSecure(enc_passhash, 0, true);
            String dec_hash = new String(dec_passhash, StandardCharsets.UTF_8);
            return dec_hash.equals(PasswordStorage.PASSWORD);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean verifyUser(OutputStream fout, InputStream fin, boolean doAuth) throws IOException {
            Object object = SDesktopServerController.this.DATA_LOCK;
            synchronized (object) {
                byte[] enc_user = StreamUtils.readNBytes(fin, 100000);
                this.user = CentralDebugging.USE_BCU_FOR_SESSION ? new String(enc_user, StandardCharsets.UTF_8) : new String(this.blowfish.decryptSecure(enc_user, 0, true), StandardCharsets.UTF_8);
            }
            return !doAuth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean verifyHost(InetAddress addr, boolean doAuth) {
            boolean allowed;
            if (!doAuth) {
                return true;
            }
            String hostname = addr.getHostName().toLowerCase();
            String hostip = addr.getHostAddress().toLowerCase();
            Object object = SDesktopServerController.this.DATA_LOCK;
            synchronized (object) {
                allowed = SDesktopServerController.this.verifyHost(hostname, hostip, SDesktopServerController.this.ban_hosts, SDesktopServerController.this.hosts.iterator());
            }
            return allowed;
        }

        public boolean setupStaticEncryption(InputStream fin, OutputStream fout) throws IOException {
            System.out.println("[SDServerController] Setting up static encryption");
            byte[] keyb = SecurityUtil.generateSymmetricKey();
            String[] theirpub = new String[]{StreamUtils.readNStringUTF8(fin, 100000), StreamUtils.readNStringUTF8(fin, 100000)};
            RSAEncryptor rsa_enc = SecurityUtil.getRSAEncryptor(theirpub);
            this.blowfish_key = new byte[keyb.length];
            System.arraycopy(keyb, 0, this.blowfish_key, 0, keyb.length);
            this.blowfish = new Blowfish();
            this.blowfish.init(this.blowfish_key);
            keyb = rsa_enc.encrypt(keyb);
            StreamUtils.writeBytes(fout, keyb);
            fout.flush();
            return true;
        }

        public byte[][] createMoreSecureKeys(InputStream in, OutputStream out, int count) throws IOException {
            byte[][] keys = new byte[count][];
            for (int i = 0; i < count; ++i) {
                byte[] key = SecurityUtil.generateSymmetricKey();
                StreamUtils.writeBytes(out, this.blowfish.encryptSecure(key, true));
                keys[i] = key;
            }
            out.flush();
            return keys;
        }

        public Object[] secureStreams(InputStream in, OutputStream out, byte[] inkey, byte[] outkey) throws IOException {
            Object[] tmp = new Object[]{new BufferedInputStream(new BlowfishDecryptionStream((InputStream)new BufferedInputStream(in), inkey)), new BufferedOutputStream(new BlowfishEncryptionStream((OutputStream)new BufferedOutputStream(out), outkey))};
            System.out.println("[Controller] Streams secured");
            return tmp;
        }
    }

    private static class User {
        String name;
        boolean connect;
        boolean control;
        boolean scontrol;
        boolean execute;
        boolean vwboard;
        boolean swboard;
        boolean vchat;
        boolean schat;
        boolean clipb;
        boolean vscreen;

        private User() {
        }
    }
}

