/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.shelp.customer.MobileCustomerSession;
import com.aem.utils.Debugger;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class MobileScreenServer
extends Thread
implements MSG,
GC,
ServerPart {
    MessageReader min;
    MessageWriter mout;
    SDesktopServerController controller;
    SDesktopServerInstance instance;
    int[] prev_image;
    boolean die = false;
    MobileCustomerSession mobSession;

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public MobileScreenServer(SDesktopServerInstance instance, SDesktopServerController controller, InputStream input, OutputStream output, MobileCustomerSession mobSession) {
        super("MobileScreenServerThread");
        this.controller = controller;
        this.instance = instance;
        this.mobSession = mobSession;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        new TestThread().start();
    }

    private void sendScreenshot() {
        try {
            byte[] imgdat = this.mobSession.getLatestScreenshot();
            Message m = new Message(196644);
            m.append(imgdat);
            this.send(m);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Message m = null;
        try {
            while (!this.die) {
                try {
                    try {
                        m = this.min.read();
                        System.out.println("[MobileScreen] " + m);
                        Thread.sleep(100L);
                    }
                    catch (Throwable tt) {
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable tt) {}
            }
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in NullServer: " + Debugger.getStackTrace(e));
            System.out.println("(Null Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public void send(Message m) throws Exception {
        this.mout.write(m);
    }

    class TestThread
    extends Thread {
        TestThread() {
        }

        @Override
        public void run() {
            while (!MobileScreenServer.this.die) {
                try {
                    Thread.sleep(4000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                MobileScreenServer.this.sendScreenshot();
            }
        }
    }
}

