/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import bcutil.BCUtil;
import bcutil.SingleStringKeyHashProvider;
import com.aem.BuildDateUtil;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.UninstallRemoteAccessService;
import com.aem.shelp.util.BCUtilMessenger;
import com.aem.shelp.util.PasswordStorage;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.utils.StreamUtils;
import com.jw.SHJWUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import jwrapper.jwutils.JWSystem;
import jwrapper.logging.ProcessResult;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.message.Message;
import utils.ostools.OS;
import utils.progtools.StackTracer;

public class MiniController {
    public static Message toMessage(ProcessResult result) {
        Message message = new Message();
        if (result.logMessages != null) {
            message.append(result.logMessages.toString());
        } else {
            message.append("");
        }
        if (result.logErrors != null) {
            message.append(result.logErrors.toString());
        } else {
            message.append("");
        }
        if (result.stacktrace != null) {
            message.append(result.stacktrace);
        } else {
            message.append("");
        }
        if (result.source != null) {
            message.append(result.source);
        } else {
            message.append("");
        }
        message.append(result.code);
        message.append(result.time);
        return message;
    }

    public static ProcessResult fromMessage(Message m) {
        int index = 0;
        ProcessResult result = new ProcessResult();
        result.logMessages.append(m.getAsString(index++));
        result.logErrors.append(m.getAsString(index++));
        result.stacktrace = m.getAsString(index++);
        result.source = m.getAsString(index++);
        result.code = m.getAsInt(index++);
        result.time = m.getAsLong(index++);
        return result;
    }

    public void backwardsConnection(String activity, ConnectionSettings settings, NodeLinkStatusListener status, boolean VERSION_3_INSTALLATION) throws Exception {
        System.out.println("[MiniController] Trying to connect to host " + settings.host + ", port " + settings.port + " on mini session " + activity);
        NodeLink sock = SHelpNodelinkConnector.getConnection(settings.host, settings.port, status);
        if (status != null) {
            sock.addLinkStatusListener(status);
        }
        System.out.println("[MiniController] Connected OK");
        OutputStream out = sock.getOutputStream();
        StreamUtils.writeLong(out, BuildDateUtil.getServiceMagicBuildDate());
        InputStream in = sock.getInputStream();
        try {
            if (BuildDateUtil.getServiceMagicBuildDate() != StreamUtils.readLong(in)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new IOException("Server does not appear to be a SimpleHelp server or is an incompatible version");
        }
        System.out.println("[SDesktopServerController] Setting up encryption (BCU)");
        String pkhash = JWLaunchProperties.getProperty((String)"shpkhash");
        if (!JWLaunchProperties.isJWrapperSetup()) {
            System.out.println("[SDesktopServerController] JW not set up, no pkhash available");
            pkhash = null;
        }
        if (pkhash != null && pkhash.length() == 0) {
            pkhash = null;
        }
        System.out.println("[SDesktopServerController] Expected server pkhash: " + pkhash);
        BCUtil bcu = new BCUtil();
        if (pkhash == null) {
            bcu.setValidHashRequired(false);
        } else {
            bcu.setClientRsaKeyPairHashNoRecovery((BCUtil.PublicKeyHashProvider)new SingleStringKeyHashProvider(pkhash));
        }
        bcu.handshake(sock.getInputStream(), sock.getOutputStream(), true, null);
        StreamUtils.writeStringUTF8(out, activity);
        System.out.println("[MiniController] Security set up OK, ready for login and queries");
        try {
            String sgServiceDir = ".." + File.separator + ".." + File.separator;
            boolean andFinish = false;
            boolean loggedIn = false;
            boolean amElevated = false;
            if (OS.isWindows() || OS.isLinux()) {
                amElevated = true;
            }
            if (!PasswordStorage.REQUIRED) {
                loggedIn = true;
            }
            System.out.println("[MiniController] Already logged in is " + loggedIn);
            String elev_user = null;
            String elev_pass = null;
            while (true) {
                Message ret;
                Message m;
                int type;
                if ((type = (m = BCUtilMessenger.readMsg(bcu, in)).getType()) == 30000) {
                    ret = new Message(1);
                    ret.append(PasswordStorage.REQUIRED);
                } else if (type == 31000) {
                    ret = new Message(1);
                    String pass = (String)m.get(0);
                    if (pass.equals(PasswordStorage.PASSWORD)) {
                        System.out.println("[MiniController] Mini session login OK");
                        loggedIn = true;
                        ret.append(true);
                    } else {
                        System.out.println("[MiniController] Mini session login FAILED");
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ret.append(false);
                        System.out.println("[MiniController] Failed login not returning false");
                    }
                } else if (type == 31200) {
                    ret = new Message(1);
                    ret.append(amElevated);
                } else if (type == 31300) {
                    elev_user = (String)m.get(0);
                    elev_pass = (String)m.get(1);
                    try {
                        if (elev_user == null || elev_user.length() == 0) {
                            throw new Exception("No credentials specified");
                        }
                        MouseMover.forceNewElevatedInstanceWithCredentials(elev_user, elev_pass);
                        ret = new Message(1);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                        ret = new Message(-1);
                        ret.append("" + x);
                    }
                } else if (type == 31400) {
                    ret = new Message(1);
                    ret.append(VERSION_3_INSTALLATION);
                } else if (type == 31500) {
                    ret = new Message(1);
                    System.out.println("[MiniController] Request to uninstall SG V4");
                    try {
                        UninstallRemoteAccessService.elevateProcessToRequestUninstall(elev_pass);
                        System.out.println("[MiniController] Uninstallation will run asynchronously, returning success");
                        andFinish = true;
                    }
                    catch (Exception x) {
                        x.printStackTrace(System.out);
                        System.out.flush();
                        ret = new Message(-1);
                        ret.append(StackTracer.getStacktrace((Throwable)x));
                    }
                } else if (type == 27000) {
                    ret = new Message(1);
                    System.out.println("[MiniController] Mini session complete, close requested");
                    System.exit(0);
                } else if (loggedIn) {
                    if (type == 31100) {
                        ret = new Message(1);
                        System.out.println("[MiniController] Request to install SG V4");
                        if (VERSION_3_INSTALLATION) {
                            try {
                                ProcessResult res;
                                String updateURL = SHJWUtil.getUpdateURLProtocol() + "://" + settings.host + ":" + settings.port + "/" + "access";
                                String language = "en";
                                System.out.println("[MiniController] Updating from " + updateURL);
                                File sgmainDir = new File(".").getCanonicalFile();
                                sgmainDir = sgmainDir.getParentFile();
                                sgmainDir = sgmainDir.getParentFile();
                                File sh3ConfigFile = new File(sgmainDir, "serviceconfig.xml");
                                System.out.println("[MiniController] Loading V3 config from " + sh3ConfigFile);
                                byte[] v4ConfigBytes = FileUtil.readFile((String)sh3ConfigFile.getAbsolutePath());
                                SimpleGatewayConfig old = new SimpleGatewayConfig(sh3ConfigFile);
                                String oldname = old.getName();
                                System.out.println("[MiniController] Old SG v3 name is " + oldname);
                                String oldfix = "Old v3 Services/";
                                if (oldname.startsWith(oldfix)) {
                                    System.out.println("[MiniController] Trimming V4 config name");
                                    System.out.flush();
                                    SimpleGatewayConfig v4config = new SimpleGatewayConfig(v4ConfigBytes);
                                    v4config.setName(oldname.substring(oldfix.length()));
                                    v4ConfigBytes = v4config.save(true);
                                } else {
                                    String newname = oldfix + oldname;
                                    old.setName(newname);
                                    System.out.println("[MiniController] Saving renamed V3 config");
                                    System.out.flush();
                                    old.save(sh3ConfigFile, true);
                                }
                                System.out.println("[MiniController] Checking MMove");
                                System.out.flush();
                                MouseMover mmove = MouseMover.getStaticMouseMover();
                                String proxyHost = null;
                                int proxyPort = 0;
                                String proxyUser = null;
                                String proxyPass = null;
                                try {
                                    Proxy jWrapperProxy = JWSystem.getJWrapperProxy();
                                    if (jWrapperProxy != null) {
                                        InetSocketAddress isa = (InetSocketAddress)jWrapperProxy.address();
                                        proxyHost = isa.getAddress().getHostAddress();
                                        proxyPort = isa.getPort();
                                        JWProxyCredentials.Credentials creds = JWSystem.getJWrapperProxyCredentials();
                                        if (creds != null) {
                                            proxyUser = creds.username;
                                            proxyPass = creds.password;
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                                if (mmove != null) {
                                    System.out.println("[MiniController] Installing via mmove");
                                    System.out.flush();
                                    res = mmove.installSGService(updateURL, v4ConfigBytes, proxyHost, proxyPort, proxyUser, proxyPass, false);
                                } else {
                                    System.out.println("[MiniController] Installing without mmove");
                                    System.out.flush();
                                    res = MouseMover.installSGServiceWithoutMouseMover(updateURL, v4ConfigBytes, true, proxyHost, proxyPort, proxyUser, proxyPass, false);
                                }
                                System.out.println("[MiniController] Result is " + res);
                                System.out.flush();
                                if (res.isError()) {
                                    throw new Exception("V4 install failed " + res.getErrors());
                                }
                            }
                            catch (Exception x) {
                                x.printStackTrace(System.out);
                                System.out.flush();
                                ret = new Message(-1);
                                ret.append(StackTracer.getStacktrace((Throwable)x));
                            }
                        }
                    } else {
                        File configFile;
                        if (type == 25000) {
                            System.out.println("[MiniController] Request for SG config");
                            configFile = SimpleGatewayConfig.getConfigLocation();
                            if (configFile == null || !configFile.exists()) {
                                configFile = new File(sgServiceDir, "serviceconfig.xml");
                            }
                            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(configFile));
                            try {
                                byte[] dat = StreamUtils.readAll(fin);
                                ret = new Message(1);
                                ret.append(dat);
                            }
                            catch (Exception x) {
                                try {
                                    fin.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw x;
                            }
                        }
                        if (type == 26000) {
                            System.out.println("[MiniController] Request to store SG config");
                            configFile = SimpleGatewayConfig.getConfigLocation();
                            if (configFile == null || !configFile.exists()) {
                                configFile = new File(sgServiceDir, "serviceconfig.xml");
                            }
                            FileOutputStream fout = new FileOutputStream(configFile);
                            try {
                                System.out.println("[MiniController] Writing config...");
                                fout.write((byte[])m.get(0));
                                fout.flush();
                                fout.close();
                                System.out.println("[MiniController] Config written OK");
                                ret = new Message(1);
                            }
                            catch (Exception x) {
                                try {
                                    fout.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                throw x;
                            }
                        }
                        System.out.println("[MiniController] Unrecognised message: " + m);
                        ret = new Message(-2);
                    }
                } else {
                    System.out.println("[MiniController] Unrecognised message: " + m);
                    ret = new Message(-2);
                }
                BCUtilMessenger.writeMsg(bcu, out, ret);
                if (!andFinish) continue;
                System.out.println("[MiniController] Will exit now");
                Thread.sleep(2000L);
                System.exit(0);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.out.println("[MiniController] Session complete, exiting");
            System.exit(0);
            return;
        }
    }
}

