/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.common.SpecialFolderUtil;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.server.controller.InputServer;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.sdesktop.util.FTPUtil;
import com.aem.sdesktop.util.FTPUtilServer;
import com.aem.sdesktop.util.Version;
import com.aem.shelp.util.WEnv;
import com.aem.utils.Debugger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.ostools.OS;
import utils.swing.components.path.elements.FTPVolume;
import utils.swing.components.path.elements.OSXVolumeUtil;

public class FTPServer
extends Thread
implements MSG,
GC,
ServerPart {
    MessageReader min;
    MessageWriter mout;
    MessageReader get_in;
    MessageWriter get_out;
    MessageReader put_in;
    MessageWriter put_out;
    MessageReader crc_serv_in;
    MessageWriter crc_serv_out;
    MessageReader crc_client_in;
    MessageWriter crc_client_out;
    SDesktopServerController controller;
    SDesktopServerInstance instance;
    FTPUtilServer utilserver;
    InputServer inputserver;
    FileSystemView fileSystemView;
    boolean die = false;
    private long maxFileSize = -1L;
    boolean[] put_cancel = new boolean[]{false};

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public FTPServer(SDesktopServerInstance instance, SDesktopServerController controller, InputStream input, OutputStream output, InputStream input2, OutputStream output2, InputStream input3, OutputStream output3, InputStream crc_s_input, OutputStream crc_s_output, InputStream crc_c_input, OutputStream crc_c_output, InputServer inputserver, long maxFileSize) {
        super("FTPServerThread");
        try {
            this.fileSystemView = FileSystemView.getFileSystemView();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.maxFileSize = maxFileSize;
        this.controller = controller;
        this.instance = instance;
        this.inputserver = inputserver;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        this.get_in = new MessageReader(input2);
        this.get_out = new MessageWriter(output2);
        this.put_in = new MessageReader(input3);
        this.put_out = new MessageWriter(output3);
        this.crc_serv_in = new MessageReader(crc_s_input);
        this.crc_serv_out = new MessageWriter(crc_s_output);
        this.crc_client_in = new MessageReader(crc_c_input);
        this.crc_client_out = new MessageWriter(crc_c_output);
        try {
            this.utilserver = new FTPUtilServer(this.crc_serv_in, this.crc_serv_out, this.crc_client_in, this.crc_client_out);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void run() {
        new Getter().start();
        new Putter().start();
        Message m = null;
        try {
            while (!this.die) {
                m = this.min.read();
                if ((m = this.handleMessage(m)) == null) continue;
                this.mout.write(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(FTP Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[FTPServer] " + e);
            }
            this.log("[FTP Server] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in FTPServer: " + Debugger.getStackTrace(e));
            System.out.println("(FTP Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public Message handleMessage(Message m) throws IOException {
        Message ret;
        block64: {
            int type = m.getType();
            ret = new Message(-286392320);
            if (type == 458753) {
                File[] roots;
                ret = new Message(458753);
                if (OS.isMacOS()) {
                    roots = OSXVolumeUtil.getMacRoots();
                    for (File file : roots) {
                        ret.append(file.getName());
                        ret.append(file.getPath());
                        ret.append(OSXVolumeUtil.isOSXRootDrive(file));
                        ret.append(false);
                    }
                } else {
                    roots = File.listRoots();
                    for (File file : roots) {
                        String name;
                        block63: {
                            name = file.getName();
                            try {
                                if (this.fileSystemView != null) {
                                    name = this.fileSystemView.getSystemDisplayName(file);
                                }
                            }
                            catch (Throwable t) {
                                boolean ignore = false;
                                if (t instanceof NullPointerException && OS.isWindows()) {
                                    System.out.println("[FtpServer] Unable to get fileSystemView systemDisplayName (null) this is expected on windows");
                                    ignore = true;
                                }
                                if (ignore) break block63;
                                t.printStackTrace();
                            }
                        }
                        String path = file.getPath();
                        if (OS.isWindows() && path.endsWith(File.separator)) {
                            path = path.substring(0, path.length() - 1);
                        }
                        if (name.length() == 0) {
                            name = path;
                        }
                        ret.append(name);
                        ret.append(path);
                        ret.append(false);
                        ret.append(false);
                    }
                }
                FTPVolume[] specials = SpecialFolderUtil.getSpecialFTPVolumes();
                System.out.println("[FTPServer] Got " + specials.length + " shortcuts");
                for (Comparable<File> comparable : specials) {
                    System.out.println("[FTPServer] Appending shortcut " + ((FTPVolume)comparable).name);
                    ret.append(((FTPVolume)comparable).name);
                    ret.append(((FTPVolume)comparable).path);
                    ret.append(((FTPVolume)comparable).isOSXRoot);
                    ret.append(((FTPVolume)comparable).isShortcut);
                }
            } else if (type == 458801) {
                String name = m.getNextString();
                ret = new Message(458801);
                if (OS.isWindows()) {
                    ret.append(WEnv.getEnv(name));
                } else {
                    ret.append(System.getenv(name));
                }
            } else if (type == 458786) {
                ret = new Message(458786);
                try {
                    List files = ClipboardUtil.getClipboardAsFiles();
                    for (int i = 0; i < files.size(); ++i) {
                        File f = (File)files.get(i);
                        ret.append(f.getCanonicalPath());
                    }
                }
                catch (Exception e) {
                    ret = new Message(458786);
                }
            } else if (type == 458784) {
                ret = new Message(458784);
                String tmpdir = System.getProperty("java.io.tmpdir");
                if (!tmpdir.endsWith(File.separator)) {
                    tmpdir = tmpdir + File.separator;
                }
                ret.append(tmpdir);
                String homedir = System.getProperty("user.home");
                if (!homedir.endsWith(File.separator)) {
                    homedir = homedir + File.separator;
                }
                if (homedir.length() == 3) {
                    homedir = homedir.substring(0, 2);
                }
                ret.append(homedir);
            } else if (type == 458754) {
                ret = new Message(458754);
                ret.append(File.separator);
            } else if (type == 458791) {
                String path = (String)m.get(0);
                ret = new Message(458791);
                ret.append(new File(path).length());
            } else if (type == 458755) {
                String path = (String)m.get(0);
                if (OS.isWindows() && path.length() == 2 && path.charAt(1) == ':') {
                    path = path + File.separator;
                }
                System.out.println("[FTPServer] Dir of " + path);
                File[] files = new File(path).listFiles();
                ret = new Message(458755);
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        Message message = new Message();
                        message.append(files[i].getName());
                        message.append(files[i].length());
                        message.append(files[i].lastModified());
                        message.append(files[i].isDirectory());
                        message.append(files[i].isHidden());
                        message.append(this.isRoot(files[i]));
                        ret.append(message);
                    }
                }
            } else if (type == 458770) {
                this.put_cancel[0] = true;
                ret = new Message(458770);
            } else if (type == 458788) {
                ret = new Message(458788);
                String dir = (String)m.get(0);
                String oldname = (String)m.get(1);
                String newname = (String)m.get(2);
                if (this.inputserver != null) {
                    if (this.inputserver.isVistaFileTransferRequired()) {
                        this.inputserver.vistaRenameFile(new File(dir + File.separatorChar + oldname).getAbsolutePath(), new File(dir + File.separatorChar + newname).getAbsolutePath());
                    } else {
                        new File(dir + File.separatorChar + oldname).renameTo(new File(dir + File.separatorChar + newname));
                    }
                } else {
                    new File(dir + File.separatorChar + oldname).renameTo(new File(dir + File.separatorChar + newname));
                }
            } else if (type == 458787) {
                ret = new Message(458787);
                String dir = (String)m.get(0);
                String file = (String)m.get(1);
                System.out.println("[FTPServer] Creating new file " + file + " in " + dir);
                File f = new File(dir + File.separatorChar + file);
                System.out.println("[FTPServer] Target is " + f);
                if (this.inputserver != null) {
                    if (this.inputserver.isVistaFileTransferRequired()) {
                        this.inputserver.vistaNewFolder(f.getAbsolutePath());
                    } else {
                        f.mkdirs();
                    }
                } else {
                    f.mkdirs();
                }
            } else if (type == 458772) {
                ret = new Message(458772);
                try {
                    String dir = (String)m.get(0);
                    String file = (String)m.get(1);
                    File f = new File(dir + File.separatorChar + file);
                    if (this.inputserver != null) {
                        if (this.inputserver.isVistaFileTransferRequired()) {
                            this.inputserver.vistaDeleteFile(f.getAbsolutePath());
                        } else {
                            FTPUtil.deleteFiles(f);
                        }
                        break block64;
                    }
                    FTPUtil.deleteFiles(f);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (type == 458771) {
                String remotedir = (String)m.get(0);
                String remotefile = (String)m.get(1);
                Long start = (Long)m.get(2);
                Long length = (Long)m.get(3);
                ret = new Message(458771);
                if (start != 0L) {
                    ret.append(new byte[0]);
                } else {
                    ret.append(FTPUtil.getCRC64(new File(remotedir + File.separatorChar + remotefile), length));
                }
            } else if (type == 458774) {
                ret = new Message(458775);
                ret.append(5.0);
                ret.append(1.0);
            } else {
                this.log("unrecognised FTP server message " + m);
            }
        }
        return ret;
    }

    private boolean isRoot(File file) {
        try {
            return this.fileSystemView.isFileSystemRoot(file);
        }
        catch (Throwable t) {
            String path = file.getAbsolutePath();
            if (path.endsWith(":\\")) {
                return true;
            }
            if (path.equals("/")) {
                return true;
            }
            int lastBackslash = path.lastIndexOf(92);
            return path.startsWith("\\\\") && lastBackslash == 1;
        }
    }

    class Getter
    extends Thread {
        Getter() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Message m = FTPServer.this.get_in.read();
                    String localdir = m.getNextString();
                    String remotedir = m.getNextString();
                    String remotefile = m.getNextString();
                    if (m.getType() == 458790) {
                        FTPUtil.putFileNoRestart(0, Version.getEncodedCurrentVersion(), FTPServer.this.utilserver, FTPServer.this.get_out, remotedir, localdir, remotefile, FTPServer.this.put_cancel, null, FTPServer.this.maxFileSize);
                    } else {
                        FTPUtil.putFile(0, Version.getEncodedCurrentVersion(), FTPServer.this.utilserver, FTPServer.this.get_out, remotedir, localdir, remotefile, FTPServer.this.put_cancel, null, FTPServer.this.maxFileSize);
                    }
                    FTPServer.this.put_cancel[0] = false;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
        }
    }

    class Putter
    extends Thread {
        Putter() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    FTPUtil.receiveFile(0, FTPServer.this.put_in, FTPServer.this.inputserver);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

