/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.sdesktop.client.gui.tools.ui.OnOffToolButton;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TransientTechUser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import utils.swing.components.TitledListView;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.oem.OEMSwitches;

public class ToolsPanel
implements NodeLinkStatusListener {
    private JPanel rootComponent = new JPanel(new GridLayout(1, 1));
    private Tool[] tools;
    private final ArrayList<AbstractToolButton> buttons = new ArrayList();
    private ChangeListener listener;
    private TechGroupPermissions permissions;
    private TitledListView.ListItem[] listItems;
    public static final boolean SHOW_ADVANCED = false;
    private static final int GAP = 2;
    private static final Border topBorder = SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR_LIGHT);
    private static final Border padded = SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)2);
    private static final Border noPad = SHBorderFactory.createEmptyBorder((int)0, (int)2, (int)2, (int)2);
    private static final Border topBorderPadded = SHBorderFactory.createCompoundBorder((Border)topBorder, (Border)padded);

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            return this.buttons.size() == 0;
        }
    }

    public ToolsPanel(Tool[] tools) {
        this.tools = tools;
    }

    public ToolsPanel(Tool[] tools, ChangeListener listener) {
        this.tools = tools;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI(int remoteOSBase, int remoteOSVariant) {
        ArrayList<ToolsListItem> listItemsList = new ArrayList<ToolsListItem>();
        boolean showAllToolsRegardlessOfOS = remoteOSBase == -1;
        for (Tool tool : this.tools) {
            if (!tool.showForThisRemoteOS(remoteOSBase, remoteOSVariant) && !showAllToolsRegardlessOfOS) continue;
            AbstractToolButton button = tool.initToolButtonUI(this.listener);
            ArrayList<AbstractToolButton> arrayList = this.buttons;
            synchronized (arrayList) {
                this.buttons.add(button);
            }
            listItemsList.add(new ToolsListItem(tool, button.getRootComponent()));
        }
        this.listItems = new TitledListView.ListItem[listItemsList.size()];
        listItemsList.toArray(this.listItems);
        OnOffListView oflv = new OnOffListView(this.listItems);
        final JScrollPane sp = new JScrollPane(oflv.getRootComponent());
        sp.setBorder(null);
        this.setTechnicianPermissions(this.permissions);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ToolsPanel.this.rootComponent.getComponentCount() != 0) {
                    ToolsPanel.this.rootComponent.removeAll();
                }
                ToolsPanel.this.rootComponent.add(sp);
                ToolsPanel.this.rootComponent.revalidate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OnOffToolButton getButtonForTool(Class toolClass) {
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            for (AbstractToolButton button : this.buttons) {
                OnOffToolButton toolButton = (OnOffToolButton)button;
                if (!toolButton.getTool().getClass().equals(toolClass)) continue;
                return toolButton;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isToolEnabled(Class toolClass) {
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            OnOffToolButton buttonForTool = this.getButtonForTool(toolClass);
            if (buttonForTool != null) {
                return buttonForTool.isOn();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToolState(Class toolClass, boolean enabled) {
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            OnOffToolButton buttonForTool = this.getButtonForTool(toolClass);
            if (buttonForTool != null) {
                if (enabled) {
                    buttonForTool.setOn();
                } else {
                    buttonForTool.setOff();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnabled(boolean b) {
        System.out.println("[ToolsPanel] Enabling tools is " + b);
        this.rootComponent.setEnabled(b);
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            for (AbstractToolButton button : this.buttons) {
                button.setEnabled(b);
            }
        }
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.initUI(remoteOsBase, remoteOsVariant);
        this.setEnabled(this.rootComponent.isEnabled());
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        for (Tool tool : this.tools) {
            tool.linkDown(link, reason);
        }
    }

    @Override
    public void linkOK(NodeLink link) {
        for (Tool tool : this.tools) {
            tool.linkOK(link);
        }
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        for (Tool tool : this.tools) {
            tool.linkDead(link, reason);
        }
    }

    public void setTechUser(TransientTechUser user) {
        for (Tool tool : this.tools) {
            tool.setTechUser(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechnicianPermissions(TechGroupPermissions permissions) {
        System.out.println("[ToolsPanel] Settings tech group permissions.");
        this.permissions = permissions;
        ArrayList<AbstractToolButton> arrayList = this.buttons;
        synchronized (arrayList) {
            System.out.println("[ToolsPanel] Configuring " + this.buttons.size() + " buttons");
            for (AbstractToolButton toolButton : this.buttons) {
                boolean isPermitted = true;
                if (permissions != null) {
                    isPermitted = toolButton.getTool().isPermitted(permissions);
                }
                toolButton.setVisible(isPermitted);
                System.out.println("[ToolsPanel] Permission for " + toolButton.getTool().title + " is " + isPermitted);
            }
        }
        this.rootComponent.repaint();
    }

    class HeaderPanel
    extends JPanel {
        private String title;

        public HeaderPanel(String title) {
            this.title = title;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            if (!OEMSwitches.DARK_THEME) {
                g2d.setPaint(SHButtonUI.getFill((SHUI.ButtonColor)SHUI.BUTTON_BLUE, (boolean)true, (int)SimpleHelpLookAndFeel.scale((int)26), (boolean)false));
            } else {
                g2d.setPaint(SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER);
            }
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.height = SimpleHelpLookAndFeel.scale((int)26);
            return d;
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            d.height = SimpleHelpLookAndFeel.scale((int)26);
            return d;
        }
    }

    class OnOffListView
    extends TitledListView
    implements MouseListener {
        public OnOffListView(TitledListView.ListItem[] items) {
            super(items);
            String title = null;
            for (int i = 0; i < items.length; ++i) {
                if (title == null || !title.equals(items[i].groupTitle)) {
                    title = items[i].groupTitle;
                    items[i].component.setBorder(topBorderPadded);
                    continue;
                }
                items[i].component.setBorder(topBorderPadded);
            }
        }

        @Override
        protected JComponent getTitleComponentFor(TitledListView.ListItem item) {
            if (item instanceof ToolsListItem) {
                HeaderPanel header = new HeaderPanel("");
                header.setLayout(new BorderLayout(0, 0));
                JLabel label = new JLabel(" " + item.groupTitle);
                if (!OEMSwitches.DARK_THEME) {
                    label.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
                } else {
                    label.setForeground(Color.white);
                }
                boolean atLeastHasOneAdvanced = false;
                for (int i = 0; i < this.items.length; ++i) {
                    ToolsListItem tli = (ToolsListItem)this.items[i];
                    if (!tli.groupTitle.equals(item.groupTitle) || !tli.tool.isAdvanced()) continue;
                    atLeastHasOneAdvanced = true;
                    break;
                }
                JLabel advancedLabel = new JLabel(Language.get("ADVANCED") + "   ");
                advancedLabel.putClientProperty("SH_CUSTOM_GROUP", item.groupTitle);
                if (!OEMSwitches.DARK_THEME) {
                    advancedLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHT);
                } else {
                    advancedLabel.setForeground(Color.white);
                }
                advancedLabel.setFont(SHStyle.smallFont);
                header.add("West", label);
                if (atLeastHasOneAdvanced) {
                    // empty if block
                }
                advancedLabel.addMouseListener(this);
                return header;
            }
            return super.getTitleComponentFor(item);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JLabel advancedLabel = (JLabel)e.getSource();
            String currentText = advancedLabel.getText().trim();
            if (currentText.equals(Language.get("ADVANCED"))) {
                advancedLabel.setText(Language.get("HIDE_ADVANCED") + "   ");
            } else {
                advancedLabel.setText(Language.get("ADVANCED") + "   ");
            }
            String groupTitle = (String)advancedLabel.getClientProperty("SH_CUSTOM_GROUP");
            for (int i = 0; i < this.items.length; ++i) {
                ToolsListItem tli = (ToolsListItem)this.items[i];
                if (!tli.groupTitle.equals(groupTitle) || !tli.tool.isAdvanced()) continue;
                tli.setShouldBeShown(!tli.shouldBeShown());
            }
            this.getRootComponent().revalidate();
            this.getRootComponent().repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ((JComponent)e.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            ((JComponent)e.getSource()).setCursor(Cursor.getDefaultCursor());
        }
    }

    class ToolsListItem
    extends TitledListView.ListItem {
        private Tool tool;
        private boolean shouldBeShown;

        public ToolsListItem(Tool tool, JComponent component) {
            super(tool.group, component);
            this.shouldBeShown = true;
            this.shouldBeShown = true;
            this.tool = tool;
        }

        public void setShouldBeShown(boolean visible) {
            this.shouldBeShown = visible;
            this.component.setVisible(this.shouldBeShown);
        }

        @Override
        public boolean shouldBeShown() {
            return this.shouldBeShown;
        }
    }
}

