/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CdbgLauncher;
import com.aem.CdbgLauncherListener;
import com.aem.CentralDebugging;
import com.aem.ClientManagement;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStats;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.vis.NLOptimisationFeed;
import com.aem.sdesktop.ClientBranding;
import com.aem.sdesktop.CloseListener;
import com.aem.sdesktop.SimpleDesktop;
import com.aem.sdesktop.SplashGradientPanel;
import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.controller.IgnoredCommandResponseListener;
import com.aem.sdesktop.client.controller.MultiController;
import com.aem.sdesktop.client.gui.CentrePanel;
import com.aem.sdesktop.client.gui.CommandPanel;
import com.aem.sdesktop.client.gui.DiagnosticsPanel;
import com.aem.sdesktop.client.gui.EastPanel;
import com.aem.sdesktop.client.gui.FileTransferPanel;
import com.aem.sdesktop.client.gui.GUIPrefs;
import com.aem.sdesktop.client.gui.HintOverlayManager;
import com.aem.sdesktop.client.gui.NorthPanel;
import com.aem.sdesktop.client.gui.ReconnectHandler;
import com.aem.sdesktop.client.gui.tools.DisableGraphicsDriver;
import com.aem.sdesktop.common.FileTransferStats;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.server.sounds.SHSounds;
import com.aem.sdesktop.util.ConnectionSpeedListener;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.sdesktop.util.MainApplet;
import com.aem.sdesktop.util.MainPanel;
import com.aem.sdesktop.util.PortRedirector;
import com.aem.sdesktop.util.TabbedWindow;
import com.aem.shelp.common.ConnectedTarget;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.ProxyConnectSettings;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.common.properties.WindowBoundsUtil;
import com.aem.shelp.common.toolbox.ToolBox;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.types.AccessSession;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.ActivityTracker;
import com.aem.shelp.tech.notifiers.NotificationOptionsPanel;
import com.aem.shelp.tech.utils.FailoverDialog;
import com.aem.shelp.tech.video.VideoRecorder;
import com.aem.shelp.tech.vnc.VNCConnectGlassDialog;
import com.aem.shelp.tech.vnc.VNCCredentialsGlassDialog;
import com.aem.shelp.util.ErrorDialogs;
import com.aem.shelp.util.RemoteMachinePasswordDialog;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.WebTransactor;
import com.aem.shelp.util.notifications.NotificationPanel;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import com.aem.tests.TestUtils;
import com.aem.tests.Testing;
import com.aem.utils.CursorInfo;
import com.aem.utils.DropDownComponent;
import com.aem.utils.NativeEventUtil;
import com.aem.utils.keyhandling.KeyRequest;
import com.aem.utils.sound.SampledSound;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.EventListener;
import javax.sound.sampled.Mixer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.FailoverMonitor;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.swing.JWAutomate;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.updater.JWLaunchProperties;
import utils.message.Message;
import utils.osstats.types.SessionInfo;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;
import utils.ostools.osx.OSXApplicationInterface;
import utils.progtools.MemoryCleaner;
import utils.swing.SwingUtil;
import utils.swing.components.SHSplitPane;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.switches.Switches;

public class GUI
implements KeyListener,
MouseListener,
MouseMotionListener,
WindowFocusListener,
FocusListener,
ClientUserInterface,
GuiConstants,
WindowListener,
NodeLinkStatusListener,
ConnectionSpeedListener,
OSXApplicationInterface,
JWNativeAPI.KeybookHookCallback,
CdbgLauncherListener,
OSXAdapter.OSXFullScreenListener,
FailoverListener {
    private int mode = 0;
    private int modeScreenCapture = 0;
    private int SCREEN_X = 0;
    private int SCREEN_Y = 0;
    private int SCREEN_COUNT = 0;
    private int SCREEN_REMOTE_SCALING_PERCENTAGE = 100;
    private boolean haveFocus = true;
    private final MainPanel mainpanel;
    private TabbedWindow mainwin;
    private MainApplet mainapplet;
    private ActivityTracker activityTracker;
    private ClientController con;
    private NorthPanel northp;
    private EastPanel eastp;
    private CommandPanel clipanel;
    private CentrePanel centrep;
    private FileTransferPanel ftp;
    private DiagnosticsPanel diag;
    private NotificationPanel northNotificationPanel;
    private final ReconnectHandler reconnectHandler;
    private final FullscreenMouseMotionListener fullscreenListener = new FullscreenMouseMotionListener();
    private Object osxFullScreenListenerProxy = null;
    private boolean consumeHotkeysLocally = true;
    private final Color got_focus = Color.cyan;
    private final Color not_focus = Color.black;
    private final JButton focus_holder = new JButton("");
    private int remoteOsBase;
    private int remoteOsVariant;
    private boolean north_always_on = true;
    private boolean east_on = true;
    private boolean south_on = true;
    private boolean west_on = true;
    private boolean north_on_prev = true;
    private boolean east_on_prev = true;
    private boolean south_on_prev = true;
    private boolean fullscreen_ok = false;
    private boolean applet = false;
    private boolean linkOK = false;
    private final CloseListener closeListener;
    private final SimpleDesktop.ReconnectListener reconnectListener;
    private boolean vncSessionIsActive = false;
    private ProxyConnectSettings connectSettings;
    private HintOverlayManager hintManager = new HintOverlayManager();
    private ThreadGroup threadGroup;
    private boolean mobileSession = false;
    private boolean cleanup;
    static boolean firstLoad = true;
    private int lastUpgradeLocal;
    private boolean chatDisabled = false;
    private boolean rdpDisabled = false;
    private String title;
    private DropDownComponent.Notification trackingNotification;
    private boolean loadedPreferencesFirstTime = false;
    private String initialZoomSetting = null;
    long t = 0L;
    private boolean was_on = false;
    private boolean was_updating = false;
    private boolean updateWarningIsUp = false;
    private final Object uwt_LOCK = new Object();
    private UpdateWarningThread uwt = null;
    private boolean alreadyPromptedForMmoveFailure = false;
    private final GUIPrefs windowed = new GUIPrefs();
    private final GUIPrefs fullscreen = new GUIPrefs();
    private TechGroupPermissions permissions;
    private TransientTechUser techUser;
    boolean ignoreLinkEvents = false;
    private static final JComponent NATIVE_UTILS_SOURCE = new JPanel();
    WebTransactor wtrans;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIcon() {
        if (OS.isMacOS()) {
            System.out.println("[SimpleDesktop] Setting dock icon");
            try {
                Image iconImage = ImageLoader.getAsImage((String)"images/svg/logos/simplehelp-empty.svg,128");
                BufferedImage image = new BufferedImage(256, 256, 2);
                BufferedImage screenImage = this.centrep.getScreenImage();
                Graphics2D g2d = image.createGraphics();
                try {
                    Rectangle rect = this.centrep.getGrabRectangle();
                    g2d.drawImage(screenImage, 0, 0, 256, 256, rect.x, rect.y, rect.width, rect.height, null);
                    g2d.drawImage(iconImage, image.getWidth() - iconImage.getWidth(null), image.getHeight() - iconImage.getHeight(null), null);
                }
                finally {
                    g2d.dispose();
                }
                OSXAdapter.setDockIcon((Image)image);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("[SimpleDesktop] Set dock icon");
        }
    }

    public GUI() {
        this(false, null, null);
    }

    public GUI(boolean applet, CloseListener closeListener, SimpleDesktop.ReconnectListener reconnectListener) {
        this.closeListener = closeListener;
        this.reconnectListener = reconnectListener;
        this.applet = applet;
        this.threadGroup = Thread.currentThread().getThreadGroup();
        if (Testing.amTesting() && !Testing.queryTestingBoolean("TEST_TECHUI_LOGIN_DEFER_CONTROL") && !Testing.queryTestingBoolean("TEST_SESSIONS_CHECK_CONN_STABILITY")) {
            if (Testing.queryTestingBoolean("TEST_SESSIONS_CHECK_PATCHING")) {
                Testing.startExitThread(3600);
            } else {
                Testing.startExitThread(300);
            }
        }
        if (!applet) {
            this.mainwin = new TabbedWindow(ClientBranding.get().getApplicationName(false)){

                @Override
                public void windowClosing(WindowEvent e) {
                }
            };
            this.mainwin.getFrame().setDefaultCloseOperation(0);
            this.mainwin.getFrame().addWindowListener(this);
            this.mainwin.getFrame().addWindowFocusListener(this);
            this.mainpanel = this.mainwin;
            if (!Switches.SH_tabbedSessions) {
                this.mainwin.getFrame().setLocationRelativeTo(null);
            }
            if (OSXAdapter.enableOSXFullscreen((Window)this.mainwin.getFrame())) {
                this.osxFullScreenListenerProxy = OSXAdapter.addOSXFullScreenListener((Window)this.mainwin.getFrame(), (OSXAdapter.OSXFullScreenListener)this);
            }
        } else {
            this.mainapplet = MainApplet.getApplet();
            this.mainpanel = this.mainapplet;
        }
        this.mainwin.getFrame().addComponentListener(new ResizeListener());
        this.reconnectHandler = new ReconnectHandler(this.mainwin.getFrame(), this, reconnectListener);
        if (CdbgLauncher.INSTANCE != null) {
            CdbgLauncher.INSTANCE.setCdbgLaunchedListener(this);
        }
    }

    @Override
    public void loadBoundsOfWindow() {
        WindowBoundsUtil.DesiredWindowBounds desiredWindowBounds = WindowBoundsUtil.getDesiredWindowBounds();
        if (desiredWindowBounds != null) {
            boolean alreadySet = false;
            if (this.connectSettings != null && this.connectSettings.desiredWindowBounds != null && this.connectSettings.desiredWindowBounds.equals(desiredWindowBounds)) {
                alreadySet = true;
            }
            if (!alreadySet) {
                desiredWindowBounds.applyToWindow(this.mainwin.getFrame());
            }
        }
    }

    public void setCollectDiagnostics(boolean collectDiagnostics) {
        this.diag.setCollectDiagnostics(collectDiagnostics);
    }

    public StyledDocument getChatDocument() {
        return this.eastp.getChatDocument();
    }

    public void timeoutSession() {
        System.out.println("[GUI] Session timeout exceeded");
        this.setCentreGreyOverlay(Language.get("SESSION_TIMEOUT_1"), -1L, false);
        this.terminateSession(Language.get("SESSION_TIMEOUT_1"));
    }

    private String getTransportName(int type) {
        if (type == -1) {
            return Language.get("TRANSPORT_ANY");
        }
        if (type == 0) {
            return Language.get("TRANSPORT_UDP_DX");
        }
        if (type == 1) {
            return Language.get("TRANSPORT_UDP_PX");
        }
        if (type == 5) {
            return Language.get("TRANSPORT_TCP_DX");
        }
        if (type == 2) {
            return "TCP";
        }
        if (type == 3) {
            return "SSL";
        }
        if (type == 4) {
            return "HTTP";
        }
        return "?";
    }

    @Override
    public void upgradeStarted(int local, int remote) {
        this.lastUpgradeLocal = local;
        this.setTopLeftGreyOverlay(Language.get("TRYING_SWITCH") + " (" + this.getTransportName(local) + ")", 60000L);
        if (local == 0 || local == 1 || local == 5 || local == remote) {
            this.setTopLeftGreyOverlay(Language.get("TRYING_SWITCH") + " (" + this.getTransportName(local) + ")", 60000L);
        } else {
            this.setTopLeftGreyOverlay(Language.get("TRYING_SWITCH") + " (" + this.getTransportName(local) + " " + Language.get("TRANSPORT_TO_TRANSPORT") + " " + this.getTransportName(remote) + ")", 60000L);
        }
    }

    @Override
    public void upgradeFailed(boolean firstStageWorked) {
        if (!firstStageWorked) {
            this.setTopLeftGreyOverlay(Language.get("TRIED_SWITCH_FAILED"), 5000L);
        } else {
            this.setTopLeftGreyOverlay(Language.get("TRIED_SWITCH_FAILED_SECOND"), 5000L);
        }
    }

    @Override
    public void upgradeComplete() {
        if (this.lastUpgradeLocal == 0 || this.lastUpgradeLocal == 1) {
            this.setTopLeftGreyOverlay(Language.get("TRIED_SWITCH_OK_OPT"), 5000L);
        } else {
            this.setTopLeftGreyOverlay(Language.get("TRIED_SWITCH_OK"), 5000L);
        }
        this.eastp.upgradeComplete();
        this.northp.upgradeComplete();
    }

    @Override
    public void recommendTcp() {
        this.northNotificationPanel.showYesNoQuestion(Language.get("TCP_SWITCH_TITLE_ALT"), Language.get("TCP_SWITCH_QUESTION_1_ALT") + "\n" + Language.get("TCP_SWITCH_QUESTION_2_ALT"), new TCPSwitchListener(), false);
    }

    @Override
    public void showSessionInfoDialog() {
        this.northp.showSessionInfoDialog();
    }

    public void forceReconnect() {
        this.setConnected(false, false, null);
        this.reconnectHandler.setShowReconnectDialog(false);
        if (this.northp.canReconnectToRAS()) {
            this.setCentreGreyOverlay(new String[]{Language.get("RECONNECT_RAS_1"), Language.get("RECONNECT_RAS_2")}, 15000L, true);
        } else {
            this.setCentreGreyOverlay(Language.get("RECONNECTING"), 5000L, true);
        }
        this.reconnectHandler.doReconnect();
    }

    @Override
    public void disableChat() {
        this.chatDisabled = true;
        System.out.println("[GUI] Disabling chat");
        this.eastp.disableChat();
        this.northp.disableChat();
    }

    @Override
    public void disableDesktop() {
        this.rdpDisabled = true;
        System.out.println("[GUI] Disabling Remote Desktop");
        this.updateContainer(this.mainpanel.centre_panel());
        this.northp.disableRemoteDesktop();
        if (this.isRemoteDesktopMode()) {
            try {
                this.setFileTransferMode();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void setCanUninstallSG(boolean can) {
        this.northp.setCanUninstallSG(can);
    }

    public void cancelTracking() {
        this.centrep.cancelTracking();
        if (this.trackingNotification != null) {
            this.northNotificationPanel.removeNotification(this.trackingNotification);
        }
    }

    public void captureRectAndTrack() {
        this.centrep.captureRectAndTrack();
    }

    @Override
    public void notifyTrackingStarted() {
        if (this.trackingNotification == null) {
            this.trackingNotification = this.northNotificationPanel.showStaticMessage(Language.get("TRACKING_MSG_TRACKING"), null, new SHProgressAnimatedIcon(), new NotificationPanel.NotificationPanelListener(){

                @Override
                public void notificationClosed(int returnCode) {
                    GUI.this.trackingNotification = null;
                    GUI.this.cancelTracking();
                    GUI.this.releaseTrackingButton();
                }
            }, true, Language.get("CANCEL"));
        }
    }

    @Override
    public void setAudioMixer(Mixer mixer) {
        if (this.con != null) {
            this.con.setMixerForAudioOutput(mixer);
        }
    }

    @Override
    public void setSessionInfo(SessionInfo info) {
        this.eastp.setSessionInfo(info);
    }

    @Override
    public FileTransferStats getFileTransferStats() {
        if (this.ftp == null) {
            return null;
        }
        return this.ftp.getFileTransferStats();
    }

    @Override
    public void notifyTrackingAlarmed() {
        final TrackingNotifyThread al = new TrackingNotifyThread();
        al.start();
        if (this.trackingNotification != null) {
            this.northNotificationPanel.removeNotification(this.trackingNotification);
        }
        this.trackingNotification = this.northNotificationPanel.showStaticMessage(Language.get("TRACKING_CHANGE_DETECTED"), null, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), new NotificationPanel.NotificationPanelListener(){

            @Override
            public void notificationClosed(int returnCode) {
                GUI.this.trackingNotification = null;
                GUI.this.releaseTrackingButton();
                al.die = true;
            }
        }, true, Language.get("CLOSE"));
        al.setNotification(this.trackingNotification);
    }

    @Override
    public void releaseTrackingButton() {
        this.northp.releaseTrackingButton();
    }

    @Override
    public void sendAllHotkeysToRemoteMachine(boolean sendHotkeys) {
        this.consumeHotkeysLocally = !sendHotkeys;
        this.centrep.setUseOverlay(!sendHotkeys);
    }

    public void mapKeycodesToKeycodes(boolean showOverlay) {
        this.centrep.mapKeycodesToKeycodes();
        if (showOverlay) {
            this.setTopLeftGreyOverlay(Language.get("MAPPING_KEY_PRESSES"), 1000L);
        }
    }

    public void mapCharactersToCharacters(boolean showOverlay) {
        this.centrep.mapCharactersToCharacters();
        if (showOverlay) {
            this.setTopLeftGreyOverlay(Language.get("MAPPING_TEXT_TYPED"), 1000L);
        }
    }

    private void setController(ClientController gcon) {
        this.con = gcon;
    }

    public void terminateSession() {
        this.terminateSession(null);
    }

    public void terminateSession(final String userMessage) {
        new Thread("TerminateSession"){

            @Override
            public void run() {
                System.out.println("[GUI] Terminating session");
                if (Switches.SH_tabbedSessions) {
                    GUI.this.reconnectHandler.setShowReconnectDialog(false);
                    GUI.this.quit();
                    return;
                }
                GUI.this.setConnected(false, false, "");
                if (GUI.this.mainwin.isFullScreen()) {
                    GUI.this.exitFullScreen(true);
                }
                GUI.this.setIgnoreLinkEvents(true);
                GUI.this.disableReconnect();
                try {
                    if (GUI.this.wtrans != null) {
                        GUI.this.wtrans.stopPolling();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (GUI.this.con != null) {
                    try {
                        GUI.this.con.closeConnection(userMessage);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        GUI.this.con.terminate();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    GUI.this.con = null;
                }
            }
        }.start();
    }

    @Override
    public void init(ClientController gcon) {
        this.init(gcon, false);
    }

    private void init(ClientController gcon, boolean preloadingOnly) {
        this.setController(gcon);
        this.initGraphics();
        this.setConnected(true, false, null);
        if (preloadingOnly) {
            return;
        }
        System.out.println("[GUI] Getting key focus...");
        this.getKeyFocus();
        System.out.println("[GUI] Checking full screen...");
        this.fullscreen_ok = this.mainpanel.isFullScreenCapable();
        System.out.println("[GUI] Setting screen size...");
    }

    @Override
    public boolean hasFocus() {
        return this.mainpanel.hasFocus();
    }

    @Override
    public void setMobileSession(boolean b) {
        this.mobileSession = b;
    }

    @Override
    public void setConnected(boolean first, boolean connected, String host) {
        System.out.println("[GUI] SetConnected connected:" + connected + " first:" + first);
        if (this.activityTracker != null) {
            this.activityTracker.die();
        }
        if (connected) {
            if (this.wtrans != null) {
                this.wtrans.ensurePolling();
            }
            this.setIgnoreLinkEvents(false);
            this.activityTracker = new ActivityTracker(this.techUser.inactivityTimeout, this);
        }
        this.eastp.setConnected(first, connected);
        this.northp.setConnected(first, connected);
        this.ftp.setConnected(connected);
        this.diag.setConnected(connected);
        this.centrep.setConnected(connected);
        try {
            if (connected) {
                this.con.sendLockingKey(20, false);
                this.con.sendLockingKey(145, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (connected) {
            this.loadStaticTechnicianPreferences();
            Message m = new Message(-1061158878);
            if (this.con != null) {
                this.con.doAsyncRemoteCommand(new RemoteMachineInfoListener(), m);
            }
            if (Testing.amTesting()) {
                JWTesting.reportSuccess((String)"Launch Session");
                JWTesting.reportScreenshot((String)"Launch Session", (JFrame)this.mainwin.getFrame(), (boolean)false);
                new Thread(new TestingThread()).start();
            }
            if (!Switches.SH_sessionsInTechUiProcess) {
                FailoverMonitor.setListener((FailoverListener)this);
            }
            if (ConnectedTarget.TARGET instanceof SupportSession) {
                this.diag.cust.load(((SupportSession)ConnectedTarget.TARGET).getCustomer());
            }
            if (!this.applet) {
                if (this.title != null) {
                    if (JWTesting.amTesting()) {
                        this.mainwin.getFrame().setTitle(JWSystem.getMyLogFile().getName() + " " + this.title);
                    } else {
                        this.mainwin.getFrame().setTitle(this.title);
                    }
                } else if (JWTesting.amTesting()) {
                    this.mainwin.getFrame().setTitle(JWSystem.getMyLogFile().getName() + " " + ClientBranding.get().getApplicationName(false));
                } else {
                    this.mainwin.getFrame().setTitle(ClientBranding.get().getApplicationName(false));
                }
            }
            if (ClientManagement.isSimpleGateway()) {
                this.reconnectListener.setAllowReconnect();
            }
        }
    }

    @Override
    public NLOptimisationFeed getNLOptimisationFeed() {
        return this.eastp;
    }

    @Override
    public NodeLinkStatusListener getNodeLinkStatusListener() {
        return this;
    }

    @Override
    public void setSessionTitle(String title) {
        this.title = title;
        this.mainwin.setSessionTitle(title);
    }

    @Override
    public void setSessionScreenshot(BufferedImage image) {
        this.mainwin.setSessionScreenshot(image);
    }

    public void updateSessionStats() {
        this.eastp.updateSessionStats();
    }

    @Override
    public void switchTransports(int local, int remote) {
        this.upgradeStarted(local, remote);
        if (this.con.switchTransports(local, remote)) {
            this.upgradeComplete();
        } else {
            this.upgradeFailed(false);
        }
    }

    public void setRemoteOS(Integer osBase, Integer osVariant) {
        this.remoteOsBase = osBase;
        this.remoteOsVariant = osVariant;
        System.out.println("[GUI] Remote OS = " + this.remoteOsBase + " , " + this.remoteOsVariant);
        this.northp.setRemoteOS(this.remoteOsBase, this.remoteOsVariant);
        this.eastp.setRemoteOS(this.remoteOsBase, this.remoteOsVariant);
        this.ftp.setRemoteOS(this.remoteOsBase, this.remoteOsVariant);
        this.centrep.setRemoteOS(this.remoteOsBase, this.remoteOsVariant);
        this.diag.setRemoteOS(this.remoteOsBase, this.remoteOsVariant);
    }

    private void loadStaticTechnicianPreferences() {
        if (this.loadedPreferencesFirstTime) {
            return;
        }
        System.out.println("[GUI] Loading static technician preferences");
        boolean showChat = true;
        boolean showMenu = true;
        boolean showStatus = true;
        boolean enableEcho = true;
        boolean enableControl = true;
        boolean showRecording = true;
        String prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_SHOW_CHAT);
        if (prop != null && prop.equalsIgnoreCase("off")) {
            showChat = false;
        }
        if ((prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_SHOW_MENU)) != null && prop.equalsIgnoreCase("off")) {
            showMenu = false;
        }
        if ((prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_ENABLE_TEXT_ECHO)) != null && prop.equalsIgnoreCase("off")) {
            enableEcho = false;
        }
        if ((prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_ENABLE_CONTROL)) != null && prop.equalsIgnoreCase("off")) {
            enableControl = false;
        }
        if ((prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_SHOW_STATUS)) != null && prop.equalsIgnoreCase("off")) {
            showStatus = false;
        }
        if ((prop = TechProperties.INSTANCE.getProp(TechProperties.PROP_SHOW_RECORDING)) != null && prop.equalsIgnoreCase("off")) {
            showRecording = false;
        }
        this.initialZoomSetting = TechProperties.INSTANCE.getProp(TechProperties.PROP_ZOOM);
        this.northp.loadStaticTechnicianPreferences();
        this.eastp.loadStaticTechnicianPreferences();
        this.setInitialZoom();
        if (!showChat) {
            this.keyPressed(112);
        }
        if (!showMenu) {
            this.keyPressed(113);
        }
        if (!showStatus) {
            this.keyPressed(114);
        }
        if (!enableControl) {
            this.northp.turnOffControlInitial();
        }
        if (!enableEcho) {
            this.northp.turnOffTextEchoInitial();
        }
        if (!showRecording) {
            this.eastp.hideRecordingButtons();
        }
        this.loadedPreferencesFirstTime = true;
    }

    private void setInitialZoom() {
        System.out.println("[SetInitialZoom] Initial Zoom = " + this.initialZoomSetting);
        if (this.initialZoomSetting != null) {
            if (this.initialZoomSetting.equals("0")) {
                this.setFitOneToOne();
            } else if (this.initialZoomSetting.equals("1")) {
                this.setFitAll();
            } else if (this.initialZoomSetting.equals("2")) {
                this.setFitHeight();
            }
            if (this.con != null) {
                this.con.notifyGrabRectangleHasChanged();
            }
        }
    }

    private void initGraphics() {
        this.centrep = new CentrePanel(this.getParentFrame(), this.con, this, this.hintManager);
        this.mainpanel.centre_panel().setLayout(new GridLayout(1, 1));
        this.eastp = new EastPanel(this.con, this, this.chatDisabled);
        this.mainpanel.east_panel().setLayout(new GridLayout(1, 1));
        this.eastp.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                GUI.this.northp.setToolsMenuVisible(true);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                GUI.this.northp.setToolsMenuVisible(false);
            }
        });
        this.ftp = new FileTransferPanel(this.con, this);
        this.diag = new DiagnosticsPanel(this.con, this);
        this.northp = new NorthPanel(this.con, this);
        this.mainpanel.north_panel().setLayout(new GridLayout(1, 1));
        this.hintManager.addOverlayListener(this.centrep);
        this.hintManager.addOverlayListener(this.northp);
        this.hintManager.addOverlayListener(this.diag);
        this.clipanel = new CommandPanel(this.con);
        this.focus_holder.setFocusCycleRoot(true);
        this.focus_holder.setFocusTraversalKeysEnabled(false);
        this.focus_holder.setPreferredSize(new Dimension(0, 1));
        this.focus_holder.addKeyListener(this);
        this.focus_holder.addFocusListener(this);
        this.mainpanel.west_panel().setLayout(new GridLayout(1, 1));
        this.centrep.addMouseListener(this);
        this.centrep.addMouseMotionListener(this);
        this.centrep.img_panel.addMouseListener(this);
        this.centrep.img_panel.addMouseMotionListener(this);
        Toolkit.getDefaultToolkit().addAWTEventListener(this.fullscreenListener, 32L);
        this.mainpanel.north_panel().add(this.northp);
        if (this.chatDisabled) {
            this.eastp.disableChat();
        }
        this.mainpanel.east_panel().add(this.eastp);
        this.mainpanel.west_panel().add(this.focus_holder);
        this.northNotificationPanel = new NotificationPanel(this.centrep);
    }

    private void setRequestedMode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GUI.this.mode == 0 && GUI.this.rdpDisabled) {
                    GUI.this.setRemoteScreenMode();
                } else if (GUI.this.mode == 1) {
                    GUI.this.mode = 0;
                    GUI.this.setFileTransferMode();
                } else if (GUI.this.mode == 2) {
                    GUI.this.mode = 0;
                    GUI.this.setDiagnosticsMode();
                } else if (GUI.this.mode == 3) {
                    GUI.this.mode = 0;
                    GUI.this.setVNCMode();
                } else if (GUI.this.mode == 4) {
                    GUI.this.mode = 4;
                    GUI.this.setTerminalMode();
                } else if (GUI.this.mode == 6) {
                    GUI.this.mode = 1;
                    GUI.this.setHeadlessMode(true);
                } else if (GUI.this.mode == 7) {
                    GUI.this.mode = 1;
                    GUI.this.setHeadlessMode(false);
                }
            }
        });
    }

    public void setTerminalMode() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.mainpanel.north_panel().removeAll();
                GUI.this.mainpanel.east_panel().removeAll();
                GUI.this.mainpanel.south_panel().removeAll();
                GUI.this.mainpanel.west_panel().removeAll();
                GUI.this.mainpanel.centre_panel().removeAll();
                GUI.this.mainpanel.flipPanel(GUI.this.mainpanel.east_panel(), false);
                GUI.this.mainpanel.centre_panel().add(((GUI)GUI.this).diag.console.getRootComponent());
                GUI.this.diag.setDedicatedTerminalMode();
                GUI.this.mainpanel.main_panel().revalidate();
                GUI.this.mainpanel.main_panel().repaint();
                GUI.this.mode = 4;
                GUI.this.modeScreenCapture = 0;
                ((GUI)GUI.this).diag.console.grabFocus();
            }
        });
    }

    private void setHeadlessMode(final boolean fileTransfer) {
        if (this.permissions != null && !this.permissions.canUseFileTransfer()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.mainpanel.east_panel().removeAll();
                GUI.this.mainpanel.flipPanel(GUI.this.mainpanel.east_panel(), false);
                GUI.this.mainpanel.centre_panel().removeAll();
                GUI.this.mainpanel.centre_panel().add(GUI.this.ftp);
                if (fileTransfer) {
                    GUI.this.northp.setMode(6);
                } else {
                    GUI.this.northp.setMode(7);
                }
                GUI.this.mainpanel.centre_panel().revalidate();
                GUI.this.mainpanel.centre_panel().repaint();
                if (fileTransfer) {
                    GUI.this.mode = 6;
                } else {
                    GUI.this.mode = 7;
                }
            }
        });
    }

    public void getKeyFocus() {
        if (this.focus_holder != null && this.haveFocus && !this.focus_holder.hasFocus()) {
            this.focus_holder.grabFocus();
            this.focus_holder.requestFocus();
        }
    }

    @Override
    public void showServerDisabledMessage() {
    }

    public void setDesktopScreenGray(boolean grey) {
        this.centrep.img_panel.setGrayScale(grey);
    }

    @Override
    public void keyLayoutAvailable() {
        this.northp.keyLayoutAvailable();
    }

    @Override
    public Rectangle getGrabRectangle() {
        return this.centrep.getGrabRectangle();
    }

    @Override
    public void addMessage(String user, String host, String message) {
        this.eastp.addMessage(user, host, message);
        this.northp.incrementChatCount();
        System.out.println("Added message " + user + "@" + host + ": " + message);
        if (!this.eastp.chatPanel.isTechnicianMessage(user, host)) {
            try {
                SampledSound chatNotificationSound = NotificationOptionsPanel.getChatNotificationSound(TechProperties.INSTANCE.getMyProperties());
                System.out.println("[GUI] Notifying technician with sound " + chatNotificationSound);
                if (chatNotificationSound != null) {
                    SHSounds.play(chatNotificationSound);
                }
            }
            catch (Throwable t) {
                System.out.println("[GUI] Unable to play new chat sound (" + t.getMessage() + ")");
            }
        }
    }

    public void setDefaultMode() {
        this.setRemoteScreenMode();
    }

    @Override
    public String getChatText() {
        return this.eastp.getChatText();
    }

    public void setRemoteScreenMode() {
        Message vncMessage = new Message(-1061158859);
        vncMessage.append(false);
        if (this.con != null) {
            this.con.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), vncMessage);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.mainpanel.centre_panel().removeAll();
                GUI.this.mainpanel.centre_panel().add(GUI.this.centrep);
                GUI.this.northp.setMode(0);
                GUI.this.mainpanel.centre_panel().revalidate();
                GUI.this.mainpanel.centre_panel().repaint();
                if (!GUI.this.east_on && GUI.this.was_on) {
                    GUI.this.was_on = false;
                    GUI.this.keyPressed(112);
                }
                if (!GUI.this.northp.getAutoRefresh() && GUI.this.was_updating) {
                    GUI.this.northp.attemptToView(true);
                }
                GUI.this.centrep.setShowScreenImage(true);
                GUI.this.centrep.repaint();
                GUI.this.mode = 0;
                GUI.this.modeScreenCapture = 0;
            }
        });
    }

    public void disconnectVNCSession() {
        if (this.con != null) {
            Message vncMessage = new Message(-1061158857);
            this.con.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), vncMessage);
        }
        this.vncSessionIsActive = false;
        this.northp.setIsRunningVNCSession(false);
        this.setRemoteScreenMode();
    }

    public void setVNCMode() {
        if (!this.vncSessionIsActive) {
            VNCConnectGlassDialog dialog = new VNCConnectGlassDialog();
            dialog.showDialog(this.getParentFrame());
            if (dialog.isOK()) {
                String hostname = dialog.getVNCHostname();
                String port = dialog.getVNCPort();
                if (hostname == null || port == null) {
                    this.setRemoteScreenMode();
                    return;
                }
                Message vncMessage = new Message(-1061158859);
                vncMessage.append(true);
                vncMessage.append(hostname);
                vncMessage.append(port);
                if (hostname.equals("127.0,0.1") || hostname.equals("localhost")) {
                    this.northp.setVNCLocalStatus(true);
                } else {
                    this.northp.setVNCLocalStatus(false);
                }
                this.con.doAsyncRemoteCommand(new GetVNCCredentialsCommandListener(), vncMessage);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUI.this.mainpanel.centre_panel().removeAll();
                    GUI.this.mainpanel.centre_panel().add(GUI.this.centrep);
                    GUI.this.mainpanel.centre_panel().revalidate();
                    GUI.this.mainpanel.centre_panel().repaint();
                    if (!GUI.this.east_on && GUI.this.was_on) {
                        GUI.this.was_on = false;
                        GUI.this.keyPressed(112);
                    }
                    if (!GUI.this.northp.getAutoRefresh() && GUI.this.was_updating) {
                        GUI.this.northp.attemptToView(true);
                    }
                    GUI.this.centrep.setShowScreenImage(true);
                    GUI.this.centrep.repaint();
                    GUI.this.mode = 3;
                    GUI.this.modeScreenCapture = 3;
                    GUI.this.northp.setMode(GUI.this.mode);
                }
            });
        }
    }

    public void setDiagnosticsMode() {
        if (this.permissions != null && !this.permissions.canUseDiagnostics()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.mainpanel.centre_panel().removeAll();
                GUI.this.mainpanel.centre_panel().add(GUI.this.diag);
                GUI.this.mainpanel.centre_panel().revalidate();
                GUI.this.mainpanel.centre_panel().repaint();
                if (GUI.this.mode == 0) {
                    if (GUI.this.east_on) {
                        GUI.this.was_on = true;
                        GUI.this.keyPressed(112);
                    } else {
                        GUI.this.was_on = false;
                    }
                    if (GUI.this.northp.getAutoRefresh()) {
                        GUI.this.was_updating = true;
                        GUI.this.northp.attemptToView(false);
                    } else {
                        GUI.this.was_updating = false;
                    }
                }
                GUI.this.mode = 2;
                GUI.this.northp.setMode(GUI.this.mode);
                GUI.this.diag.hasReceivedFocus();
            }
        });
    }

    private boolean isRemoteDesktopMode() {
        return this.mode == 0;
    }

    public void setFileTransferMode() {
        if (this.permissions != null && !this.permissions.canUseFileTransfer()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.mainpanel.centre_panel().removeAll();
                GUI.this.mainpanel.centre_panel().add(GUI.this.ftp);
                GUI.this.mainpanel.centre_panel().revalidate();
                GUI.this.mainpanel.centre_panel().repaint();
                if (GUI.this.mode == 0) {
                    if (GUI.this.east_on) {
                        GUI.this.was_on = true;
                        GUI.this.keyPressed(112);
                    } else {
                        GUI.this.was_on = false;
                    }
                    if (GUI.this.northp.getAutoRefresh()) {
                        GUI.this.was_updating = true;
                        GUI.this.northp.attemptToView(false);
                    } else {
                        GUI.this.was_updating = false;
                    }
                }
                GUI.this.mode = 1;
                GUI.this.northp.setMode(GUI.this.mode);
            }
        });
    }

    @Override
    public void updateFTPJobFinished(int jobID) {
        this.ftp.updateFTPJobFinished(jobID);
    }

    @Override
    public void updateFTPProgress(int jobID, boolean upload, String dir, String file, long sent, long max, long transferred) {
        this.ftp.updateFTPProgress(jobID, upload, dir, file, sent, max, transferred);
    }

    @Override
    public void updateFTPProgress(int jobID, long totalSize) {
        this.ftp.updateFTPProgress(jobID, totalSize);
    }

    @Override
    public void updateFTPProgressError(int jobID, String message) {
        this.ftp.updateFTPProgressError(jobID, message);
    }

    @Override
    public void setCanControlAndView(boolean controllingPermitted, boolean viewingPermitted, boolean controllingOn, boolean viewingOn) {
        System.out.println("[GUI] Set control:" + controllingOn + " (allowed:" + controllingPermitted + ") and view:" + viewingOn + "(allowed:" + viewingPermitted + ")");
        if (this.centrep != null) {
            this.centrep.setCanControlAndView(controllingPermitted, viewingPermitted, controllingOn, viewingOn);
        }
        if (this.eastp != null) {
            this.eastp.setCanControlAndView(controllingPermitted, viewingPermitted, controllingOn, viewingOn);
        }
        if (this.ftp != null) {
            this.ftp.setCanControlAndView(controllingPermitted, viewingPermitted, controllingOn, viewingOn);
        }
        if (this.diag != null) {
            this.diag.setCanControlAndView(controllingPermitted, viewingPermitted, controllingOn, viewingOn);
        }
    }

    @Override
    public void setTextEcho(boolean b) {
        this.centrep.setTextEcho(b);
    }

    @Override
    public void setTyping(String text) {
        this.centrep.setTyping(text);
    }

    @Override
    public void setTopLeftGreyOverlay(String message, long waitFor) {
        this.hintManager.setTopHint(message, waitFor);
        if (JWTesting.amTesting() && !JWTestControl.amDeferred()) {
            JWTesting.reportScreenshot((String)("Session Message '" + message + "'"), (JFrame)this.mainwin.getFrame(), (boolean)true);
        }
    }

    @Override
    public void setCentreGreyOverlay(String message, long waitFor, boolean showProgress) {
        this.setCentreGreyOverlay(new String[]{message}, waitFor, showProgress);
    }

    @Override
    public void setCentreGreyOverlay(String[] message, long waitFor, boolean showProgress) {
        if (CentralDebugging.GUI_OVERLAYS_DEBUG) {
            System.out.println("[Overlays] Set centre overlay message:" + Arrays.toString(message) + " waitFor:" + waitFor + " showProgress:" + showProgress);
        }
        this.hintManager.setCentreHint(message, waitFor, showProgress);
        if (JWTesting.amTesting() && !JWTestControl.amDeferred()) {
            JWTesting.reportScreenshot((String)("Session Message '" + Arrays.toString(message) + "'"), (JFrame)this.mainwin.getFrame(), (boolean)true);
        }
    }

    public void promptTest() {
        this.northNotificationPanel.showOkWarning("TEST", "TEST1\nTEST2", null, true);
    }

    @Override
    public void promptMmoveFailure() {
        if (!this.alreadyPromptedForMmoveFailure) {
            this.alreadyPromptedForMmoveFailure = true;
            this.northNotificationPanel.showOkWarning(Language.get("MMOVE_FAILURE_TITLE"), Language.get("MMOVE_FAILURE_1"), null, true);
        }
    }

    @Override
    public void promptForRdpConsoleSwitch() {
        if (!this.connectSettings.isMachine) {
            return;
        }
        String inSessionProp = JWLaunchProperties.getProperty((String)"launch_in_specific_session");
        if (inSessionProp == null || inSessionProp.equals("false")) {
            this.northNotificationPanel.showYesNoQuestion(Language.get("RDP_SWITCH_TITLE_ALT"), Language.get("RDP_SWITCH_QUESTION_1B") + "\n" + Language.get("RDP_SWITCH_QUESTION_2_ALT"), new RDPSwitchListener(), false);
        }
    }

    @Override
    public void setScreenImage(BufferedImage screen, Rectangle[] updatedRegions) {
        this.centrep.setScreenImage(screen, updatedRegions);
        if (this.initialZoomSetting != null) {
            this.setInitialZoom();
            this.initialZoomSetting = null;
        }
    }

    @Override
    public void clearScreenImage() {
        this.centrep.clearScreenImage();
    }

    @Override
    public void setScreenSize(int x, int y, int w, int h, ScreenDimension[] screens, int remoteScalingPercentage) {
        if (this.SCREEN_X == w && this.SCREEN_Y == h && this.SCREEN_COUNT == screens.length) {
            return;
        }
        this.SCREEN_X = w;
        this.SCREEN_Y = h;
        this.SCREEN_COUNT = screens.length;
        this.SCREEN_REMOTE_SCALING_PERCENTAGE = remoteScalingPercentage;
        this.centrep.setScreenSize(w, h, screens, this.SCREEN_REMOTE_SCALING_PERCENTAGE);
        this.northp.setScreenSize(w, h, screens);
        if (VideoRecorder.getInstance() != null) {
            VideoRecorder.getInstance().setScreenSize(w, h);
        }
    }

    public void startDuplicateConnection() {
        boolean isOk = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)this.getParentFrame(), (String)Language.get("DUPLICATE_SESSION_MESSAGE"), (String)Language.get("START_DUPLICATE_SESSION"), (Icon)ImageLoader.getImageIcon((String)"images/svg/arrows/split.svg,48"), (String)Language.get("DUPLICATE_SESSION_OK"));
        if (isOk) {
            this.con.requestDuplicateBackConnection();
        }
    }

    @Override
    public void exportScreen() {
        this.centrep.exportScreen();
    }

    @Override
    public JFrame getParentFrame() {
        if (!this.applet) {
            return this.mainwin.getFrame();
        }
        return null;
    }

    @Override
    public void setPointerLocation(int x, int y) {
        this.centrep.setPointerLocation(x, y);
    }

    @Override
    public void addProgramPrintout(String data) {
        this.clipanel.addResponse(data);
    }

    @Override
    public void doLicenseWait(int eval_uses, int eval_wait) {
    }

    @Override
    public String requestMachinePassword() {
        String pass = RemoteMachinePasswordDialog.showPasswordDialog(this.mainwin.getFrame());
        if (pass == null) {
            this.reconnectHandler.setShowReconnectDialog(false);
        }
        if (pass == null) {
            return "";
        }
        return pass;
    }

    private void updateContainer(JComponent c) {
        try {
            c.revalidate();
        }
        catch (Exception x) {
            c.invalidate();
        }
        c.repaint();
    }

    private void flipWest() {
        if (!(this.south_on || this.north_always_on || this.east_on)) {
            if (this.west_on) {
                this.west_on = false;
                this.focus_holder.setPreferredSize(new Dimension(0, 0));
                this.updateContainer(this.mainpanel.west_panel());
            }
        } else if (!this.west_on) {
            this.west_on = true;
            this.focus_holder.setPreferredSize(new Dimension(0, 1));
            this.updateContainer(this.mainpanel.west_panel());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (CentralDebugging.GUI_KEY_EVENTS_DEBUG) {
            System.out.println("[GUI] KeyPressed: " + e + " hotkeys:" + this.consumeHotkeysLocally);
        }
        int kcode = e.getKeyCode();
        if (this.consumeHotkeysLocally && e.isAltDown()) {
            if (!this.keyPressed(kcode, true)) {
                this.centrep.keyPressed(e);
            }
        } else {
            this.centrep.keyPressed(e);
        }
        if (kcode == 18) {
            e.consume();
        }
    }

    public boolean keyPressed(int kcode) {
        return this.keyPressed(kcode, false);
    }

    private boolean keyPressed(int kcode, boolean fromUser) {
        if (kcode == 112) {
            System.out.println("[GUI] Flipping east panel to " + !this.east_on);
            this.east_on = !this.east_on;
            this.flipWest();
            this.mainpanel.flipPanel(this.mainpanel.east_panel(), this.east_on);
            if (fromUser) {
                this.prefChanged("EAST_PANEL", this.east_on);
            }
        } else if (kcode == 113) {
            System.out.println("[GUI] Flipping north panel. Currently always on is " + this.north_always_on);
            if (!this.north_always_on) {
                this.turnOnNorthPanel();
            } else {
                this.turnOffNorthPanel();
            }
            if (fromUser) {
                this.prefChanged("NORTH_PANEL", this.north_always_on);
            }
        } else if (kcode == 114) {
            System.out.println("[GUI] Flipping south panel");
            this.south_on = !this.south_on;
            this.flipWest();
            this.mainpanel.flipPanel(this.mainpanel.south_panel(), this.south_on);
            if (fromUser) {
                this.prefChanged("SOUTH_PANEL", this.south_on);
            }
        } else if (kcode == 123) {
            System.out.println("[GUI] Flipping full screen mode");
            if (!this.applet) {
                try {
                    int mode = this.mainwin.getFrame().getMode();
                    if (this.fullscreen_ok) {
                        if (mode == 2) {
                            this.enterFullScreen(true, true);
                        } else if (mode == 1 || mode == 0) {
                            this.exitFullScreen(true);
                        }
                    }
                    System.out.println("[GUI] Done Flipping full screen mode");
                }
                catch (Throwable t) {
                    System.out.println("[GUI] Error switching on fullscreen mode");
                    t.printStackTrace();
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private void enterFullScreen(boolean modifyFullScreenState, boolean forceDropDown) {
        this.east_on_prev = this.east_on;
        this.north_on_prev = this.north_always_on;
        this.south_on_prev = this.south_on;
        if (this.east_on) {
            this.keyPressed(112);
        }
        if (forceDropDown && this.north_always_on) {
            this.keyPressed(113);
        }
        if (this.south_on) {
            this.keyPressed(114);
        }
        this.centrep.setFullScreen(true);
        if (modifyFullScreenState) {
            this.mainwin.setFullScreen(true);
        }
        try {
            if (this.fullscreen.get("MODIFIED")) {
                this.applyPrefs(this.fullscreen);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.mainwin.getFrame().repaint();
    }

    private void exitFullScreen(boolean modifyFullScreenState) {
        this.centrep.setFullScreen(false);
        if (modifyFullScreenState) {
            this.mainwin.setFullScreen(false);
        }
        if (!this.east_on && this.east_on_prev) {
            this.keyPressed(112);
        }
        if (!this.north_always_on && this.north_on_prev) {
            this.keyPressed(113);
        }
        if (!this.south_on && this.south_on_prev) {
            this.keyPressed(114);
        }
        try {
            if (this.windowed.get("MODIFIED")) {
                this.applyPrefs(this.windowed);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.mainwin.getFrame().repaint();
    }

    @Override
    public void disableFullScreenMode() {
        int mode = this.mainwin.getFrame().getMode();
        if (mode == 1 || mode == 0) {
            this.keyPressed(123);
        }
    }

    private void prefChanged(String pref, boolean value) {
        int mode = this.mainwin.getFrame().getMode();
        if (mode == 2) {
            this.windowed.set(pref, value);
            this.windowed.set("MODIFIED", true);
            if (!this.fullscreen.exists(pref)) {
                this.fullscreen.set(pref, value);
                this.fullscreen.set("MODIFIED", true);
            }
        } else {
            this.fullscreen.set(pref, value);
            this.fullscreen.set("MODIFIED", true);
            if (!this.windowed.exists(pref)) {
                this.windowed.set(pref, value);
                this.windowed.set("MODIFIED", true);
            }
        }
    }

    private void applyPrefs(GUIPrefs prefs) {
        if (prefs.exists("NORTH_PANEL")) {
            if (prefs.get("NORTH_PANEL")) {
                if (!this.north_always_on) {
                    this.keyPressed(113);
                }
            } else if (this.north_always_on) {
                this.keyPressed(113);
            }
        }
        if (prefs.exists("EAST_PANEL")) {
            if (prefs.get("EAST_PANEL")) {
                if (!this.east_on) {
                    this.keyPressed(112);
                }
            } else if (this.east_on) {
                this.keyPressed(112);
            }
        }
        if (prefs.exists("SOUTH_PANEL")) {
            if (prefs.get("SOUTH_PANEL")) {
                if (!this.south_on) {
                    this.keyPressed(114);
                }
            } else if (this.south_on) {
                this.keyPressed(114);
            }
        }
    }

    @Override
    public void turnOnNorthPanel() {
        if (!this.north_always_on) {
            this.north_always_on = true;
            this.mainwin.setDropDownNorthPanel(false);
        }
    }

    @Override
    public void turnOffNorthPanel() {
        if (this.north_always_on) {
            this.north_always_on = false;
            this.mainwin.setDropDownNorthPanel(true);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (CentralDebugging.GUI_KEY_EVENTS_DEBUG) {
            System.out.println("[GUI] KeyReleased: " + e);
        }
        this.centrep.keyReleased(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.centrep.keyTyped(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.getKeyFocus();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.focus_holder.setBackground(this.got_focus);
        this.focus_holder.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.focus_holder != null) {
            this.focus_holder.setBackground(this.not_focus);
            this.focus_holder.repaint();
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.quit();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private void cleanupMemory() {
        this.cleanup = true;
        System.out.println("[GUI] Cleaning up Controller memory");
        if (this.con != null) {
            this.con.cleanupMemory();
        }
        this.centrep.cleanupMemory();
        if (this.osxFullScreenListenerProxy != null) {
            OSXAdapter.removeOSXFullScreenListener((Window)this.mainwin.getFrame(), (Object)this.osxFullScreenListenerProxy);
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fullscreenListener);
        for (WindowListener windowListener : this.mainwin.getFrame().getWindowListeners()) {
            this.mainwin.getFrame().removeWindowListener(windowListener);
        }
        for (EventListener eventListener : this.mainwin.getFrame().getWindowFocusListeners()) {
            this.mainwin.getFrame().removeWindowFocusListener((WindowFocusListener)eventListener);
        }
        for (EventListener eventListener : this.mainwin.getFrame().getMouseMotionListeners()) {
            this.mainwin.getFrame().removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.mainwin.getFrame().getComponentListeners()) {
            this.mainwin.getFrame().removeComponentListener((ComponentListener)eventListener);
        }
        for (EventListener eventListener : this.mainwin.getFrame().getFocusListeners()) {
            this.mainwin.getFrame().removeFocusListener((FocusListener)eventListener);
        }
        if (!Switches.SH_tabbedSessions) {
            this.mainwin.getFrame().removeAll();
            this.mainwin.getFrame().dispose();
            this.mainwin.getFrame().getLayeredPane().removeAll();
            this.mainwin.getFrame().getContentPane().removeAll();
        }
        System.out.println("[GUI] My thread group is " + this.threadGroup.getName());
        final ThreadGroup tg = this.threadGroup;
        new Thread("CleanupChecker"){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    System.out.println("[GUI] Cleaning up");
                    MemoryCleaner.cleanThreads(tg);
                    MemoryCleaner.cleanAndNullifyAll(GUI.this.con);
                    MemoryCleaner.cleanAndNullifyAll(GUI.this.centrep);
                    MemoryCleaner.cleanAndNullifyAll(this);
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = 0; i < 3; ++i) {
                    System.out.println("[Session] Checking cleanup status...");
                    Thread[] list = new Thread[tg.activeCount() * 2];
                    tg.enumerate(list, true);
                    for (Thread thread : list) {
                        StackTraceElement[] elems;
                        if (thread == null || i <= 0) continue;
                        System.out.println("[GUI] Thread still alive: " + thread.getName() + " / " + thread.getClass().getName());
                        for (StackTraceElement elem : elems = thread.getStackTrace()) {
                            System.out.println("   - " + elem);
                        }
                    }
                    try {
                        Thread.sleep(20000L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    private void exit() {
        System.out.println("*** GUI Exit***");
        if (Switches.SH_tabbedSessions) {
            this.mainwin.closeTab();
        } else {
            try {
                System.out.println("[GUI] Hiding main window... (edt: " + SwingUtilities.isEventDispatchThread() + ")");
                this.mainwin.setVisible(false);
                this.mainwin.dispose();
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (Switches.SH_sessionsInTechUiProcess) {
            this.cleanupMemory();
            return;
        }
        try {
            System.out.println("[GUI] Launching exit thread");
            new ExitThread().start();
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            System.out.println("[GUI] Waiting 4...");
            Thread.sleep(2000L);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        System.out.println("[GUI] Exit now.");
        try {
            System.exit(0);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            Runtime.getRuntime().exit(0);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void setIgnoreLinkEvents(boolean b) {
        this.ignoreLinkEvents = b;
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
        if (this.ignoreLinkEvents) {
            return;
        }
        System.out.println("[GUI] Link Dead (" + link + ") " + reason);
        this.linkOK = false;
        try {
            this.centrep.linkDead(link, reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.eastp.linkDead(link, reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reconnectHandler.nodeLinkDead();
        if (this.wtrans != null) {
            this.wtrans.linkDied();
        }
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        if (this.ignoreLinkEvents) {
            return;
        }
        System.out.println("[GUI] Link Down (" + link + ") " + reason);
        this.linkOK = false;
        try {
            this.centrep.linkDown(link, reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.eastp.linkDown(link, reason);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reconnectHandler.nodeLinkDown();
    }

    @Override
    public void linkOK(NodeLink link) {
        if (this.ignoreLinkEvents) {
            return;
        }
        System.out.println("[GUI] Link OK (" + link + ")");
        this.linkOK = true;
        try {
            this.centrep.linkOK(link);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.eastp.linkOK(link);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reconnectHandler.nodeLinkOK();
    }

    @Override
    public void connectionIsSlow(int tcpPortToOpen) {
    }

    @Override
    public void about() {
    }

    @Override
    public void preferences() {
    }

    @Override
    public void stopReconnectsForRemoteClose() {
        this.reconnectListener.setDisableReconnect();
        if (ConnectedTarget.TARGET instanceof AccessSession) {
            AccessSession session = (AccessSession)ConnectedTarget.TARGET;
            try {
                this.wtrans.clearAccessHandlerTimeout(session.getMachine().getMachineID());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void silentQuit() {
        try {
            if (this.wtrans != null) {
                this.wtrans.stopPolling();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.out.println("[GUI] Close requested. Finishing recording.");
            if (VideoRecorder.getInstance() != null) {
                VideoRecorder.getInstance().finish();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.out.println("[GUI] Calling closeListener");
            this.closeListener.doClose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.out.println("[GUI] Disabling reconnect.");
            this.reconnectListener.setDisableReconnect();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.exit();
    }

    @Override
    public boolean quit() {
        System.out.println("[GUI] Closing SessionUI");
        boolean sessonActive = this.linkOK;
        if (this.closeListener != null && this.closeListener.closeRequested(sessonActive)) {
            this.silentQuit();
            return true;
        }
        return false;
    }

    @Override
    public void setAutoRefresh(boolean b) {
        if (this.northp != null) {
            this.northp.attemptToView(b);
        }
    }

    @Override
    public void setFitAll() {
        if (this.centrep != null) {
            this.centrep.setFitAll();
        }
    }

    @Override
    public void setFitHeight() {
        if (this.centrep != null) {
            this.centrep.setFitHeight();
        }
    }

    @Override
    public void setFitOneToOne() {
        if (this.centrep != null) {
            this.centrep.setFitOneToOne();
        }
    }

    @Override
    public void setResolutionPercentage(double percentage) {
        if (this.centrep != null) {
            this.centrep.setResolutionPercentage(percentage);
        }
        if (this.northp != null) {
            this.northp.setResolutionPercentage(percentage);
        }
    }

    @Override
    public void disableReconnect() {
        this.reconnectListener.setDisableReconnect();
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        this.haveFocus = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        this.haveFocus = false;
        if (this.centrep != null) {
            this.centrep.focusLostReleaseAllKeys();
        }
    }

    @Override
    public void setScreenPng(int x, int y, byte[] png) {
    }

    @Override
    public void setPortRedirector(PortRedirector redir) {
        this.diag.setPortRedirector(redir);
    }

    public void keyEvent(int keyCode, boolean down) {
        block19: {
            if (!this.centrep.control_enabled) {
                return;
            }
            if (keyCode == 9) {
                try {
                    KeyEvent event = new KeyEvent(NATIVE_UTILS_SOURCE, 0, System.currentTimeMillis(), 512, 9, '\uffff', 0);
                    Thread.sleep(100L);
                    System.out.println("[GUI] GUI sending TAB: " + keyCode);
                    if (down) {
                        this.keyPressed(event);
                        break block19;
                    }
                    this.keyReleased(event);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (keyCode == 91 || keyCode == 92) {
                if (this.remoteOsBase == 0) {
                    System.out.println("[GUI] GUI sending WINDOWS key: " + keyCode);
                    KeyRequest req = KeyRequest.getKeyRequestForCode(524, down);
                    if (Switches.SH_multiControl && MultiController.on()) {
                        MultiController.get().sendKeyRequest(req);
                    } else {
                        this.con.sendKeyRequest(req);
                    }
                } else if (this.remoteOsBase == 1) {
                    System.out.println("[GUI] GUI sending OS X CMD key: " + keyCode);
                    KeyRequest req = KeyRequest.getKeyRequestForCode(157, down);
                    if (Switches.SH_multiControl && MultiController.on()) {
                        MultiController.get().sendKeyRequest(req);
                    } else {
                        this.con.sendKeyRequest(req);
                    }
                } else {
                    System.out.println("[GUI] GUI detected WINDOWS key: " + keyCode + " but not sending " + this.remoteOsBase);
                }
            } else if (keyCode != 18 && keyCode != 164 && keyCode != 165 && keyCode == 27) {
                KeyRequest req = KeyRequest.getKeyRequestForCode(27, down);
                if (Switches.SH_multiControl && MultiController.on()) {
                    MultiController.get().sendKeyRequest(req);
                } else {
                    this.con.sendKeyRequest(req);
                }
            }
        }
    }

    @Override
    public void setToolState(Class toolClass, boolean on) {
        this.eastp.setToolState(toolClass, on);
    }

    public Boolean isToolOn(Class toolClass) {
        return this.eastp.isToolOn(toolClass);
    }

    @Override
    public void setSelectedScreen(int selectedScreen) {
        this.con.setSelectedScreen(selectedScreen);
    }

    @Override
    public void setTechnicianAvatar(byte[] avatarBytes) {
        this.eastp.chatPanel.setAvatar(avatarBytes, this.techUser.username, this.techUser.displayName);
    }

    @Override
    public void setTechnicianPermissions(TechGroupPermissions permissions, boolean shouldRequestControl) {
        System.out.println("[GUI] Setting technician permissions");
        this.permissions = permissions;
        this.eastp.setTechnicianPermissions(permissions);
        this.diag.setTechnicianPermissions(permissions);
        this.northp.setTechnicianPermissions(permissions, shouldRequestControl);
    }

    @Override
    public void setTechnicianDetails(TransientTechUser techUser) {
        this.techUser = techUser;
        this.eastp.setTechUser(techUser);
        this.northp.setTechUser(techUser);
        this.ftp.setTechnicianDetails(techUser);
    }

    public TransientTechUser getTechUser() {
        return this.techUser;
    }

    public boolean isChatPanelVisible() {
        if (this.east_on) {
            return this.eastp.isChatPanelVisible();
        }
        return false;
    }

    @Override
    public void consoleLaunched() {
        try {
            this.con.launchRemoteDebugger();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setFileTransferProgress(int cur, int tot) {
        this.northp.setFileTransferProgress(cur, tot);
    }

    @Override
    public void setRemoteCursor(CursorInfo cInfo) {
        this.centrep.img_panel.setCursor(cInfo);
    }

    @Override
    public void expectCustomerTerminate() {
        this.reconnectHandler.setExpectRemoteTerminate(true);
    }

    @Override
    public void expectReboot() {
        this.reconnectHandler.setExpectReboot(true);
    }

    @Override
    public void expectPowerOrLogoff() {
        this.reconnectHandler.setExpectLogoutShutdown(true);
    }

    @Override
    public void silentReconnect(String reason) {
        System.out.println("[SilentReconnect] Silently reconnecting now (" + reason + ")");
        this.disableReconnect();
        this.forceReconnect();
    }

    @Override
    public void expectSleep() {
        this.reconnectHandler.setExpectSleep(true);
    }

    @Override
    public void expectWake() {
    }

    @Override
    public void expectSessionDeactivated() {
    }

    @Override
    public void expectSessionActivated() {
    }

    @Override
    public void initEventListeners() {
        if (this.mainwin != null && NativeEventUtil.getInstance() != null) {
            NativeEventUtil.getInstance().addEventListener(this.mainwin);
        }
    }

    @Override
    public void showBlankScreenOrBlockedInputWarning(boolean enabled) {
        this.eastp.chatPanel.setWarningLabelVisible(enabled);
    }

    @Override
    public void toggleShowAllScreens() {
        this.centrep.toggleShowAllScreens();
    }

    @Override
    public void requestEntireScreenForRecording() {
        System.out.println("[GUI] Requested entire screen image for recording");
        if (VideoRecorder.getInstance() != null) {
            VideoRecorder.getInstance().captureEntireScreen(this.centrep.getScreenImage(), this.SCREEN_X, this.SCREEN_Y);
        } else {
            System.out.println("[GUI] Video recorder appears to not be initialised yet");
        }
    }

    @Override
    public void updateCustomerIsTyping(String displayName) {
        if (displayName.length() > 40) {
            displayName = displayName.substring(0, 40);
        }
        this.eastp.chatPanel.updateIsTyping(displayName + " " + Language.get("IS_TYPING") + "...");
    }

    public void windowEnteredFullScreen(Window window) {
        this.enterFullScreen(false, false);
    }

    public void windowExitedFullScreen(Window window) {
        this.exitFullScreen(false);
    }

    @Override
    public void setToolBox(ToolBox box) {
        System.out.println("[GUI] Loaded Toolbox: " + box);
        this.eastp.toolBoxUI.load(box);
    }

    public long mustFailoverTo(String newURL, long maxDelay, long autoSwitchTimeMS) {
        System.out.println("[Tech-HAF] Asked to fail over to " + newURL);
        FailoverDialog dialog = new FailoverDialog(this.mainwin.getFrame(), maxDelay, autoSwitchTimeMS);
        dialog.showDialog();
        long option = dialog.getSelectedDelay();
        if (option < 0L) {
            option = 0L;
        }
        System.out.println("[Tech-HAF] Requested delay of " + option);
        return option;
    }

    public void prepareForRelaunch(String newURL) {
        System.out.println("[Tech-HAF] Failing over in 5...");
        this.con.sendFailoverRequest(newURL);
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JWLaunchProperties.overrideProperty((String)"fover_so_mustwait", (String)"yes");
        JWLaunchProperties.overrideProperty((String)"no_preconnection", (String)"yes");
        if (JWLaunchProperties.getPropertyPossiblyNull((String)"TechHelpUiHost") != null) {
            try {
                System.out.println("[Tech-HAF] Overriding TechHelpUI HOST and PORT arguments");
                URL target = new URL(newURL);
                JWLaunchProperties.overrideProperty((String)"TechHelpUiHost", (String)target.getHost());
                int port = target.getPort();
                if (port == -1) {
                    port = target.getDefaultPort();
                }
                JWLaunchProperties.overrideProperty((String)"TechHelpUiPort", (String)("" + port));
            }
            catch (MalformedURLException x) {
                x.printStackTrace();
            }
        } else {
            System.out.println("[Tech-HAF] TechHelpUI HOST and PORT arguments not present");
        }
    }

    @Override
    public void receivedTerminalOutput(byte[] data) {
        this.diag.console.receivedTerminalOutput(data);
    }

    @Override
    public void startup(ProxyConnectSettings settings) {
        this.connectSettings = settings;
        this.mode = settings == null ? 0 : settings.initialMode;
        if (settings != null) {
            if (!settings.amReconnecting) {
                this.northp.setMode(this.mode);
            }
            System.out.println("[GUI] Desired window bounds are " + settings.desiredWindowBounds);
            try {
                if (!settings.amReconnecting && settings.desiredWindowBounds != null) {
                    settings.desiredWindowBounds.applyToWindow(this.mainwin.getFrame());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!(this.applet || settings != null && settings.amReconnecting)) {
            this.mainwin.flipAllButCenter(false);
            this.mainpanel.centre_panel().setLayout(new GridLayout(1, 1));
            this.mainpanel.centre_panel().add(new SplashGradientPanel(ClientBranding.get().getFullLogo(true)));
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwingUtil.frameToFront((RootPaneContainer)GUI.this.mainwin.getFrame());
                }
            });
            new SplashFlipperOffThread().start();
        }
    }

    @Override
    public void setupPostPreload() {
        this.northp.setupPostPreload();
        this.eastp.startTimer();
    }

    @Override
    public void setWebTransactor(WebTransactor wtrans) {
        if (this.wtrans != null) {
            this.wtrans.stopPolling();
        }
        this.wtrans = wtrans;
        this.eastp.setWebTransactor(wtrans);
    }

    @Override
    public void remoteSideUpdating() {
        try {
            this.setCentreGreyOverlay(Language.get("REMOTE_COMPUTER_UPDATING_JOINING") + "...", 600000L, true);
        }
        catch (Throwable t) {
            System.out.println("[SimpleDesktop] Unable to pass on message that SG is currently updating: " + t);
            t.printStackTrace();
        }
    }

    @Override
    public void notifySlowCapture() {
        Boolean hardwareAccelerationDisabled = this.isToolOn(DisableGraphicsDriver.class);
        if (hardwareAccelerationDisabled == null) {
            return;
        }
        System.out.println("[GUI] Hardware acceleration disabled is currently " + hardwareAccelerationDisabled);
        if (hardwareAccelerationDisabled.booleanValue()) {
            return;
        }
        this.northNotificationPanel.showOkWarning(Language.get("SLOW_CAPTURE_TITLE"), Language.get("SLOW_CAPTURE_MESSAGE"), new NotificationPanel.NotificationPanelListener(){

            @Override
            public void notificationClosed(int returnCode) {
                if (returnCode == 1) {
                    System.out.println("[GUI] Technician has chosen to disable hardware acceleration");
                    GUI.this.setToolState(DisableGraphicsDriver.class, true);
                }
            }
        }, true, Language.get("SLOW_CAPTURE_ACTION"));
    }

    @Override
    public void setRemoteAccessServiceID(String machineID) {
        this.reconnectListener.setRemoteMachineReconnectTargetID(machineID);
        this.northp.setCanReconnectToRAS(true);
    }

    public DiagnosticsPanel getDiagnosticsPanel() {
        return this.diag;
    }

    public NorthPanel getNorthPanel() {
        return this.northp;
    }

    public FileTransferPanel getFileTransferPanel() {
        return this.ftp;
    }

    public CentrePanel getCentrePanel() {
        return this.centrep;
    }

    private class ErrorDialogCommandListener
    implements CommandResponseListener {
        private ErrorDialogCommandListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == -286392320) {
                String message = null;
                if (m.length() > 0) {
                    message = m.getAsString(0);
                }
                ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(GUI.this.getParentFrame(), Language.get("VNC_CANNOT_CONNECT_TITLE"));
                dialog.setText(Language.get("VNC_CANNOT_AUTHENTICATE_MSG"), message, null);
                dialog.showDialog();
            } else {
                GUI.this.setCentreGreyOverlay(Language.get("VNC_CONNECT_OK"), 2000L, false);
                GUI.this.vncSessionIsActive = true;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUI.this.northp.setIsRunningVNCSession(true);
                        GUI.this.setVNCMode();
                    }
                });
            }
        }
    }

    private class ExitThread
    extends Thread {
        public ExitThread() {
            super("ExitThread");
        }

        @Override
        public void run() {
            try {
                System.out.println("[ExitThread] Cleaning up...");
                if (GUI.this.wtrans != null) {
                    GUI.this.wtrans.stopPolling();
                }
                if (GUI.this.con != null) {
                    GUI.this.con.closeConnection();
                    GUI.this.con.terminate();
                    GUI.this.con = null;
                }
                if (GUI.this.mainwin.isVisible()) {
                    System.out.println("[ExitThread] Hiding main window... (edt: " + SwingUtilities.isEventDispatchThread() + ")");
                    GUI.this.mainwin.setVisible(false);
                    GUI.this.mainwin.dispose();
                }
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                System.out.println("[ExitThread] Waiting...");
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                System.out.println("[ExitThread] Exit now.");
                System.exit(0);
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                Runtime.getRuntime().exit(0);
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    class FullscreenMouseMotionListener
    implements AWTEventListener {
        FullscreenMouseMotionListener() {
        }

        private void flip(int diff) {
            if (!GUI.this.north_always_on) {
                if (diff <= 3) {
                    GUI.this.mainwin.dropDownNorthPanel(true);
                } else if (diff > GUI.this.northp.getHeight()) {
                    GUI.this.mainwin.dropDownNorthPanel(false);
                }
            }
        }

        private boolean isChildOfNorthPanel(Object o) {
            if (o.getClass() == NorthPanel.class) {
                return true;
            }
            if (o instanceof JComponent) {
                JComponent jc = (JComponent)o;
                return this.isChildOfNorthPanel(jc.getParent());
            }
            return false;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            try {
                ActivityTracker.touch();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            MouseEvent e = (MouseEvent)event;
            int origin = 0;
            boolean ok = false;
            if (GUI.this.centrep != null && e.getSource() == ((GUI)GUI.this).centrep.img_panel) {
                origin = ((GUI)GUI.this).centrep.img_scroll.getViewport().getViewPosition().y;
                ok = true;
            } else if (e.getSource() == GUI.this.mainwin) {
                origin = ((GUI)GUI.this).mainwin.getFrame().getInsets().top;
                ok = true;
            } else if (this.isChildOfNorthPanel(e.getSource())) {
                origin = 0;
                ok = true;
            } else if (e.getSource() instanceof SHSplitPane) {
                origin = 0;
                ok = true;
            }
            int diff = e.getY() - origin;
            if (!ok) {
                diff = 100;
            }
            this.flip(diff);
        }
    }

    private class GetVNCCredentialsCommandListener
    implements CommandResponseListener {
        private GetVNCCredentialsCommandListener() {
        }

        @Override
        public void response(Message m) {
            if (m.getType() == -286392320) {
                String hostname = m.getAsString(0);
                String port = m.getAsString(1);
                String message = null;
                if (m.length() > 2) {
                    message = m.getAsString(2);
                }
                ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(GUI.this.getParentFrame(), Language.get("VNC_CANNOT_CONNECT_TITLE"));
                dialog.setText(Language.get("VNC_CANNOT_CONNECT_MSG", hostname + ":" + port), message, null);
                dialog.showDialog();
            } else {
                int securityType = m.getAsInt(0);
                System.out.println("[GUI] Detected VNC security type as " + securityType);
                VNCCredentialsGlassDialog dialog = new VNCCredentialsGlassDialog(securityType == 2);
                dialog.showDialog(GUI.this.getParentFrame());
                if (dialog.getVNCPassword() == null && dialog.getVNCUsername() == null) {
                    GUI.this.setRemoteScreenMode();
                    return;
                }
                Message vncMessage = new Message(-1061158858);
                vncMessage.append(dialog.getVNCUsername());
                vncMessage.append(dialog.getVNCPassword());
                GUI.this.con.doAsyncRemoteCommand(new ErrorDialogCommandListener(), vncMessage);
            }
        }
    }

    private class RDPSwitchListener
    implements NotificationPanel.NotificationPanelListener {
        private RDPSwitchListener() {
        }

        @Override
        public void notificationClosed(int returnCode) {
            if (returnCode == 1) {
                Message m = new Message(-1061158890);
                GUI.this.con.doAsyncRemoteCommand(new IgnoredCommandResponseListener(), m);
            }
        }
    }

    private class RemoteMachineInfoListener
    implements CommandResponseListener {
        private RemoteMachineInfoListener() {
        }

        @Override
        public void response(Message m) {
            GUI.this.setRemoteOS((Integer)m.get(0), (Integer)m.get(1));
        }
    }

    class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.notifyForSave();
        }

        private void notifyForSave() {
            Rectangle bounds = GUI.this.mainwin.getFrame().getBounds();
            String result = bounds.x + "," + bounds.y + "," + bounds.width + "," + bounds.height;
            SessionProperties.INSTANCE.setPropAndSaveIn(SessionProperties.PROP_LAST_WINDOW_SIZE, result, 3000);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.notifyForSave();
        }
    }

    private class SplashFlipperOffThread
    extends Thread {
        public SplashFlipperOffThread() {
            super("SplashFlipperOffThread");
        }

        @Override
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (GUI.this.northNotificationPanel == null) {
                System.out.println("[SplashFlipper] Having to wait for notification panel");
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!GUI.this.cleanup) continue;
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    System.out.println("[SplashFlipper] Flipping splash off");
                    if (!GUI.this.applet) {
                        GUI.this.mainwin.flipAllButCenter(true);
                        GUI.this.mainpanel.centre_panel().removeAll();
                        GUI.this.mainpanel.centre_panel().add(GUI.this.northNotificationPanel.getRootComponent());
                        GUI.this.mainpanel.north_panel().revalidate();
                        GUI.this.mainwin.getFrame().invalidate();
                        GUI.this.mainwin.getFrame().validate();
                        GUI.this.setRequestedMode();
                    }
                }
            });
        }
    }

    private class TCPSwitchListener
    extends Thread
    implements NotificationPanel.NotificationPanelListener {
        public TCPSwitchListener() {
            super("TCPSwitchListener");
        }

        @Override
        public void notificationClosed(int returnCode) {
            if (returnCode == 1) {
                this.start();
            }
        }

        @Override
        public void run() {
            GUI.this.upgradeStarted(-1, -1);
            if (GUI.this.con.switchTransports(-1, -1)) {
                GUI.this.upgradeComplete();
            } else {
                GUI.this.upgradeFailed(false);
            }
        }
    }

    class TestingThread
    implements Runnable,
    JWTestable {
        int connType;
        long connFails;
        int[] transportIDs = new int[]{4, 1, 3, 2, 0};

        TestingThread() {
        }

        @Override
        public void run() {
            System.out.println("[Testing] Testing thread launched");
            if (Testing.queryTestingBoolean("TEST_SESSIONS_DO_NOTHING_DISCONNECT")) {
                try {
                    Thread.sleep((int)(Math.random() * 30000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GUI.this.con.closeConnection();
                System.exit(0);
            } else if (Testing.queryTestingBoolean("TEST_SESSIONS_DO_NOTHING_QUIT")) {
                try {
                    Thread.sleep((int)(Math.random() * 30000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
            if (Testing.queryTestingBoolean("TEST_TECHUI_LOGIN_DEFER_CONTROL")) {
                String deferHost = JWLaunchProperties.getProperty((String)"TEST_TECHUI_LOGIN_DEFER_TO_HOST");
                System.out.println("[Testing] Deferring control to " + deferHost);
                try {
                    JWTestControl.shareJWT((JWTestable)this, (String)deferHost, (int)TestUtils.TESTCONTROL_PORT);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
                return;
            }
            NodeLinkStats stats = GUI.this.con.getLocalSessionStats();
            int currType = stats.type;
            while (true) {
                System.out.println("[Testing] Waiting for transport stability (" + currType + ")");
                JWAutomate.sleep((long)60000L);
                stats = GUI.this.con.getLocalSessionStats();
                if (currType == stats.type && !GUI.this.con.isSwitchingTransport()) break;
                currType = stats.type;
            }
            System.out.println("[Testing] Transport stable at (" + currType + "), continuing");
            GUI.this.setCanControlAndView(true, true, false, true);
            if (Testing.queryTestingBoolean("TEST_SESSIONS_CHECK_PATCHING")) {
                this.testSwitchTransportToAllSequentially(false);
            } else if (Testing.queryTestingBoolean("TEST_SESSIONS_CHECK_CONN_STABILITY")) {
                this.testSwitchTransportToAllSequentially(true);
            }
            JWTesting.reportScreenshot((String)"Session Window", (JFrame)GUI.this.mainwin.getFrame(), (boolean)true);
            JWTesting.reportScreenshot((String)"East Panel", (Component)GUI.this.eastp, (boolean)true);
            try {
                Thread.sleep(10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            GUI.this.con.closeConnection();
            System.exit(0);
        }

        public String getTestableAppName() {
            return TestUtils.APP_TECH_SESSION_GUI;
        }

        public void call(String str, Message m) throws IOException {
            if (str.equals(TestUtils.SS_CMD_terminate)) {
                GUI.this.exit();
            } else if (str.equals(TestUtils.SS_CMD_switchThroughAllTransports)) {
                this.testSwitchTransportToAllSequentially(false);
            } else if (str.equals(TestUtils.SS_CMD_checkStabilityAllTransports)) {
                this.testSwitchTransportToAllSequentially(true);
            } else if (str.equals(TestUtils.SS_CMD_switchToRandomTransport)) {
                this.testSwitchTransportToRandom(false);
            } else if (str.equals(TestUtils.SS_CMD_checkStabilityRandomTransport)) {
                this.testSwitchTransportToRandom(true);
            } else if (str.equals(TestUtils.SS_CMD_reconnect)) {
                GUI.this.forceReconnect();
            } else if (str.equals(TestUtils.SS_CMD_closeconnection)) {
                GUI.this.disableReconnect();
                GUI.this.con.closeConnection();
            }
        }

        public void testControlConnectionFailed() {
            System.out.println("[Testing] JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail((String)"JWTestControl connection failed to Session GUI", (String)"");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }

        void getCurrentConnectionType() {
            NodeLinkStats stats = GUI.this.con.getLocalSessionStats();
            this.connType = stats.type;
            System.out.println("[Testing] Current NL connection type is " + this.connType);
        }

        boolean checkConnectionSwitched(long TOUT) {
            TOUT = System.currentTimeMillis() + TOUT;
            System.out.println("[Testing] Waiting for NL connection to switch...");
            while (System.currentTimeMillis() < TOUT) {
                JWAutomate.sleep((long)2000L);
                NodeLinkStats stats = GUI.this.con.getLocalSessionStats();
                if (stats.type == this.connType) continue;
                System.out.println("[Testing] New NL connection type is " + stats.type + ", was " + this.connType);
                JWAutomate.sleep((long)4000L);
                this.connFails = stats.diedTimes;
                return true;
            }
            System.out.println("[Testing] NL connection has not switched :(");
            return false;
        }

        boolean checkConnectionStability(long TOUT) {
            System.out.println("[Testing] Checking connection stability (" + TOUT / 1000L + "s)...");
            JWAutomate.sleep((long)TOUT);
            NodeLinkStats stats = GUI.this.con.getLocalSessionStats();
            if (this.connFails == stats.diedTimes) {
                System.out.println("[Testing] Connection stability ok");
                return true;
            }
            System.out.println("[Testing] Connection stability FAILED x" + stats.diedTimes);
            return false;
        }

        void openConnectionTuning() {
            JWAutomate.sleep((long)1500L);
            JWAutomate.hitButtonTT((Component)GUI.this.northp, (String)"Tools Menu");
            JWAutomate.sleep((long)2500L);
            JWAutomate.hitMenu((Component)GUI.this.mainwin.getFrame(), (String)"Tune Connection");
            JWAutomate.sleep((long)4500L);
        }

        void snapshotConnectionStats(String name) {
            this.openConnectionTuning();
            GUI.this.northp.testTakeTuningSnapshot(name);
            JWAutomate.hitButton((Component)GUI.this.mainwin.getFrame(), (String)"Close");
            JWAutomate.sleep((long)1500L);
        }

        void changeConnectionTypeViaUI(String match) {
            System.out.println("[Testing] Changing connection type to " + match);
            this.openConnectionTuning();
            Component sessionTab = JWAutomate.hitTab((Component)GUI.this.mainwin.getFrame(), (String)"Session");
            JWAutomate.sleep((long)1500L);
            JWAutomate.hitList((Component)sessionTab, (String)match);
            JWAutomate.sleep((long)1500L);
            JWAutomate.hitButton((Component)sessionTab, (String)"both");
            System.out.println("[Testing] Hit buttons to change connection type ok");
        }

        void changeConnectionType(int transport) {
            System.out.println("[Testing] Changing connection type to " + transport);
            GUI.this.switchTransports(transport, transport);
        }

        private String getRandomTransport() {
            String[] tmp = new String[]{"HTTP", "UDP via Server", "SSL", "TCP", "UDP Direct"};
            return tmp[(int)(Math.random() * (double)tmp.length)];
        }

        private int getTransportFor(String name) {
            if ((name = name.toLowerCase()).contains("http")) {
                return 4;
            }
            if (name.contains("ssl")) {
                return 3;
            }
            if (name.contains("tcp direct")) {
                return 5;
            }
            if (name.contains("tcp")) {
                return 2;
            }
            if (name.contains("udp direct")) {
                return 0;
            }
            if (name.contains("udp")) {
                return 1;
            }
            return -1;
        }

        void testSwitchTransportToRandom(boolean checkStability) {
            String chosen = this.getRandomTransport();
            this.testSwitchTransportTo(chosen, checkStability);
        }

        void testSwitchTransportTo(String type, boolean checkStability) {
            JWTesting.reportAttempt((String)"Switch to _Total", (String)"", (int)120000);
            JWTesting.reportAttempt((String)("Switch to " + type), (String)"", (int)120000);
            this.getCurrentConnectionType();
            int targetTransport = this.getTransportFor(type);
            System.out.println("[Testing] Identified target transport '" + type + "' as " + targetTransport);
            this.changeConnectionType(targetTransport);
            if (!this.checkConnectionSwitched(60000L)) {
                return;
            }
            JWTesting.reportSuccess((String)"Switch to _Total");
            JWTesting.reportSuccess((String)("Switch to " + type));
            if (checkStability) {
                this.testTransportStability(type);
            } else {
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        void testSwitchTransportToAllSequentially(boolean checkStability) {
            String[] order = new String[]{"UDP via Server", "HTTP", "TCP Direct", "TCP", "UDP Direct", "UDP via Server", "TCP", "HTTP", "UDP Direct", "TCP Direct"};
            for (int i = 0; i < order.length * 30; ++i) {
                String next = order[i % order.length];
                this.testSwitchTransportTo(next, checkStability);
            }
        }

        void testTransportStability(String name) {
            JWTesting.reportAttempt((String)"Stability testing _Total", (String)"", (int)720000);
            JWTesting.reportAttempt((String)("Stability testing " + name), (String)"", (int)720000);
            if (!this.checkConnectionStability(600000L)) {
                return;
            }
            JWTesting.reportSuccess((String)"Stability testing _Total");
            JWTesting.reportSuccess((String)("Stability testing " + name));
        }
    }

    public class TrackingNotifyThread
    extends Thread {
        private DropDownComponent.Notification notification;
        boolean die;
        private Color start;
        private float bChange;
        private float rChange;
        private float gChange;
        float steps;
        Color end;

        public TrackingNotifyThread() {
            super("TrackingNotifyThread");
            this.die = false;
            this.start = null;
            this.steps = 50.0f;
            this.end = new Color(255, 50, 50);
            try {
                if (!GUI.this.mainwin.getFrame().isActive()) {
                    SwingUtil.frameToFront((RootPaneContainer)GUI.this.mainwin.getFrame());
                }
            }
            catch (Exception e) {
                System.out.println("[GUI] Unable to bring frame front.");
            }
        }

        private void setNotification(DropDownComponent.Notification n) {
            this.notification = n;
            this.start = this.notification.getBackground();
            this.rChange = ((float)this.end.getRed() - (float)this.start.getRed()) / this.steps;
            this.gChange = ((float)this.end.getGreen() - (float)this.start.getGreen()) / this.steps;
            this.bChange = ((float)this.end.getBlue() - (float)this.start.getBlue()) / this.steps;
        }

        @Override
        public void run() {
            long nextBellTime = 0L;
            boolean towardsRed = true;
            int step = 0;
            while (!this.die) {
                Color current;
                if (SHSounds.bell != null && System.currentTimeMillis() > nextBellTime) {
                    SHSounds.play(SHSounds.bell);
                    nextBellTime = System.currentTimeMillis() + 4000L;
                }
                try {
                    Thread.sleep(40L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.start == null) continue;
                int r = this.start.getRed();
                int g = this.start.getGreen();
                int b = this.start.getBlue();
                if (towardsRed) {
                    current = new Color((int)((float)r + this.rChange * (float)step), (int)((float)g + this.gChange * (float)step), (int)((float)b + this.bChange * (float)step));
                    if ((float)(++step) == this.steps) {
                        towardsRed = false;
                    }
                } else {
                    current = new Color((int)((float)r + this.rChange * (float)step), (int)((float)g + this.gChange * (float)step), (int)((float)b + this.bChange * (float)step));
                    if (--step == 0) {
                        towardsRed = true;
                    }
                }
                this.notification.setBackground(current);
            }
        }
    }

    class UpdateWarningThread
    extends Thread {
        final boolean showMessage = true;

        public UpdateWarningThread() {
            super("UpdateWarningThread");
            this.showMessage = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean tmp;
                Thread.sleep(30000L);
                Object object = GUI.this.uwt_LOCK;
                synchronized (object) {
                    tmp = true;
                }
                if (tmp) {
                    GUI.this.updateWarningIsUp = true;
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)GUI.this.getParentFrame(), (String)(Language.get("UPDATE_WARNING_1") + "\n" + Language.get("UPDATE_WARNING_2")), (String)Language.get("UPDATE_WARNING_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,48"));
                    GUI.this.updateWarningIsUp = false;
                }
                object = GUI.this.uwt_LOCK;
                synchronized (object) {
                    GUI.this.uwt = null;
                }
            }
            catch (Exception e) {
                GUI.this.updateWarningIsUp = false;
            }
        }
    }
}

