/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.sdesktop.client.controller.MultiController;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.util.GuiConstants;
import com.aem.utils.Debugger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.SoftBevelBorder;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import utils.swing.customlaf.ScaledInsets;
import utils.switches.Switches;

public class CommandPanel
extends JPanel
implements GuiConstants,
KeyListener {
    ArrayList command_history = new ArrayList();
    String def_working_dir = "C:\\";
    ClientController controller;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    JPanel pout_panel = new JPanel();
    StyledDocument pout_doc = new DefaultStyledDocument();
    JTextPane pout_win = new JTextPane(this.pout_doc);
    JScrollPane pout_scroll = new JScrollPane(this.pout_win);
    JPanel cont_panel = new JPanel();
    JLabel comm_lab = new JLabel("Run Prog");
    JTextField comm_ent = new JTextField("");
    JLabel work_lab = new JLabel("Run Inside");
    JTextField work_ent = new JTextField(this.def_working_dir);
    SimpleAttributeSet attr_prompt = new SimpleAttributeSet();
    SimpleAttributeSet attr_process = new SimpleAttributeSet();
    SimpleAttributeSet attr_output = new SimpleAttributeSet();
    int history_index = 0;

    public CommandPanel(ClientController con) {
        this.controller = con;
        this.initStyles();
        this.initGraphics();
        this.initEventHandling();
    }

    private void initGraphics() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.pout_panel);
        this.pout_panel.setBorder(new SoftBevelBorder(0));
        this.pout_panel.setLayout(new BorderLayout());
        this.pout_panel.add("South", this.cont_panel);
        this.pout_panel.add("Center", this.pout_scroll);
        this.pout_win.setEditable(false);
        this.cont_panel.setLayout(this.gbl);
        ScaledInsets insets = new ScaledInsets(0, 0, 0, 0);
        this.gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 100.0, 17, 2, (Insets)insets, 0, 0);
        this.gbl.setConstraints(this.work_lab, this.gbc);
        this.gbc = new GridBagConstraints(1, 0, 1, 1, 1000.0, 100.0, 17, 2, (Insets)insets, 0, 0);
        this.gbl.setConstraints(this.work_ent, this.gbc);
        this.gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 100.0, 17, 2, (Insets)insets, 0, 0);
        this.gbl.setConstraints(this.comm_lab, this.gbc);
        this.gbc = new GridBagConstraints(1, 1, 1, 1, 1000.0, 100.0, 17, 2, (Insets)insets, 0, 0);
        this.gbl.setConstraints(this.comm_ent, this.gbc);
        this.cont_panel.add(this.work_lab);
        this.cont_panel.add(this.work_ent);
        this.cont_panel.add(this.comm_lab);
        this.cont_panel.add(this.comm_ent);
    }

    private void initEventHandling() {
        this.comm_ent.addKeyListener(this);
    }

    public void clear() {
        try {
            this.pout_doc.remove(0, this.pout_doc.getLength());
        }
        catch (Exception e) {
            Debugger.error("problem removing messages", e);
        }
        this.pout_win.repaint();
    }

    private void scrollToBottom() {
        this.pout_scroll.revalidate();
        this.pout_scroll.repaint();
        JScrollBar vbar = this.pout_scroll.getVerticalScrollBar();
        vbar.setValue(vbar.getMaximum());
    }

    private void addProcess(String process, String dir) {
        try {
            this.pout_doc.insertString(this.pout_doc.getLength(), process + " (" + dir + ")\n", this.attr_process);
            this.scrollToBottom();
            this.repaint();
        }
        catch (Exception e) {
            Debugger.error("problem adding process", e);
        }
    }

    public void addResponse(String output) {
        try {
            int blen = this.pout_doc.getLength();
            this.pout_doc.insertString(blen, output + "\n", this.attr_output);
            int diff = this.pout_doc.getLength() - blen;
            this.pout_doc.setParagraphAttributes(blen, diff, this.attr_output, false);
            this.scrollToBottom();
            this.repaint();
        }
        catch (Exception e) {
            Debugger.error("problem adding process response", e);
        }
    }

    private void initStyles() {
        StyleConstants.setFontSize(this.attr_prompt, 12);
        StyleConstants.setBold(this.attr_prompt, true);
        StyleConstants.setItalic(this.attr_prompt, false);
        StyleConstants.setForeground(this.attr_prompt, Color.black);
        StyleConstants.setFontSize(this.attr_process, 12);
        StyleConstants.setBold(this.attr_process, true);
        StyleConstants.setItalic(this.attr_process, false);
        StyleConstants.setForeground(this.attr_process, new Color(128, 0, 0));
        StyleConstants.setFontSize(this.attr_output, 12);
        StyleConstants.setBold(this.attr_output, false);
        StyleConstants.setItalic(this.attr_output, false);
        StyleConstants.setForeground(this.attr_output, Color.black);
        StyleConstants.setLeftIndent(this.attr_output, 10.0f);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        if (keycode == 10) {
            String program = this.comm_ent.getText();
            if (program.length() > 0) {
                String working_dir = this.work_ent.getText();
                this.comm_ent.setText("");
                if (Switches.SH_multiControl && MultiController.on()) {
                    MultiController.get().runProgram(program, working_dir, false);
                } else {
                    this.controller.runProgram(program, working_dir, false);
                }
                this.addProcess(program, working_dir);
                this.command_history.add(program);
                this.history_index = this.command_history.size();
                while (this.command_history.size() > 100) {
                    this.command_history.remove(0);
                }
            }
        } else if (keycode == 38) {
            if (this.history_index > 0) {
                --this.history_index;
                String program = (String)this.command_history.get(this.history_index);
                this.comm_ent.setText(program);
            }
        } else if (keycode == 40) {
            if (this.history_index < this.command_history.size() - 1) {
                ++this.history_index;
                String program = (String)this.command_history.get(this.history_index);
                this.comm_ent.setText(program);
            } else {
                this.comm_ent.setText("");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

