/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ProxiedSoundInterface;
import com.aem.sdesktop.interfaces.ProxiedSoundListener;
import com.aem.sdesktop.util.sound.PCMSoundPlayerListener;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Mixer;
import org.concentus.OpusDecoder;
import org.concentus.OpusException;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.sound.encoders.opus.OpusTest;

public class SoundController
extends Thread
implements GC,
MSG,
ProxiedSoundInterface {
    private final boolean isMobile;
    private Controller controller;
    private ClientUserInterface gui;
    private MessageReader min;
    private MessageWriter mout;
    private final Object listeners_LOCK = new Object();
    private OpusDecoder opusDecoder;
    private ProxiedSoundListener listener;
    private short[] pcmBuffer = new short[51200];

    public SoundController(Controller controller, ClientUserInterface gui, MessageReader min, MessageWriter mout, boolean isMobile) {
        super("SoundController");
        System.out.println("[SoundController] Initialising sound controller");
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
        this.isMobile = isMobile;
        if (!isMobile && CentralDebugging.ENABLE_AUDIO_CUST_TO_TECH) {
            this.acceptSoundData();
            this.setSoundListener(new PCMSoundPlayerListener());
        }
    }

    @Override
    public void run() {
        System.out.println("[SoundController] Starting...");
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Sound Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[SoundController] " + e);
                System.out.println("(Sound Controller) LAST MESSAGE:" + m);
            }
        }
        catch (Throwable e) {
            System.out.println("(Sound Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message m) {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            int type = m.getType();
            if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                System.out.println("[SoundController] Received message: " + m);
            }
            if (type == 655361) {
                byte[] dat = (byte[])m.get(0);
                if (CentralDebugging.ENABLE_AUDIO_CUST_TO_TECH) {
                    if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                        System.out.println("[SoundController] Received " + dat.length + " bytes...");
                    }
                    if (this.listener != null) {
                        this.listener.soundBytes(dat);
                    }
                }
            } else if (type == 655366) {
                this.handleOpusMessage(m);
            } else if (type == 655368) {
                for (int i = 0; i < m.length(); ++i) {
                    this.handleMessage(m.getNextMessage());
                }
            } else if (type == 655365) {
                if (CentralDebugging.ENABLE_AUDIO_CUST_TO_TECH) {
                    AudioFormat format = new AudioFormat(m.getNextInt(), m.getNextInt(), m.getNextInt(), true, false);
                    try {
                        this.opusDecoder = new OpusDecoder(48000, 2);
                    }
                    catch (OpusException e) {
                        e.printStackTrace();
                    }
                    if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                        System.out.println("[SoundController] Received a new format: " + format);
                    }
                    if (this.listener != null) {
                        this.listener.setFormat(format);
                    }
                }
            } else {
                System.out.println("[SoundController] Unrecognised sound server message " + m);
            }
        }
    }

    private void handleOpusMessage(Message m) {
        if (CentralDebugging.ENABLE_AUDIO_CUST_TO_TECH) {
            byte[] encodedData = (byte[])m.get(0);
            try {
                int channels = this.opusDecoder.getChannels();
                int samplesDecoded = this.opusDecoder.decode(encodedData, 0, encodedData.length, this.pcmBuffer, 0, 960, false);
                byte[] data = OpusTest.ShortsToBytes(this.pcmBuffer, 0, samplesDecoded * channels);
                if (CentralDebugging.PRINT_AUDIO_DEBUG) {
                    System.out.println("[SoundController] Decoded " + encodedData.length + " encoded bytes and produced " + data.length);
                }
                if (this.listener != null) {
                    this.listener.soundBytes(data);
                }
            }
            catch (OpusException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoundListener(ProxiedSoundListener listener) {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            if (this.listener != null) {
                listener.die();
            }
            this.listener = listener;
        }
    }

    @Override
    public void sendSoundBytes(byte[] dat) {
        this.sendSoundBytes(dat, 0, dat.length);
    }

    @Override
    public void sendSoundBytes(byte[] dat, int offset, int length) {
        if (!CentralDebugging.ENABLE_AUDIO_TECH_TO_CUST) {
            return;
        }
        if (CentralDebugging.PRINT_AUDIO_DEBUG) {
            System.out.println("[SoundController] Sending " + length + " bytes...");
        }
        Message m = new Message(655361);
        m.append(dat, offset, length);
        try {
            this.mout.write(m);
        }
        catch (Exception x) {
            System.out.println("[SoundController] Unable to send sound data: " + x);
        }
    }

    private void acceptSoundData() {
        Message m = new Message(655367);
        try {
            this.mout.write(m);
        }
        catch (Exception x) {
            System.out.println("[SoundController] Unable to send sound data accept: " + x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMixerForAudioOutput(Mixer mixerForAudioOutput) {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            if (this.listener != null) {
                this.listener.setMixerToUse(mixerForAudioOutput);
            }
        }
    }
}

