/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.shelp.common.Language;
import java.io.IOException;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class ChatController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    MessageWriter mout;

    public void log(String msg, String details) {
    }

    public ChatController(Controller controller, ClientUserInterface gui, MessageReader min, MessageWriter mout) {
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            this.log(Language.get("CONNECTION_TERMINATED"), Language.get("CONNECTION_TERMINATED_DETAILS"));
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Chat Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ChatController] " + e);
            }
        }
        catch (Throwable e) {
            System.out.println("(Chat Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    public void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 327681) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("MESSAGE_SEND " + m);
            }
            String message = (String)m.get(0);
            String user = (String)m.get(1);
            String host = (String)m.get(2);
            this.gui.addMessage(user, host, message);
        } else if (type == 327683) {
            this.gui.disableChat();
        }
    }
}

