/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop;

import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.util.Properties;
import utils.message.Message;
import utils.xml.XML14Util;

public abstract class SessionDescription {
    public String technicianSummary;
    public String chatTranscript;
    public long sessionDurationMS;
    public String sessionDuration;
    public String customEmailAddress;
    private String sessionID;

    public abstract boolean isCustomerSession();

    protected SessionDescription() {
    }

    public SessionDescription(Message m) {
        this.sessionID = m.getNextString();
        this.technicianSummary = SessionDescription.getString(m);
        this.chatTranscript = SessionDescription.getString(m);
        this.sessionDurationMS = m.getNextLong();
        this.sessionDuration = new ElapsedTimeFormatter().getCompleteFormattedTime(this.sessionDurationMS, false);
        this.customEmailAddress = SessionDescription.getString(m);
    }

    public Message toMessage() {
        Message message = new Message();
        message.append(this.isCustomerSession());
        message.append(this.sessionID);
        SessionDescription.appendString(message, this.technicianSummary);
        SessionDescription.appendString(message, this.chatTranscript);
        message.append(this.sessionDurationMS);
        SessionDescription.appendString(message, this.customEmailAddress);
        return message;
    }

    public static SessionDescription fromMessage(Message m) {
        boolean isSupport = m.getNextBoolean();
        SessionDescription sd = isSupport ? new SupportSessionDescription(m) : new AccessSessionDescription(m);
        return sd;
    }

    private static void appendString(Message message, String str) {
        if (str == null) {
            message.append("----null----");
        } else {
            message.append(str);
        }
    }

    private static String getString(Message message) {
        String result = message.getNextString();
        if (result.equals("----null----")) {
            return null;
        }
        return result;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void toProperties(String tag, Properties properties) {
        if (this.sessionDuration != null) {
            properties.put(tag + "_sessionDuration", this.sessionDuration);
        }
        properties.put(tag + "_sessionDurationMS", Long.toString(this.sessionDurationMS));
        if (this.technicianSummary != null && this.technicianSummary.trim().length() > 0) {
            properties.put(tag + "_technicianSummary", this.technicianSummary.trim());
        }
        if (this.chatTranscript != null && this.chatTranscript.trim().length() > 0) {
            properties.put(tag + "_chatTranscript", this.chatTranscript.trim());
        }
        if (this.customEmailAddress != null && this.customEmailAddress.trim().length() > 0) {
            properties.put(tag + "_customEmailAddress", this.customEmailAddress.trim());
        }
        properties.put(tag + "_sessionID", this.sessionID);
    }

    public void appendToXML(StringBuffer buffer, int i) {
        if (this.sessionDuration != null) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"sessionDuration", (String)this.sessionDuration);
        }
        XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"sessionDurationMS", (String)Long.toString(this.sessionDurationMS));
        if (this.technicianSummary != null && this.technicianSummary.trim().length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"technicianSummary", (String)this.technicianSummary.trim());
        }
        if (this.chatTranscript != null && this.chatTranscript.trim().length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"chatTranscript", (String)this.chatTranscript.trim());
        }
        if (this.customEmailAddress != null && this.customEmailAddress.trim().length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"customEmailAddress", (String)this.customEmailAddress.trim());
        }
        XML14Util.appendTextNode((StringBuffer)buffer, (int)i, (String)"sessionID", (String)this.sessionID);
    }

    public static class AccessSessionDescription
    extends SessionDescription {
        public Machine machineType;

        public AccessSessionDescription(Message m) {
            super(m);
            this.machineType = new Machine(m.getNextMessage());
        }

        public AccessSessionDescription(Machine machine) {
            this.machineType = machine;
        }

        @Override
        public Message toMessage() {
            Message m = super.toMessage();
            m.append(this.machineType.toMessage());
            return m;
        }

        public String getRemoteMachineName() {
            return this.machineType.getMachineName().toString();
        }

        @Override
        public boolean isCustomerSession() {
            return false;
        }

        @Override
        public void appendToXML(StringBuffer buffer, int i) {
            buffer.append(XML14Util.getIndent((int)i)).append("<AccessSessionDescription>\n");
            super.appendToXML(buffer, i + 1);
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(i + 1), (String)"machineType", (String)this.getRemoteMachineName());
            buffer.append(XML14Util.getIndent((int)i)).append("</AccessSessionDescription>\n");
        }

        @Override
        public void toProperties(String tag, Properties properties) {
            super.toProperties(tag, properties);
            properties.put(tag + "_machineType", this.getRemoteMachineName());
        }
    }

    public static class SupportSessionDescription
    extends SessionDescription {
        public Customer customer;

        public SupportSessionDescription(Message m) {
            super(m);
            this.customer = new Customer(m.getNextMessage());
        }

        public SupportSessionDescription(Customer customer) {
            this.customer = customer;
        }

        @Override
        public Message toMessage() {
            Message m = super.toMessage();
            m.append(this.customer.toMessage());
            return m;
        }

        @Override
        public boolean isCustomerSession() {
            return true;
        }

        public Customer getCustomerInfo() {
            return this.customer;
        }

        @Override
        public void appendToXML(StringBuffer buffer, int i) {
            buffer.append(XML14Util.getIndent((int)i)).append("<SupportSessionDescription>\n");
            super.appendToXML(buffer, i + 1);
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(i + 1), (String)"customer", (String)this.customer.toString(true));
            buffer.append(XML14Util.getIndent((int)i)).append("</SupportSessionDescription>\n");
        }

        @Override
        public void toProperties(String tag, Properties properties) {
            super.toProperties(tag, properties);
            properties.put(tag + "_customer", this.customer.toString(true));
        }
    }
}

