/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.http.DefaultHttpClientFactory;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.KeystoreConfig;
import com.aem.nodelink.utils.NotNodelinkSslConnectionException;
import com.aem.nodelink.utils.SSLCipherSuiteHelper;
import com.aem.nodelink.utils.WorkingNioSocket;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import utils.progtools.BufferPool;
import utils.progtools.ByteBufferPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.progtools.WeakReferenceTimerThread;
import utils.stream.SelectPool;
import utils.stream.SelectPoolHandler;
import utils.switches.Switches;

public class SslToTcp {
    public static boolean LOCAL_SOCKET_CREATE_VERBOSE = false;
    public static boolean ACCEPT_ONLY_SSL_CONNECTIONS = false;
    private static boolean GRAB_UNDERLYING_TCP_SOCKETS = true;
    private static boolean FALL_BACK_TO_SELF_SIGNED = true;
    private static String[] possibleAcceptedCiphers = null;
    private static String[] enabledCiphers = null;
    private static String[] possibleAcceptedProtocols = null;
    private static String[] enabledProtocols = null;
    static ServerSocket ssock;
    static int port;
    static Object LOCK;
    static IOException bindFail;
    static ArrayList sslrefs;
    private static int test_port;
    private static boolean test_loop;
    private static boolean test_HTTP;
    private static final boolean VERBOSE_SSL_PROXY = false;
    private static final boolean VERBOSE_MARKER = false;
    private static final String SSLRESOURCE = "---nl---sh---connect---XXX";
    public static KeystoreConfig KEYSTORE;
    static TimeoutMap.NoKeyTimeoutMap<Socket> shutdown;
    static SocketClose shutdownHandler;
    static Object pool_LOCK;
    static SelectPool pool;
    static SslSelectHandler poolHandler;
    static BufferPool bpool;
    static ByteBufferPool bbpool;
    private static TimeoutHandler handler;
    private static TimeoutMap<Socket, Socket> timeout;
    static Object packs_LOCK;
    static ArrayList<SocketPack> packs;
    static SocketPackCleanup packCleanup;
    static WeakReferenceTimerThread wrt;
    static boolean SSL_LOADED;
    static SSLContext ssc;
    private static HostnameVerifier trustAllHosts;
    private static TrustManager[] trustAllCerts;

    public static void setSslEnforcement(boolean acceptOnlySsl, boolean useSslEncryption) {
        ACCEPT_ONLY_SSL_CONNECTIONS = acceptOnlySsl;
        GRAB_UNDERLYING_TCP_SOCKETS = ACCEPT_ONLY_SSL_CONNECTIONS ? !useSslEncryption : true;
    }

    public static void setSSLAcceptedCiphers(String[] ciphers, String[] protocols) {
        System.out.println("[SSlToTcp] Accepted protocols are " + Arrays.toString(protocols));
        possibleAcceptedCiphers = ciphers;
        possibleAcceptedProtocols = protocols;
    }

    public static void main(String[] args) throws Exception {
        Socket ssl;
        System.out.println("GOT - " + SslToTcp.getKeyManagerFactory().getAlgorithm());
        SslToTcp.startListening();
        new DefaultHttpClientFactory();
        ServerSocket tcpServ = new ServerSocket(test_port);
        System.out.println("TCP listening on port " + test_port);
        int N = 1;
        do {
            if (!test_HTTP) {
                new TestThread().start();
            }
            System.out.println("SSL listening on port " + port);
            Socket tcp = tcpServ.accept();
            System.out.println("Server got TCP socket, mapping to SSL now");
            byte[] first = DataUtils.readBytes(tcp.getInputStream(), 4);
            SocketPack pack = SslToTcp.mapTcpToSsl(tcp, first);
            ssl = pack.getReplacement();
            System.out.println("Server was provided with socket: " + ssl);
            if (test_HTTP) {
                SslToTcp.readHttpRequest(ssl.getInputStream());
                SslToTcp.sendFakeHttpResponse(ssl.getOutputStream());
                continue;
            }
            DataUtils.writeString(ssl.getOutputStream(), "This is the server side saying Hello!");
            ssl.getOutputStream().flush();
            System.out.println("Client told me: \"" + DataUtils.readNString(ssl.getInputStream(), 20000) + "\"");
            if (!test_loop) continue;
            ssl.close();
            System.out.println("----------- ATTEMPT " + N++ + " ------------");
        } while (test_loop || test_HTTP);
        while (true) {
            DataUtils.writeString(ssl.getOutputStream(), "This is the server side saying Hello!");
            ssl.getOutputStream().flush();
            System.out.println("Client told me: \"" + DataUtils.readNString(ssl.getInputStream(), 20000) + "\"");
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restartListening() {
        Object object = LOCK;
        synchronized (object) {
            try {
                ssock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ssock = null;
            bindFail = null;
            SSL_LOADED = false;
            SslToTcp.startListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startListening() {
        Object object = LOCK;
        synchronized (object) {
            if (ssock == null && bindFail == null) {
                try {
                    SslToTcp.setupSslAndHttpsToAcceptAllCerts();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    ssock = SslToTcp.createSSLServerSocket();
                    port = ssock.getLocalPort();
                }
                catch (IOException x) {
                    bindFail = x;
                }
            }
        }
    }

    public static void updateTracking(Socket sock) {
        timeout.put(sock, sock, NodeLink.DEFAULT_RECONNECT_TIMEOUT, handler);
    }

    public static Socket createSslMappedTcpSocket(String host, int port) throws IOException {
        try {
            SslToTcp.setupSslAndHttpsToAcceptAllCerts();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        HttpsURLConnection conn = (HttpsURLConnection)new URL("https://" + host + ":" + port + "/" + SSLRESOURCE).openConnection();
        conn.setHostnameVerifier(trustAllHosts);
        IntrospectingSSLSocketFactory factory = new IntrospectingSSLSocketFactory(ssc.getSocketFactory());
        conn.setSSLSocketFactory(factory);
        conn.connect();
        conn.getInputStream().read();
        Socket mysock = factory.latestSslSock;
        System.out.println("[SslTcpClient] Client got socket " + mysock);
        SslToTcp.writeMarker(mysock.getOutputStream());
        SslToTcp.readUntilReady("[SslTcpClient] ", mysock.getInputStream());
        if (DataUtils.readBoolean(mysock.getInputStream())) {
            SocketsRef ref = new SocketsRef();
            ref.conn = conn;
            ref.sslsock = factory.latestSslSock;
            ref.tcpsock = new WeakReference<Socket>(factory.latestTcpSock);
            sslrefs.add(ref);
            for (int i = 0; i < sslrefs.size(); ++i) {
                SocketsRef test = (SocketsRef)sslrefs.get(i);
                if (test.tcpsock.get() != null) continue;
                sslrefs.remove(i--);
            }
            DataUtils.writeBoolean(mysock.getOutputStream(), true);
            mysock.getOutputStream().flush();
            mysock = factory.latestTcpSock;
            SslToTcp.readUntilReady("[SslTcpClient] ", mysock.getInputStream());
            SslToTcp.writeCrud(mysock.getOutputStream());
            DataUtils.readBoolean(mysock.getInputStream());
            try {
                Field field = Socket.class.getDeclaredField("impl");
                field.setAccessible(true);
                field.set(factory.latestSslSock, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            SslToTcp.writeMarker(mysock.getOutputStream());
            return mysock;
        }
        DataUtils.writeBoolean(mysock.getOutputStream(), true);
        mysock.getOutputStream().flush();
        return mysock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketPack mapTcpToSsl(Socket tcp, byte[] firstBytes) throws IOException, NotNodelinkSslConnectionException {
        Socket sslSock;
        TcpPiper piper;
        if (bindFail != null) {
            throw bindFail;
        }
        SocketPack pack = new SocketPack("" + tcp);
        pack.add("original tcp", tcp);
        Object object = LOCK;
        synchronized (object) {
            piper = new TcpPiper(tcp, firstBytes);
            piper.start();
            ssock.setSoTimeout(10000);
            sslSock = ssock.accept();
        }
        pack.add("server accepted ssl (orig)", sslSock);
        pack.add("client ssl (orig)", piper.origssl);
        pack.add("original tcp (nio wrap)", piper.tcp);
        pack.add("client ssl (nio wrap)", piper.ssl);
        if (Switches.SH_1829_increaseSslToTcpTimeout) {
            piper.tcp.setSoTimeout(300000);
            piper.ssl.setSoTimeout(300000);
        }
        if (Switches.SH_1829_reduceSslToTcpBuffering) {
            piper.tcp.setReceiveBufferSize(100000);
            piper.tcp.setSendBufferSize(100000);
            piper.ssl.setReceiveBufferSize(100000);
            piper.ssl.setSendBufferSize(100000);
        }
        try {
            InputStream testin = sslSock.getInputStream();
            char[] teststr = "GET /---nl---sh---connect---XXX".toCharArray();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            sslSock.setSoTimeout(30000);
            boolean matches = true;
            for (int i = 0; i < teststr.length; ++i) {
                int n = testin.read();
                bout.write(n);
                if (matches && teststr[i] == (char)n) continue;
                matches = false;
                if (bout.size() < 4) continue;
                throw new NotNodelinkSslConnectionException(bout.toByteArray(), sslSock);
            }
            if (!Switches.SH_1468_sslToTcpSocketTimeout) {
                sslSock.setSoTimeout(0);
            } else {
                sslSock.setSoTimeout(NodeLink.DEFAULT_ERROR_TIMEOUT);
            }
        }
        catch (IOException x) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception teststr) {
                // empty catch block
            }
            try {
                sslSock.close();
            }
            catch (Exception teststr) {
                // empty catch block
            }
            if (Switches.SH_1778_sslToTcpCloseTcpAlso) {
                try {
                    tcp.close();
                }
                catch (Exception teststr) {
                    // empty catch block
                }
            }
            try {
                piper.d1.stop = true;
                piper.d2.stop = true;
            }
            catch (Exception teststr) {
                // empty catch block
            }
            throw x;
        }
        try {
            SslToTcp.readHttpRequest(sslSock.getInputStream());
            SslToTcp.sendFakeHttpResponse(sslSock.getOutputStream());
            Socket mysock = sslSock;
            SslToTcp.writeMarker(mysock.getOutputStream());
            SslToTcp.readUntilReady("[SslTcpServer] ", mysock.getInputStream());
            if (GRAB_UNDERLYING_TCP_SOCKETS) {
                DataUtils.writeBoolean(sslSock.getOutputStream(), true);
                sslSock.getOutputStream().flush();
                int timeout = sslSock.getSoTimeout();
                sslSock.setSoTimeout(NodeLink.DEFAULT_ERROR_TIMEOUT);
                DataUtils.readBoolean(sslSock.getInputStream());
                sslSock.setSoTimeout(timeout);
                try {
                    piper.d1.stop = true;
                    new CrudWriter(sslSock.getOutputStream()).start();
                }
                catch (Exception x) {
                    System.err.println(x);
                }
                try {
                    piper.d1.join();
                }
                catch (Exception x) {
                    System.err.println(x);
                }
                try {
                    piper.d2.stop = true;
                }
                catch (Exception x) {
                    System.err.println(x);
                }
                SslToTcp.writeMarker(tcp.getOutputStream());
                try {
                    piper.d2.join();
                }
                catch (Exception x) {
                    System.err.println(x);
                }
                DataUtils.writeBoolean(tcp.getOutputStream(), false);
                tcp.getOutputStream().flush();
                SslToTcp.readUntilReady("[SslTcpServer] ", tcp.getInputStream());
                pack.setReplacement(tcp);
                SocketPack socketPack = pack;
                return socketPack;
            }
            DataUtils.writeBoolean(sslSock.getOutputStream(), false);
            sslSock.getOutputStream().flush();
            DataUtils.readBoolean(sslSock.getInputStream());
            pack.setReplacement(mysock);
            SocketPack socketPack = pack;
            return socketPack;
        }
        finally {
            if (Switches.SH_1468_sslToTcpSocketTimeout) {
                sslSock.setSoTimeout(0);
            }
        }
    }

    private static void readHttpRequest(InputStream in) throws IOException {
        String line = new String(DataUtils.readLine(in), "ASCII");
        while (line != null) {
            if (line.trim().length() == 0) {
                return;
            }
            line = new String(DataUtils.readLine(in), "ASCII");
        }
    }

    private static void sendFakeHttpResponse(OutputStream out) throws IOException {
        out.write("HTTP/1.1 200 OK\n".getBytes("ASCII"));
        out.write("Content-type: text/html\n".getBytes("ASCII"));
        out.write("Content-Length: 512\n".getBytes("ASCII"));
        for (int i = 0; i < 512; ++i) {
            if (i % 2 == 0) {
                out.write(46);
            } else {
                out.write(32);
            }
            if (i % 100 != 0) continue;
            out.flush();
        }
        out.write(10);
        out.write(10);
        out.flush();
    }

    private static void writeCrud(OutputStream out) throws IOException {
        for (int i = 0; i < 5000; ++i) {
            out.write(37);
            if (i % 100 != 0) continue;
            out.flush();
        }
        out.flush();
    }

    private static void writeMarker(OutputStream out) throws IOException {
        int i;
        for (i = 0; i < 1000; ++i) {
            out.write(36);
            if (i % 100 != 0) continue;
            out.flush();
        }
        out.flush();
        for (i = 0; i < 50; ++i) {
            out.write(45);
        }
        out.flush();
    }

    private static void readUntilReady(String name, InputStream in) throws IOException {
        int count = 0;
        int n = in.read();
        while (n != -1) {
            count = n == 36 ? ++count : 0;
            n = in.read();
            if (count != 50) continue;
        }
        count = 0;
        while (n != -1) {
            count = n == 45 ? ++count : 0;
            if (count == 50) break;
            n = in.read();
        }
    }

    public static boolean haveSpecificEnabledCiphersAndProtocols() {
        return enabledCiphers != null;
    }

    public static String[] getEnabledCiphers() {
        return enabledCiphers;
    }

    public static String[] getEnabledProtocols() {
        return enabledProtocols;
    }

    public static String[] getPossibleAcceptedCiphers() {
        if (possibleAcceptedCiphers == null) {
            possibleAcceptedCiphers = SSLCipherSuiteHelper.DEFAULT_GOOD_CIPHERS;
        }
        return possibleAcceptedCiphers;
    }

    public static String[] getPossibleAcceptedProtocols() {
        if (possibleAcceptedProtocols == null) {
            possibleAcceptedProtocols = SSLCipherSuiteHelper.DEFAULT_GOOD_PROTOCOLS;
        }
        return possibleAcceptedProtocols;
    }

    private static ServerSocket createSSLServerSocket() throws IOException {
        SSLServerSocket ssock = (SSLServerSocket)ssc.getServerSocketFactory().createServerSocket(0, 50, InetAddress.getByName("localhost"));
        ssock.setWantClientAuth(false);
        ssock.setNeedClientAuth(false);
        if (enabledCiphers == null) {
            if (possibleAcceptedCiphers == null) {
                possibleAcceptedCiphers = SSLCipherSuiteHelper.DEFAULT_GOOD_CIPHERS;
            }
            if (possibleAcceptedProtocols == null) {
                possibleAcceptedProtocols = SSLCipherSuiteHelper.DEFAULT_GOOD_PROTOCOLS;
            }
            enabledCiphers = SSLCipherSuiteHelper.getGoodAvailableCiphers(possibleAcceptedCiphers, ssock);
            enabledProtocols = SSLCipherSuiteHelper.getGoodAvailableProtocols(possibleAcceptedProtocols, ssock);
        }
        ssock.setEnabledCipherSuites(enabledCiphers);
        ssock.setEnabledProtocols(enabledProtocols);
        return ssock;
    }

    public static void setKeystorePasswords(String storePassword, String keyPassword) {
        KEYSTORE.setKeystorePasswords(storePassword, keyPassword);
        try {
            SslToTcp.restartListening();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        try {
            return KeyManagerFactory.getInstance("SunX509");
        }
        catch (Throwable t) {
            System.out.println("[SSLCertificate] No Sun SSL Provider found.");
            try {
                return KeyManagerFactory.getInstance("IbmX509");
            }
            catch (Throwable tt) {
                System.out.println("[SSLCertificate] No IBM SSL Provider found.");
                try {
                    return KeyManagerFactory.getInstance("X.509");
                }
                catch (Throwable ttt) {
                    System.out.println("[SSLCertificate] No Generic X.509 Provider found.");
                    return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(File location, char[] password) throws Exception {
        KeyStore keyStore;
        try {
            FileInputStream fin = new FileInputStream(location);
            try {
                keyStore = KeyStore.getInstance("JKS");
                keyStore.load(fin, password);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception ex) {
            FileInputStream fin = new FileInputStream(location);
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                keyStore.load(fin, password);
            }
            finally {
                try {
                    if (fin != null) {
                        fin.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        return keyStore;
    }

    public static SSLContext getSSLContext() throws Exception {
        SslToTcp.setupSslAndHttpsToAcceptAllCerts();
        return ssc;
    }

    private static void setupSslAndHttpsToAcceptAllCerts() throws Exception {
        if (!SSL_LOADED) {
            ssc = SSLContext.getInstance("SSL");
            try {
                System.out.println("[SSLCertificates] Trying to load SSL Keystore");
                KeyStore keyStore = SslToTcp.loadKeystore(KEYSTORE.getKeystoreFile(), KEYSTORE.getKeystoreStorePassword().toCharArray());
                KeyManagerFactory keyManagerFactory = SslToTcp.getKeyManagerFactory();
                keyManagerFactory.init(keyStore, KEYSTORE.getKeystoreKeyPassword().toCharArray());
                ssc.init(keyManagerFactory.getKeyManagers(), trustAllCerts, new SecureRandom());
                System.out.println("[SSLCertificates] SSL Keystore loaded.");
                KEYSTORE.setIsSelfSigned(false);
            }
            catch (Throwable t) {
                KEYSTORE.setIsSelfSigned(true);
                try {
                    System.out.println("[SSLCertificates] Trying to load default self-signed SSL Keystore");
                    KeyStore keyStore = SslToTcp.loadKeystore(KEYSTORE.getDefaultKeystoreFile(), KEYSTORE.getDefaultKeystorePassword().toCharArray());
                    KeyManagerFactory keyManagerFactory = SslToTcp.getKeyManagerFactory();
                    keyManagerFactory.init(keyStore, KEYSTORE.getDefaultKeystorePassword().toCharArray());
                    ssc.init(keyManagerFactory.getKeyManagers(), trustAllCerts, new SecureRandom());
                    System.out.println("[SSLCertificates] default self-signed SSL Keystore loaded");
                }
                catch (Throwable tt) {
                    System.out.println("[SSLCertificates] SSL Keystore load failed (" + tt + ")");
                    ssc.init(null, trustAllCerts, new SecureRandom());
                }
            }
            SSL_LOADED = true;
        }
    }

    static {
        LOCK = new Object();
        sslrefs = new ArrayList();
        test_port = 5510;
        test_loop = false;
        test_HTTP = true;
        KEYSTORE = new KeystoreConfig();
        shutdown = new TimeoutMap.NoKeyTimeoutMap(5000);
        shutdownHandler = new SocketClose();
        pool_LOCK = new Object();
        handler = new TimeoutHandler();
        timeout = new TimeoutMap();
        packs_LOCK = new Object();
        packs = new ArrayList();
        packCleanup = new SocketPackCleanup();
        SSL_LOADED = false;
        trustAllHosts = new HostnameVerifier(){

            @Override
            public boolean verify(String rserver, SSLSession sses) {
                if (!rserver.equals(sses.getPeerHost())) {
                    // empty if block
                }
                return true;
            }
        };
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static class CrudWriter
    extends Thread {
        OutputStream out;

        public CrudWriter(OutputStream out) {
            this.out = out;
        }

        @Override
        public void run() {
            try {
                SslToTcp.writeCrud(this.out);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class DataTransferer
    extends Thread {
        InputStream in;
        OutputStream out;
        boolean stop = false;

        public DataTransferer(InputStream in, OutputStream out) {
            super("SSLDatTran");
            this.in = new BufferedInputStream(in);
            this.out = new BufferedOutputStream(out);
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[100];
                int n = 0;
                while (n != -1 && !this.stop) {
                    n = this.in.read(buf, 0, buf.length);
                    if (!this.stop) {
                        if (n == -1) continue;
                        this.out.write(buf, 0, n);
                        this.out.flush();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class IntrospectingSSLSocketFactory
    extends SSLSocketFactory {
        SSLSocketFactory factory;
        Socket latestSslSock;
        Socket latestTcpSock;

        public IntrospectingSSLSocketFactory(SSLSocketFactory factory) {
            this.factory = factory;
        }

        private void setup(Socket s) {
            String[] suites = ((SSLSocket)s).getSupportedCipherSuites();
            ((SSLSocket)s).setEnabledCipherSuites(suites);
            ((SSLSocket)s).setWantClientAuth(false);
            ((SSLSocket)s).setNeedClientAuth(false);
        }

        @Override
        public Socket createSocket(Socket tcp, String host, int port, boolean autoClose) throws IOException {
            Socket s = this.factory.createSocket(tcp, host, port, true);
            this.setup(s);
            this.latestTcpSock = tcp;
            this.latestSslSock = s;
            return s;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return SSLCipherSuiteHelper.DEFAULT_GOOD_CIPHERS;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return SSLCipherSuiteHelper.DEFAULT_GOOD_CIPHERS;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            if (!GRAB_UNDERLYING_TCP_SOCKETS) {
                Socket s = this.factory.createSocket();
                this.setup(s);
                s.connect(new InetSocketAddress(host, port));
                this.latestSslSock = s;
                return s;
            }
            Socket s = new Socket(host, port);
            return this.createSocket(s, host, port, true);
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            if (!GRAB_UNDERLYING_TCP_SOCKETS) {
                Socket s = this.factory.createSocket();
                this.setup(s);
                s.connect(new InetSocketAddress(host, port));
                this.latestSslSock = s;
                return s;
            }
            String hname = host.getHostAddress();
            Socket s = new Socket(hname, port);
            return this.createSocket(s, hname, port, true);
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localaddr, int localport) throws IOException, UnknownHostException {
            if (!GRAB_UNDERLYING_TCP_SOCKETS) {
                Socket s = this.factory.createSocket();
                this.setup(s);
                s.bind(new InetSocketAddress(localaddr, localport));
                s.connect(new InetSocketAddress(host, port));
                this.latestSslSock = s;
                return s;
            }
            Socket s = new Socket(host, port, localaddr, localport);
            return this.createSocket(s, host, port, true);
        }

        @Override
        public Socket createSocket(InetAddress host, int port, InetAddress localaddr, int localport) throws IOException {
            if (!GRAB_UNDERLYING_TCP_SOCKETS) {
                Socket s = this.factory.createSocket();
                this.setup(s);
                s.bind(new InetSocketAddress(localaddr, localport));
                s.connect(new InetSocketAddress(host, port));
                this.latestSslSock = s;
                return s;
            }
            String hname = host.getHostAddress();
            Socket s = new Socket(hname, port, localaddr, localport);
            return this.createSocket(s, hname, port, true);
        }
    }

    static class MyKeyManager
    implements X509KeyManager {
        X509Certificate[] certs;

        public MyKeyManager(ArrayList allcerts) {
            this.certs = new X509Certificate[allcerts.size()];
            allcerts.toArray(this.certs);
        }

        @Override
        public String chooseClientAlias(String[] arg0, Principal[] arg1, Socket arg2) {
            System.out.println("[KeyManager] Choose client alias");
            return null;
        }

        @Override
        public String chooseServerAlias(String arg0, Principal[] arg1, Socket arg2) {
            System.out.println("[KeyManager] Choose server alias " + arg0);
            return "all";
        }

        @Override
        public X509Certificate[] getCertificateChain(String arg0) {
            System.out.println("[KeyManager] Get certificate chain");
            return null;
        }

        @Override
        public String[] getClientAliases(String arg0, Principal[] arg1) {
            System.out.println("[KeyManager] Get client alias");
            return null;
        }

        @Override
        public PrivateKey getPrivateKey(String arg0) {
            System.out.println("[KeyManager] Get private key");
            return null;
        }

        @Override
        public String[] getServerAliases(String arg0, Principal[] arg1) {
            System.out.println("[KeyManager] Get server alias");
            return null;
        }
    }

    static class SocketClose
    implements TimeoutMapListener<String, Socket> {
        SocketClose() {
        }

        @Override
        public void objectTimedOut(String key, Socket socket) {
            try {
                socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class SocketPack {
        Object LOCK = new Object();
        ArrayList<String> names = new ArrayList();
        ArrayList<Socket> socks = new ArrayList();
        Socket replacement;
        String ref;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SocketPack(String ref) {
            this.ref = ref;
            Object object = packs_LOCK;
            synchronized (object) {
                if (wrt == null) {
                    wrt = new WeakReferenceTimerThread((Runnable)packCleanup, 10000);
                    wrt.start();
                }
                packs.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(String name, Socket sock) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.socks.contains(sock)) {
                    this.names.add(name);
                    this.socks.add(sock);
                }
            }
        }

        public Socket getReplacement() {
            return this.replacement;
        }

        public ArrayList<Socket> getSocks() {
            return this.socks;
        }

        public void setReplacement(Socket sock) {
            this.add("replacement", sock);
            this.replacement = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean closeIfBroken() {
            Object object = this.LOCK;
            synchronized (object) {
                for (Socket sock : this.socks) {
                    try {
                        if (!sock.isClosed()) continue;
                        this.close();
                        return true;
                    }
                    catch (Exception x) {
                        this.close();
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (Switches.SH_1778_sslToTcpCloseAllRelatedSockets) {
                Object object = this.LOCK;
                synchronized (object) {
                    for (Socket sock : this.socks) {
                        try {
                            sock.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        public String toString() {
            return "SocketPack[" + this.ref + "]";
        }
    }

    public static class SocketPackCleanup
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = packs_LOCK;
            synchronized (object) {
                for (int i = 0; i < packs.size(); ++i) {
                    SocketPack pack = packs.get(i);
                    if (!pack.closeIfBroken()) continue;
                    if (LOCAL_SOCKET_CREATE_VERBOSE) {
                        System.out.println("[SSLTT] Pack " + pack + " closed");
                    }
                    packs.remove(i--);
                }
            }
            if (LOCAL_SOCKET_CREATE_VERBOSE) {
                System.out.println("[SSLTT] Cleanup ran, " + packs.size() + " packs remaining");
            }
        }
    }

    private static class SocketsRef {
        Object conn;
        Object sslsock;
        WeakReference tcpsock;

        private SocketsRef() {
        }
    }

    private static class SslSelectHandler
    implements SelectPoolHandler {
        private SslSelectHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void process(Socket socket, Object attachment) {
            Socket dest = (Socket)attachment;
            if (Switches.SH_XXXX_trackAndClearLocalSockets) {
                SslToTcp.updateTracking(socket);
                SslToTcp.updateTracking(dest);
            }
            if (Switches.SH_XXXX_sslNioForwardUsingChannels) {
                ByteBuffer buffer = bbpool.getBuffer();
                try {
                    SocketChannel source = socket.getChannel();
                    SocketChannel target = dest.getChannel();
                    source.configureBlocking(false);
                    target.configureBlocking(false);
                    int n = source.read(buffer);
                    if (n == -1) {
                        throw new IOException("Channel closed");
                    }
                    if (n > 0) {
                        buffer.flip();
                        while (buffer.hasRemaining()) {
                            target.write(buffer);
                        }
                        buffer.clear();
                    }
                    pool.dumpIntoPool(socket, attachment);
                    return;
                }
                catch (IOException x) {
                    if (!Switches.SH_suppressSslNioClosePrinting) {
                        x.printStackTrace();
                    }
                    shutdown.add(socket, 5000L, shutdownHandler);
                    shutdown.add(dest, 5000L, shutdownHandler);
                    return;
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    shutdown.add(socket, 5000L, shutdownHandler);
                    shutdown.add(dest, 5000L, shutdownHandler);
                    return;
                }
                finally {
                    bbpool.done(buffer);
                }
            }
            byte[] buffer = bpool.getBuffer();
            try {
                boolean doRead = true;
                int n = 0;
                int attempt = 0;
                while (doRead) {
                    try {
                        if (++attempt == 10) {
                            throw new IOException("Too many OOM errors in SslSelectHandler");
                        }
                        if (doRead) {
                            System.out.println("DOING READ");
                            n = socket.getInputStream().read(buffer);
                        }
                        doRead = false;
                        if (n == -1) {
                            throw new IOException("source socket " + socket.getRemoteSocketAddress() + " closed");
                        }
                        if (n > 0) {
                            OutputStream out = dest.getOutputStream();
                            out.write(buffer, 0, n);
                            out.flush();
                        }
                        pool.dumpIntoPool(socket, attachment);
                    }
                    catch (OutOfMemoryError x) {
                        x.printStackTrace();
                        System.out.println("***WARNING*** OOM in SslSelectHandler: " + x.getMessage() + ", will gc and retry");
                        System.gc();
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {}
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        try {
                            System.out.println("DELETEME closing socket due to " + x);
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            System.out.println("DELETEME closing dest also due to " + x);
                            dest.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        bpool.done((Object)buffer);
                        return;
                    }
                    catch (Throwable x) {
                        try {
                            x.printStackTrace();
                            try {
                                System.out.println("DELETEME closing socket due to " + x);
                                socket.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                System.out.println("DELETEME closing dest also due to " + x);
                                dest.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                        bpool.done((Object)buffer);
                        return;
                    }
                }
            }
            finally {
                bpool.done((Object)buffer);
            }
        }
    }

    private static class TcpPiper
    extends Thread {
        Socket tcp;
        byte[] send;
        DataTransferer d1;
        DataTransferer d2;
        Socket origssl;
        SocketChannel sslnio;
        Socket ssl;

        public TcpPiper(Socket tcp, byte[] send) {
            super("SSLTcpPiper");
            this.tcp = tcp;
            this.send = send;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (Switches.SH_XXXX_useNioSelectorsInSsl) {
                    this.sslnio = SocketChannel.open();
                    this.sslnio.connect(new InetSocketAddress("localhost", port));
                    this.origssl = this.ssl = this.sslnio.socket();
                    if (Switches.SH_XXXX_trackAndClearLocalSockets) {
                        SslToTcp.updateTracking(this.tcp);
                        SslToTcp.updateTracking(this.ssl);
                    }
                    if (LOCAL_SOCKET_CREATE_VERBOSE) {
                        System.out.println("[SSLTT] New ssl socket " + this.ssl);
                    }
                    if (!Switches.SH_XXXX_sslNioForwardUsingChannels) {
                        this.ssl = WorkingNioSocket.fixNIO(this.ssl);
                        this.tcp = WorkingNioSocket.fixNIO(this.tcp);
                    }
                } else {
                    this.ssl = new Socket("localhost", port);
                }
                OutputStream sslout = this.ssl.getOutputStream();
                InputStream sslin = this.ssl.getInputStream();
                OutputStream tcpout = this.tcp.getOutputStream();
                InputStream tcpin = this.tcp.getInputStream();
                sslout.write(this.send);
                sslout.flush();
                if (Switches.SH_XXXX_useNioSelectorsInSsl) {
                    Object object = pool_LOCK;
                    synchronized (object) {
                        if (poolHandler == null) {
                            poolHandler = new SslSelectHandler();
                            try {
                                pool = new SelectPool("SslToTcp", poolHandler, Switches.SH_1778_sslToTcpSelectPoolSize);
                                pool.setAutoSetBlocking(false);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                            bpool = new BufferPool(pool.getMaxThreads());
                            bbpool = new ByteBufferPool(pool.getMaxThreads());
                        }
                        if (pool != null) {
                            if (this.ssl.getChannel() == null) {
                                this.ssl = WorkingNioSocket.fixNIO(this.ssl);
                            }
                            if (this.tcp.getChannel() == null) {
                                this.tcp = WorkingNioSocket.fixNIO(this.tcp);
                            }
                            try {
                                this.tcp.getChannel().configureBlocking(false);
                                this.ssl.getChannel().configureBlocking(false);
                                pool.dumpIntoPool(this.ssl, this.tcp);
                                pool.dumpIntoPool(this.tcp, this.ssl);
                            }
                            catch (Exception x) {
                                x.printStackTrace();
                            }
                            return;
                        }
                    }
                }
                this.d1 = new DataTransferer(sslin, tcpout);
                this.d2 = new DataTransferer(tcpin, sslout);
                this.d1.start();
                this.d2.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class TestThread
    extends Thread {
        private TestThread() {
        }

        @Override
        public void run() {
            try {
                Socket ssl = SslToTcp.createSslMappedTcpSocket("localhost", test_port);
                System.out.println("Client was provided with socket: " + ssl);
                OutputStream out = ssl.getOutputStream();
                InputStream in = ssl.getInputStream();
                while (true) {
                    DataUtils.writeString(out, "This is the client side saying YO!");
                    out.flush();
                    System.out.println("Server told me: \"" + DataUtils.readNString(in, 20000) + "\"");
                }
            }
            catch (Exception x) {
                if (!test_loop) {
                    x.printStackTrace();
                } else {
                    System.out.println("Test thread exited (" + x + ")");
                }
                return;
            }
        }
    }

    static class TimeoutHandler
    implements TimeoutMapListener<Socket, Socket> {
        TimeoutHandler() {
        }

        @Override
        public void objectTimedOut(Socket sock, Socket val) {
            try {
                if (LOCAL_SOCKET_CREATE_VERBOSE) {
                    System.out.println("[SSLTT] " + sock + " timed out, closing");
                }
                sock.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

