/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.utils.OpenByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;

public class HistoryBuffer
extends OutputStream {
    Object LOCK = new Object();
    boolean VERBOSE = false;
    LinkedList bouts = new LinkedList();
    OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
    long start = 0L;
    long skip = 0L;

    private void dumpToStdout() {
        System.out.println("HistoryBuffer");
        for (OpenByteArrayOutputStream oot : this.bouts) {
            System.out.println(oot.size() + ", " + oot.getByteArray()[0] + "...");
        }
    }

    private void postWrite() {
        if (this.bout.size() >= 350000) {
            this.bouts.add(this.bout);
            this.bout = new OpenByteArrayOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] dat) {
        Object object = this.LOCK;
        synchronized (object) {
            this.bout.write(dat, 0, dat.length);
            this.postWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(byte[] dat, int off, int len) {
        Object object = this.LOCK;
        synchronized (object) {
            this.bout.write(dat, off, len);
            this.postWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.bout.write(b);
            this.postWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skip(long N) {
        Object object = this.LOCK;
        synchronized (object) {
            this.skip += N;
            boolean checkAgain = true;
            while (checkAgain) {
                OpenByteArrayOutputStream bout;
                checkAgain = false;
                if (this.bouts.size() <= 0 || this.skip <= (long)(bout = (OpenByteArrayOutputStream)this.bouts.getFirst()).size()) continue;
                this.bouts.removeFirst();
                this.skip -= (long)bout.size();
                this.start += (long)bout.size();
                checkAgain = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HistoryInputStream getArrayFrom(long point) {
        Object object = this.LOCK;
        synchronized (object) {
            int begin;
            OpenByteArrayOutputStream oot;
            System.out.println("[HistoryBuffer] Asked to restart from " + point + " (" + this.start + ")");
            LinkedList copy = (LinkedList)this.bouts.clone();
            copy.add(this.bout);
            for (begin = (int)(point - this.start); begin > ((OpenByteArrayOutputStream)copy.getFirst()).size(); begin -= oot.size()) {
                oot = (OpenByteArrayOutputStream)copy.removeFirst();
            }
            HistoryInputStream hin = new HistoryInputStream(copy, point, begin);
            return hin;
        }
    }

    public static void main(String[] args) throws Exception {
        HistoryBuffer hb = new HistoryBuffer();
        for (int i = 0; i < 10; ++i) {
            byte[] dat = new byte[100000];
            Arrays.fill(dat, (byte)i);
            hb.add(dat);
        }
        hb.dumpToStdout();
        System.out.println("Reading from HistoryBuffer...");
        HistoryInputStream in = hb.getArrayFrom(0L);
        int TOT = 0;
        byte[] buf = new byte[99999];
        int N = 0;
        while (N != -1) {
            N = ((InputStream)in).read(buf);
            if (N <= 0) continue;
            System.out.println(TOT + " = " + buf[0]);
            TOT += N;
        }
        System.out.println(TOT + " total bytes read");
        in = hb.getArrayFrom(500000L);
        TOT = 0;
        buf = new byte[99999];
        N = 0;
        while (N != -1) {
            N = ((InputStream)in).read(buf);
            if (N <= 0) continue;
            System.out.println(TOT + " = " + buf[0]);
            TOT += N;
        }
        System.out.println(TOT + " total bytes read");
    }

    public class HistoryInputStream
    extends InputStream {
        LinkedList list;
        long startPoint;
        int begin;

        public HistoryInputStream(LinkedList list, long startPoint, int begin) {
            this.list = list;
            this.startPoint = startPoint;
            this.begin = begin;
        }

        public long getNextReadStartPoint() {
            return this.startPoint;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            if (this.list.size() > 0) {
                OpenByteArrayOutputStream bout = (OpenByteArrayOutputStream)this.list.getFirst();
                byte[] scdat = bout.getByteArray();
                int sclen = bout.size() - this.begin;
                if (HistoryBuffer.this.VERBOSE) {
                    System.out.println("[HB Read] Next block out of " + this.list.size() + " is " + bout.size() + " >>" + this.begin + " <>" + sclen + " " + scdat[0] + "..." + scdat[scdat.length - 1]);
                }
                if (sclen > len) {
                    if (HistoryBuffer.this.VERBOSE) {
                        System.out.println("[HB Read] Buffer is small, " + len + " < " + sclen);
                    }
                    System.arraycopy(scdat, this.begin, buf, off, len);
                    this.begin += len;
                    this.startPoint += (long)len;
                    return len;
                }
                if (HistoryBuffer.this.VERBOSE || sclen == 0) {
                    System.out.println("[HB Read] Buffer is large, " + len + " >= " + sclen);
                }
                if (sclen < 0) {
                    System.exit(0);
                }
                System.arraycopy(scdat, this.begin, buf, off, sclen);
                this.list.removeFirst();
                this.begin = 0;
                this.startPoint += (long)sclen;
                return sclen;
            }
            return -1;
        }

        @Override
        public int read() throws IOException {
            throw new IOException("Unsupported by HistoryBuffer");
        }
    }
}

