/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.utils.BlockingObjectHandler;
import com.aem.nodelink.utils.SafeClock;
import java.io.IOException;
import java.util.LinkedList;

public class BlockingObjectInputStream {
    LinkedList objBuf = new LinkedList();
    Object add_LOCK = new Object();
    Object read_LOCK = new Object();
    Object objs_LOCK = new Object();
    Object objs_Notifier = new Object();
    IOException fatalerror = null;
    Thread owner = null;
    long lastUsed = SafeClock.currentTimeMillis();
    BlockingObjectHandler handler = null;
    static BlockingObjectInputStream test;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockingObjectHandler(BlockingObjectHandler handler) {
        Object object = this.add_LOCK;
        synchronized (object) {
            Object object2 = this.objs_LOCK;
            synchronized (object2) {
                this.handler = handler;
                while (this.objBuf.size() > 0) {
                    Object toProcess = this.objBuf.remove(0);
                    handler.processBlockingObject(toProcess);
                }
            }
            object2 = this.objs_Notifier;
            synchronized (object2) {
                this.objs_Notifier.notify();
            }
        }
    }

    public long getLastUsedSC() {
        return this.lastUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilData() throws InterruptedException {
        Object object = this.objs_Notifier;
        synchronized (object) {
            InfiniteLoop il = new InfiniteLoop();
            while (this.objBuf.size() == 0 && this.fatalerror == null) {
                il.LOOP();
                this.objs_Notifier.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Object object = this.objs_LOCK;
        synchronized (object) {
            for (int i = 0; i < this.objBuf.size(); ++i) {
                if (!o.equals(this.objBuf.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.objs_LOCK;
        synchronized (object) {
            return this.objBuf.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.objs_LOCK;
        synchronized (object) {
            this.objBuf = new LinkedList();
        }
    }

    public boolean hasNext() {
        return this.objBuf.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() throws IOException, InterruptedException {
        Object object = this.read_LOCK;
        synchronized (object) {
            this.waitUntilData();
            if (this.fatalerror != null) {
                throw this.fatalerror;
            }
            if (this.owner != null && this.owner != Thread.currentThread()) {
                throw new IOException("We are no longer the owner of this stream");
            }
            this.lastUsed = SafeClock.currentTimeMillis();
            Object object2 = this.objs_LOCK;
            synchronized (object2) {
                return this.objBuf.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o) {
        Object object = this.add_LOCK;
        synchronized (object) {
            if (this.handler != null) {
                this.handler.processBlockingObject(o);
            } else {
                Object object2 = this.objs_LOCK;
                synchronized (object2) {
                    this.objBuf.add(o);
                }
                object2 = this.objs_Notifier;
                synchronized (object2) {
                    this.objs_Notifier.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Thread me) {
        this.owner = me;
        Object object = this.objs_Notifier;
        synchronized (object) {
            this.objs_Notifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException t) {
        this.fatalerror = t;
        Object object = this.objs_Notifier;
        synchronized (object) {
            this.objs_Notifier.notifyAll();
        }
    }

    public static void main(String[] args) throws Exception {
        test = new BlockingObjectInputStream();
        new TestReader().start();
        new TestReader().start();
        new TestWriter().start();
    }

    static class TestReader
    extends Thread {
        TestReader() {
        }

        @Override
        public void run() {
            try {
                boolean i = false;
                while (true) {
                    int n = (Integer)test.next();
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                return;
            }
        }
    }

    static class TestWriter
    extends Thread {
        TestWriter() {
        }

        @Override
        public void run() {
            for (int i = 0; i < 1000; ++i) {
                test.add(new Integer(i));
            }
            System.out.println("Done");
        }
    }
}

