/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.utils;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.utils.SafeClock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import utils.switches.Switches;

public class BlockingByteInputStreamHashMap {
    private int CHECK_MINS = -1;
    private int TIMEOUT_MINS = -1;
    ArrayList<Object> keepOpen = new ArrayList();
    private long nextCheck = SafeClock.currentTimeMillis() + 10000L;
    private Object sem_LOCK = new Object();
    private int sem_val = 1;
    public HashMap map = new HashMap();

    public void setUseTimeout(int timeout_mins, int check_mins) {
        this.TIMEOUT_MINS = timeout_mins;
        this.CHECK_MINS = check_mins;
    }

    public void keepOpen(Object key) {
        try {
            this.general_LOCK();
            this.keepOpen.add(key);
            this.general_RELEASE();
        }
        catch (Exception x) {
            this.keepOpen.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void general_LOCK() throws InterruptedException {
        Object object = this.sem_LOCK;
        synchronized (object) {
            --this.sem_val;
            if (this.sem_val < 0) {
                try {
                    this.sem_LOCK.wait();
                }
                catch (InterruptedException e) {
                    ++this.sem_val;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void general_RELEASE() {
        Object object = this.sem_LOCK;
        synchronized (object) {
            ++this.sem_val;
            if (this.sem_val > 1) {
                this.sem_val = 1;
            }
            if (this.sem_val <= 0) {
                this.sem_LOCK.notify();
            }
        }
    }

    public ArrayList getDataAsList() throws Exception {
        this.general_LOCK();
        ArrayList stuff = new ArrayList();
        Iterator it = this.map.values().iterator();
        InfiniteLoop il = new InfiniteLoop();
        while (it.hasNext()) {
            il.LOOP();
            ObjLock lock = (ObjLock)it.next();
            stuff.addAll(lock.messages);
        }
        this.general_RELEASE();
        return stuff;
    }

    private void deleteLock(Object key) {
        this.map.remove(key);
    }

    private ObjLock fetchLockFor(Object key) {
        ObjLock notifier;
        if (Switches.SH_1582_blockingByteInputStreamHashMapCleanup) {
            this.doMaintenance();
        }
        if ((notifier = (ObjLock)this.map.get(key)) == null) {
            notifier = new ObjLock();
            notifier.lastUsed = SafeClock.currentTimeMillis();
            this.map.put(key, notifier);
        } else {
            notifier.lastUsed = SafeClock.currentTimeMillis();
        }
        return notifier;
    }

    private void deleteRecipient(ObjRecipient recipient) {
        Object key = recipient.key;
        ObjLock tmp = this.fetchLockFor(key);
        tmp.recipients.remove(recipient);
        if (tmp.isEmpty()) {
            this.deleteLock(key);
        }
    }

    public long getBuffered(String key) throws InterruptedException {
        this.general_LOCK();
        ObjLock notifier = this.fetchLockFor(key);
        long size = notifier.recipients.size() > 0 ? 0L : (long)notifier.messages.size();
        this.general_RELEASE();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long put(String key, Object value) throws InterruptedException {
        this.general_LOCK();
        ObjLock notifier = this.fetchLockFor(key);
        if (notifier.recipients.size() > 0) {
            ObjRecipient recipient;
            ObjRecipient objRecipient = recipient = (ObjRecipient)notifier.recipients.getFirst();
            synchronized (objRecipient) {
                recipient.value = value;
                this.deleteRecipient(recipient);
                this.general_RELEASE();
                recipient.notify();
            }
            return 0L;
        }
        notifier.messages.addLast(value);
        long size = notifier.messages.size();
        this.general_RELEASE();
        return size;
    }

    public void clear(String keys) throws InterruptedException {
        this.general_LOCK();
        ObjLock lock = this.fetchLockFor(keys);
        if (lock.messages.size() > 0) {
            lock.messages.clear();
        }
        this.deleteLock(keys);
        this.general_RELEASE();
    }

    public Object get(String keys) throws InterruptedException {
        return this.get(keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String keys, long timeout) throws InterruptedException {
        ObjRecipient recipient = new ObjRecipient();
        recipient.key = keys;
        recipient.value = null;
        boolean timed_out = false;
        this.general_LOCK();
        ObjLock lock = this.fetchLockFor(keys);
        if (lock.messages.size() > 0) {
            recipient.value = lock.messages.removeFirst();
            if (lock.isEmpty()) {
                this.deleteLock(keys);
            }
        }
        if (recipient.value == null) {
            ObjRecipient objRecipient;
            try {
                objRecipient = recipient;
                synchronized (objRecipient) {
                    lock = this.fetchLockFor(keys);
                    lock.recipients.add(recipient);
                    this.general_RELEASE();
                    recipient.wait(timeout);
                }
            }
            catch (InterruptedException e) {
                this.general_LOCK();
                ObjRecipient objRecipient2 = recipient;
                synchronized (objRecipient2) {
                    this.deleteRecipient(recipient);
                    this.general_RELEASE();
                    throw e;
                }
            }
            this.general_LOCK();
            objRecipient = recipient;
            synchronized (objRecipient) {
                if (recipient.value == null) {
                    timed_out = true;
                    this.deleteRecipient(recipient);
                }
            }
            this.general_RELEASE();
        } else {
            this.general_RELEASE();
        }
        if (timed_out) {
            throw new InterruptedException("Timed out (" + timeout + "ms)");
        }
        return recipient.value;
    }

    private void doMaintenance() {
        if (this.CHECK_MINS == -1) {
            return;
        }
        try {
            long Tsafe = SafeClock.currentTimeMillis();
            if (Tsafe > this.nextCheck) {
                this.nextCheck = Tsafe + (long)(this.CHECK_MINS * 60000);
                Object[] objs = this.map.keySet().toArray();
                if (Switches.SH_1582_blockingByteInputStreamHashMapCleanupDebugging) {
                    System.out.println("[NodeBBIN] " + objs.length + " total entries");
                }
                for (Object key : objs) {
                    ObjLock lock = (ObjLock)this.map.get(key);
                    if (lock == null) continue;
                    if (Switches.SH_1582_blockingByteInputStreamHashMapCleanupDebugging) {
                        System.out.println("[NodeBBIN] Listed: " + key + " - " + lock.recipients.size() + " recs, " + lock.messages.size() + " msgs, used: " + (Tsafe - lock.lastUsed) + "ms");
                    }
                    if (Tsafe - lock.lastUsed <= (long)(this.TIMEOUT_MINS * 60000)) continue;
                    boolean ignore = false;
                    for (Object keep : this.keepOpen) {
                        if (keep == null || key == null || !keep.equals(key)) continue;
                        ignore = true;
                    }
                    if (!ignore) {
                        this.map.remove(key);
                        if (Switches.SH_1582_blockingByteInputStreamHashMapCleanupDebugging) {
                            System.out.println("[NodeBBIN] Cleared BBIN " + key + " (" + lock.messages.size() + " msg)");
                        }
                        lock.messages.clear();
                        lock.recipients.clear();
                        continue;
                    }
                    if (!Switches.SH_1582_blockingByteInputStreamHashMapCleanupDebugging) continue;
                    System.out.println("[NodeBBIN] Ignoring permanent BBIN " + key + " (" + lock.messages.size() + " msg)");
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    class ObjLock {
        long lastUsed;
        LinkedList messages = new LinkedList();
        LinkedList recipients = new LinkedList();

        ObjLock() {
        }

        public boolean isEmpty() {
            return this.messages.size() == 0 && this.recipients.size() == 0;
        }
    }

    class ObjRecipient {
        Object key;
        Object value;

        ObjRecipient() {
        }
    }
}

