/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.udp;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.Transport;
import com.aem.nodelink.udp.UdpEndpoint;
import com.aem.nodelink.udp.UdpPacketHandler;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;

public class UdpTransport
implements Transport {
    public static boolean VERBOSE_PACKET_RATE = false;
    private static final boolean VERBOSE = false;
    public static boolean VERBOSE_LIVENESS = false;
    public static boolean VERBOSE_EVERY_PACKET_SENT = false;
    public static boolean VERBOSE_UDP_PACKET_TIMING = false;
    public static boolean VERBOSE_EVERY_PACKET_RECEIVED = false;
    private static final int MAGIC_NODELINK = 1313098827;
    private static final int MAGIC_REESTABLISH = 0x55CB55CB;
    public static long VERBOSE_LIVENESS_PRINT_FREQ = 0L;
    public static boolean DISCARD_PACKET_ON_EXCEPTION = true;
    private static boolean FAIL_ON_NO_DATA = false;
    private static long FAIL_ON_NO_DATA_TIMEOUT = Long.MAX_VALUE;
    public static final int UDP_FORWARD = 55430004;
    public static InetAddress HACK_SEND_TO_IP = null;
    public static int HACK_SEND_TO_PORT = -1;
    Node mynode;
    long udpConnectTimeout;
    private long lastReceivedData = 0L;
    Object socks_LOCK = new Object();
    HashMap socks = new HashMap();
    long nextWritePrint = 0L;
    int waitCount = 0;
    int falloffReset;
    int falloff = this.falloffReset = 100;
    static InetAddress oneLanIP;
    static Object oneLanIP_LOCK;
    boolean dropAll = false;
    boolean importedFromOtherUDP = false;
    long lastRateSent = 0L;
    long lastPacketsSent = 0L;
    long lastDroppedSent = 0L;
    HashMap accepters = new HashMap();
    Cache fromAddresses = new Cache("UdpTransport", 1000);
    DatagramSocket notouch;
    Transport fwdTransport;
    Node fwdNode;
    Endpoint fwdEndpoint;

    @Override
    public String getHumanReadableTransportIdentifierFor(Node target) throws Exception {
        InetAddress addr = (InetAddress)this.fromAddresses.getFromCache(target.toString());
        if (addr == null) {
            return "127.0.0.1";
        }
        return "" + addr;
    }

    public static void setFailOnNoDataTimeout(long ms) {
        UdpTransport.setFailOnNoDataTimeout(ms, NodeLink.KEEPALIVE_WRITE_EVERY);
    }

    public static void setFailOnNoDataTimeout(long ms, int nodeLinkKeepaliveEvery) {
        NodeLink.KEEPALIVE_WRITE_EVERY = nodeLinkKeepaliveEvery;
        FAIL_ON_NO_DATA_TIMEOUT = ms;
        FAIL_ON_NO_DATA = true;
    }

    public UdpTransport(Node selfnode, long udpConnectTimeout) {
        this.mynode = selfnode;
        this.udpConnectTimeout = udpConnectTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InetAddress getOneLanIP() throws IOException {
        Object object = oneLanIP_LOCK;
        synchronized (object) {
            if (oneLanIP == null) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface ni = en.nextElement();
                    Enumeration<InetAddress> ips = ni.getInetAddresses();
                    while (ips.hasMoreElements()) {
                        InetAddress addr = ips.nextElement();
                        if (addr.getAddress().length != 4) continue;
                        oneLanIP = addr;
                        return addr;
                    }
                }
            }
        }
        throw new IOException("No LAN IPs found");
    }

    private static DatagramSocket getDatagramSocket(Node target, int port) throws IOException {
        DatagramSocket ds;
        try {
            ds = new DatagramSocket(port);
        }
        catch (BindException x) {
            ds = new DatagramSocket(port, UdpTransport.getOneLanIP());
        }
        System.out.println("[UdpTransport] created UDP socket " + ds + " on " + ds.getLocalPort() + " to reach " + target);
        return ds;
    }

    @Override
    public void dropAllPackets() {
        this.dropAll = true;
    }

    @Override
    public void stopDroppingAllPackets() {
        this.dropAll = false;
    }

    @Override
    public void setMyNode(Node node, Endpoint ep) {
        this.mynode = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapTargetsWith(Node myTarget, Transport fromTransport, Endpoint fromEndpoint, Node fromTarget) {
        System.out.println("[UDPTransport] Swapping transport targets with " + fromTransport.getClass().getName());
        System.out.println("[UDPTransport] My target is " + myTarget);
        System.out.println("[UDPTransport] Other target is " + fromTarget);
        if (fromTransport instanceof UdpTransport) {
            UdpTransport udp = (UdpTransport)fromTransport;
            Object object = this.socks_LOCK;
            synchronized (object) {
                Object object2 = udp.socks_LOCK;
                synchronized (object2) {
                    UdpEndpoint ue = (UdpEndpoint)fromEndpoint;
                    boolean directUDP = ue.hasForwardingID();
                    if (directUDP) {
                        DatagramSocket fromDS = (DatagramSocket)udp.socks.get(fromTarget.getUID());
                        DatagramSocket myDS = (DatagramSocket)this.socks.get(myTarget.getUID());
                        System.out.println("[UDPTransport] Imported DSocket from shell " + fromDS.getLocalPort());
                        System.out.println("[UDPTransport] Pushed back DSocket into shell " + myDS.getLocalPort());
                        udp.socks.put(fromTarget.getUID(), myDS);
                        this.socks.put(myTarget.getUID(), fromDS);
                        this.notouch = fromDS;
                        udp.notouch = myDS;
                        this.importedFromOtherUDP = true;
                        udp.importedFromOtherUDP = true;
                    } else {
                        this.importedFromOtherUDP = false;
                        udp.importedFromOtherUDP = false;
                    }
                }
            }
        }
    }

    @Override
    public void sendPacketTo(Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        this.sendPacketTo(this.mynode, target, ep, data, rarelyVerifyLiveness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacketTo(Node sentFrom, Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        DatagramPacket dp;
        long T;
        if (VERBOSE_UDP_PACKET_TIMING) {
            System.out.println("[UdpTransport] Asked to send packet " + data.length);
        }
        if (this.dropAll) {
            ++this.lastDroppedSent;
        } else {
            ++this.lastPacketsSent;
        }
        if (VERBOSE_PACKET_RATE && (T = SafeClock.currentTimeMillis()) > this.lastRateSent) {
            System.out.println("[UDPTransport] Packets Sent = " + this.lastPacketsSent + "/sec, Dropped = " + this.lastDroppedSent + "/sec");
            this.lastPacketsSent = 0L;
            this.lastDroppedSent = 0L;
            this.lastRateSent = T + 1000L;
        }
        if (this.dropAll) {
            return;
        }
        UdpEndpoint et = (UdpEndpoint)ep;
        if (SafeClock.currentTimeMillis() < et.discardAllUntil) {
            return;
        }
        DatagramSocket sock = null;
        Object object = this.socks_LOCK;
        synchronized (object) {
            sock = (DatagramSocket)this.socks.get(target.getUID());
            if (sock == null) {
                if (et.useSock != null) {
                    sock = et.useSock;
                    System.out.println("[UdpTransport] using existing dsocket on local port " + et.useSock.getLocalPort() + " expect ensureAcceptingOn has been called already");
                    this.socks.put(target.getUID(), sock);
                } else {
                    if (et.lport != -1) {
                        System.out.println("[UdpTransport] creating new dsocket on local port " + et.lport);
                        sock = UdpTransport.getDatagramSocket(target, et.lport);
                    } else {
                        sock = UdpTransport.getDatagramSocket(target, 0);
                    }
                    this.socks.put(target.getUID(), sock);
                    PacketReader pr = new PacketReader(sock, et, true);
                    if (FAIL_ON_NO_DATA) {
                        this.lastReceivedData = System.currentTimeMillis();
                    }
                    pr.start();
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (FAIL_ON_NO_DATA && SafeClock.currentTimeMillis() - this.lastReceivedData > FAIL_ON_NO_DATA_TIMEOUT) {
            out.reset();
            if (et.forwardingID != 0) {
                DataUtils.writeInt(out, 55430004);
                DataUtils.writeShort(out, et.forwardingID);
            }
            DataUtils.writeInt(out, 0x55CB55CB);
            dp = new DatagramPacket(out.toByteArray(), out.size());
            if (HACK_SEND_TO_IP != null) {
                dp.setAddress(HACK_SEND_TO_IP);
                dp.setPort(HACK_SEND_TO_PORT);
            } else {
                dp.setAddress(et.inetaddr);
                dp.setPort(et.port);
            }
            while (SafeClock.currentTimeMillis() - this.lastReceivedData > FAIL_ON_NO_DATA_TIMEOUT) {
                sock.send(dp);
                Thread.sleep(250L);
                if (SafeClock.currentTimeMillis() - this.lastReceivedData <= 60000L) continue;
                throw new Exception("Unable to reestablish");
            }
            Thread.sleep(250L);
            sock.send(dp);
            Thread.sleep(250L);
            sock.send(dp);
            Thread.sleep(250L);
            sock.send(dp);
            Thread.sleep(250L);
            sock.send(dp);
            Thread.sleep(50L);
        }
        out.reset();
        if (et.forwardingID != 0) {
            DataUtils.writeInt(out, 55430004);
            DataUtils.writeShort(out, et.forwardingID);
        }
        DataUtils.writeInt(out, 1313098827);
        DataUtils.writeString(out, sentFrom.getUID());
        DataUtils.writeBytes(out, data);
        dp = new DatagramPacket(out.toByteArray(), out.size());
        if (HACK_SEND_TO_IP != null) {
            dp.setAddress(HACK_SEND_TO_IP);
            dp.setPort(HACK_SEND_TO_PORT);
        } else {
            dp.setAddress(et.inetaddr);
            dp.setPort(et.port);
        }
        if (dp.getLength() > 512) {
            System.err.println("***WARNING Datagram Packet length is " + dp.getLength() + " overhead " + (dp.getLength() - data.length));
        }
        boolean sent = false;
        boolean failed = false;
        while (!sent) {
            try {
                if (VERBOSE_UDP_PACKET_TIMING) {
                    System.out.println("[UdpTransport] Sending through socket");
                }
                sock.send(dp);
                sent = true;
                if (VERBOSE_EVERY_PACKET_SENT || VERBOSE_UDP_PACKET_TIMING) {
                    System.out.println("[UDP Transport] ^" + sock.getPort() + " @" + dp.getAddress() + ":" + dp.getPort() + "  >>" + dp.getLength() + " (fid " + et.forwardingID + ")");
                }
                if (VERBOSE_LIVENESS && SafeClock.currentTimeMillis() >= this.nextWritePrint) {
                    System.out.println("*** UDP packets going OUT from ^" + sock.getPort() + " to " + dp.getAddress() + ":" + dp.getPort());
                    this.nextWritePrint = SafeClock.currentTimeMillis() + VERBOSE_LIVENESS_PRINT_FREQ;
                }
                if (failed) continue;
                this.falloff = this.falloffReset;
            }
            catch (Exception x) {
                if (VERBOSE_EVERY_PACKET_SENT) {
                    if (sock == null) {
                        System.out.println("[UDP Transport] ^" + sock + " @" + dp.getAddress() + ":" + dp.getPort() + "  >>" + dp.getLength() + " (fid " + et.forwardingID + ") *** Failed to send: " + x);
                    } else {
                        System.out.println("[UDP Transport] ^" + sock.getPort() + " @" + dp.getAddress() + ":" + dp.getPort() + "  >>" + dp.getLength() + " (fid " + et.forwardingID + ") *** Failed to send: " + x);
                    }
                }
                if (DISCARD_PACKET_ON_EXCEPTION) {
                    if (failed) {
                        System.err.println(x + " (will discard for " + this.falloff + ")");
                        et.discardAllUntil = SafeClock.currentTimeMillis() + (long)this.falloff;
                        this.falloff *= 2;
                    }
                    failed = true;
                    return;
                }
                failed = true;
                System.err.println(x + " (will wait for " + this.falloff + ")");
                try {
                    Thread.sleep(this.falloff);
                    this.falloff *= 2;
                }
                catch (Exception exception) {}
            }
        }
        if (failed) {
            System.err.println("Able to send OK again...");
        }
    }

    @Override
    public void ensureAcceptingOn(Endpoint ee) throws Exception {
        UdpEndpoint e = (UdpEndpoint)ee;
        e.setIsServerEndpoint(true);
        Accepter accepter = new Accepter(e);
        this.accepters.put(e.toString(), accepter);
    }

    public void stopAcceptingOn(Endpoint ee) throws Exception {
        UdpEndpoint e = (UdpEndpoint)ee;
        Accepter accepter = (Accepter)this.accepters.get(e.toString());
        if (accepter != null) {
            accepter.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnections() throws Exception {
        Object object = this.socks_LOCK;
        synchronized (object) {
            try {
                Object[] all = this.socks.values().toArray();
                System.out.println("[UDPTransport] cleaning up " + all.length + " sockets");
                for (int i = 0; i < all.length; ++i) {
                    try {
                        if (all[i] != this.notouch) {
                            System.out.println("[UDPTransport] closing " + all[i]);
                            ((DatagramSocket)all[i]).close();
                            continue;
                        }
                        System.out.println("[UDPTransport] Leaving " + all[i]);
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnectionsTo(Node target) throws Exception {
        Object object = this.socks_LOCK;
        synchronized (object) {
            try {
                ((DatagramSocket)this.socks.get(target.getUID())).close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void forwardAllPacketsTo(Transport transport, Node target, Endpoint ep) throws Exception {
        this.fwdEndpoint = ep;
        this.fwdNode = target;
        this.fwdTransport = transport;
    }

    public boolean areForwarding() {
        return this.fwdTransport != null;
    }

    @Override
    public void copyTransportData(Node currentTarget, Node newTarget, Endpoint myEndpoint) {
        UdpEndpoint ue = (UdpEndpoint)myEndpoint;
        if (ue.hasForwardingID()) {
            if (!this.importedFromOtherUDP) {
                System.out.println("[UDPTransport] Proxied UDP - copying DSocket from current target " + currentTarget + " to new target " + newTarget);
                DatagramSocket myDS = (DatagramSocket)this.socks.get(currentTarget.getUID());
                this.socks.put(newTarget.getUID(), myDS);
            } else {
                System.out.println("[UDPTransport] Proxied UDP but socket already imported from other UDP transport");
            }
        } else {
            System.out.println("[UDPTransport] Direct UDP - not copying DSocket from current target " + currentTarget + " to new target " + newTarget);
        }
    }

    @Override
    public boolean isProxiedConnection(Endpoint ep) {
        UdpEndpoint ue = (UdpEndpoint)ep;
        return ((UdpEndpoint)ep).hasForwardingID();
    }

    static {
        oneLanIP_LOCK = new Object();
    }

    class Accepter
    extends Thread {
        UdpEndpoint e;
        DatagramSocket ssock;
        PacketReader pr;

        private void shutdown() {
            this.pr.die = true;
            try {
                this.ssock.close();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }

        public Accepter() throws Exception {
            this.setName("UdpTransport$Accepter");
        }

        public Accepter(UdpEndpoint e) throws Exception {
            this.e = e;
            this.setName("UdpTransport$Accepter");
            this.setDaemon(true);
            if (Robustness.ALL_UDP_BINDS_FAIL) {
                throw new Exception("Robustness forcing all UDP binds to fail");
            }
            this.ssock = e.useSock != null ? e.useSock : (e.bindIp != null ? new DatagramSocket(e.port, InetAddress.getByName(e.bindIp)) : UdpTransport.getDatagramSocket(null, e.port));
            this.start();
        }

        @Override
        public void run() {
            this.pr = new PacketReader(this.ssock, this.e, true);
            if (FAIL_ON_NO_DATA) {
                UdpTransport.this.lastReceivedData = SafeClock.currentTimeMillis();
            }
            this.pr.start();
        }
    }

    class DatagramAddress {
        InetAddress address;
        int port;

        public DatagramAddress(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }
    }

    class PacketReader
    extends Thread {
        DatagramSocket sock;
        UdpEndpoint e;
        boolean storeIncoming;
        boolean die = false;
        HashMap havestored = new HashMap();
        String lastsaw = "";
        long lastRateReceived = 0L;
        long lastPacketsReceived = 0L;
        long lastDroppedReceived = 0L;

        public PacketReader(DatagramSocket sock, UdpEndpoint e, boolean storeIncoming) {
            this.setName("UdpTransport$PacketReader");
            this.sock = sock;
            this.e = e;
            this.storeIncoming = storeIncoming;
            this.setDaemon(true);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextReadPrint = 0L;
            try {
                byte[] buf = new byte[NodeLink.DEFAULT_MAX_DATA_PER_WRITE * 2];
                ByteArrayInputStream bin = new ByteArrayInputStream(buf);
                while (!this.die) {
                    long T;
                    DatagramPacket packet = new DatagramPacket(buf, buf.length);
                    this.sock.receive(packet);
                    if (VERBOSE_EVERY_PACKET_RECEIVED) {
                        System.out.println("[UDP Transport] ^" + this.sock.getPort() + " @" + packet.getAddress() + ":" + packet.getPort() + "  <<" + packet.getLength());
                    }
                    if (UdpTransport.this.dropAll) {
                        ++this.lastDroppedReceived;
                    } else {
                        ++this.lastPacketsReceived;
                    }
                    if (VERBOSE_PACKET_RATE && (T = SafeClock.currentTimeMillis()) > this.lastRateReceived) {
                        System.out.println("[UDPTransport] Packets Received = " + this.lastPacketsReceived + "/sec, Dropped = " + this.lastDroppedReceived + "/sec");
                        this.lastPacketsReceived = 0L;
                        this.lastDroppedReceived = 0L;
                        this.lastRateReceived = T + 1000L;
                    }
                    if (UdpTransport.this.dropAll) continue;
                    String fromnode = null;
                    try {
                        if (VERBOSE_LIVENESS && SafeClock.currentTimeMillis() >= nextReadPrint) {
                            System.out.println("*** UDP packets coming IN to ^" + this.sock.getPort() + " from " + packet.getSocketAddress());
                            nextReadPrint = SafeClock.currentTimeMillis() + VERBOSE_LIVENESS_PRINT_FREQ;
                        }
                        bin.reset();
                        int magic = DataUtils.readInt(bin);
                        if (magic == 0x55CB55CB) {
                            if (!FAIL_ON_NO_DATA) continue;
                            System.out.println("DELETEME REESTABLISH RECEIVED");
                            UdpTransport.this.lastReceivedData = SafeClock.currentTimeMillis();
                            continue;
                        }
                        if (magic != 1313098827) {
                            UdpPacketHandler alt = this.e.getAlternateSocketHandler();
                            if (alt != null) {
                                alt.incomingPacket(this.sock, packet);
                                continue;
                            }
                            System.out.println("Unrecognised packet (" + magic + ") with no alternate handler");
                            continue;
                        }
                        fromnode = DataUtils.readNString(bin, 100000);
                        UdpTransport.this.fromAddresses.addToCache(fromnode, packet.getAddress());
                        byte[] dat = DataUtils.readNBytes(bin, 10000000);
                        if (this.storeIncoming && !this.lastsaw.equals(fromnode) && !this.havestored.containsKey(fromnode)) {
                            if (FAIL_ON_NO_DATA) {
                                UdpTransport.this.lastReceivedData = SafeClock.currentTimeMillis();
                            }
                            UdpEndpoint ue = new UdpEndpoint(packet.getAddress(), packet.getPort());
                            if (this.e.useSock != null) {
                                ue.setExistingDatagramSocket(this.e.useSock);
                            }
                            if (this.e.hasForwardingID()) {
                                ue.setForwardingID(this.e.forwardingID);
                            }
                            UdpTransport.this.mynode.setRemoteNodeAddress(new Node(fromnode), ue, UdpTransport.this);
                            Object object = UdpTransport.this.socks_LOCK;
                            synchronized (object) {
                                UdpTransport.this.socks.put(fromnode, this.sock);
                            }
                            this.havestored.put(fromnode, fromnode);
                            this.lastsaw = fromnode;
                        }
                        if (FAIL_ON_NO_DATA) {
                            UdpTransport.this.lastReceivedData = SafeClock.currentTimeMillis();
                        }
                        if (UdpTransport.this.areForwarding()) {
                            UdpTransport.this.fwdTransport.sendPacketTo(UdpTransport.this.fwdNode, UdpTransport.this.fwdEndpoint, dat, false);
                            continue;
                        }
                        UdpTransport.this.mynode.processPacket(dat, fromnode);
                    }
                    catch (Exception e) {
                        System.out.println("ERROR interpreting packet length " + packet.getLength() + " from " + fromnode);
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

