/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.Endpoint;
import com.aem.nodelink.Node;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.Transport;
import com.aem.nodelink.http.HttpEndpoint;
import com.aem.nodelink.http.extend.HttpRequestPoster;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.utils.Cache;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SslToTcp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class OldHttpTransport
implements Transport,
HttpRequestProcessor {
    static boolean DEBUG = false;
    static boolean VERBOSE = false;
    public static int POLLER_COUNT = 2;
    boolean dead = false;
    HttpEndpoint server;
    Node mynode;
    Node alsoFetch;
    Object pollers_LOCK = new Object();
    HashMap pollers = new HashMap();
    Object responses_LOCK = new Object();
    HashMap responses = new HashMap();
    InetAddress from;
    Cache fromAddresses = new Cache("HttpTransport", 1000);
    boolean dropAll = false;
    Transport fwdTransport;
    Node fwdNode;
    Endpoint fwdEndpoint;

    @Override
    public String getHumanReadableTransportIdentifierFor(Node target) throws Exception {
        InetAddress addr = (InetAddress)this.fromAddresses.getFromCache(target.toString());
        if (addr == null) {
            return "127.0.0.1";
        }
        return addr.getHostAddress();
    }

    public OldHttpTransport(Node node) {
        this.mynode = node;
    }

    @Override
    public void ensureAcceptingOn(Endpoint ee) throws Exception {
        HttpEndpoint e = (HttpEndpoint)ee;
        this.server = new HttpEndpoint(new URL("http://SERVER/"));
        if (Robustness.ALL_HTTP_BINDS_FAIL) {
            throw new Exception("Robustness forcing all HTTP binds (server creates) to fail");
        }
        e.factory.redirectUrlRequests(e.url, this);
    }

    @Override
    public void sendPacketTo(Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        this.sendPacketTo(this.mynode, target, ep, data, rarelyVerifyLiveness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPacketTo(Node sentFrom, Node target, Endpoint ep, byte[] data, boolean rarelyVerifyLiveness) throws Exception {
        if (this.dropAll) {
            return;
        }
        if (ep == this.server) {
            Object object = this.responses_LOCK;
            synchronized (object) {
                ArrayList list = (ArrayList)this.responses.get(target.toString());
                if (list != null) {
                    list.add(sentFrom);
                    list.add(data);
                    return;
                }
            }
        }
        HttpEndpoint e = (HttpEndpoint)ep;
        this.makeHttpRequest(sentFrom, e, data, target, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeHttpRequest(Node sentFrom, HttpEndpoint e, byte[] outgoing, Node target, boolean mayBlock) throws Exception {
        if (DEBUG) {
            System.out.println(System.currentTimeMillis() + ": " + mayBlock + " IN>>>");
        }
        if (this.dead) {
            return false;
        }
        HttpRequestPoster poster = e.cfactory.newClient();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataUtils.writeString(bout, sentFrom.getUID());
        if (this.alsoFetch == null) {
            DataUtils.writeString(bout, sentFrom.getUID());
        } else {
            DataUtils.writeString(bout, this.alsoFetch.getUID());
        }
        DataUtils.writeBytes(bout, outgoing);
        DataUtils.writeBoolean(bout, mayBlock);
        try {
            int i;
            if (Robustness.ALL_HTTP_CONNECTIONS_FAIL) {
                throw new Exception("Robustness forcing all HTTP connects (queries) to fail");
            }
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " IN>>> >>>>");
            }
            byte[] ret = poster.doPost(e.url, bout.toByteArray());
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " OT<<< <<<<");
            }
            if (DEBUG) {
                System.out.println("Transfer (" + mayBlock + ") \t\t" + bout.size() + "\t\t" + ret.length);
            }
            Object object = this.pollers_LOCK;
            synchronized (object) {
                Poller[] poller = (Poller[])this.pollers.get(e.toString());
                if (poller == null && !this.dead) {
                    poller = new Poller[POLLER_COUNT];
                    for (i = 0; i < poller.length; ++i) {
                        poller[i] = new Poller(e, target);
                        poller[i].start();
                    }
                    this.pollers.put(e.toString(), poller);
                }
            }
            ByteArrayInputStream in = new ByteArrayInputStream(ret);
            int packets = DataUtils.readInt(in);
            for (i = 0; i < packets; i += 2) {
                String sendingNode = DataUtils.readNStringUTF8(in, 10000);
                this.mynode.setRemoteNodeAddress(new Node(sendingNode), e, this);
                byte[] rdat = DataUtils.readNBytes(in, 10000000);
                if (this.dropAll) continue;
                if (this.areForwarding()) {
                    this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, rdat, false);
                    continue;
                }
                this.mynode.processPacket(rdat, target.toString());
            }
            if (DEBUG) {
                System.out.println(System.currentTimeMillis() + ": " + mayBlock + " OT<<<");
            }
            try {
                poster.close();
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
            return packets > 0;
        }
        catch (Exception x) {
            try {
                poster.close();
            }
            catch (Exception xx) {
                xx.printStackTrace();
            }
            throw x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] processHttpRequest(byte[] incoming, boolean isSslConnection, InetAddress fromAddr) throws Exception {
        byte[] toret;
        block29: {
            block30: {
                if (SslToTcp.ACCEPT_ONLY_SSL_CONNECTIONS && !isSslConnection) {
                    throw new Exception("Refusing non-SSL session connections");
                }
                if (DEBUG) {
                    System.out.println(System.currentTimeMillis() + ": \t\tSERVER >>>");
                }
                ByteArrayInputStream bin = new ByteArrayInputStream(incoming);
                String fromnode = DataUtils.readNString(bin, 100000);
                String fetchnode = DataUtils.readNString(bin, 10000);
                this.fromAddresses.addToCache(fromnode, fromAddr);
                this.mynode.setRemoteNodeAddress(new Node(fromnode), this.server, this);
                byte[] dat = DataUtils.readNBytes(bin, 10000000);
                boolean mayBlock = false;
                try {
                    mayBlock = DataUtils.readBoolean(bin);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (DEBUG) {
                    System.out.println(System.currentTimeMillis() + ": \t\tSERVER RESP >>>");
                }
                Object object = this.responses_LOCK;
                synchronized (object) {
                    ArrayList list = (ArrayList)this.responses.get(fromnode);
                    if (list == null) {
                        list = new ArrayList();
                        this.responses.put(fromnode, list);
                    }
                    if ((list = (ArrayList)this.responses.get(fetchnode)) == null) {
                        list = new ArrayList();
                        this.responses.put(fetchnode, list);
                    }
                }
                if (DEBUG) {
                    System.out.println(System.currentTimeMillis() + ": \t\tSERVER RESP <<<");
                }
                if (dat.length > 0 && !this.dropAll) {
                    if (this.areForwarding()) {
                        this.fwdTransport.sendPacketTo(this.fwdNode, this.fwdEndpoint, dat, false);
                    } else {
                        this.mynode.processPacket(dat, fromnode);
                    }
                }
                if (DEBUG) {
                    System.out.println(System.currentTimeMillis() + ": \t\tSERVER LOOP>>>");
                }
                long mustRespondBy = System.currentTimeMillis() + 2000L;
                while (true) {
                    ArrayList list;
                    ArrayList biglist = new ArrayList();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    Object object2 = this.responses_LOCK;
                    synchronized (object2) {
                        list = (ArrayList)this.responses.get(fromnode);
                        this.responses.put(fromnode, new ArrayList());
                    }
                    biglist.addAll(list);
                    object2 = this.responses_LOCK;
                    synchronized (object2) {
                        list = (ArrayList)this.responses.get(fetchnode);
                        this.responses.put(fetchnode, new ArrayList());
                    }
                    biglist.addAll(list);
                    DataUtils.writeInt(bout, biglist.size());
                    for (int i = 0; i < biglist.size(); i += 2) {
                        Node node = (Node)biglist.get(i);
                        DataUtils.writeStringUTF8(bout, node.getUID());
                        byte[] rdat = (byte[])biglist.get(i + 1);
                        DataUtils.writeBytes(bout, rdat);
                    }
                    toret = bout.toByteArray();
                    if (!mayBlock) break block29;
                    if (DEBUG) {
                        System.out.println("We can block...");
                    }
                    if (biglist.size() != 0) break block30;
                    if (DEBUG) {
                        System.out.println("No data going out...");
                    }
                    if (System.currentTimeMillis() >= mustRespondBy) break;
                    try {
                        if (DEBUG) {
                            System.out.println("Just going to wait...");
                        }
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {}
                }
                if (DEBUG) {
                    System.out.println("I have to respond now...");
                }
                return toret;
            }
            return toret;
        }
        return toret;
    }

    @Override
    public Object getLockObject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupAllConnections() throws Exception {
        System.out.println("[HttpTransport] Cleaning up all connections");
        this.dead = true;
        Object object = this.pollers_LOCK;
        synchronized (object) {
            System.out.println("[HttpTransport] Trying to shut down threads");
            Object[] arrays = this.pollers.values().toArray();
            for (int i = 0; i < arrays.length; ++i) {
                Poller[] tmp = (Poller[])arrays[i];
                for (int k = 0; k < tmp.length; ++k) {
                    tmp[k].join();
                }
                System.out.println("[HttpTransport] Joined " + (1 + i) + " of " + arrays.length);
            }
        }
    }

    @Override
    public void cleanupAllConnectionsTo(Node target) throws Exception {
        this.cleanupAllConnections();
    }

    @Override
    public void setMyNode(Node node, Endpoint e) {
        System.out.println("[HttpTransport] My Node set to " + this.mynode + " from " + node);
        this.mynode = node;
    }

    public void addFetchTarget(Node node) {
        System.out.println("[HttpTransport] Also fetching packets for node " + node);
        this.alsoFetch = node;
    }

    @Override
    public void dropAllPackets() {
        this.dropAll = true;
    }

    @Override
    public void stopDroppingAllPackets() {
        this.dropAll = false;
    }

    @Override
    public void swapTargetsWith(Node myTarget, Transport fromTransport, Endpoint fromEndpoint, Node fromTarget) {
    }

    @Override
    public void forwardAllPacketsTo(Transport transport, Node target, Endpoint ep) throws Exception {
        this.fwdEndpoint = ep;
        this.fwdNode = target;
        this.fwdTransport = transport;
    }

    @Override
    public boolean isProxiedConnection(Endpoint ep) {
        return false;
    }

    public boolean areForwarding() {
        return this.fwdTransport != null;
    }

    @Override
    public void copyTransportData(Node currentTarget, Node newTarget, Endpoint myEp) {
    }

    @Override
    public void processHttpRequest(Socket sock, InputStream in, OutputStream out, boolean sslConnection, InetAddress from) throws Exception {
    }

    @Override
    public boolean isStreamProcessor() {
        return false;
    }

    @Override
    public int getStreamContentLength() {
        return 0;
    }

    class Poller
    extends Thread {
        HttpEndpoint e;
        Node target;
        Node orig;
        byte[] empty = new byte[0];

        public Poller(HttpEndpoint e, Node target) {
            this.setName("HttpTransport$Poller");
            this.e = e;
            this.target = target;
            this.orig = target;
            this.setPriority(10);
            this.setDaemon(true);
            System.out.println("[HttpTransport] Poller created for " + target + " (" + e + ") (httpT=" + OldHttpTransport.this.hashCode() + ")");
        }

        @Override
        public void run() {
            int errors = 0;
            boolean wasted = false;
            while (!OldHttpTransport.this.dead) {
                try {
                    if (VERBOSE) {
                        System.out.println("Poller about to make HTTP request");
                    }
                    OldHttpTransport.this.makeHttpRequest(OldHttpTransport.this.mynode, this.e, this.empty, this.target, true);
                    errors = 0;
                    if (!VERBOSE) continue;
                    System.out.println("Poller OK");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (VERBOSE) {
                        t.printStackTrace();
                    }
                    if (errors < 7) {
                        ++errors;
                    }
                    try {
                        if (VERBOSE) {
                            System.out.println("Poller sleeping for " + errors + "secs");
                        }
                        Thread.sleep(errors * 1000);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

