/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.fec;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.fec.ReedSolomon;
import com.aem.nodelink.fec.ShardDataTooLongException;
import com.aem.nodelink.utils.ByteArrayUtils;
import com.aem.nodelink.utils.SafeClock;
import java.util.ArrayList;
import utils.switches.Switches;

public class ParityWriter {
    static int SHARDLEN = NodeLink.DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE + 20;
    int DATA_SHARDS = 55;
    int PARITY_SHARDS = 20;
    static Object cloneable_LOCK = new Object();
    static int cloneableRsData = -1;
    static int cloneableRsParity = -1;
    static ReedSolomon cloneableReedSolomon = null;
    ReedSolomon reedSolomon = null;
    ArrayList<byte[]> list = new ArrayList();
    long pgstart = 0L;
    long pgend = 0L;
    long pgStartTime = SafeClock.currentTimeMillis();
    short pgid = 1;
    ArrayList<byte[]> parity = new ArrayList();

    public int getMinPacketsToRetain() {
        return this.DATA_SHARDS * 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReedSolomon getReedSolomon(int data, int parity) {
        if (Switches.SH_xxxx_nlCloneReedSolomon) {
            Object object = cloneable_LOCK;
            synchronized (object) {
                if (data != cloneableRsData || parity != cloneableRsParity) {
                    cloneableReedSolomon = ReedSolomon.create(data, parity);
                    cloneableRsData = data;
                    cloneableRsParity = parity;
                }
                return ReedSolomon.createClone(cloneableReedSolomon);
            }
        }
        return ReedSolomon.create(data, parity);
    }

    private void reset() {
        this.pgStartTime = SafeClock.currentTimeMillis();
        this.pgstart = 0L;
        this.pgend = 0L;
        this.list.clear();
        this.pgid = (short)(this.pgid + 1);
        if (this.pgid == 255) {
            this.pgid = 1;
        }
    }

    public long getParityGroupStart() {
        return this.pgstart;
    }

    public long getParityGroupEnd() {
        return this.pgend;
    }

    public int getMaxDataLength() {
        return SHARDLEN - 4;
    }

    private byte[] padDataToShardLen(byte[] data, int contentLen) throws ShardDataTooLongException {
        byte[] tmp = new byte[SHARDLEN];
        ByteArrayUtils.writeShort(tmp, 0, (short)contentLen);
        ByteArrayUtils.writeShort(tmp, 2, (short)data.length);
        try {
            System.arraycopy(data, 0, tmp, 4, data.length);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new ShardDataTooLongException();
        }
        return tmp;
    }

    private byte[] encodeShard(byte[] shard, int index) {
        return this.encodeShard(shard, index, 0);
    }

    private byte[] encodeShard(byte[] shard, int index, int skippedShardlen) {
        byte[] tmp = new byte[SHARDLEN + 22];
        ByteArrayUtils.writeLong(tmp, 0, this.pgstart);
        ByteArrayUtils.writeUnsignedByte(tmp, 8, this.DATA_SHARDS);
        ByteArrayUtils.writeUnsignedByte(tmp, 9, this.PARITY_SHARDS);
        ByteArrayUtils.writeUnsignedByte(tmp, 10, this.pgid);
        ByteArrayUtils.writeUnsignedByte(tmp, 11, index);
        if (skippedShardlen > 0) {
            ByteArrayUtils.writeShort(tmp, 12, (short)(-skippedShardlen));
        } else {
            ByteArrayUtils.writeShort(tmp, 12, (short)shard.length);
            System.arraycopy(shard, 0, tmp, 14, shard.length);
        }
        return tmp;
    }

    public byte[] willWriteData(byte[] dat, long start, int contentLen) throws ShardDataTooLongException {
        boolean skipAndComplete = false;
        long Tnow = SafeClock.currentTimeMillis();
        if (this.list.size() == 0) {
            this.pgStartTime = Tnow;
            this.pgstart = start;
            this.pgend = start;
        }
        if (Tnow - this.pgStartTime > (long)(NodeLink.FYI_WRITE_EVERY + 25)) {
            if (NodeLink.VERBOSE_PG_MANAGEMENT) {
                System.out.println("*** PG truncated after " + (Tnow - this.pgStartTime));
            }
            skipAndComplete = true;
        }
        byte[] padded = this.padDataToShardLen(dat, contentLen);
        if (this.pgend == start) {
            int myindex = this.list.size();
            this.list.add(padded);
            byte[] dataShard = this.encodeShard(padded, myindex);
            this.pgend += (long)contentLen;
            byte[] skipShard = null;
            if (skipAndComplete) {
                int skipped = this.DATA_SHARDS - this.list.size();
                if (skipped == 0 || this.list.size() == 1) {
                    skipAndComplete = false;
                } else {
                    skipShard = this.encodeShard(new byte[0], this.list.size(), SHARDLEN);
                    this.parity.add(skipShard);
                    this.parity.add(skipShard);
                    for (int i = 0; i < skipped; ++i) {
                        this.list.add(new byte[SHARDLEN]);
                    }
                }
            }
            if (this.list.size() == this.DATA_SHARDS) {
                int i;
                int TOT_SHARDS = this.DATA_SHARDS + this.PARITY_SHARDS;
                byte[][] shards = new byte[TOT_SHARDS][];
                for (i = 0; i < shards.length; ++i) {
                    shards[i] = i < this.list.size() ? this.list.get(i) : new byte[SHARDLEN];
                }
                if (this.reedSolomon == null) {
                    this.reedSolomon = ParityWriter.getReedSolomon(this.DATA_SHARDS, this.PARITY_SHARDS);
                }
                this.reedSolomon.encodeParity(shards, 0, SHARDLEN);
                for (i = this.DATA_SHARDS; i < TOT_SHARDS; ++i) {
                    this.parity.add(this.encodeShard(shards[i], i));
                }
                if (skipAndComplete) {
                    this.parity.add(skipShard);
                    this.parity.add(skipShard);
                }
                this.reset();
            }
            return dataShard;
        }
        this.reset();
        return this.willWriteData(dat, start, contentLen);
    }

    public ArrayList<byte[]> getParityShardsIfAny() {
        ArrayList<byte[]> ret = this.parity;
        this.parity = new ArrayList();
        return ret;
    }
}

