/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.attempt.socket;

import com.aem.nodelink.attempt.socket.SocketConnectAttempt;
import com.aem.nodelink.utils.DataUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerSocketConnectAttempt
implements SocketConnectAttempt {
    ServerSocket ssock;
    boolean shutdown;
    long delay;
    boolean expectData = false;
    int expected;
    Socket sock;
    boolean aborted = false;
    boolean finished = false;
    boolean success = false;

    public ServerSocketConnectAttempt(ServerSocket ssock, boolean andShutdown) {
        this(ssock, andShutdown, 0L);
    }

    public ServerSocketConnectAttempt(ServerSocket ssock, boolean andShutdown, long delay) {
        this.ssock = ssock;
        this.delay = delay;
        this.shutdown = andShutdown;
    }

    public void setExpectedFirstData(int expected) {
        this.expectData = true;
        this.expected = expected;
    }

    @Override
    public Socket getSocket() {
        return this.sock;
    }

    @Override
    public void abortAttempt() {
        this.aborted = true;
        try {
            System.out.println("[ServerConnect] Aborted - closing socket as precaution " + this.sock);
            this.sock.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.success = false;
        this.finished = true;
        if (this.shutdown) {
            try {
                System.out.println("[ServerConnect] Closing server socket as instructed " + this.ssock);
                this.ssock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void attemptNow() {
        block13: {
            try {
                block14: {
                    this.sock = this.ssock.accept();
                    if (this.aborted) {
                        try {
                            System.out.println("[ServerConnect] Aborted - closing socket after creation " + this.sock);
                            this.sock.close();
                        }
                        catch (Throwable throwable) {}
                        break block13;
                    }
                    try {
                        if (!this.expectData) break block14;
                        InputStream in = this.sock.getInputStream();
                        this.sock.setSoTimeout(8000);
                        int first = DataUtils.readInt(in);
                        if (first != this.expected) {
                            try {
                                this.sock.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw new IOException("Expected data not received data");
                        }
                        this.sock.setSoTimeout(0);
                    }
                    catch (Exception x) {
                        this.success = false;
                        throw new IOException("Connection cancelled or invalid");
                    }
                }
                this.success = true;
                System.out.println("[ServerConnect] Success - got socket " + this.sock);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.finished = true;
        if (this.shutdown) {
            try {
                System.out.println("[ServerConnect] Closing server socket as instructed " + this.ssock);
                this.ssock.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean wasSuccessful() {
        return this.success;
    }

    public String toString() {
        return "Server connection on " + this.ssock;
    }
}

