/*
 * Decompiled with CFR 0.152.
 */
package com.aem.gstore;

import com.aem.gstore.DataBlock;
import com.aem.gstore.GenStore;
import com.aem.gstore.StorePacket;
import com.aem.gstore.StoreProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class GenCollator {
    boolean transientWillClose = false;
    Object userObject;
    StoreProcessor processor;
    long acked = 0L;
    int MAX_PACKETS = 50;
    Object packets_LOCK = new Object();
    Object processing_LOCK = new Object();
    ArrayList<PartialPacket> packets = new ArrayList();

    public GenCollator(StoreProcessor processor, Object userObject) {
        this.processor = processor;
        this.userObject = userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.packets_LOCK;
        synchronized (object) {
            return this.packets.size() == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unfinishedPackets() {
        Object object = this.packets_LOCK;
        synchronized (object) {
            return this.packets.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedBlock(DataBlock db) {
        PartialPacket packet;
        if (db.isEarliestBlock()) {
            this.trimUpTo(db.getOverallStart());
        }
        if ((packet = this.findOrCreatePacket(db.getPacketUID(), db.getPacketStart())) != null) {
            packet.addBlock(db);
            if (packet.isFinished() && this.acked == packet.getPacketStart()) {
                this.processFinishedPacket(packet);
                Object object = this.packets_LOCK;
                synchronized (object) {
                    boolean processed;
                    block3: do {
                        processed = false;
                        for (PartialPacket check : this.packets) {
                            if (!check.isFinished() || this.acked != check.getPacketStart()) continue;
                            this.processFinishedPacket(check);
                            processed = true;
                            continue block3;
                        }
                    } while (processed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFinishedPacket(PartialPacket packet) {
        Object object = this.packets_LOCK;
        synchronized (object) {
            this.packets.remove(packet);
        }
        StorePacket sp = new StorePacket(packet.getData());
        sp.setPacketIndex(packet.getPacketStart());
        sp.setPacketUID(packet.packetUID);
        this.trimUpTo(packet.getPacketStart() + sp.size());
        Object object2 = this.processing_LOCK;
        synchronized (object2) {
            this.processor.processStorePacket(sp, this, this.userObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartialPacket findOrCreatePacket(long packetID, long packetIndex) {
        Object object = this.packets_LOCK;
        synchronized (object) {
            for (PartialPacket packet : this.packets) {
                if (packet.packetUID != packetID) continue;
                return packet;
            }
            if (this.packets.size() < this.MAX_PACKETS) {
                PartialPacket storePacket = new PartialPacket(packetID, packetIndex);
                this.packets.add(storePacket);
                return storePacket;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trimUpTo(long overallStart) {
        this.acked = Math.max(this.acked, overallStart);
        int dropped = 0;
        Object object = this.packets_LOCK;
        synchronized (object) {
            for (int i = 0; i < this.packets.size(); ++i) {
                PartialPacket packet = this.packets.get(i);
                if (packet.getLatestValidDataPoint() >= overallStart) continue;
                this.packets.remove(i--);
                ++dropped;
            }
        }
        if (GenStore.DEBUG_GENSTORE_UPDATES) {
            System.out.println("[GenCollator] Trimmed up to " + this.acked + " (dropped " + dropped + ")");
        }
    }

    public long getNextRequiredIndex() {
        return this.acked;
    }

    void restoreNextRequiredIndex(long acked) {
        this.acked = acked;
    }

    class PartialPacket {
        long packetIndex;
        long packetUID;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HashMap<Long, DataBlock> blocks = new HashMap();
        long pos = 0L;
        boolean finished = false;

        public PartialPacket(long packetUID, long packetIndex) {
            this.packetUID = packetUID;
            this.packetIndex = packetIndex;
        }

        public long getPacketStart() {
            return this.packetIndex;
        }

        public long getLatestValidDataPoint() {
            return this.packetIndex + this.pos;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public byte[] getData() {
            return this.bout.toByteArray();
        }

        private void write(DataBlock block) {
            try {
                this.bout.write(block.data);
                this.pos += (long)block.data.length;
                if (block.isLastBlock()) {
                    this.finished = true;
                }
            }
            catch (IOException x) {
                throw new ArrayIndexOutOfBoundsException("Unable to write data for incoming DataBlock - " + x);
            }
        }

        private void addBlock(DataBlock block) {
            if (GenStore.DEBUG_GENSTORE_UPDATES) {
                System.out.println("[GenCollator] Adding block " + block + ", current pos is " + this.pos);
            }
            if (block.position == this.pos) {
                this.write(block);
            } else {
                this.blocks.put(block.position, block);
            }
            while (this.blocks.containsKey(this.pos)) {
                this.write(this.blocks.remove(this.pos));
            }
        }
    }
}

