/*
 * Decompiled with CFR 0.152.
 */
package com.aem;

import com.aem.CdbgLauncher;
import com.aem.ServerManagement;
import com.aem.gstore.GenStore;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.tcp.TcpTransport;
import com.aem.nodelink.udp.UdpTransport;
import com.aem.nodelink.utils.SslToTcp;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.TaggedPrintStream;
import com.aem.utils.DualPrintstream;
import com.aem.utils.os.SystemInfo;
import com.aem.utils.sound.SoundUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.files.FileUtil;
import utils.files.ZipUtils;
import utils.ostools.OS;
import utils.ostools.debug.ThreadCountPrinter;
import utils.progtools.CheapTimingPrintStream;
import utils.progtools.CheapTimingProvider;
import utils.progtools.Counter;
import utils.progtools.MapOfLists;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.UIDeadlockDetector;
import utils.progtools.profiler.SamplingProfiler;
import utils.progtools.resume.TccMap;
import utils.progtools.time.TimeHierarchy;
import utils.stream.SocketLeaks;
import utils.swing.color.ConfigurableColor;
import utils.switches.LocalSwitches;
import utils.switches.Switches;

public class CentralDebugging {
    static Object LOCK = new Object();
    static HashMap metrics = new HashMap();
    static TimeHierarchy timers = new TimeHierarchy();
    static HashMap<String, Double> cumulates = new HashMap();
    static DualPrintstream dp;
    static String logPath;
    private static Object PRINTSTREAM_LOCK;
    private static TaggedPrintStream currentTaggedOutputStream;
    private static TaggedPrintStream currentTaggedErrorStream;
    public static boolean DEBUGGING_ON;
    public static boolean VERY_LARGE_SCALE_SG;
    public static boolean HEAP_AND_THREAD_DEBUGGING_ALWAYS;
    public static boolean DDEBUG_ON;
    public static boolean DDEBUG_PROXYSERVER_LIST_UPDATES;
    public static boolean DDEBUG_PROXYSERVER_MONITORING;
    public static boolean DDEBUG_PROXYSERVER_MESSAGING;
    public static boolean DDEBUG_PROXYSERVER_SECMSG;
    public static boolean DDEBUG_PROXYSERVER_LOSSY;
    public static boolean DDEBUG_PROXYSERVER_LOSSY_LARGE;
    public static boolean DDEBUG_PROXYSERVER_LOSSY_LARGE_OVERSLEEP;
    public static boolean DDEBUG_PROXYSERVER_WOL;
    public static boolean DUMP_SESSION_PERFORMANCE_ALWAYS;
    public static String SHOW_TRACE_FOR_STDOUT_FLAG;
    public static int SAMPLING_PROFILER;
    public static boolean USE_BCU_FOR_SESSION;
    public static boolean LIGHTWEIGHT_FILE_TRANSFER;
    public static int SET_LIGHTWEIGHT_QUERY_MS;
    public static boolean SILENT;
    public static boolean ACTIVITY_TRACKER_DEBUG;
    public static boolean ALL_METRICS;
    public static boolean FS_JOURNALING_VERBOSE;
    public static boolean FS_JOURNALING_CHANGES;
    public static boolean SECMSG_VERBOSE_HANDSHAKE;
    public static boolean SECMSG_HANDLING;
    public static boolean SECMSG_NO_BUSY_WAIT;
    public static boolean SECMSG_LOOKUPS;
    public static boolean SECMSG_TRACE_VERIFY_REQUESTS;
    public static boolean SECMSG_SHOW_OVERLOAD;
    public static boolean SECMSG_SHOW_ALL_DROPPED;
    public static boolean MUPLOAD_ALL;
    public static boolean MUPLOAD_WOL;
    public static boolean MUPLOAD_ALERT_LOGIC;
    public static boolean MUPLOAD_TCM_VERBOSE;
    public static boolean MUPLOAD_RUN_RESPONSE_VERBOSE_TC;
    public static boolean MUPLOAD_RUN_RESPONSE_VERBOSE_PX;
    public static boolean MONAPI_SHOW_FORWARDING;
    public static boolean MONAPI_SHOW_SENDS_AND_TRANS;
    public static boolean DEBUG_INPUT_BUFFERING_LAG;
    public static boolean SHOW_KEY_INPUT_CODES;
    public static boolean SHOW_IGNORED_CODES;
    public static boolean IGNORE_ALT_GR_ON_CLIENT;
    public static boolean SHOW_KEY_OUTPUT_CODES;
    public static boolean SHOW_ALL_INPUT_MESSAGES;
    public static boolean VERBOSE_MOUSE_INPUT;
    public static boolean MMOVE_PRINT_ALL_COMMANDS;
    public static boolean FORCE_MMOVE_USE_ROBOT;
    public static boolean DUMP_LOCK_KEY_STATES;
    public static boolean UDP_VERBOSE;
    public static boolean UDP_VERIFY_PACKET_LOSS_UNDER_DIRECT_UDP;
    public static boolean MSG_VERBOSE;
    public static boolean MSG_VERBOSE_ALL;
    public static boolean FORCE_NON_MAPPED_KEYSTROKES;
    public static boolean DISABLE_CONNECTION_HTTP;
    public static boolean DISABLE_CONNECTION_TCP;
    public static boolean DISABLE_CONNECTION_SSL;
    public static boolean DISABLE_CONNECTION_UDP_VIA_SERVER;
    public static boolean DISABLE_CONNECTION_UDP;
    public static boolean DISABLE_CONNECTION_FDHTTPS;
    public static boolean ALWAYS_ATTEMPT_FULL_UDP_DIRECT;
    public static boolean NEVER_STORE_UDP_ALLOW_PS;
    public static boolean LOSSY_SECURITY;
    public static boolean LOSSY_PRINT_USER_MESSAGES;
    public static boolean LOSSY_PRINT_ALL_MESSAGES;
    public static boolean LOSSY_PRINT_LARGE_MESSAGES;
    public static boolean CLUSTERING_MESSAGES;
    public static boolean CLUSTERING_DETAILS;
    public static boolean REPORT_SESSION_RTTS_ON_SWITCH;
    public static boolean SESSION_STARTUP;
    public static boolean WALLPAPER_DISABLING;
    public static boolean KEEP_SERVICE_FILES;
    public static boolean TECH_UI_VERBOSE_PAINT;
    public static boolean SHOW_RECONNECT_IN_TECH_UI_DEBUG;
    public static boolean VERBOSE_CURSOR_CACHE;
    public static boolean TECH_UI_MACHINE_NOTIFICATIONS;
    public static boolean TECH_CLIENT_SHOW_ALL_NOTIFICATIONS;
    public static boolean TECH_RUN_COMMAND_TESTS_NOTIFICATION_PANEL;
    public static boolean PRINT_STACK_ON_CONNECTION_FAIL;
    public static boolean DEBUG_NORTHPANEL_LOCK;
    public static boolean DIAGNOSTICS_ALL_MESSAGES;
    public static boolean FILE_TRANSFER;
    public static boolean SEND_UNRECOGNISED_KEYS_AS_PASTE;
    public static boolean KEYMAPPED_CHARACTERS_VERBOSE;
    public static boolean TECH_CLIENT_HANDLING;
    public static boolean MOBILE_REQUEST_HANDLING;
    public static boolean MOBILE_PRINT_INPUT;
    public static boolean MOBILE_PRINT_CONTROLS;
    public static boolean HIERARCHY_SAVING;
    public static boolean SCREEN_NO_PROCESSING_READ_FROM_PIPE_ONLY;
    public static boolean LOW_COLDEPTH_ON_DRAG;
    public static boolean DRAGS_AS_TRANSLATIONS;
    public static boolean ALLOW_CHANGE_FILTERING_SIZE;
    public static boolean CACHE_ALL_CHUNKS;
    public static boolean CACHE_EXTERNAL_PROCESS;
    public static boolean VISUALLY_SHOW_CACHING;
    public static boolean DEBUG_SCR_CACHING_VERBOSE;
    public static boolean DEBUG_TRANSLATIONS_CROP_RIGHT;
    public static boolean DETECT_DRAGS_ALWAYS;
    public static boolean DEBUG_DRAG_TRANSLATIONS_VERBOSE;
    public static boolean STORE_SCREEN_DEBUG_DUMPS;
    public static boolean VISUALLY_SHOW_TRANSLATIONS;
    public static boolean NO_MOUSE_DELAYS_FOR_DOUBLECLICK;
    public static boolean MOUSE_SCALING_GUI;
    public static boolean MOUSE_SCALING_DRAW_AT_HOTSPOT;
    public static boolean MOUSE_UPDATE_1PX_ACCURACY;
    public static boolean VERBOSE_DOUBLE_CLICK_SIMULATION;
    public static boolean SIMULATE_DOUBLE_CLICKS_IF_REQUIRED;
    public static boolean SCR_PRINT_INTENDED_VS_ACTUAL_SLEEP;
    public static boolean SCR_ADAPTIVE_DELAY;
    public static boolean SCREEN_DPI_TRANSLATION;
    public static boolean SCR_TEST_SCREEN_COMPRESSION;
    public static boolean SCR_VERBOSE_CHUNK_SEND;
    public static boolean SCR_FORCE_SEND_ALL_CHUNKS;
    public static boolean SCR_FORCE_SEND_NO_CHUNKS;
    public static boolean SCR_FORCE_LARGE_CHUNKS;
    public static boolean SCR_DUMP_GRAB_SPEC;
    public static boolean SCR_NO_VISTAPLUS_CONTEXTUAL_NONNATIVE_GRABS;
    public static boolean SCR_VISTAPLUS_CONTEXTUAL_NONNATIVE_GRABS_EVERY_FRAME;
    public static boolean SCR_FORCE_NON_NATIVE_FILTERING;
    public static boolean SCR_GRAB_VERBOSE;
    public static boolean SCR_GRAB_DUMP_VERBOSE;
    public static boolean SCR_NO_BATCH_SCREEN_PACKETS;
    public static boolean SCR_NO_FLUSH_ALL_BUFFERS;
    public static boolean SCR_SEND_NOTHING_ON_NO_CHANGE;
    public static boolean SCR_SEND_THREAD_VERBOSE;
    public static boolean SCR_FORCE_NON_JNI_GRAB;
    public static boolean SCR_NO_CHECK_FOR_BLACK_SCREEN;
    public static boolean SCR_USE_MINIMAL_ENCODING;
    public static boolean SCR_USE_COLOUR_RLE;
    public static boolean SCR_GRAB_OPENGL_NATIVE;
    public static boolean SCR_DISABLE_IMMEDIATE_SEND_AROUND_CURSOR;
    public static boolean SCR_FORCE_NON_NATIVE_GRAB;
    public static boolean SCR_DECOMPRESS_NO_BUFFERS;
    public static boolean SCR_VERBOSE_SCALING;
    public static boolean SCR_RECORD_SCREEN;
    public static boolean SCR_PLAYBACK_SCREEN;
    public static boolean SCR_SHOW_UPDATE_REGIONS;
    public static boolean DISALLOW_UDP_SESSIONS;
    public static boolean ATTEMPT_UDP_DIRECT;
    public static boolean UDP_DURING_SDEMO;
    public static boolean ATTEMPT_UDP_TO_SERVER;
    public static boolean DEBUG_NL_PACKET_LOSS_LONG;
    public static boolean DEBUG_NL_PACKET_LOSS_VERY_LONG;
    public static boolean DEBUG_ODTP_PRINT_STATS;
    public static boolean TCC_MAP_PRINT_REGULARLY;
    public static boolean SSLTT_LOCAL_SOCKET_CREATE_VERBOSE;
    public static boolean VERBOSE_TCPTRANSPORT_HANDLING_ERRORS;
    public static boolean NL_FORCE_HTTP_ONLY;
    public static boolean NL_FORCE_HTTPS_IF_POSSIBLE;
    public static boolean NL_UDP_TRANSPORT_VERBOSE_LIVENESS;
    public static boolean NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_SENT;
    public static boolean NL_UDP_TRANSPORT_VERBOSE_UDP_PACKET_TIMING;
    public static boolean NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_RECEIVED;
    public static boolean NL_VERBOSE_RESEND;
    public static boolean NL_VERBOSE_FLOW_RATE;
    public static boolean NL_VERBOSE_RTT;
    public static boolean NL_VERBOSE_ACKS;
    public static boolean NL_VERBOSE_PACKET_SEND_RESEND;
    public static boolean NL_VERBOSE_PACKET_SEND_NORMAL;
    public static boolean NL_VERBOSE_PACKET_READ;
    public static boolean NL_VERBOSE_HOLEY_BIG_BUFFER;
    public static boolean NL_VERBOSE_OOOP;
    public static boolean NL_VERBOSE_KEEPALIVE;
    public static boolean NL_VERBOSE_FYI;
    public static boolean NL_VERBOSE_CLOCK_SKEW;
    public static boolean NL_VERBOSE_UNACKED_HISTORY;
    public static boolean NL_VERBOSE_INCOMING_SOCKETS;
    public static int NL_FORCE_MAX_FLOW_CONTROLLED_PACKET_SIZE;
    public static boolean NL_FORCE_WRITE_SMALL_PACKETS;
    public static boolean WS_TIMED_REQUESTS;
    public static boolean WS_VERBOSE_REQUESTS;
    public static boolean WS_VERBOSE_CONNECTION_AND_REQUEST;
    public static boolean WS_VERBOSE_REQUESTS_INCLUDING_SG_MACHINES;
    public static boolean WS_VERBOSE_JAVASCRIPT;
    public static boolean LW_DEBUG_LIGHTWEIGHT_PRIMARY;
    public static boolean LW_DEBUG_MOBILE_ALL_REQUESTS;
    public static boolean LW_DEBUG_DEMO_ALL_REQUESTS;
    public static boolean DEBUG_WEBDOWNLOADSERVER_COUNT;
    public static boolean DEBUG_WDS_PING;
    public static boolean TCC_INS_OUTS;
    public static boolean ALERT_HISTORY_VERBOSE;
    public static boolean ALERT_CLOCK_VERBOSE;
    public static boolean ALERT_STATE_VERBOSE;
    public static boolean ALERT_TCP_VERBOSE;
    public static boolean ALERT_BASIC_ALERT;
    public static boolean ALERT_BASIC_ALERT_THRESHOLDS;
    public static boolean ALERT_BASIC_ALERT_INPUTS;
    public static boolean ALERT_BASIC_ALERT_LOGIC;
    public static boolean ALERT_REGISTRY;
    public static boolean ALERT_COROLLARY;
    public static boolean ALERT_DISK_HEALTH_DEBUG;
    public static boolean ALERT_FILE_MODIFIED_DEBUG;
    public static boolean ALERT_MEMORY_DEBUG;
    public static boolean ALERT_WINDOWS_EVENT_LOG;
    public static boolean ALERT_PROC_RUNNING_DEBUG;
    public static boolean ALERT_TOOL_RUNNING_DEBUG;
    public static boolean ALERT_TOOL_RUNNING_TIMING;
    public static boolean ALERT_DISK_SPACE_DEBUG;
    public static boolean ALERT_SERVICE_RUNNING_DEBUG;
    public static boolean ALERT_FILE_ACCESSIBLE_DEBUG;
    public static boolean ALERT_WEBSITE;
    public static boolean ALERT_WEBSITE_RESPONSE;
    public static boolean KACE_SHOW_ALL_RESPONSES;
    public static boolean PX_VERBOSE_SERVER_CONFIG;
    public static boolean PX_PROVIDE_INSTANCE_ID;
    public static boolean PX_CLEAR_INSTANCE_ID;
    public static boolean PX_MOBILE_CUST_UPLOAD;
    public static boolean PX_PEER_CONNECTION_HTTPS;
    public static boolean PX_SIMULATE_SERVER_LOGS;
    public static boolean PX_SIMULATE_RADIUS;
    public static boolean PX_GENSTORE_UPLOAD;
    public static boolean PX_GENSTORE_CONCURRENCY;
    public static boolean PX_GENSTORE_TIMEOUTS;
    public static boolean PX_GENSTORE_TESTDATA;
    public static boolean PX_GENSTORE_TESTAPI;
    public static boolean PX_GENSTORE_UPDATES;
    public static boolean PX_DEBUG_WDS_NL_FDHTTP;
    public static boolean PX_SESSION_TOKEN_REPOSITORY;
    public static boolean PX_SESSION_TOKEN_REPOSITORY_DEBUG_SHORT_TIME;
    public static boolean PX_BPH_VERBOSE;
    public static boolean PX_LICENSE_SERVER;
    public static boolean PX_PEER_MESSAGES;
    public static boolean PX_PEER_PROCESSING;
    public static boolean PX_PROXIED_CONTROLLER_MSGS;
    public static boolean PX_DEBUG_HTTP_FDUPLEX_FAILURES;
    public static boolean PX_DEBUG_SOCKET_LEAKS;
    public static boolean PX_DEBUG_SOCKET_ALL;
    public static boolean PX_DEBUG_SOCKETS;
    public static boolean PX_DEBUG_ALL_WDS_FAILS;
    public static boolean PX_DEBUG_SOCKETS_TO_FILE;
    public static boolean PX_VERBOSE_PROPERTY_MERGING;
    public static boolean PX_APP_PROFILES;
    public static boolean PX_RA_HASH_MISMATCH;
    public static boolean PX_PING_WAN_VERBOSE;
    public static boolean PX_TIMEOUT_SESSION_TOKENS;
    public static boolean PX_VERBOSE_RA_POPUPS;
    public static boolean PX_NOTIFY_SUPPORT;
    public static boolean PX_SHOW_DEMO_SESSIONS;
    public static boolean PX_TOLERATE_BADVERSION;
    public static boolean PX_MONITORING_INCOMING;
    public static boolean TERMINAL_VERBOSE;
    public static boolean PX_FORCE_SSL_UPDATE_URL;
    public static boolean PX_SESSION_CLAIMS;
    public static boolean PX_ALERT_SENDING;
    public static boolean PX_ALERT_SAVING_LOADING;
    public static boolean PX_ALERT_TEST_SAVING;
    public static boolean PX_ALERT_LIST;
    public static boolean PX_ALERT_ALLOCATIONS;
    public static boolean PX_ALERT_ALLOCATIONS_ADDS;
    public static boolean PX_TOOLBOX;
    public static boolean PX_ALERT_HASHES;
    public static boolean PX_ALERT_EVENTS;
    public static boolean PX_WS_THREADING;
    public static boolean PX_THREAD_CREATE_CALLBACK;
    public static boolean PX_SHOW_SOCKET_TIMEOUT_STACKTRACE;
    public static boolean PX_PROCESS_SG_POLLS_BY_WAITING_THREADS;
    public static boolean PX_LOW_LIMIT_UPDATES;
    public static boolean PX_MEDIUM_LIMIT_UPDATES;
    public static boolean PX_NO_LIMIT_UPDATES;
    public static boolean PX_FAIL_ALL_UPDATES;
    public static boolean PX_SERIALISE_SECMSG_SETUPS;
    public static boolean PX_LIMIT_SECMSG_SETUPS;
    public static boolean DEBUG_SECMSG_INITIAL_CHAT;
    public static boolean PX_VERBOSE_WTOK;
    public static boolean PX_WTOK_CHECK_EVENTS_VERBOSE;
    public static boolean PX_DEBUG_RENEGOTIATE;
    public static boolean PX_VERBOSE_RECOVERY_KEY;
    public static boolean PX_VERBOSE_MACHINE_POLLING;
    public static boolean PX_LOG_ACCESS;
    public static boolean PX_PREVENT_HEAP_DUMPS;
    public static boolean PX_VERBOSE_RESTART_REQUESTS;
    public static boolean PX_VERBOSE_MACHINE_AUTO_UDPATES;
    public static boolean PX_VERBOSE_MACHINELIST_ON_NOT_FOUND;
    public static boolean PX_VERBOSE_CUSTOMERLIST_ON_NOT_FOUND;
    public static boolean PX_VERBOSE_SCREEN_PNGS;
    public static boolean PX_VERBOSE_UDP_NATHP_RULES;
    public static boolean PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS;
    public static boolean PX_PREVENT_UPLOAD_ON_UPDATES;
    public static boolean PX_MONITOR_SOCKETS;
    public static boolean ASYNC_VERBOSE;
    public static boolean ASYNC_VERBOSE_RESPONSE;
    public static boolean SERVICES_VERBOSE;
    public static boolean VIDEO_RECORD_VERBOSE;
    public static boolean VIDEO_QUEUE_SIZE;
    public static boolean OOB_LINK_VERBOSE;
    public static boolean GLASS_DIALOGS_VERBOSE;
    public static boolean PRINT_SERVER_CONFIG_ON_SAVE;
    public static boolean LOGGING_ERRORS_VERBOSE;
    public static boolean PRINT_GROUP_CONCURRENCY_LIMITING;
    public static boolean DEBUG_WREG;
    public static boolean ALERT_ROUND_TRIPPING;
    public static boolean ENABLE_NATIVE_HOOKS;
    public static boolean TECH_UI_ACCESS_MODEL;
    public static boolean SHOW_ACCESS_SUBSCRIPTIONS;
    public static boolean GUI_KEY_EVENTS_DEBUG;
    public static boolean GUI_OVERLAYS_DEBUG;
    public static boolean DEBUG_SHOW_RESTART_SERVER_BUTTON;
    public static boolean TOOLBOX_TECH;
    public static boolean ENABLE_SYSTEM_AUDIO_CAPTURE;
    public static boolean ENABLE_AUDIO_TECH_TO_CUST;
    public static boolean ENABLE_AUDIO_CUST_TO_TECH;
    public static boolean PRINT_AUDIO_DEBUG;
    public static boolean SOUND_PLAYER_DEBUG;
    public static boolean VNC_DEBUG_INPUT;
    public static boolean VERBOSE_PING_MESSAGE;
    public static boolean SG_IN_USE_MONITOR_DEBUG;
    public static boolean RA_SHOW_READABLE_MESSAGES;
    public static boolean SG_BANDWIDTH_REPORTING;
    public static boolean SG_ACCEPT_ALL_CERTS;
    public static boolean SG_TIME_BROADCASTS;
    public static boolean SG_ALERTS;
    public static boolean SG_ALERTS_SGM_PROPAGATION;
    public static boolean SG_ALERTS_HASHES;
    public static boolean SG_ALERTS_MSGS;
    public static boolean SG_ALERTS_SIMULATE_REG_ERROR;
    public static boolean SG_ALERTS_DUMP_STATS;
    public static boolean SG_ADD_FIREWALL_RULES;
    public static boolean SG_ADD_SAFE_MODE_REBOOT_KEY;
    public static boolean SG_POLL_TIMING;
    public static boolean SG_VERBOSE_HTTP_READ;
    public static boolean SG_MONITORING_SOURCE;
    public static boolean SG_ALL_INCOMING_MESSAGES;
    public static boolean SG_SERVICE_SIMULATE_STUCK;
    public static boolean SG_DNS_RESOLUTION_DEBUG;
    public static boolean SG_TEST_RENEGOTIATE_SECMSG_EVERY_TIME;
    public static boolean RENEGOTIATION_TRACING;
    public static boolean TOOLBOX_REPOSITORY;
    public static boolean CHAT_VERBOSE;
    public static boolean PKHASH_PORTION_DEBUGGING;
    public static boolean CAD_ALWAYS_USE_EXE;
    public static boolean CREATE_SYNTHETIC_MACHINES;
    private static Object fcheck_LOCK;
    private static CheckThread pct;
    private static CheckThread ct;
    private static File optionalDir;

    public static String getLogFilePath() {
        return logPath;
    }

    public static String getFilePathInSameDirAsLog(String name) {
        File logsFolder;
        if (logPath != null) {
            return new File(new File(logPath).getParent(), name).getAbsolutePath();
        }
        if (JWLaunchProperties.isJWrapperSetup() && (logsFolder = JWSystem.getAllAppLoggingFolder()) != null) {
            return new File(logsFolder, name).getAbsolutePath();
        }
        return new File(name).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timerStart(String timer) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                timers.start(timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timerStop(String timer) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                timers.stop(timer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void counterStart(String counter) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                cumulates.put(counter, new Double(0.0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void counterAdd(String counter, double val) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                Double tot = cumulates.get(counter);
                if (tot == null) {
                    cumulates.put(counter, new Double(val));
                } else {
                    cumulates.put(counter, new Double(val + tot));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void counterFinish(String counter) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                Double l = cumulates.get(counter);
                cumulates.put(counter, new Double(0.0));
                if (l != null) {
                    metrics.put("Counter: " + counter, l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void counterFinishIfMax(String counter) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                Double l = cumulates.get(counter);
                cumulates.put(counter, new Double(0.0));
                if (l != null) {
                    Number d = (Number)metrics.get("Counter: " + counter);
                    if (d != null) {
                        if (d.doubleValue() < l) {
                            metrics.put("Counter: " + counter, l);
                        }
                    } else {
                        metrics.put("Counter: " + counter, l);
                    }
                }
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ALL_METRICS = true;
        CentralDebugging.timerStart("test");
        Thread.sleep(100L);
        CentralDebugging.timerStop("test");
        for (int i = 0; i < 10; ++i) {
            CentralDebugging.timerStart("woot");
            Thread.sleep(100L);
            CentralDebugging.timerStop("woot");
        }
        HashMap map = CentralDebugging.getMetricsSnapshot();
        Object[] keys = map.keySet().toArray();
        Arrays.sort(keys);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i] + " = " + map.get(keys[i]));
            sb.append("\n");
        }
        System.out.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void counterFinishIfMin(String counter) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                Double l = cumulates.get(counter);
                cumulates.put(counter, new Double(0.0));
                if (l != null) {
                    Number d = (Number)metrics.get("Counter: " + counter);
                    if (d != null) {
                        if (d.doubleValue() > l) {
                            metrics.put("Counter: " + counter, l);
                        }
                    } else {
                        metrics.put("Counter: " + counter, l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMetric(String name, double val) {
        if (ALL_METRICS) {
            Object object = LOCK;
            synchronized (object) {
                metrics.put("Metric: " + name, new Double(val));
            }
        }
    }

    public static void clearAllMetrics() {
        metrics = new HashMap();
    }

    public static HashMap getMetricsSnapshot() {
        return (HashMap)metrics.clone();
    }

    public static String getTimerSummary() {
        return timers.dumpStats();
    }

    public static void applyDebugSettings() {
        if (NL_FORCE_WRITE_SMALL_PACKETS) {
            System.out.println("[CDBG] Max flow controlled packet size is " + NL_FORCE_MAX_FLOW_CONTROLLED_PACKET_SIZE + " from " + NodeLink.DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE);
            NodeLink.DEFAULT_MAX_FLOW_CONTROLLED_PACKET_SIZE = NL_FORCE_MAX_FLOW_CONTROLLED_PACKET_SIZE;
        }
        NodeLink.VERBOSE_PACKET_SEND_RESEND = NL_VERBOSE_PACKET_SEND_RESEND;
        NodeLink.VERBOSE_PACKET_SEND_NORMAL = NL_VERBOSE_PACKET_SEND_NORMAL;
        NodeLink.VERBOSE_PACKET_READ = NL_VERBOSE_PACKET_READ;
        NodeLink.VERBOSE_HOLEY_BIG_BUFFER = NL_VERBOSE_HOLEY_BIG_BUFFER;
        NodeLink.VERBOSE_OOOP = NL_VERBOSE_OOOP;
        NodeLink.VERBOSE_RESEND = NL_VERBOSE_RESEND;
        NodeLink.VERBOSE_ACKS = NL_VERBOSE_ACKS;
        NodeLink.VERBOSE_RTT = NL_VERBOSE_RTT;
        NodeLink.VERBOSE_FLOW_RATE = NL_VERBOSE_FLOW_RATE;
        NodeLink.VERBOSE_KEEPALIVE = NL_VERBOSE_KEEPALIVE;
        NodeLink.VERBOSE_FYI = NL_VERBOSE_FYI;
        NodeLink.VERBOSE_CLOCK_SKEW = NL_VERBOSE_CLOCK_SKEW;
        NodeLink.VERBOSE_UNACKED_HISTORY = NL_VERBOSE_UNACKED_HISTORY;
        NodeLink.VERBOSE_SOCKETS = NL_VERBOSE_INCOMING_SOCKETS;
        UdpTransport.VERBOSE_LIVENESS = NL_UDP_TRANSPORT_VERBOSE_LIVENESS;
        UdpTransport.VERBOSE_EVERY_PACKET_SENT = NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_SENT;
        UdpTransport.VERBOSE_UDP_PACKET_TIMING = NL_UDP_TRANSPORT_VERBOSE_UDP_PACKET_TIMING;
        UdpTransport.VERBOSE_EVERY_PACKET_RECEIVED = NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_RECEIVED;
        TcpTransport.VERBOSE_TCPTRANSPORT_HANDLING_ERRORS = VERBOSE_TCPTRANSPORT_HANDLING_ERRORS;
        SslToTcp.LOCAL_SOCKET_CREATE_VERBOSE = SSLTT_LOCAL_SOCKET_CREATE_VERBOSE;
        SoundUtils.SOUND_PLAYER_DEBUG = SOUND_PLAYER_DEBUG;
        OnDemandThreadPool.PRINT_STATS = DEBUG_ODTP_PRINT_STATS;
        boolean bl = PX_DEBUG_SOCKETS = PX_DEBUG_SOCKET_ALL || PX_DEBUG_SOCKET_LEAKS;
        if (PX_DEBUG_SOCKETS) {
            SocketLeaks.trackSocketLeaks(true);
        } else {
            SocketLeaks.trackSocketLeaks(false);
        }
        if (PX_DEBUG_SOCKETS_TO_FILE) {
            SocketLeaks.dumpToFile(new File("socket_tracking.txt"));
        }
        if (TCC_MAP_PRINT_REGULARLY) {
            TccMap.TCC_MAP_STATUS_FREQUENCY = 10000;
        }
        GenStore.DEBUG_COLLATION_TIMEOUTS = PX_GENSTORE_TIMEOUTS;
        GenStore.DEBUG_COLLATION_CONCURRENCY = PX_GENSTORE_CONCURRENCY;
        GenStore.DEBUG_GENSTORE_UPDATES = PX_GENSTORE_UPDATES;
    }

    public static void setOptionalDebugDir(File dir) {
        optionalDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preloadDebugSettings(String whoami, boolean checkForUIDeadlock) {
        Object object = fcheck_LOCK;
        synchronized (object) {
            if (pct == null) {
                try {
                    if (!SILENT) {
                        System.out.println("[CentralDebugging] PreLoading Debug Settings for " + whoami);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!SILENT) {
                        System.out.println("[CentralDebugging] checking properties in " + new File(".").getAbsoluteFile().getCanonicalPath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!SILENT) {
                        System.out.println("[CentralDebugging] checking properties in " + new File(".." + File.separator + ".." + File.separator).getAbsoluteFile().getCanonicalPath());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                pct = new CheckThread(checkForUIDeadlock);
                CentralDebugging.pct.whoami = whoami;
                pct.start();
            }
        }
    }

    public static void loadCentralisedSwitchesFromProperties(Properties props) {
        try {
            if (props.getProperty("DISABLE_CONNECTION_HTTP") != null) {
                DISABLE_CONNECTION_HTTP = true;
                System.out.println("[CentralDebugging] Switching on DISABLE_CONNECTION_HTTP");
            }
            if (props.getProperty("DISABLE_CONNECTION_TCP") != null) {
                DISABLE_CONNECTION_TCP = true;
                System.out.println("[CentralDebugging] Switching on DISABLE_CONNECTION_TCP");
            }
            if (props.getProperty("DISABLE_CONNECTION_SSL") != null) {
                DISABLE_CONNECTION_SSL = true;
                System.out.println("[CentralDebugging] Switching on DISABLE_CONNECTION_SSL");
            }
            if (props.getProperty("DISABLE_CONNECTION_UDP_VIA_SERVER") != null) {
                DISABLE_CONNECTION_UDP_VIA_SERVER = true;
                System.out.println("[CentralDebugging] Switching on DISABLE_CONNECTION_UDP_VIA_SERVER");
            }
            if (props.getProperty("DISABLE_CONNECTION_UDP") != null) {
                DISABLE_CONNECTION_UDP = true;
                System.out.println("[CentralDebugging] Switching on DISABLE_CONNECTION_UDP");
            }
            if (props.getProperty("ALWAYS_ATTEMPT_FULL_UDP_DIRECT") != null) {
                ALWAYS_ATTEMPT_FULL_UDP_DIRECT = true;
                System.out.println("[CentralDebugging] Switching on ALWAYS_ATTEMPT_FULL_UDP_DIRECT");
            }
            if (props.getProperty("NEVER_STORE_UDP_ALLOW_PS") != null) {
                NEVER_STORE_UDP_ALLOW_PS = true;
                System.out.println("[CentralDebugging] Switching on NEVER_STORE_UDP_ALLOW_PS");
            }
            System.out.println("[NL Connect] HTTP connection: " + (DISABLE_CONNECTION_HTTP ? "disabled" : "allowed"));
            System.out.println("[NL Connect] TCP connection: " + (DISABLE_CONNECTION_TCP ? "disabled" : "allowed"));
            System.out.println("[NL Connect] SSL/HTTPS connection: " + (DISABLE_CONNECTION_SSL ? "disabled" : "allowed"));
            System.out.println("[NL Connect] UDP Proxied connection: " + (DISABLE_CONNECTION_UDP_VIA_SERVER ? "disabled" : "allowed"));
            System.out.println("[NL Connect] UDP Direct connection: " + (DISABLE_CONNECTION_UDP ? "disabled" : "allowed"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void saveCentralisedSwitchesToProperties(Properties props) {
        if (DISABLE_CONNECTION_HTTP) {
            props.setProperty("DISABLE_CONNECTION_HTTP", "yes");
        }
        if (DISABLE_CONNECTION_TCP) {
            props.setProperty("DISABLE_CONNECTION_TCP", "yes");
        }
        if (DISABLE_CONNECTION_SSL) {
            props.setProperty("DISABLE_CONNECTION_SSL", "yes");
        }
        if (DISABLE_CONNECTION_UDP_VIA_SERVER) {
            props.setProperty("DISABLE_CONNECTION_UDP_VIA_SERVER", "yes");
        }
        if (DISABLE_CONNECTION_UDP) {
            props.setProperty("DISABLE_CONNECTION_UDP", "yes");
        }
        if (ALWAYS_ATTEMPT_FULL_UDP_DIRECT) {
            props.setProperty("ALWAYS_ATTEMPT_FULL_UDP_DIRECT", "yes");
        }
        if (NEVER_STORE_UDP_ALLOW_PS) {
            props.setProperty("NEVER_STORE_UDP_ALLOW_PS", "yes");
        }
    }

    public static void loadDebugSettings(String whoami, boolean checkForUIDeadlock) {
        System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
        CdbgLauncher.loadListener();
        new DebugLoader(whoami, checkForUIDeadlock).start();
    }

    public static String dumpCondensedCompleteThreadStacks(File save) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream pout = new PrintStream(bout);
            Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Map map = (Map)method.invoke(null, new Object[0]);
            Object[] keys = map.keySet().toArray();
            pout.println("[AllThreadsTrace] Full Thread Trace Printout " + new Date());
            pout.println("[AllThreadsTrace] Total Threads: x" + keys.length);
            StringBuffer sb = new StringBuffer();
            HashMap staks = new HashMap();
            MapOfLists byTrace = new MapOfLists(true);
            Counter sorter = new Counter();
            for (int i = 0; i < keys.length; ++i) {
                Thread th = (Thread)keys[i];
                StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                Thread.State tstate = th.getState();
                String tname = th.getName();
                StringBuffer stacks = new StringBuffer();
                for (int z = 0; z < stack.length; ++z) {
                    stacks.append("\tat " + stack[z] + "\n");
                }
                String tstak = stacks.toString();
                byTrace.add((Object)tstak, (Object)th);
                sorter.add((Object)tstak, 1.0);
            }
            keys = byTrace.keySet().toArray();
            sorter.sortByValue(false);
            ArrayList keylist = sorter.getSortedKeys();
            for (int i = 0; i < keylist.size(); ++i) {
                String key;
                String tstak = key = (String)keylist.get(i);
                List all = byTrace.get((Object)key);
                pout.println();
                pout.println("[AllThreadsTrace] " + all.size() + "x threads with trace:");
                pout.println(tstak);
                pout.println("   Thread Names:");
                for (int k = 0; k < all.size(); ++k) {
                    Thread th = (Thread)all.get(k);
                    if (k == 0) {
                        pout.print("   ");
                    } else if (k % 3 == 0) {
                        pout.println();
                        pout.print("   ");
                    }
                    pout.print(th.getName() + " (" + (Object)((Object)th.getState()) + "),");
                }
                pout.println();
            }
            pout.flush();
            String text = new String(bout.toByteArray());
            System.out.println(text);
            if (save != null) {
                FileOutputStream fout = new FileOutputStream(save);
                fout.write(bout.toByteArray());
                fout.close();
            }
            return text;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static void launchDebuggingUI(boolean consoleOnly) {
        if (consoleOnly) {
            CentralDebugging.ct.launchDebugConsole = true;
        } else {
            CentralDebugging.ct.launchDebuggerUI = true;
        }
        CentralDebugging.ct.lastMod = 0L;
        CentralDebugging.ct.checkNow = true;
        File debug = CentralDebugging.debugTxtExistsGetFile();
        if (debug == null) {
            System.out.println("[CentralDebugging] Trying to create debug file " + new File("debug.txt").getAbsolutePath() + " for debugger launch");
            boolean created = false;
            try {
                if (!new File("debug.txt").createNewFile()) {
                    System.out.println("[CentralDebugging] Unable to create debug file for debugger launch");
                } else {
                    created = true;
                }
            }
            catch (IOException x) {
                System.out.println("[CentralDebugging] Failed to create debug file for debugger launch " + x);
            }
            if (!created && optionalDir != null) {
                try {
                    if (!new File(optionalDir, "debug.txt").createNewFile()) {
                        System.out.println("[CentralDebugging] Unable to create debug file for debugger launch in " + optionalDir);
                    }
                }
                catch (IOException x) {
                    System.out.println("[CentralDebugging] Failed to create debug file for debugger launch in " + optionalDir + " because " + x);
                }
            }
        }
    }

    static File debugTxtExistsGetFile() {
        File[] files = optionalDir != null ? new File[4] : new File[]{new File("." + File.separator + "debug.txt"), new File(".." + File.separator + ".." + File.separator + "debug.txt"), new File(".." + File.separator + "logs" + File.separator + "debug.txt")};
        if (optionalDir != null) {
            files[3] = new File(optionalDir, "debug.txt");
        }
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].exists()) continue;
            return files[i];
        }
        return null;
    }

    public static String getThreadID(Thread thread) {
        try {
            Method method = thread.getClass().getMethod("getId", new Class[0]);
            Object result = method.invoke((Object)thread, new Object[0]);
            return (String)result;
        }
        catch (Throwable t) {
            return "Unknown";
        }
    }

    static {
        PRINTSTREAM_LOCK = new Object();
        DEBUGGING_ON = false;
        VERY_LARGE_SCALE_SG = false;
        HEAP_AND_THREAD_DEBUGGING_ALWAYS = true;
        DDEBUG_PROXYSERVER_LIST_UPDATES = DDEBUG_ON = false;
        DDEBUG_PROXYSERVER_MONITORING = DDEBUG_ON;
        DDEBUG_PROXYSERVER_MESSAGING = DDEBUG_ON;
        DDEBUG_PROXYSERVER_SECMSG = DDEBUG_ON;
        DDEBUG_PROXYSERVER_LOSSY = false;
        DDEBUG_PROXYSERVER_LOSSY_LARGE = false;
        DDEBUG_PROXYSERVER_LOSSY_LARGE_OVERSLEEP = false;
        DDEBUG_PROXYSERVER_WOL = false;
        DUMP_SESSION_PERFORMANCE_ALWAYS = true;
        SHOW_TRACE_FOR_STDOUT_FLAG = null;
        SAMPLING_PROFILER = 0;
        USE_BCU_FOR_SESSION = true;
        LIGHTWEIGHT_FILE_TRANSFER = false;
        SET_LIGHTWEIGHT_QUERY_MS = 0;
        SILENT = false;
        ACTIVITY_TRACKER_DEBUG = false;
        ALL_METRICS = false;
        FS_JOURNALING_VERBOSE = false;
        FS_JOURNALING_CHANGES = false;
        SECMSG_VERBOSE_HANDSHAKE = false;
        SECMSG_HANDLING = false;
        SECMSG_NO_BUSY_WAIT = false;
        SECMSG_LOOKUPS = false;
        SECMSG_TRACE_VERIFY_REQUESTS = false;
        SECMSG_SHOW_OVERLOAD = false;
        SECMSG_SHOW_ALL_DROPPED = true;
        MUPLOAD_ALL = false;
        MUPLOAD_WOL = true;
        MUPLOAD_ALERT_LOGIC = false;
        MUPLOAD_TCM_VERBOSE = true;
        MUPLOAD_RUN_RESPONSE_VERBOSE_TC = false;
        MUPLOAD_RUN_RESPONSE_VERBOSE_PX = false;
        MONAPI_SHOW_FORWARDING = false;
        MONAPI_SHOW_SENDS_AND_TRANS = false;
        DEBUG_INPUT_BUFFERING_LAG = false;
        SHOW_KEY_INPUT_CODES = false;
        SHOW_IGNORED_CODES = true;
        IGNORE_ALT_GR_ON_CLIENT = true;
        SHOW_KEY_OUTPUT_CODES = false;
        SHOW_ALL_INPUT_MESSAGES = false;
        VERBOSE_MOUSE_INPUT = false;
        MMOVE_PRINT_ALL_COMMANDS = false;
        FORCE_MMOVE_USE_ROBOT = false;
        DUMP_LOCK_KEY_STATES = false;
        UDP_VERBOSE = false;
        UDP_VERIFY_PACKET_LOSS_UNDER_DIRECT_UDP = false;
        MSG_VERBOSE = false;
        MSG_VERBOSE_ALL = false;
        FORCE_NON_MAPPED_KEYSTROKES = false;
        DISABLE_CONNECTION_HTTP = false;
        DISABLE_CONNECTION_TCP = false;
        DISABLE_CONNECTION_SSL = false;
        DISABLE_CONNECTION_UDP_VIA_SERVER = false;
        DISABLE_CONNECTION_UDP = false;
        DISABLE_CONNECTION_FDHTTPS = false;
        ALWAYS_ATTEMPT_FULL_UDP_DIRECT = false;
        NEVER_STORE_UDP_ALLOW_PS = false;
        LOSSY_SECURITY = false;
        LOSSY_PRINT_USER_MESSAGES = false;
        LOSSY_PRINT_ALL_MESSAGES = false;
        LOSSY_PRINT_LARGE_MESSAGES = false;
        CLUSTERING_MESSAGES = false;
        CLUSTERING_DETAILS = false;
        REPORT_SESSION_RTTS_ON_SWITCH = true;
        SESSION_STARTUP = true;
        WALLPAPER_DISABLING = false;
        KEEP_SERVICE_FILES = false;
        TECH_UI_VERBOSE_PAINT = false;
        SHOW_RECONNECT_IN_TECH_UI_DEBUG = false;
        VERBOSE_CURSOR_CACHE = false;
        TECH_UI_MACHINE_NOTIFICATIONS = false;
        TECH_CLIENT_SHOW_ALL_NOTIFICATIONS = false;
        TECH_RUN_COMMAND_TESTS_NOTIFICATION_PANEL = false;
        PRINT_STACK_ON_CONNECTION_FAIL = true;
        DEBUG_NORTHPANEL_LOCK = false;
        DIAGNOSTICS_ALL_MESSAGES = false;
        FILE_TRANSFER = false;
        SEND_UNRECOGNISED_KEYS_AS_PASTE = false;
        KEYMAPPED_CHARACTERS_VERBOSE = false;
        TECH_CLIENT_HANDLING = true;
        MOBILE_REQUEST_HANDLING = false;
        MOBILE_PRINT_INPUT = false;
        MOBILE_PRINT_CONTROLS = false;
        HIERARCHY_SAVING = false;
        SCREEN_NO_PROCESSING_READ_FROM_PIPE_ONLY = false;
        LOW_COLDEPTH_ON_DRAG = false;
        DRAGS_AS_TRANSLATIONS = false;
        ALLOW_CHANGE_FILTERING_SIZE = false;
        CACHE_ALL_CHUNKS = true;
        CACHE_EXTERNAL_PROCESS = false;
        VISUALLY_SHOW_CACHING = false;
        DEBUG_SCR_CACHING_VERBOSE = false;
        DEBUG_TRANSLATIONS_CROP_RIGHT = true;
        DETECT_DRAGS_ALWAYS = false;
        DEBUG_DRAG_TRANSLATIONS_VERBOSE = false;
        STORE_SCREEN_DEBUG_DUMPS = false;
        VISUALLY_SHOW_TRANSLATIONS = false;
        NO_MOUSE_DELAYS_FOR_DOUBLECLICK = false;
        MOUSE_SCALING_GUI = false;
        MOUSE_SCALING_DRAW_AT_HOTSPOT = true;
        MOUSE_UPDATE_1PX_ACCURACY = true;
        VERBOSE_DOUBLE_CLICK_SIMULATION = false;
        SIMULATE_DOUBLE_CLICKS_IF_REQUIRED = true;
        SCR_PRINT_INTENDED_VS_ACTUAL_SLEEP = false;
        SCR_ADAPTIVE_DELAY = false;
        SCREEN_DPI_TRANSLATION = false;
        SCR_TEST_SCREEN_COMPRESSION = false;
        SCR_VERBOSE_CHUNK_SEND = false;
        SCR_FORCE_SEND_ALL_CHUNKS = false;
        SCR_FORCE_SEND_NO_CHUNKS = false;
        SCR_FORCE_LARGE_CHUNKS = false;
        SCR_DUMP_GRAB_SPEC = false;
        SCR_NO_VISTAPLUS_CONTEXTUAL_NONNATIVE_GRABS = true;
        SCR_VISTAPLUS_CONTEXTUAL_NONNATIVE_GRABS_EVERY_FRAME = false;
        SCR_FORCE_NON_NATIVE_FILTERING = true;
        SCR_GRAB_VERBOSE = false;
        SCR_GRAB_DUMP_VERBOSE = false;
        SCR_NO_BATCH_SCREEN_PACKETS = false;
        SCR_NO_FLUSH_ALL_BUFFERS = false;
        SCR_SEND_NOTHING_ON_NO_CHANGE = true;
        SCR_SEND_THREAD_VERBOSE = false;
        SCR_FORCE_NON_JNI_GRAB = false;
        SCR_NO_CHECK_FOR_BLACK_SCREEN = false;
        SCR_USE_MINIMAL_ENCODING = true;
        SCR_USE_COLOUR_RLE = false;
        SCR_GRAB_OPENGL_NATIVE = false;
        SCR_DISABLE_IMMEDIATE_SEND_AROUND_CURSOR = true;
        SCR_FORCE_NON_NATIVE_GRAB = false;
        SCR_DECOMPRESS_NO_BUFFERS = false;
        SCR_VERBOSE_SCALING = false;
        SCR_RECORD_SCREEN = false;
        SCR_PLAYBACK_SCREEN = false;
        SCR_SHOW_UPDATE_REGIONS = false;
        DISALLOW_UDP_SESSIONS = false;
        ATTEMPT_UDP_DIRECT = true;
        UDP_DURING_SDEMO = true;
        ATTEMPT_UDP_TO_SERVER = false;
        DEBUG_NL_PACKET_LOSS_LONG = false;
        DEBUG_NL_PACKET_LOSS_VERY_LONG = false;
        DEBUG_ODTP_PRINT_STATS = false;
        TCC_MAP_PRINT_REGULARLY = false;
        SSLTT_LOCAL_SOCKET_CREATE_VERBOSE = false;
        VERBOSE_TCPTRANSPORT_HANDLING_ERRORS = false;
        NL_FORCE_HTTP_ONLY = false;
        NL_FORCE_HTTPS_IF_POSSIBLE = false;
        NL_UDP_TRANSPORT_VERBOSE_LIVENESS = false;
        NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_SENT = false;
        NL_UDP_TRANSPORT_VERBOSE_UDP_PACKET_TIMING = false;
        NL_UDP_TRANSPORT_VERBOSE_EVERY_PACKET_RECEIVED = false;
        NL_VERBOSE_RESEND = true;
        NL_VERBOSE_FLOW_RATE = false;
        NL_VERBOSE_RTT = false;
        NL_VERBOSE_ACKS = false;
        NL_VERBOSE_PACKET_SEND_RESEND = false;
        NL_VERBOSE_PACKET_SEND_NORMAL = false;
        NL_VERBOSE_PACKET_READ = false;
        NL_VERBOSE_HOLEY_BIG_BUFFER = false;
        NL_VERBOSE_OOOP = false;
        NL_VERBOSE_KEEPALIVE = false;
        NL_VERBOSE_FYI = false;
        NL_VERBOSE_CLOCK_SKEW = false;
        NL_VERBOSE_UNACKED_HISTORY = false;
        NL_VERBOSE_INCOMING_SOCKETS = false;
        NL_FORCE_MAX_FLOW_CONTROLLED_PACKET_SIZE = 512;
        NL_FORCE_WRITE_SMALL_PACKETS = false;
        WS_TIMED_REQUESTS = false;
        WS_VERBOSE_REQUESTS = false;
        WS_VERBOSE_CONNECTION_AND_REQUEST = false;
        WS_VERBOSE_REQUESTS_INCLUDING_SG_MACHINES = false;
        WS_VERBOSE_JAVASCRIPT = false;
        LW_DEBUG_LIGHTWEIGHT_PRIMARY = false;
        LW_DEBUG_MOBILE_ALL_REQUESTS = false;
        LW_DEBUG_DEMO_ALL_REQUESTS = false;
        DEBUG_WEBDOWNLOADSERVER_COUNT = false;
        DEBUG_WDS_PING = false;
        TCC_INS_OUTS = false;
        ALERT_HISTORY_VERBOSE = false;
        ALERT_CLOCK_VERBOSE = false;
        ALERT_STATE_VERBOSE = false;
        ALERT_TCP_VERBOSE = false;
        ALERT_BASIC_ALERT = false;
        ALERT_BASIC_ALERT_THRESHOLDS = false;
        ALERT_BASIC_ALERT_INPUTS = false;
        ALERT_BASIC_ALERT_LOGIC = false;
        ALERT_REGISTRY = false;
        ALERT_COROLLARY = false;
        ALERT_DISK_HEALTH_DEBUG = false;
        ALERT_FILE_MODIFIED_DEBUG = false;
        ALERT_MEMORY_DEBUG = false;
        ALERT_WINDOWS_EVENT_LOG = false;
        ALERT_PROC_RUNNING_DEBUG = false;
        ALERT_TOOL_RUNNING_DEBUG = false;
        ALERT_TOOL_RUNNING_TIMING = false;
        ALERT_DISK_SPACE_DEBUG = false;
        ALERT_SERVICE_RUNNING_DEBUG = false;
        ALERT_FILE_ACCESSIBLE_DEBUG = false;
        ALERT_WEBSITE = false;
        ALERT_WEBSITE_RESPONSE = false;
        KACE_SHOW_ALL_RESPONSES = false;
        PX_VERBOSE_SERVER_CONFIG = false;
        PX_PROVIDE_INSTANCE_ID = false;
        PX_CLEAR_INSTANCE_ID = false;
        PX_MOBILE_CUST_UPLOAD = false;
        PX_PEER_CONNECTION_HTTPS = false;
        PX_SIMULATE_SERVER_LOGS = false;
        PX_SIMULATE_RADIUS = false;
        PX_GENSTORE_UPLOAD = false;
        PX_GENSTORE_CONCURRENCY = false;
        PX_GENSTORE_TIMEOUTS = false;
        PX_GENSTORE_TESTDATA = false;
        PX_GENSTORE_TESTAPI = false;
        PX_GENSTORE_UPDATES = false;
        PX_DEBUG_WDS_NL_FDHTTP = false;
        PX_SESSION_TOKEN_REPOSITORY = false;
        PX_SESSION_TOKEN_REPOSITORY_DEBUG_SHORT_TIME = false;
        PX_BPH_VERBOSE = false;
        PX_LICENSE_SERVER = false;
        PX_PEER_MESSAGES = false;
        PX_PEER_PROCESSING = false;
        PX_PROXIED_CONTROLLER_MSGS = false;
        PX_DEBUG_HTTP_FDUPLEX_FAILURES = false;
        PX_DEBUG_SOCKET_LEAKS = false;
        PX_DEBUG_SOCKET_ALL = false;
        PX_DEBUG_SOCKETS = false;
        PX_DEBUG_ALL_WDS_FAILS = false;
        PX_DEBUG_SOCKETS_TO_FILE = false;
        PX_VERBOSE_PROPERTY_MERGING = false;
        PX_APP_PROFILES = false;
        PX_RA_HASH_MISMATCH = false;
        PX_PING_WAN_VERBOSE = false;
        PX_TIMEOUT_SESSION_TOKENS = true;
        PX_VERBOSE_RA_POPUPS = true;
        PX_NOTIFY_SUPPORT = true;
        PX_SHOW_DEMO_SESSIONS = true;
        PX_TOLERATE_BADVERSION = false;
        PX_MONITORING_INCOMING = false;
        TERMINAL_VERBOSE = false;
        PX_FORCE_SSL_UPDATE_URL = false;
        PX_SESSION_CLAIMS = false;
        PX_ALERT_SENDING = false;
        PX_ALERT_SAVING_LOADING = false;
        PX_ALERT_TEST_SAVING = false;
        PX_ALERT_LIST = false;
        PX_ALERT_ALLOCATIONS = false;
        PX_ALERT_ALLOCATIONS_ADDS = false;
        PX_TOOLBOX = true;
        PX_ALERT_HASHES = false;
        PX_ALERT_EVENTS = true;
        PX_WS_THREADING = false;
        PX_THREAD_CREATE_CALLBACK = false;
        PX_SHOW_SOCKET_TIMEOUT_STACKTRACE = false;
        PX_PROCESS_SG_POLLS_BY_WAITING_THREADS = false;
        PX_LOW_LIMIT_UPDATES = false;
        PX_MEDIUM_LIMIT_UPDATES = false;
        PX_NO_LIMIT_UPDATES = false;
        PX_FAIL_ALL_UPDATES = false;
        PX_SERIALISE_SECMSG_SETUPS = false;
        PX_LIMIT_SECMSG_SETUPS = false;
        DEBUG_SECMSG_INITIAL_CHAT = true;
        PX_VERBOSE_WTOK = false;
        PX_WTOK_CHECK_EVENTS_VERBOSE = false;
        PX_DEBUG_RENEGOTIATE = false;
        PX_VERBOSE_RECOVERY_KEY = false;
        PX_VERBOSE_MACHINE_POLLING = false;
        PX_LOG_ACCESS = false;
        PX_PREVENT_HEAP_DUMPS = false;
        PX_VERBOSE_RESTART_REQUESTS = false;
        PX_VERBOSE_MACHINE_AUTO_UDPATES = false;
        PX_VERBOSE_MACHINELIST_ON_NOT_FOUND = false;
        PX_VERBOSE_CUSTOMERLIST_ON_NOT_FOUND = false;
        PX_VERBOSE_SCREEN_PNGS = false;
        PX_VERBOSE_UDP_NATHP_RULES = false;
        PX_VERBOSE_UDP_NATHP_RULES_ALLPACKETS = false;
        PX_PREVENT_UPLOAD_ON_UPDATES = false;
        PX_MONITOR_SOCKETS = false;
        ASYNC_VERBOSE = false;
        ASYNC_VERBOSE_RESPONSE = false;
        SERVICES_VERBOSE = false;
        VIDEO_RECORD_VERBOSE = false;
        VIDEO_QUEUE_SIZE = false;
        OOB_LINK_VERBOSE = false;
        GLASS_DIALOGS_VERBOSE = false;
        PRINT_SERVER_CONFIG_ON_SAVE = false;
        LOGGING_ERRORS_VERBOSE = false;
        PRINT_GROUP_CONCURRENCY_LIMITING = false;
        DEBUG_WREG = false;
        ALERT_ROUND_TRIPPING = false;
        ENABLE_NATIVE_HOOKS = true;
        TECH_UI_ACCESS_MODEL = false;
        SHOW_ACCESS_SUBSCRIPTIONS = false;
        GUI_KEY_EVENTS_DEBUG = false;
        GUI_OVERLAYS_DEBUG = false;
        DEBUG_SHOW_RESTART_SERVER_BUTTON = false;
        TOOLBOX_TECH = true;
        ENABLE_SYSTEM_AUDIO_CAPTURE = Switches.SLB_audio;
        ENABLE_AUDIO_TECH_TO_CUST = false;
        ENABLE_AUDIO_CUST_TO_TECH = Switches.SLB_audio;
        PRINT_AUDIO_DEBUG = false;
        SOUND_PLAYER_DEBUG = false;
        VNC_DEBUG_INPUT = false;
        VERBOSE_PING_MESSAGE = false;
        SG_IN_USE_MONITOR_DEBUG = false;
        RA_SHOW_READABLE_MESSAGES = false;
        SG_BANDWIDTH_REPORTING = LocalSwitches.experimental;
        SG_ACCEPT_ALL_CERTS = false;
        SG_TIME_BROADCASTS = false;
        SG_ALERTS = false;
        SG_ALERTS_SGM_PROPAGATION = false;
        SG_ALERTS_HASHES = false;
        SG_ALERTS_MSGS = false;
        SG_ALERTS_SIMULATE_REG_ERROR = false;
        SG_ALERTS_DUMP_STATS = true;
        SG_ADD_FIREWALL_RULES = true;
        SG_ADD_SAFE_MODE_REBOOT_KEY = true;
        SG_POLL_TIMING = false;
        SG_VERBOSE_HTTP_READ = false;
        SG_MONITORING_SOURCE = false;
        SG_ALL_INCOMING_MESSAGES = false;
        SG_SERVICE_SIMULATE_STUCK = false;
        SG_DNS_RESOLUTION_DEBUG = false;
        SG_TEST_RENEGOTIATE_SECMSG_EVERY_TIME = false;
        RENEGOTIATION_TRACING = false;
        TOOLBOX_REPOSITORY = false;
        CHAT_VERBOSE = false;
        PKHASH_PORTION_DEBUGGING = true;
        CAD_ALWAYS_USE_EXE = false;
        CREATE_SYNTHETIC_MACHINES = false;
        fcheck_LOCK = new Object();
        optionalDir = null;
    }

    static class CheckThread
    extends Thread {
        String whoami;
        long lastMod = 0L;
        boolean redirectedStreams = false;
        boolean launchedDebugger = false;
        boolean storeAllLogs = false;
        boolean cheapTiming = false;
        MemTracker memt;
        ThreadTracker tht;
        boolean launchDebugConsole = false;
        boolean launchDebuggerUI = false;
        boolean checkNow = false;
        boolean die = false;

        public CheckThread(boolean checkForUIDeadlock) {
            super("CentralDebugging-CheckThread");
            if (checkForUIDeadlock && !ServerManagement.isServerJVM()) {
                UIDeadlockDetector.start(UIDeadlockDetector.STACKDUMP_ACTION);
            }
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!SILENT) {
                System.out.println("[CentralDebugging] CentralDebugging check thread started");
            }
            try {
                if (!SILENT) {
                    System.out.println(SystemInfo.getFullInfo());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (HEAP_AND_THREAD_DEBUGGING_ALWAYS) {
                System.out.println("[CentralDebugging] Production ongoing memory tracking ON");
                this.memt = new MemTracker();
                this.memt.productionTracking = true;
                this.memt.start();
            } else {
                System.out.println("[CentralDebugging] Production ongoing memory tracking OFF");
            }
            while (!this.die) {
                FileInputStream fin;
                block84: {
                    this.checkNow = false;
                    boolean debugTxtExists = CentralDebugging.debugTxtExistsGetFile() != null;
                    fin = null;
                    try {
                        File debug;
                        if (debugTxtExists && (debug = CentralDebugging.debugTxtExistsGetFile()).exists() && debug.lastModified() != this.lastMod) {
                            String dump;
                            String output;
                            Integer port;
                            String host;
                            int index;
                            Method m;
                            Class<?> c;
                            String conntest;
                            String debugthread;
                            String debugmem;
                            String debugcpu;
                            File debugFile;
                            String cheapTimingProp;
                            this.lastMod = debug.lastModified();
                            Properties props = new Properties();
                            fin = new FileInputStream(debug);
                            props.load(new BufferedInputStream(fin));
                            System.out.println("[CentralDebugging]  applying properties");
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.addAll(props.keySet());
                            Collections.sort(list);
                            for (int i = 0; i < list.size(); ++i) {
                                String key = (String)list.get(i);
                                System.out.println("[CentralDebugging]  (property) " + key + "='" + props.getProperty(key) + "'");
                            }
                            String storeAllLogsProperty = props.getProperty("ALL_LOGS");
                            this.storeAllLogs = storeAllLogsProperty != null ? storeAllLogsProperty.equalsIgnoreCase("yes") : false;
                            String processHealth = props.getProperty("PROCESS_HEALTH");
                            String monitorThreads = props.getProperty("PX_MONITOR_SOCKETS");
                            boolean doIt = false;
                            if (monitorThreads != null) {
                                boolean bl = doIt = monitorThreads.equals("yes") || monitorThreads.equals("on");
                            }
                            if (processHealth != null) {
                                boolean bl = doIt = processHealth.equals("yes") || processHealth.equals("on");
                            }
                            if (doIt) {
                                ThreadCountPrinter.countThreads(10000);
                            } else {
                                ThreadCountPrinter.die();
                            }
                            String showColorConfigurationUI = props.getProperty("SHOW_COLOR_CONFIG_UI");
                            if (showColorConfigurationUI != null && showColorConfigurationUI.equalsIgnoreCase("yes")) {
                                ConfigurableColor.showConfigurationUI();
                            }
                            this.cheapTiming = (cheapTimingProp = props.getProperty("CHEAP_TIMING_TO_STDOUT")) != null ? cheapTimingProp.equalsIgnoreCase("yes") : false;
                            String launchdebugger = props.getProperty("LAUNCH_DEBUGGER");
                            if ((this.launchDebuggerUI || launchdebugger != null) && (this.launchDebuggerUI || launchdebugger.equalsIgnoreCase("yes")) && !this.launchedDebugger) {
                                this.launchedDebugger = true;
                                debugFile = debug;
                                new Thread(){

                                    @Override
                                    public void run() {
                                        if (!CheckThread.this.launchDebuggerUI) {
                                            try {
                                                Thread.sleep(2000L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        try {
                                            Constructor<?> con = Class.forName("com.aem.CentralDebugger").getConstructor(String.class, String.class, Boolean.TYPE);
                                            Object obj = con.newInstance(debugFile.getAbsoluteFile().getCanonicalFile().getParentFile().getCanonicalPath(), CheckThread.this.whoami, Boolean.FALSE);
                                            PrintStream ps = (PrintStream)Class.forName("com.aem.CentralDebugger").getDeclaredMethod("getPrintStream", new Class[0]).invoke(obj, new Object[0]);
                                            CheapTimingPrintStream ctp = new CheapTimingPrintStream((OutputStream)ps);
                                            if (Switches.SH_1559_centralClockStdout) {
                                                ctp.setProvider((CheapTimingProvider)new OneClock());
                                            }
                                            dp.addThroughStream((PrintStream)ctp);
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    }
                                }.start();
                            }
                            launchdebugger = props.getProperty("LAUNCH_CONSOLE");
                            if ((this.launchDebugConsole || launchdebugger != null) && (this.launchDebugConsole || launchdebugger.equalsIgnoreCase("yes")) && !this.launchedDebugger) {
                                this.launchedDebugger = true;
                                debugFile = debug;
                                new Thread(){

                                    @Override
                                    public void run() {
                                        if (!CheckThread.this.launchDebugConsole) {
                                            try {
                                                Thread.sleep(2000L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        try {
                                            Constructor<?> con = Class.forName("com.aem.CentralDebugger").getConstructor(String.class, String.class, Boolean.TYPE);
                                            Object obj = con.newInstance(debugFile.getAbsoluteFile().getCanonicalFile().getParentFile().getCanonicalPath(), CheckThread.this.whoami, Boolean.TRUE);
                                            PrintStream ps = (PrintStream)Class.forName("com.aem.CentralDebugger").getDeclaredMethod("getPrintStream", new Class[0]).invoke(obj, new Object[0]);
                                            CheapTimingPrintStream ctp = new CheapTimingPrintStream((OutputStream)ps);
                                            if (Switches.SH_1559_centralClockStdout) {
                                                ctp.setProvider((CheapTimingProvider)new OneClock());
                                            }
                                            dp.addThroughStream((PrintStream)ctp);
                                        }
                                        catch (Throwable t) {
                                            t.printStackTrace();
                                        }
                                    }
                                }.start();
                            }
                            if ((debugcpu = props.getProperty("SAMPLING_PROFILER")) != null) {
                                try {
                                    SAMPLING_PROFILER = Integer.parseInt(debugcpu.trim());
                                    if (SAMPLING_PROFILER > 0) {
                                        System.out.println("[SamplingProfiler] Starting sampling profiler at " + System.currentTimeMillis() + ", will run for " + SAMPLING_PROFILER + " secs");
                                        new SamplingProfilerThread(SAMPLING_PROFILER).start();
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if ((debugmem = props.getProperty("PRINT_MEMORY_USAGE")) != null && !debugmem.equalsIgnoreCase("no") && !debugmem.equalsIgnoreCase("false")) {
                                try {
                                    if (this.memt == null) {
                                        System.out.println("[CentralDebugging] Launching ongoing debug memory tracking, will dump heap on breaches (file: ShHeapDump)");
                                        this.memt = new MemTracker();
                                        this.memt.productionTracking = false;
                                        this.memt.start();
                                    } else {
                                        this.memt.productionTracking = false;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if ((debugthread = props.getProperty("PRINT_THREAD_USAGE")) != null) {
                                try {
                                    long dumpEveryMS = 120000L;
                                    try {
                                        dumpEveryMS = Integer.parseInt(debugthread) * 1000;
                                    }
                                    catch (NumberFormatException ex) {
                                        ex.printStackTrace();
                                    }
                                    if (this.tht == null) {
                                        System.out.println("[CentralDebugging] Launching ongoing thread tracking");
                                        this.tht = new ThreadTracker(dumpEveryMS);
                                        this.tht.start();
                                    } else {
                                        this.tht.dumpEveryMS = dumpEveryMS;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if ((conntest = props.getProperty("DIAGNOSE_CONNECTION")) != null) {
                                try {
                                    c = Class.forName("com.aem.shelp.util.SHelpNodelinkConnector");
                                    m = c.getDeclaredMethod("diagnoseConnectionIssues", String.class, Integer.TYPE, Boolean.TYPE);
                                    index = conntest.indexOf(58);
                                    host = conntest.substring(0, index);
                                    port = new Integer(conntest.substring(index + 1));
                                    System.out.println("[CentralDebugging]  --- Performing connection diagnosis ---");
                                    output = (String)m.invoke(null, host, port, new Boolean(false));
                                    System.out.println("[CentralDebugging]  --- BEGIN CONNECTION DIAGNOSIS ---");
                                    System.out.println(output);
                                    System.out.println("[CentralDebugging]  --- END CONNECTION DIAGNOSIS ---");
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if ((conntest = props.getProperty("DIAGNOSE_CONNECTION_EXTENDED")) != null) {
                                try {
                                    c = Class.forName("com.aem.shelp.util.SHelpNodelinkConnector");
                                    m = c.getDeclaredMethod("diagnoseConnectionIssues", String.class, Integer.TYPE, Boolean.TYPE);
                                    index = conntest.indexOf(58);
                                    host = conntest.substring(0, index);
                                    port = new Integer(conntest.substring(index + 1));
                                    System.out.println("[CentralDebugging]  --- Performing extended connection diagnosis ---");
                                    output = (String)m.invoke(null, host, port, new Boolean(true));
                                    System.out.println("[CentralDebugging]  --- BEGIN CONNECTION DIAGNOSIS ---");
                                    System.out.println(output);
                                    System.out.println("[CentralDebugging]  --- END CONNECTION DIAGNOSIS ---");
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            if ((dump = props.getProperty("STACKDUMP")) != null && dump.equalsIgnoreCase("yes")) {
                                File output2 = new File(debug.getAbsoluteFile().getCanonicalFile().getParentFile().getCanonicalPath(), "stackdump_" + this.whoami + "_" + System.currentTimeMillis() + ".txt");
                                StringBuffer sb = new StringBuffer();
                                try {
                                    Method method = Thread.class.getMethod("getAllStackTraces", new Class[0]);
                                    Map map = (Map)method.invoke(null, new Object[0]);
                                    Object[] keys = map.keySet().toArray();
                                    for (int i = 0; i < keys.length; ++i) {
                                        Thread th = (Thread)keys[i];
                                        StackTraceElement[] stack = (StackTraceElement[])map.get(th);
                                        sb.append("(id " + CentralDebugging.getThreadID(th) + ") " + th.getName() + "\n");
                                        for (int k = 0; k < stack.length; ++k) {
                                            sb.append("\tat " + stack[k] + "\n");
                                        }
                                        sb.append("\n");
                                    }
                                    System.out.println("[CentralDebugging]  --- BEGIN CONDENSED STACKDUMP ---");
                                    CentralDebugging.dumpCondensedCompleteThreadStacks(null);
                                    System.out.println("[CentralDebugging]  --- BEGIN FULL STACKDUMP ---");
                                    System.out.println(sb.toString());
                                    System.out.println("[CentralDebugging]  --- END STACKDUMP ---");
                                    CentralDebugging.dumpCondensedCompleteThreadStacks(output2);
                                    System.out.println("[CentralDebugging]  captured stackdump to " + output2);
                                }
                                catch (NoSuchMethodException t) {
                                    System.out.println("[CentralDebugging]  unable to perform stackdump - JVM version must be 1.5 or above");
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                            Field[] fields = CentralDebugging.class.getFields();
                            for (int i = 0; i < fields.length; ++i) {
                                try {
                                    String name = fields[i].getName();
                                    String value = props.getProperty(name);
                                    if (value == null) continue;
                                    if (fields[i].getType() == String.class) {
                                        System.out.println("[CentralDebugging]  setting " + name + " to string " + value);
                                        fields[i].set(null, value);
                                        continue;
                                    }
                                    try {
                                        int N = Integer.parseInt(value);
                                        System.out.println("[CentralDebugging]  setting " + name + " to integer " + N);
                                        fields[i].set(null, new Integer(N));
                                    }
                                    catch (NumberFormatException x) {
                                        try {
                                            double D = Double.parseDouble(value);
                                            fields[i].set(null, new Double(D));
                                            System.out.println("[CentralDebugging]  setting " + name + " to double " + D);
                                        }
                                        catch (NumberFormatException xx) {
                                            if (value.trim().equalsIgnoreCase("yes")) {
                                                System.out.println("[CentralDebugging]  setting " + name + " ON");
                                                fields[i].set(null, Boolean.TRUE);
                                                continue;
                                            }
                                            System.out.println("[CentralDebugging]  setting " + name + " OFF");
                                            fields[i].set(null, Boolean.FALSE);
                                        }
                                    }
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            CentralDebugging.applyDebugSettings();
                        }
                        if (this.redirectedStreams) break block84;
                        try {
                            if (!debugTxtExists) break block84;
                            this.redirectedStreams = true;
                            DEBUGGING_ON = true;
                            if (this.storeAllLogs) {
                                if (new File("debug.txt").exists()) {
                                    logPath = "." + File.separator + "debug_" + this.whoami + "_" + System.currentTimeMillis() + ".log";
                                } else if (new File(".." + File.separator + ".." + File.separator + "debug.txt").exists()) {
                                    logPath = ".." + File.separator + ".." + File.separator + "debug_" + this.whoami + "_" + System.currentTimeMillis() + ".log";
                                } else if (optionalDir != null && new File(optionalDir, "debug.txt").exists()) {
                                    logPath = optionalDir.getCanonicalPath() + File.separator + ".." + File.separator + "debug_" + this.whoami + "_" + System.currentTimeMillis() + ".log";
                                }
                            } else {
                                int count;
                                if (new File("debug.txt").exists()) {
                                    logPath = "." + File.separator + "debug_" + this.whoami;
                                } else if (new File(".." + File.separator + ".." + File.separator + "debug.txt").exists()) {
                                    logPath = ".." + File.separator + ".." + File.separator + "debug_" + this.whoami;
                                } else if (optionalDir != null && new File(optionalDir, "debug.txt").exists()) {
                                    logPath = optionalDir.getCanonicalPath() + File.separator + ".." + File.separator + "debug_" + this.whoami;
                                }
                                String newPath = logPath + ".log";
                                for (count = 1; !this.canWrite(newPath) && count < 100; ++count) {
                                    newPath = logPath + "_" + count + ".log";
                                }
                                if (count == 100) {
                                    newPath = logPath + "_" + System.currentTimeMillis() + ".log";
                                }
                                logPath = newPath;
                            }
                            if (logPath == null) break block84;
                            if (!SILENT) {
                                System.out.println("[CentralDebugging] CentralDebugging redirecting all output to " + new File(logPath).getAbsoluteFile().getCanonicalPath());
                            }
                            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(logPath)));
                            if (this.cheapTiming && !CheapTimingPrintStream.usedForStdout && !(System.out instanceof CheapTimingPrintStream)) {
                                CheapTimingPrintStream.usedForStdout = true;
                                dp = new DualPrintstream();
                                dp.addThroughStream((PrintStream)new CheapTimingPrintStream((OutputStream)System.out));
                                dp.addDateStream(pout);
                            } else {
                                dp = new DualPrintstream();
                                dp.addThroughStream(System.out);
                                dp.addDateStream(pout);
                            }
                            Object object = PRINTSTREAM_LOCK;
                            synchronized (object) {
                                if (currentTaggedOutputStream != null) {
                                    currentTaggedOutputStream.setEnabled(false);
                                }
                                if (currentTaggedErrorStream != null) {
                                    currentTaggedErrorStream.setEnabled(false);
                                }
                                currentTaggedOutputStream = new TaggedPrintStream(dp.addOutputStream());
                                currentTaggedErrorStream = new TaggedPrintStream(dp.addOutputStream());
                                System.setOut(currentTaggedOutputStream);
                                System.setErr(currentTaggedErrorStream);
                            }
                        }
                        catch (Exception xx) {
                            xx.printStackTrace();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    FileUtil.robustClose(fin);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    for (long T = 0L; T < 15000L && !this.checkNow; T += 25L) {
                        Thread.sleep(25L);
                        if (!this.die) continue;
                        return;
                    }
                }
                catch (Exception exception) {
                }
            }
        }

        private boolean canWrite(String newPath) {
            try {
                File targetFile = new File(newPath);
                FileOutputStream fout = new FileOutputStream(targetFile);
                fout.write(new String("\n").getBytes());
                fout.flush();
                fout.close();
                return targetFile.length() != 0L;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }

    static class DebugLoader
    extends Thread {
        String whoami;
        private boolean checkForUIDeadlock;

        public DebugLoader(String who, boolean checkForUIDeadlock) {
            super("CentralDebugging-DebugLoader");
            this.whoami = who;
            this.checkForUIDeadlock = checkForUIDeadlock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = fcheck_LOCK;
            synchronized (object) {
                if (ct == null) {
                    if (pct != null) {
                        pct.die();
                        try {
                            pct.join();
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            System.out.println("[CentralDebugging] Couldn't join PCT");
                            return;
                        }
                    }
                    try {
                        if (!SILENT) {
                            System.out.println("[CentralDebugging] Loading Debug Settings for " + this.whoami);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!SILENT) {
                            System.out.println("[CentralDebugging] checking properties in " + new File(".").getAbsoluteFile().getCanonicalPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (!SILENT) {
                            System.out.println("[CentralDebugging] checking properties in " + new File(".." + File.separator + ".." + File.separator).getAbsoluteFile().getCanonicalPath());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ct = new CheckThread(this.checkForUIDeadlock);
                    ct.whoami = this.whoami;
                    ct.start();
                }
            }
        }
    }

    static class MemTracker
    extends Thread {
        boolean SIMULATE_LEAK = false;
        boolean productionTracking = false;
        boolean productionDumped = false;
        int nextThreadDump = 500;
        double peakUsedPc = 0.0;

        public MemTracker() {
            super("CentralDebugging-MemTracker");
        }

        @Override
        public void run() {
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            DecimalFormat df = new DecimalFormat("###,###,###,###,##0");
            DecimalFormat df2 = new DecimalFormat("###,###,###,###,##0.0");
            Runtime rt = Runtime.getRuntime();
            ArrayList<byte[]> leak = new ArrayList<byte[]>();
            long nextPrint = System.currentTimeMillis() + 60000L;
            int step = 0;
            int[] thresholds = new int[]{50, 80, 90, 95, 98};
            block6: while (true) {
                try {
                    while (true) {
                        int currentThreshold;
                        int FREQ;
                        if (this.productionTracking) {
                            Thread.sleep(1000L);
                            FREQ = 300000;
                        } else {
                            Thread.sleep(500L);
                            FREQ = 5000;
                        }
                        if (this.SIMULATE_LEAK) {
                            leak.add(new byte[5000000]);
                        }
                        double total = rt.totalMemory();
                        double free = rt.freeMemory();
                        double max = rt.maxMemory();
                        double used = total - free;
                        double usedPc = 100.0 / max * used;
                        double threads = bean.getThreadCount();
                        if (System.currentTimeMillis() > nextPrint) {
                            String peak = "";
                            if (usedPc > this.peakUsedPc) {
                                this.peakUsedPc = usedPc;
                                peak = " (^NewPeak " + df2.format(this.peakUsedPc) + ")";
                            }
                            System.out.println("[MemoryTracking2] Threads = " + (int)threads + ", Used Memory = " + df.format(used) + " (" + df2.format(usedPc) + "% of " + df.format(max) + ")" + peak);
                            nextPrint = System.currentTimeMillis() + (long)FREQ;
                        }
                        if (threads > (double)this.nextThreadDump) {
                            System.out.println("[MemoryTracking2] Threads = " + (int)threads + ", Used Memory = " + df.format(used) + " (" + df2.format(usedPc) + "% of " + df.format(max) + ")");
                            System.out.println("[MemoryTracking2] ***IMPORTANT*** Breached production thread threshold, will dump threads now, please send this log file to SimpleHelp Support");
                            File dump = new File(CentralDebugging.getFilePathInSameDirAsLog("ShThreadDump-" + this.nextThreadDump + ".txt"));
                            CentralDebugging.dumpCondensedCompleteThreadStacks(dump);
                            ZipUtils.zipSingleFile(dump, true);
                            this.nextThreadDump += 250;
                        }
                        if (this.productionTracking) {
                            if (!(usedPc > 90.0) || this.productionDumped || PX_PREVENT_HEAP_DUMPS || OS.isLinux()) continue;
                            this.productionDumped = true;
                            System.out.println("[MemoryTracking2] Threads = " + (int)threads + ", Used Memory = " + df.format(used) + " (" + df2.format(usedPc) + "% of " + df.format(max) + ")");
                            System.out.println("[MemoryTracking2] ***IMPORTANT*** Breached production memory threshold, will dump heap now, please send the file ShHeapDump-PP in to SimpleHelp Support");
                            String heapName = "ShHeapDump-PP";
                            try {
                                System.out.println("[MemoryTracking] Dumping heap to file [" + heapName + "] now");
                                heapName = (String)Class.forName("utils.progtools.HeapDumper").getMethod("dumpHeap", String.class, Boolean.TYPE).invoke(null, CentralDebugging.getFilePathInSameDirAsLog("temp_partial_hdump"), Boolean.TRUE);
                                new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)).delete();
                                new File(CentralDebugging.getFilePathInSameDirAsLog("temp_partial_hdump.hprof")).renameTo(new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)));
                                ZipUtils.zipSingleFile(new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)), true);
                                continue block6;
                            }
                            catch (Throwable t) {
                                System.out.println("[MemoryTracking] Unable to dump heap " + heapName + ": " + t);
                                t.printStackTrace();
                                continue;
                            }
                        }
                        if (step >= thresholds.length || !(usedPc > (double)(currentThreshold = thresholds[step]))) continue;
                        System.out.println("[MemoryTracking2] ***IMPORTANT*** Breached memory threshold " + currentThreshold + "%, will dump heap now");
                        String heapName = "ShHeapDump-" + currentThreshold;
                        try {
                            System.out.println("[MemoryTracking] Dumping heap to file [" + heapName + "] now");
                            heapName = (String)Class.forName("utils.progtools.HeapDumper").getMethod("dumpHeap", String.class, Boolean.TYPE).invoke(null, CentralDebugging.getFilePathInSameDirAsLog("temp_partial_hdump"), Boolean.TRUE);
                            new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)).delete();
                            new File(CentralDebugging.getFilePathInSameDirAsLog("temp_partial_hdump.hprof")).renameTo(new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)));
                            ZipUtils.zipSingleFile(new File(CentralDebugging.getFilePathInSameDirAsLog(heapName)), true);
                        }
                        catch (Throwable t) {
                            System.out.println("[MemoryTracking] Unable to dump heap " + heapName + ": " + t);
                            t.printStackTrace();
                        }
                        ++step;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    static class SamplingProfilerThread
    extends Thread {
        int seconds;

        public SamplingProfilerThread(int secs) {
            this.seconds = secs;
        }

        @Override
        public void run() {
            SamplingProfiler profiler = new SamplingProfiler();
            profiler.startSampling(50);
            try {
                Thread.sleep(this.seconds * 1000);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            profiler.stopSampling();
            profiler.dump(1.0);
            try {
                File file = new File("sampling_profiler_" + System.currentTimeMillis() + ".txt");
                System.out.println("[SamplingProfiler] Writing profiler results to " + file.getCanonicalPath());
                FileUtil.writeFileAsString((File)file, (String)profiler.dumpToString(1.0));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static class ThreadTracker
    extends Thread {
        long dumpEveryMS;

        public ThreadTracker(long dumpMS) {
            super("CentralDebugging-ThreadTracker");
            this.dumpEveryMS = dumpMS;
        }

        @Override
        public void run() {
            long nextDump = System.currentTimeMillis();
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (System.currentTimeMillis() < nextDump) continue;
                    nextDump = System.currentTimeMillis() + this.dumpEveryMS;
                    CentralDebugging.dumpCondensedCompleteThreadStacks(null);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

