/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.dialog.glassdialog;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.KeyEventDispatcher;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.customlaf.SHInternalFrameUI;
import utils.swing.customlaf.ScaledFlowLayout;

public class GlassDialog {
    public static Object glass_LOCK = new Object();
    public static GlassDialog currentlyShowingGlassDialog = null;
    protected RootPaneContainer src_rootPane = null;
    private boolean modal = false;
    private boolean centerOnScreen = true;
    private boolean keepCentered = true;
    private String dialogTitle = "";
    protected boolean showDecoration = true;
    protected JDesktopPane desktopPane;
    protected JInternalFrame internalFrame;
    protected JComponent focusComponent = null;
    boolean ignoreVis = false;
    Object notifier = new Object();
    private boolean DEBUG = false;
    private int blockCount = 0;
    private BlockMouse blockMouse = new BlockMouse();
    private BlockKeys blockKeys = new BlockKeys();

    public JInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public GlassDialog(RootPaneContainer rootPane, int w, int h, boolean modal, boolean makeVisible, final boolean tint) {
        this.src_rootPane = rootPane;
        if (this.src_rootPane == null) {
            new Exception("GlassDialog Null Rootpane").printStackTrace();
        }
        this.modal = modal;
        if (rootPane instanceof Component) {
            rootPane.getContentPane().addComponentListener(new ResizeListener());
        }
        this.desktopPane = new JDesktopPane(){

            @Override
            public boolean isOpaque() {
                return tint;
            }

            @Override
            public void paint(Graphics g) {
                GlassDialog.this.src_rootPane.getContentPane().paint(g);
                super.paint(g);
            }
        };
        if (tint) {
            this.desktopPane.setOpaque(true);
            this.desktopPane.setBackground(new Color(100, 100, 100, 30));
        } else {
            this.desktopPane.setOpaque(false);
        }
        if (modal) {
            this.desktopPane.addMouseListener(this.blockMouse);
        }
        this.internalFrame = new JInternalFrame();
        this.setShowDecoration(this.showDecoration);
        this.internalFrame.setBounds(0, 0, w, h);
        if (makeVisible) {
            this.init(false);
        }
    }

    public void repaint() {
        this.internalFrame.repaint();
    }

    public void setFocusComponent(final JComponent focusComponent) {
        this.focusComponent = focusComponent;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (focusComponent != null) {
                    focusComponent.requestFocusInWindow();
                }
            }
        });
    }

    public void setCenterOnScreen(boolean b, boolean keepCentered) {
        this.centerOnScreen = b;
        this.keepCentered = keepCentered;
    }

    protected boolean showDecoration() {
        return this.showDecoration;
    }

    public void setShowDecoration(boolean showDecoration) {
        this.showDecoration = showDecoration;
        try {
            ((SHInternalFrameUI)this.internalFrame.getUI()).setDecorated(this.showDecoration());
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public String getTitle() {
        return this.dialogTitle;
    }

    public void setResizeable(boolean resize) {
        this.internalFrame.setResizable(resize);
    }

    public void initAndPack() {
        this.init(true);
    }

    public void pack() {
        try {
            this.internalFrame.pack();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWidth() {
        return this.internalFrame.getBounds().width;
    }

    public void setHeight(int height) {
        this.internalFrame.setSize(this.internalFrame.getWidth(), height);
    }

    public void setWidth(int width) {
        this.internalFrame.setSize(width, this.internalFrame.getHeight());
    }

    public void setSize(int width, int height) {
        this.internalFrame.setSize(width, height);
    }

    public int getHeight() {
        return this.internalFrame.getBounds().height;
    }

    public void setLocation(int x, int y) {
        this.internalFrame.setLocation(x, y);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.internalFrame.setBounds(x, y, w, h);
    }

    public void init(boolean pack) {
        this.internalFrame.setClosable(false);
        this.internalFrame.setIconifiable(false);
        this.internalFrame.setFrameIcon(null);
        this.internalFrame.setVisible(true);
        this.internalFrame.setOpaque(false);
        try {
            this.internalFrame.setTitle(this.getTitle());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.desktopPane.add(this.internalFrame);
        try {
            this.internalFrame.setSelected(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (pack) {
            try {
                this.internalFrame.pack();
                Rectangle r = this.internalFrame.getBounds();
                if (r.width < 300) {
                    r.width = 300;
                }
                if (r.height < 130) {
                    r.height = 130;
                }
                r.x -= 25;
                r.width += 50;
                if (r.x < 0) {
                    r.x = 0;
                }
                if (r.y < 0) {
                    r.y = 0;
                }
                this.internalFrame.setBounds(r);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.centerOnScreen) {
            try {
                this.updateBoundsForCenteredOnScreen();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalFrame.getContentPane().setLayout(new GridLayout(1, 1));
    }

    protected void updateBoundsForCenteredOnScreen() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle r = GlassDialog.this.internalFrame.getBounds();
                Rectangle s = GlassDialog.this.src_rootPane.getContentPane().getBounds();
                int wo2 = r.width / 2;
                int ho2 = r.height / 2;
                GlassDialog.this.internalFrame.setBounds(new Rectangle(s.width / 2 - wo2, s.height / 2 - ho2, r.width, r.height));
                GlassDialog.this.desktopPane.setBounds(GlassDialog.this.src_rootPane.getLayeredPane().getBounds());
                ((Component)((Object)GlassDialog.this.src_rootPane)).repaint();
            }
        });
    }

    public Container getContentPane() {
        return this.internalFrame.getContentPane();
    }

    public void setFrameIcon(Icon icon) {
        this.internalFrame.setFrameIcon(icon);
    }

    public boolean isVisible() {
        return this.desktopPane.isVisible();
    }

    public void setModal(boolean modal) {
        if (!this.isVisible()) {
            this.modal = modal;
        }
    }

    public void setTitle(String title) {
        this.dialogTitle = title;
        if (this.internalFrame != null) {
            this.internalFrame.setTitle(title);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void setVisible(boolean vis) {
        this.setVisible(vis, true);
    }

    public static void clearAllGlassDialogs() {
        try {
            if (currentlyShowingGlassDialog != null) {
                System.out.println("[GlassDialog] Removing old glass dialog");
                currentlyShowingGlassDialog.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setFocus() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GlassDialog.this.setFocus();
                }
            });
        }
        try {
            if (this.focusComponent != null) {
                this.focusComponent.requestFocusInWindow();
            }
            if (this.focusComponent != null) {
                this.focusComponent.grabFocus();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean isVisible, boolean block) {
        Object layeredPane;
        if (isVisible) {
            this.updateBoundsForCenteredOnScreen();
        }
        if (this.DEBUG) {
            System.out.println("GlassDialog: setting super visible");
        }
        this.desktopPane.setVisible(isVisible);
        if (this.DEBUG) {
            System.out.println("GlassDialog: set super visible");
        }
        if (this.ignoreVis) {
            if (this.DEBUG) {
                System.out.println("GlassDialog: ignoring visible");
            }
            return;
        }
        if (isVisible) {
            Object object = glass_LOCK;
            synchronized (object) {
                if (currentlyShowingGlassDialog != null && currentlyShowingGlassDialog != this) {
                    try {
                        currentlyShowingGlassDialog.setVisible(false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (this.modal) {
                this.block(true);
            }
            if (this.src_rootPane instanceof JInternalFrame) {
                new Exception("***WARNING*** GlassDialog being used on JInternalFrame, incorrect RPC being passed in?").printStackTrace();
            }
            layeredPane = this.src_rootPane.getLayeredPane();
            ((Container)layeredPane).add((Component)this.desktopPane, JLayeredPane.MODAL_LAYER);
            this.setFocus();
            currentlyShowingGlassDialog = this;
        } else {
            this.ignoreVis = true;
            layeredPane = glass_LOCK;
            synchronized (layeredPane) {
                if (currentlyShowingGlassDialog == this) {
                    currentlyShowingGlassDialog = null;
                }
            }
            layeredPane = this.src_rootPane.getLayeredPane();
            ((Container)layeredPane).remove(this.desktopPane);
            ((Component)layeredPane).repaint();
            this.ignoreVis = false;
            if (this.modal) {
                this.block(false);
            }
        }
        try {
            this.internalFrame.setSelected(true);
        }
        catch (Exception layeredPane2) {
            // empty catch block
        }
        if (isVisible) {
            this.setFocus();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GlassDialog.this.desktopPane.repaint();
            }
        });
        if (this.modal && !isVisible) {
            layeredPane = this.notifier;
            synchronized (layeredPane) {
                this.notifier.notifyAll();
            }
        }
        if (this.modal && isVisible) {
            if (block) {
                if (SwingUtilities.isEventDispatchThread()) {
                    EventQueue theQueue = this.desktopPane.getToolkit().getSystemEventQueue();
                    int consecutiveInterrupts = 0;
                    while (this.isVisible()) {
                        try {
                            AWTEvent event = theQueue.getNextEvent();
                            Object src = event.getSource();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)((Object)event)).dispatch();
                                continue;
                            }
                            if (src instanceof Component) {
                                ((Component)src).dispatchEvent(event);
                                continue;
                            }
                            if (src instanceof MenuComponent) {
                                ((MenuComponent)src).dispatchEvent(event);
                                continue;
                            }
                            System.err.println("unable to dispatch event: " + event);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            ++consecutiveInterrupts;
                            try {
                                Thread.sleep(50L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (consecutiveInterrupts != 10) continue;
                            e.printStackTrace();
                            return;
                        }
                    }
                } else {
                    int consecutiveErrors = 0;
                    while (this.isVisible()) {
                        Object object = this.notifier;
                        synchronized (object) {
                            block48: {
                                try {
                                    this.notifier.wait();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    ++consecutiveErrors;
                                    try {
                                        Thread.sleep(50L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (consecutiveErrors != 10) break block48;
                                    e.printStackTrace();
                                    return;
                                }
                            }
                        }
                    }
                }
            } else {
                EventThread th = new EventThread();
                th.start();
            }
        }
    }

    public void block(boolean block) {
        if (block) {
            if (this.blockCount == 0) {
                FocusManager.getCurrentManager().addKeyEventDispatcher(this.blockKeys);
            }
            ++this.blockCount;
        } else {
            --this.blockCount;
            if (this.blockCount == 0) {
                FocusManager.getCurrentManager().removeKeyEventDispatcher(this.blockKeys);
            }
        }
    }

    public boolean isBlocked() {
        return this.blockCount > 0;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setBounds(0, 0, 640, 480);
        JPanel colory = new JPanel();
        colory.setBackground(Color.BLUE);
        colory.setLayout(new ScaledFlowLayout(2));
        colory.add(new JTextField("THIS SHOULD BE BLOCKED"));
        colory.add(new JButton("THIS TOO"));
        frame.setContentPane(colory);
        frame.setVisible(true);
        GlassDialog gd = new GlassDialog(frame, 450, 450, true, true, true);
        JComboBox<String> jComboBox = new JComboBox<String>(new String[]{"A", "B", "C"});
        gd.getContentPane().setLayout(new GridLayout(3, 3));
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(jComboBox);
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        gd.getContentPane().add(new JPanel());
        frame.repaint();
        Thread.sleep(1000L);
        gd.setTitle("TEST TITLE");
        System.out.println("Making glass dialog visible");
        gd.setVisible(true);
        Thread.sleep(6000L);
        System.out.println("Making glass dialog visible");
        gd.setVisible(false);
    }

    class ResizeListener
    implements ComponentListener {
        ResizeListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (GlassDialog.this.centerOnScreen && GlassDialog.this.keepCentered) {
                try {
                    GlassDialog.this.updateBoundsForCenteredOnScreen();
                    ((Component)((Object)GlassDialog.this.src_rootPane)).repaint();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    private class BlockMouse
    extends MouseAdapter {
        private BlockMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            System.out.println("[GlassDialog] Modal dialog consumed mouse event.");
        }
    }

    private class BlockKeys
    implements KeyEventDispatcher {
        private BlockKeys() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent ev) {
            Component source = ev.getComponent();
            Component parentSource = SwingUtilities.getRoot(source);
            Component parentDesktop = SwingUtilities.getRoot(GlassDialog.this.desktopPane);
            if (source != null && !SwingUtilities.isDescendingFrom(source, GlassDialog.this.desktopPane) && parentSource == parentDesktop) {
                System.out.println("[GlassDialog] Consume event from " + source);
                ev.consume();
                return true;
            }
            return false;
        }
    }

    class EventThread
    extends Thread {
        EventThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = GlassDialog.this.desktopPane.getToolkit().getSystemEventQueue();
                int consecutiveInterrupts = 0;
                while (GlassDialog.this.isVisible()) {
                    try {
                        AWTEvent event = theQueue.getNextEvent();
                        Object src = event.getSource();
                        if (event instanceof ActiveEvent) {
                            ((ActiveEvent)((Object)event)).dispatch();
                            continue;
                        }
                        if (src instanceof Component) {
                            ((Component)src).dispatchEvent(event);
                            continue;
                        }
                        if (src instanceof MenuComponent) {
                            ((MenuComponent)src).dispatchEvent(event);
                            continue;
                        }
                        System.err.println("unable to dispatch event: " + event);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        ++consecutiveInterrupts;
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (consecutiveInterrupts != 10) continue;
                        e.printStackTrace();
                        return;
                    }
                }
            } else {
                int consecutiveInterrupts = 0;
                while (GlassDialog.this.isVisible()) {
                    Object object = GlassDialog.this.notifier;
                    synchronized (object) {
                        block18: {
                            try {
                                GlassDialog.this.notifier.wait();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                ++consecutiveInterrupts;
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                if (consecutiveInterrupts != 10) break block18;
                                e.printStackTrace();
                                return;
                            }
                        }
                    }
                }
            }
        }
    }
}

