/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.validators;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import utils.swing.cui.validators.Validator;

public class RequiredValidator
extends Validator {
    private boolean isRequired;
    public static final RequiredValidator REQUIRED_INSTANCE = new RequiredValidator(true);

    public RequiredValidator(boolean isRequired) {
        this.isRequired = isRequired;
    }

    @Override
    public String getValidatorID() {
        return "required";
    }

    @Override
    public String toXML() {
        return "<Validator type=\"" + this.getValidatorID() + "\">" + Boolean.toString(this.isRequired) + "</Validator>";
    }

    @Override
    public boolean isValid(JComponent component) {
        String contents;
        Component[] children;
        Component[] componentArray;
        int n;
        int n2;
        if (!this.isRequired) {
            return true;
        }
        if (component instanceof RequiredValidatable) {
            return ((RequiredValidatable)((Object)component)).isRequiredValid();
        }
        if (component instanceof JPanel && (n2 = 0) < (n = (componentArray = (children = component.getComponents())).length)) {
            Component c = componentArray[n2];
            return !(c instanceof JComponent) || this.isValid((JComponent)c);
        }
        if (component instanceof JScrollPane) {
            JViewport viewport = ((JScrollPane)component).getViewport();
            component = (JComponent)viewport.getView();
        }
        if (component instanceof JTextField) {
            contents = ((JTextField)component).getText();
            if (contents.length() > 0) {
                return true;
            }
        } else if (component instanceof JTextArea) {
            contents = ((JTextArea)component).getText();
            if (contents.length() > 0) {
                return true;
            }
        } else if (component instanceof JLabel) {
            contents = ((JLabel)component).getText();
            if (contents.length() > 0) {
                return true;
            }
        } else {
            System.out.println("[RequiredValidator] Don't know how to validate an instance of " + component.getClass().toString());
            return true;
        }
        return false;
    }

    public static interface RequiredValidatable {
        public boolean isRequiredValid();
    }
}

