/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.cui.types.fields;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.validators.Validator;
import utils.swing.customlaf.SHUI;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.RelativeLayout;
import utils.xml.XML14Util;

public abstract class AbstractField
implements CUIField {
    public static final int WIDTH_PERCENTAGE_PREFERRED_SIZE = 1;
    protected ArrayList<Validator> validators = new ArrayList();
    protected String label;
    protected int widthPercentage = 100;
    private ChangeListener changeListener;
    protected ProxyChangeListener proxyChangeListener = new ProxyChangeListener();
    protected String ID;
    protected int subType;
    private JPanel emptyPanel;
    private JPanel innerPanel;
    private JLabel unitsLabel;
    private JLabel jLabel;
    protected String displayLabel;
    private String units;
    private Insets layoutInsets = null;

    public void setVisible(boolean visible) {
        this.getComponent().setVisible(visible);
        this.innerPanel.setVisible(visible);
        if (this.unitsLabel != null) {
            this.unitsLabel.setVisible(visible);
        }
        this.jLabel.setVisible(visible);
    }

    public AbstractField(String ID, String label, ChangeListener changeListener) {
        this(ID, -1, label, changeListener);
    }

    public AbstractField(String ID, int subType, String label, ChangeListener changeListener) {
        this.ID = ID;
        this.label = label;
        this.changeListener = changeListener;
        this.setSubType(subType);
        this.initAbstractUI();
    }

    protected boolean renderLabel() {
        return true;
    }

    public abstract JComponent getComponent();

    protected void initComponent() {
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int anyType) {
        this.subType = anyType;
        this.initComponent();
        this.initValidatorsForSubType();
    }

    protected void initValidatorsForSubType() {
    }

    @Override
    public String toXML(int tabs) {
        String sub;
        StringBuffer buffer = new StringBuffer();
        buffer.append(XML14Util.getIndent(tabs)).append("<CUIField type=\"" + this.ID + "\" ");
        if (this.subType != -1 && (sub = this.subTypeToName()) != null) {
            buffer.append("subType=\"" + sub + "\" ");
        }
        buffer.append("width=\"" + this.widthPercentage + "\" label=\"" + XML14Util.escape(this.label) + "\">\n");
        this.toXML(buffer, tabs + 1);
        buffer.append(XML14Util.getIndent(tabs)).append("</CUIField>");
        return buffer.toString();
    }

    protected abstract void toXML(StringBuffer var1, int var2);

    protected String subTypeToName() {
        return null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setDisplayLabel(String displayLabel) {
        this.displayLabel = displayLabel;
        this.initLabel();
    }

    @Override
    public String getDisplayLabel() {
        if (this.displayLabel == null) {
            return this.label;
        }
        return this.displayLabel;
    }

    public void addValidator(Validator validator) {
        this.validators.add(validator);
    }

    public void setWidthPercentage(int percentage) {
        this.widthPercentage = percentage;
    }

    private void initAbstractUI() {
        this.initLabel();
        this.innerPanel = new JPanel();
        this.emptyPanel = new JPanel();
    }

    private void initLabel() {
        this.jLabel = new JLabel(this.getDisplayLabel());
        if (!this.renderLabel()) {
            this.jLabel = new JLabel("");
        }
    }

    @Override
    public void populate(GbPanel panel, int X, int Y) {
        boolean hasLabelText;
        Insets leftInsets = this.layoutInsets != null ? (Insets)this.layoutInsets.clone() : (Insets)panel.getGbPanelInsets().clone();
        leftInsets.left = 0;
        if (Y == 0) {
            leftInsets.top = 0;
        }
        boolean bl = hasLabelText = this.jLabel.getText() != null && this.jLabel.getText().length() > 0;
        if (this.getComponent() instanceof JPanel || this.getComponent() instanceof JScrollPane) {
            int idealHeight = SHUI.TEXT_FIELD_HEIGHT;
            this.jLabel.setPreferredSize(new Dimension(this.jLabel.getPreferredSize().width, idealHeight));
            this.jLabel.setMinimumSize(new Dimension(this.jLabel.getPreferredSize().width, idealHeight));
            panel.add(this.jLabel, X, Y, 1, 1, 0, 1, 12, 2, leftInsets);
        } else if (hasLabelText) {
            panel.add(this.jLabel, X, Y, 1, 1, 0, 1, 13, 1, leftInsets);
        }
        this.jLabel.setHorizontalAlignment(4);
        JComponent content = this.getComponent();
        if (this.units != null) {
            this.unitsLabel = new JLabel(this.units);
            JPanel unitsWrapper = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale(5), SimpleHelpLookAndFeel.scale(5)));
            unitsWrapper.add((Component)content, "Center");
            unitsWrapper.add((Component)this.unitsLabel, "East");
            content = unitsWrapper;
        }
        Insets rightInsets = this.layoutInsets != null ? (Insets)this.layoutInsets.clone() : (Insets)panel.getGbPanelInsets().clone();
        rightInsets.right = 0;
        if (Y == 0) {
            rightInsets.top = 0;
        }
        if (!hasLabelText) {
            rightInsets.left = 0;
        }
        if (this.widthPercentage >= 0) {
            if (this.widthPercentage <= 1) {
                this.innerPanel.setLayout(new BorderLayout());
                this.innerPanel.add((Component)content, "West");
            } else {
                this.innerPanel.setLayout(new RelativeLayout(0));
                this.innerPanel.add((Component)content, new Float(this.widthPercentage));
                this.innerPanel.add((Component)this.emptyPanel, new Float(100 - this.widthPercentage));
            }
            panel.add(this.innerPanel, X + 1, Y, 1, 1, 100, 1, 17, 2, rightInsets);
        } else {
            panel.add(content, X + 1, Y, 1, 1, 100, 1, 17, 2, rightInsets);
        }
    }

    public boolean isValid() {
        for (Validator validator : this.validators) {
            if (validator == null || validator.isValid(this.getComponent())) continue;
            return false;
        }
        return true;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void fireChangeListener() {
        if (this.changeListener != null) {
            this.changeListener.changed(this);
        }
    }

    public void setLabelText(String text) {
        this.jLabel.setText(text);
    }

    public void clearValidators() {
        this.validators.clear();
    }

    public static boolean isValidIndex(int[] validIndices, int index) {
        if (validIndices == null) {
            return true;
        }
        for (int validIndice : validIndices) {
            if (validIndice != index) continue;
            return true;
        }
        return false;
    }

    public int getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public void setBackground(Color backgroundColor) {
        this.jLabel.setBackground(backgroundColor);
        this.innerPanel.setBackground(backgroundColor);
        this.emptyPanel.setBackground(backgroundColor);
    }

    @Override
    public void setLayoutInsets(Insets layoutInsets) {
        this.layoutInsets = layoutInsets;
    }

    public static interface ChangeListener {
        public void changed(AbstractField var1);
    }

    class ProxyChangeListener
    extends KeyAdapter
    implements ActionListener,
    javax.swing.event.ChangeListener {
        ProxyChangeListener() {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (AbstractField.this.changeListener != null) {
                AbstractField.this.changeListener.changed(AbstractField.this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AbstractField.this.changeListener != null) {
                AbstractField.this.changeListener.changed(AbstractField.this);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (AbstractField.this.changeListener != null) {
                AbstractField.this.changeListener.changed(AbstractField.this);
            }
        }
    }
}

