/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.borders.aqua;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.border.Border;

public class ShadowBorder
implements Border {
    private final Painter prePainter;
    private final int offsetX;
    private final int offsetY;
    private final float distance;
    private final int blur;
    private final Insets insets;
    private final ConvolveOp blurOp;

    ShadowBorder(Painter prePainter, Painter postPainter, int offsetX, int offsetY, float distance, float intensity, int blur) {
        this.prePainter = prePainter;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.distance = distance;
        this.blur = blur;
        int halfBlur = blur / 2;
        this.insets = new Insets(halfBlur - offsetY, halfBlur - offsetX, halfBlur + offsetY, halfBlur + offsetX);
        float blurry = intensity / (float)(blur * blur);
        float[] blurKernel = new float[blur * blur];
        for (int i = 0; i < blurKernel.length; ++i) {
            blurKernel[i] = blurry;
        }
        this.blurOp = new ConvolveOp(new Kernel(blur, blur, blurKernel));
    }

    @Override
    public final boolean isBorderOpaque() {
        return false;
    }

    @Override
    public final Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        BufferedImage img = new BufferedImage(width + this.blur * 2, height + this.blur * 2, 3);
        this.paintToImage(img, x, y, width, height);
        g.drawImage(img, -this.blur, -this.blur, null);
    }

    private void paintToImage(BufferedImage img, int x, int y, int width, int height) {
        Graphics2D imgG = (Graphics2D)img.getGraphics();
        imgG.setComposite(AlphaComposite.Clear);
        imgG.setColor(Color.black);
        imgG.fillRect(0, 0, width + this.blur * 2, height + this.blur * 2);
        int adjX = (int)((float)(x + this.blur + this.offsetX) + (float)this.insets.left * this.distance);
        int adjY = (int)((float)(y + this.blur + this.offsetY) + (float)this.insets.top * this.distance);
        int adjW = (int)((float)width - (float)(this.insets.left + this.insets.right) * this.distance);
        int adjH = (int)((float)height - (float)(this.insets.top + this.insets.bottom) * this.distance);
        imgG.setComposite(AlphaComposite.DstAtop);
        if (this.prePainter != null) {
            this.prePainter.paint(imgG, adjX, adjY, adjW, adjH);
        }
        imgG.dispose();
        imgG = (Graphics2D)img.getGraphics();
        imgG.setComposite(AlphaComposite.DstAtop);
        imgG.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        imgG.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        imgG.drawImage(img, this.blurOp, 0, 0);
        imgG.dispose();
    }

    static interface Painter {
        public void paint(Graphics var1, int var2, int var3, int var4, int var5);
    }
}

