/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools.time;

import java.util.ArrayList;
import java.util.HashMap;
import utils.progtools.time.TimeSet;
import utils.progtools.time.TimeValue;

public class TimeHierarchy {
    private static final int COLUMN_WIDTH = 11;
    private static final int PERC_COL_WIDTH = 5;
    private HashMap<String, HierarchyTimeElement> elements = new HashMap();
    private HierarchyTimeElement ROOT;
    private HierarchyTimeElement lastStartedElement = this.ROOT = new HierarchyTimeElement();
    private int maxTitleLength = 0;
    private int maxDepth = 0;
    private int depth = 0;

    public static void main(String[] args) throws InterruptedException {
        int i;
        int testSleep = 100;
        TimeHierarchy hierarchy = new TimeHierarchy();
        hierarchy.start("Node 1");
        hierarchy.start("Node 1 - 1");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 1");
        hierarchy.start("Node 1 - 2");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 2");
        hierarchy.start("Node 1 - 3");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 3");
        hierarchy.stop("Node 1");
        hierarchy.start("Node 2");
        hierarchy.start("Node 2 - 1");
        for (i = 0; i < 10; ++i) {
            hierarchy.start("Node 2 -- " + i);
        }
        Thread.sleep(100L);
        for (i = 0; i < 10; ++i) {
            hierarchy.stop("Node 2 -- " + i);
        }
        hierarchy.stop("Node 2 - 1");
        hierarchy.stop("Node 2");
        hierarchy.start("Node 1");
        hierarchy.start("Node 1 - 1");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 1");
        hierarchy.start("Node 1 - 2");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 2");
        hierarchy.start("Node 1 - 3");
        Thread.sleep(100L);
        hierarchy.stop("Node 1 - 3");
        hierarchy.stop("Node 1");
        hierarchy.start("Node 2");
        hierarchy.start("Node 2 - 1");
        hierarchy.start("Node 2 - 1 - 1");
        Thread.sleep(100L);
        hierarchy.stop("Node 2 - 1 - 1");
        hierarchy.stop("Node 2 - 1");
        hierarchy.stop("Node 2");
        System.out.println(hierarchy.dumpStats());
    }

    public synchronized String dumpStats() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TimeSet.padRight("Title", this.maxTitleLength + 1));
        buffer.append(TimeSet.padLeft("Last (ms)", 11));
        buffer.append(TimeSet.padLeft("%", 5));
        buffer.append(TimeSet.padLeft("Total (ms)", 11));
        buffer.append(TimeSet.padLeft("%", 5));
        buffer.append(TimeSet.padLeft("Calls", 11));
        buffer.append(TimeSet.padLeft("Average", 11));
        buffer.append("\n");
        this.dumpStats(buffer, this.ROOT, 0);
        return buffer.toString();
    }

    private void dumpStats(StringBuffer buffer, HierarchyTimeElement element, int indent) {
        if (element.startCalls != element.stopCalls) {
            System.out.println("Timer " + element.timerName + " start:" + element.startCalls + " != stop:" + element.stopCalls);
        }
        String prefix = "";
        if (indent == 1) {
            prefix = " |-> ";
        } else {
            for (int i = 1; i < indent; ++i) {
                prefix = prefix + "    ";
            }
            prefix = prefix + " |-> ";
        }
        if (element != this.ROOT) {
            TimeValue value = element.timeValue;
            if (value.calls == 0) {
                buffer.append(prefix).append(element.timerName + " -> Started but never stopped\n");
            } else {
                String lastPerc = "";
                String totalPerc = "";
                if (element.parent.timeValue.lastTime != 0L) {
                    lastPerc = "" + 100L * value.lastTime / element.parent.timeValue.lastTime;
                }
                if (element.parent.timeValue.totalTime != 0L) {
                    totalPerc = "" + 100L * value.totalTime / element.parent.timeValue.totalTime;
                }
                buffer.append(prefix).append(TimeSet.padRight(element.timerName.trim(), this.maxTitleLength - 4 * indent));
                buffer.append(TimeSet.padLeft(value.lastTime + "", 11));
                buffer.append(TimeSet.padLeft(lastPerc, 5));
                buffer.append(TimeSet.padLeft(value.totalTime + "", 11));
                buffer.append(TimeSet.padLeft(totalPerc, 5));
                buffer.append(TimeSet.padLeft(value.calls + "", 11));
                buffer.append(TimeSet.padLeft(value.totalTime / (long)value.calls + "", 11));
                buffer.append("\n");
            }
        }
        for (HierarchyTimeElement child : element.children) {
            this.dumpStats(buffer, child, indent + 1);
        }
    }

    public synchronized void start(String timerName) {
        ++this.depth;
        HierarchyTimeElement element = this.elements.get(timerName);
        if (element == null) {
            element = new HierarchyTimeElement();
            element.parent = this.lastStartedElement;
            element.timerName = timerName;
            this.lastStartedElement.children.add(element);
            this.elements.put(timerName, element);
            this.maxTitleLength = Math.max(this.maxTitleLength, timerName.length() + 2 + 5 * this.depth);
        }
        element.timeValue.time.reset();
        ++element.startCalls;
        this.lastStartedElement = element;
        this.maxDepth = Math.max(this.depth, this.maxDepth);
    }

    public synchronized void stop(String timerName) {
        HierarchyTimeElement element = this.elements.get(timerName);
        if (element == null) {
            System.out.println("[TimeHierarchy] Stopping time element without previously starting it (" + timerName + ")!");
        } else {
            element.timeValue.lastTime = element.timeValue.time.lap();
            element.timeValue.totalTime += element.timeValue.lastTime;
            ++element.timeValue.calls;
            this.lastStartedElement = element.parent;
            ++element.stopCalls;
        }
        --this.depth;
    }

    class HierarchyTimeElement {
        String timerName;
        TimeValue timeValue = new TimeValue();
        ArrayList<HierarchyTimeElement> children = new ArrayList();
        HierarchyTimeElement parent;
        int startCalls = 0;
        int stopCalls = 0;

        HierarchyTimeElement() {
        }
    }
}

