/*
 * Decompiled with CFR 0.152.
 */
package utils.progtools;

import java.util.Calendar;
import java.util.Date;
import java.util.Random;

public class TimeUtil {
    private static Random RANDOM = null;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_YEAR = 31622400000L;

    public static long getRandomHourFraction() {
        return TimeUtil.getRandomDurationFraction(3600000L);
    }

    private static long getRandomDurationFraction(long duration) {
        if (RANDOM == null) {
            RANDOM = new Random();
        }
        return System.currentTimeMillis() + (long)(RANDOM.nextDouble() * (double)duration);
    }

    public static long stripMS(long duration) {
        duration /= 1000L;
        return duration *= 1000L;
    }

    public static long roundTimeDownToStartOfMonth(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundTimeUpToEndOfMonth(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(10, cal.getActualMaximum(10));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return cal.getTimeInMillis();
    }

    public static long roundTimeDownToStartOfDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundTimeUpToEndOfDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return cal.getTimeInMillis();
    }

    public static long roundTimeUpToStartOfNextDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundTimeUpToStartOfNextHour(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.add(11, 1);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static long roundTimeDownToEndOfPreviousDay(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        cal.add(5, -1);
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return cal.getTimeInMillis();
    }

    public static boolean isToday(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        Calendar today = Calendar.getInstance();
        return TimeUtil.isSameDay(cal, today);
    }

    public static boolean isSameDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        return TimeUtil.isSameDay(cal1, cal2);
    }

    public static boolean isSameDay(Calendar cal1, Calendar cal2) {
        if (cal1 == null || cal2 == null) {
            return false;
        }
        return cal1.get(0) == cal2.get(0) && cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isMidnight(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        return c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) == 0;
    }
}

