/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.util.ArrayList;
import utils.progtools.BufferPool;
import utils.stream.ByteArrayPool;
import utils.stream.OpenBoutPool;
import utils.stream.OpenByteArrayOutputStream;

public class TrackingBoutPool
implements ByteArrayPool {
    OpenBoutPool pool;
    BufferPool buffers;
    ArrayList<OpenByteArrayOutputStream> allocated = new ArrayList();
    ArrayList<byte[]> allocatedBuffers = new ArrayList();

    public TrackingBoutPool(OpenBoutPool pool, BufferPool buffers) {
        this.pool = pool;
        this.buffers = buffers;
    }

    @Override
    public OpenByteArrayOutputStream allocate() {
        OpenByteArrayOutputStream bout = this.pool.getBout();
        this.allocated.add(bout);
        return bout;
    }

    @Override
    public byte[] allocateBuffer() {
        byte[] bout = (byte[])this.buffers.get();
        this.allocatedBuffers.add(bout);
        return bout;
    }

    public void deallocateAll() {
        for (OpenByteArrayOutputStream bout : this.allocated) {
            this.pool.done(bout);
        }
        this.allocated.clear();
        for (byte[] buffer : this.allocatedBuffers) {
            this.buffers.done(buffer);
        }
        this.allocatedBuffers.clear();
    }
}

