/*
 * Decompiled with CFR 0.152.
 */
package utils.message;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageConstants;
import utils.message.MessageUtils;
import utils.message.MessageWriterInterface;
import utils.stream.OpenByteArrayOutputStream;

public class MessageWriter
implements MessageConstants,
MessageWriterInterface {
    private static boolean BUFFER_FIRST = false;
    private OpenByteArrayOutputStream bout = new OpenByteArrayOutputStream();
    private final Object LOCK = new Object();
    OutputStream out;

    public MessageWriter(OutputStream out) {
        this.out = BUFFER_FIRST ? out : new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Message m) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (BUFFER_FIRST) {
                this.bout.reset();
                MessageUtils.writeMessage(this.bout, m);
                this.out.write(this.bout.getByteArray(), 0, this.bout.size());
                this.out.flush();
            } else {
                MessageUtils.writeMessage(this.out, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNoFlush(Message m) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            if (BUFFER_FIRST) {
                this.bout.reset();
                MessageUtils.writeMessage(this.bout, m);
                this.out.write(this.bout.getByteArray(), 0, this.bout.size());
                this.out.flush();
            } else {
                MessageUtils.writeMessageNoFlush(this.out, m);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] messageBytes) throws IOException {
        Object object = this.LOCK;
        synchronized (object) {
            this.out.write(messageBytes, 0, messageBytes.length);
            this.out.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

