/*
 * Decompiled with CFR 0.152.
 */
package utils.jarbuilder.utils;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;

public class JarClassVersionChecker {
    private int[] versionCount = new int[100];

    public void check(File file) throws IOException {
        if (file.getName().endsWith("jar")) {
            this.checkJar(file);
        } else if (file.getName().endsWith("class")) {
            this.checkClass(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJar(File jarFile) throws IOException {
        try (JarFile jf = new JarFile(jarFile);){
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                try (InputStream in = jf.getInputStream(entry);){
                    this.processJarEntry(entry, in);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarEntry(JarEntry entry, InputStream in) throws IOException {
        if (entry.getName().endsWith(".class")) {
            this.checkClass(entry.getName(), in);
        } else if (entry.getName().endsWith(".jar")) {
            System.out.println("[JarClassVersionChecker] Processing jar " + entry.getName());
            try (JarInputStream jin = new JarInputStream(in);){
                JarEntry internalEntry = jin.getNextJarEntry();
                while (internalEntry != null) {
                    this.processJarEntry(internalEntry, jin);
                    internalEntry = jin.getNextJarEntry();
                }
            }
        }
    }

    private void checkClass(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.checkClass(file.getName(), inputStream);
        }
    }

    private void checkClass(String className, InputStream in) throws IOException {
        int javaVersion;
        DataInputStream din = new DataInputStream(in);
        if (din.readInt() != -889275714) {
            System.out.println("[JarVersionChecker] Not a class file: " + className);
            return;
        }
        short minor = din.readShort();
        short major = din.readShort();
        int n = javaVersion = major - 44;
        this.versionCount[n] = this.versionCount[n] + 1;
        System.out.println(className + " - " + javaVersion);
    }

    public int getRequiredJavaVersion() {
        for (int index = this.versionCount.length - 1; index >= 0; --index) {
            if (this.versionCount[index] > 0) {
                return index;
            }
            if (index != 0) continue;
            return 0;
        }
        return 0;
    }

    public static void main(String[] args) throws IOException {
        args = new String[]{"/Users/gchristelis/Desktop/jwstandalone.jar"};
        String jarName = args[0];
        File file = new File(jarName);
        JarClassVersionChecker checker = new JarClassVersionChecker();
        checker.check(file);
        for (int i = 0; i < 10; ++i) {
            System.out.println("Java " + i + " = " + checker.versionCount[i]);
        }
        System.out.println(checker.getRequiredJavaVersion());
    }

    public String getStatsString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[JarClassVersionChecker] ");
        for (int i = 1; i < this.versionCount.length; ++i) {
            if (this.versionCount[i] <= 0) continue;
            buffer.append(i).append(") ").append(this.versionCount[i]).append("\t");
        }
        return buffer.toString();
    }
}

