/*
 * Decompiled with CFR 0.152.
 */
package utils.files;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import utils.ostools.OS;
import utils.progtools.ProcessPrinter;

public class PermissionsUtil {
    private static final boolean USE_CMD = false;

    public static void setExecutableForMe(File targetFile) {
        System.out.println("[PermissionsUtil] Setting executable for me: " + targetFile);
        if (OS.isMacOS() || OS.isLinux()) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", "u+x", targetFile.getCanonicalPath()});
                new ProcessPrinter(p, System.out, System.err);
                p.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void callChmod(File targetFile, String permissions) {
        System.out.println("[PermissionsUtil] Setting " + permissions + " on " + targetFile);
        if (OS.isMacOS() || OS.isLinux()) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", permissions, targetFile.getCanonicalPath()});
                new ProcessPrinter(p, System.out, System.err);
                p.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void setRecursiveFullPermissions(String absolutePath) {
        System.out.println("[PermissionsUtil] Setting full permissions for: " + absolutePath);
        if (OS.isWindows()) {
            try {
                System.out.println("[PermissionsUtil] Setting recursive permissions for " + absolutePath);
                Process p = Runtime.getRuntime().exec("cacls \"" + absolutePath + "\" /t /e /g \"Users\":f");
                try {
                    OutputStream out = p.getOutputStream();
                    out.write("Y\r\n".getBytes());
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    System.out.println("[PermissionsUtil] Warning: unable to flush output stream. (" + ex.getMessage() + ")");
                }
                new ProcessPrinter(p, new NullOutputStream(), System.out);
                p.waitFor();
                System.out.println("[PermissionsUtil] Finished setting permissions.");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (OS.isMacOS()) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", "-R", "a+rwx", absolutePath});
                new ProcessPrinter(p, System.out, System.err);
                p.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (OS.isLinux()) {
            try {
                Process p = Runtime.getRuntime().exec(new String[]{"chmod", "-R", "a+rwx", absolutePath});
                new ProcessPrinter(p, System.out, System.err);
                p.waitFor();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void write(int b) throws IOException {
        }
    }
}

