/*
 * Decompiled with CFR 0.152.
 */
package utils.encryption.rsa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import utils.encryption.rsa.RSAConstants;

public class RSADecryptor
implements RSAConstants {
    private int MAXBITS = 960;
    private int MAXLEN = this.MAXBITS / 8;
    private BigInteger BASE = new BigInteger("2").pow(this.MAXBITS);
    private boolean CRT = false;
    private BigInteger[] key;

    public RSADecryptor(BigInteger[] private_key) {
        BigInteger n;
        this.key = private_key;
        if (this.key.length == 2) {
            this.CRT = false;
            n = this.key[0];
        } else {
            this.CRT = true;
            n = this.key[5];
        }
        this.MAXBITS = (int)((double)n.bitLength() * 0.9);
        this.MAXLEN = this.MAXBITS / 8;
        this.MAXBITS = this.MAXLEN * 8;
        this.BASE = new BigInteger("2").pow(this.MAXBITS);
    }

    private BigInteger readAndDecrypt(int siz, InputStream in) throws IOException {
        byte[] tmp = new byte[siz];
        int total = 0;
        while (total < tmp.length) {
            int x = in.read(tmp, total, tmp.length - total);
            if (x <= 0) continue;
            total += x;
        }
        BigInteger ciphertext = new BigInteger(tmp);
        if (this.CRT) {
            BigInteger cDp = ciphertext.modPow(this.key[2], this.key[0]);
            BigInteger cDq = ciphertext.modPow(this.key[3], this.key[1]);
            BigInteger u = cDq.subtract(cDp).multiply(this.key[4]).remainder(this.key[1]);
            if (u.compareTo(BigInteger.ZERO) < 0) {
                u = u.add(this.key[1]);
            }
            ciphertext = cDp.add(u.multiply(this.key[0]));
        } else {
            ciphertext = ciphertext.modPow(this.key[1], this.key[0]);
        }
        ciphertext = ciphertext.subtract(this.BASE);
        return ciphertext;
    }

    private int readN(InputStream in) throws IOException {
        int n = 0;
        n = in.read() << 24;
        n |= in.read() << 16;
        n |= in.read() << 8;
        return n |= in.read();
    }

    public byte[] decrypt(byte[] data) {
        byte[] origdat;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            byte[] writedat = new byte[this.MAXLEN];
            ByteArrayInputStream bin = new ByteArrayInputStream(data);
            int n = 0;
            n = this.readN(bin);
            BigInteger origlen = this.readAndDecrypt(n, bin);
            origdat = new byte[origlen.intValue()];
            n = this.readN(bin);
            while (n != -1) {
                for (int i = 0; i < writedat.length; ++i) {
                    writedat[i] = 0;
                }
                BigInteger ciphertext = this.readAndDecrypt(n, bin);
                byte[] plaintext = ciphertext.toByteArray();
                int tmpn = this.MAXLEN - plaintext.length;
                System.arraycopy(plaintext, 0, writedat, tmpn, plaintext.length);
                bout.write(writedat);
                n = this.readN(bin);
            }
        }
        catch (IOException e) {
            return null;
        }
        byte[] tmp = bout.toByteArray();
        if (origdat.length > tmp.length) {
            return null;
        }
        System.arraycopy(tmp, 0, origdat, 0, origdat.length);
        return origdat;
    }
}

