/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import utils.files.AutoChmodFile;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;

public class OSXBundleUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupOrRepairOSXJreBundle(File targetBundle, File targetJRE) {
        if (!OS.isMacOS()) {
            return;
        }
        System.out.println("[OSXBundleUtil] Setup or repair targetBundle:" + targetBundle + " targetJRE:" + targetJRE);
        targetJRE.mkdirs();
        File subJRE = OSXBundleUtil.getSubJREForBundle(targetBundle);
        File[] children = subJRE.listFiles();
        if (children != null) {
            for (File f : children) {
                File newFile = new File(targetJRE, f.getName());
                if (f.renameTo(newFile)) continue;
                System.out.println("[AllPlatformWrapper] Renaming to " + newFile.getAbsolutePath() + " failed.");
            }
        }
        try {
            OSXBundleUtil.linkJREAndBundle(targetJRE, targetBundle, targetJRE, targetBundle);
        }
        catch (Throwable throwable) {
            File spawnHelper = OSXBundleUtil.getSpawnHelper(targetJRE);
            if (OSXBundleUtil.getSpawnHelper(targetJRE).exists()) {
                String chmod = AutoChmodFile.getChmodExe();
                RunCommandGetOutput.runCommandGetOutput(new String[]{chmod, "a+x", spawnHelper.getAbsolutePath()});
            }
            throw throwable;
        }
        File spawnHelper = OSXBundleUtil.getSpawnHelper(targetJRE);
        if (OSXBundleUtil.getSpawnHelper(targetJRE).exists()) {
            String chmod = AutoChmodFile.getChmodExe();
            RunCommandGetOutput.runCommandGetOutput(new String[]{chmod, "a+x", spawnHelper.getAbsolutePath()});
        }
    }

    private static File getSpawnHelper(File targetJRE) {
        File spawnHelper = new File(targetJRE.getAbsolutePath() + "/lib/jspawnhelper");
        if (!spawnHelper.exists()) {
            spawnHelper = new File(targetJRE.getAbsolutePath() + "/jre/lib/jspawnhelper");
        }
        return spawnHelper;
    }

    private static String getSubJREPathForBundle(File targetBundle) {
        File subJRE = new File(targetBundle.getAbsolutePath() + "/Contents/Home/jre");
        if (!subJRE.exists()) {
            return "/Contents/Home";
        }
        return "/Contents/Home/jre";
    }

    private static File getSubJREForBundle(File targetBundle) {
        return new File(targetBundle.getAbsolutePath() + OSXBundleUtil.getSubJREPathForBundle(targetBundle));
    }

    public static void linkJREAndBundle(File existingJRE, File existingBundle, File targetJRE, File targetBundle) {
        String[] potentialTargets;
        if (!OS.isMacOS()) {
            return;
        }
        File[] files = new File(existingBundle.getAbsolutePath() + "/Contents/MacOS").listFiles();
        String executableName = "JavaAppletPlugin";
        if (files.length > 0) {
            executableName = files[0].getName();
        }
        System.out.println("[OSXBundleUtil] Executable is " + executableName);
        File existingSubJRE = OSXBundleUtil.getSubJREForBundle(existingBundle);
        File targetSubJRE = new File(targetBundle.getAbsolutePath() + OSXBundleUtil.getSubJREPathForBundle(existingBundle));
        System.out.println("[OSXBundleUtil] Existing SubJRE is " + existingSubJRE);
        System.out.println("[OSXBundleUtil] Target SubJRE is " + targetSubJRE);
        FileUtil.deleteDir(existingSubJRE);
        RunCommandGetOutput.runCommandGetOutput(new String[]{"ln", "-s", targetJRE.getAbsolutePath(), targetSubJRE.getAbsolutePath()});
        new File(existingBundle.getAbsolutePath() + "/Contents/MacOS/" + executableName).delete();
        for (String s : potentialTargets = new String[]{"/lib/libnpjp2.dylib", "/lib/jli/libjli.dylib"}) {
            if (!new File(existingJRE.getAbsolutePath() + s).exists()) continue;
            File target = new File(targetJRE.getAbsolutePath() + s);
            String targetExe = existingBundle.getAbsolutePath() + "/Contents/MacOS/" + executableName;
            System.out.println("[OSXBundleUtil] Linking " + target.getAbsolutePath() + " -> " + targetExe);
            RunCommandGetOutput.runCommandGetOutput(new String[]{"ln", "-s", target.getAbsolutePath(), targetExe});
            return;
        }
    }
}

