/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.updater;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import utils.encryption.OptionalEncrypt;
import utils.files.FileUtil;
import utils.ostools.OS;
import utils.stream.CFriendlyProperties;
import utils.switches.Switches;

public class JWLaunchProperties {
    public static final String PROP_UPDATE_URL = "update_url";
    public static final String PROP_FAILOVER_URL = "failover_update_url";
    public static final String PROP_SPLASH_IMAGE = "splash_image";
    public static final String PROP_SPLASH_IMAGE_BORDER = "splash_buffer";
    public static final String PROP_MY_DIR = "app_dir";
    public static final String PROP_APP_JRE_DIR = "app_jre_dir";
    public static final String PROP_APP_NAME = "app_name";
    public static final String PROP_JRE_NAME = "jre_name";
    public static final String PROP_MIN_SPLASH_MS = "min_splash_ms";
    public static final String PROP_JWSIG_PUB_KEY = "jwsig_public_key";
    public static final String PROP_SILENT_PARAMETER = "silent_parameter";
    public static final String PROP_CAN_OVERRIDE_SPLASH = "can_override_splash";
    public static final String PROP_MATCH_VERSIONS = "match_versions";
    public static final String PROP_SKIP_SYSTEM_JRE = "skip_system_jre";
    public static final String PROP_INSTALL_TYPE = "install_type";
    public static final String PROP_FIRST_RUN_POST_UPDATE = "first_run_post_update";
    public static final String PROP_FIRST_RUN_POST_INSTALL = "first_run_post_install";
    public static final String PROP_JVM_OPTIONS = "jvm_options";
    public static final String PROP_SUPPORTED_LANGS = "supported_langs";
    public static final String PROP_SHOW_NO_UI = "show_no_ui";
    public static final String PROP_FORCE_SPAWN = "force_spawn";
    public static final String PROP_LAUNCHED_FROM_DYNPROPS = "launched_from_dynprops";
    public static final String PROP_WINDOWS_APP_ID = "windows_app_id";
    public static final String PROP_AUTO_DISABLE_APPNAP = "auto_disable_appnap";
    public static final String PROP_URL_HANDLER_REQUEST = "url_req";
    public static final String PROP_URL_HANDLER_OPEN = "urlhandler";
    public static final String PROP_JAVA_VERSION_REQUIRED = "java_version";
    public static final String PROP_FORCE_NATIVE_UNPACK200 = "force_native_unpack200";
    public static final String PROP_DEFAULT_RA_URL_PROTOCOL = "def_ra_url_protocol";
    public static final String PROP_XMX_OVERRIDE = "xmx_override";
    public static final String PROP_XMX_PERCENT_PHYS = "xmx_pc_phys";
    public static final String PROP_XMX_PERCENT_FREE = "xmx_pc_free";
    public static final String PROP_XMX_MAX = "xmx_max";
    public static final String PROP_XMX_MIN = "xmx_min";
    public static final String PROP_HEADLESS_JVM_JVMARGS = "headless_jvm_jvmargs";
    public static final String PROP_HEADLESS_JVM_SYSPROP = "headless_jvm_sysprop";
    public static final String PROP_GU_PROTOCOL_OVERRIDE = "gu_protocols";
    public static final String PROP_PRI_HIGH = "procpri_high";
    public static final String PROP_PRI_NORMAL = "procpri_normal";
    public static final String PROP_PRI_LOW = "procpri_low";
    public static final String PROP_JW_VERSION = "jwrapper_gu_version";
    public static final String PROP_TIMEBOMB = "exit_timebomb";
    public static final String PROP_JIP = "jip_options";
    public static final String PROP_JVM_ADDPARAM = "jvm_add_param";
    public static final String WRAPPER_APP_VERSION = "wrapper_app_version";
    public static final String WRAPPER_JW_VERSION = "wrapper_gu_version";
    public static final String WRAPPER_AUTO_TEST = "wrapper_autotest";
    public static final String WRAPPER_MAX_APP_VERSIONS = "wrapper_app_versions";
    public static final String WRAPPER_MAX_GU_VERSIONS = "wrapper_gu_versions";
    public static final String DEBUG_LOGGING = "debug_logging";
    public static final String DEBUG_LOGGING_UNTIL = "debug_logging_until";
    public static final String LAUNCHER_VIRTUAL_APP = "gu_virt_app";
    public static final String LAUNCH_ELEVATE = "launch_elevate";
    public static final String LAUNCH_ELEVATE_SILENT = "launch_elevate_silent";
    public static final String LAUNCH_IN_SESSION = "launch_in_session";
    public static final String LAUNCH_IN_SPECIFIC_SESSION = "launch_in_specific_session";
    public static final String LAUNCH_PREPARE_ONLY = "launch_prepare_only";
    public static final String LAUNCH_EXPECT_APPVERSION = "launch_expect_appversion";
    public static final String LAUNCH_EXPECT_APPNAME = "launch_expect_appname";
    public static final String PROP_POST_PREPARE_SHOW_UI = "post_prep_show_ui";
    public static final String PROP_USE_SERVICE_FQ_NAMES = "service_use_fq_names";
    public static final String LOGGING_MUTE = "logging_mute";
    private static Object LOCK = new Object();
    private static HashMap subPropsMap = null;
    Properties rootprops = new Properties();
    File file;
    static JWLaunchProperties INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPropertyMapFor(ThreadGroup threadGroup, Properties props) {
        Object object = LOCK;
        synchronized (object) {
            Object[] keys;
            Properties merged = (Properties)JWLaunchProperties.getRawProps().clone();
            for (Object key : keys = props.keySet().toArray()) {
                String propkey = (String)key;
                merged.setProperty("jwdyna_" + propkey, props.getProperty(propkey));
            }
            if (subPropsMap == null) {
                subPropsMap = new HashMap();
            }
            System.out.println("[JWLaunchProperties] Set properties for " + threadGroup.getName() + " hc=" + merged.hashCode());
            subPropsMap.put(threadGroup, merged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProps() {
        if (Switches.SH_sessionsInTechUiProcess && subPropsMap != null) {
            Object object = LOCK;
            synchronized (object) {
                for (ThreadGroup tg = Thread.currentThread().getThreadGroup(); tg != null; tg = tg.getParent()) {
                    Properties subProps = (Properties)subPropsMap.get(tg);
                    if (subProps == null) continue;
                    return subProps;
                }
            }
        }
        return this.rootprops;
    }

    public void addStaticProperty(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.getProps().setProperty("jwstat_" + name, value);
    }

    public void addDynamicProperty(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.getProps().setProperty("jwdyna_" + name, value);
    }

    public static boolean getBooleanProperty(String name, boolean def) {
        String property = JWLaunchProperties.getProperty(name);
        if (property == null) {
            return def;
        }
        return Boolean.parseBoolean(property);
    }

    public static boolean hideUI() {
        String showNoUI = JWLaunchProperties.getProperty(PROP_SHOW_NO_UI);
        String isPrepare = JWLaunchProperties.getProperty(LAUNCH_PREPARE_ONLY);
        if (showNoUI != null && Boolean.parseBoolean(showNoUI)) {
            return true;
        }
        return isPrepare != null && Boolean.parseBoolean(isPrepare);
    }

    public static boolean isNonEmpty(String value) {
        if (value == null) {
            return false;
        }
        return value.trim().length() != 0;
    }

    public String getFileRef() {
        return this.file.getAbsolutePath();
    }

    void store(boolean encrypt) throws IOException {
        byte[] dat = CFriendlyProperties.encode(this.getProps());
        if (encrypt && Switches.SH_encryptLaunchPropFile) {
            dat = OptionalEncrypt.encrypt(dat, "zxghjsadgj213687479823198hjkasnkjdbjhw139r0934588923y21ug3hbj");
        }
        FileUtil.writeFile(this.file, dat);
    }

    public void setLaunchFolder(File folder) {
        this.file = new File(folder, "JWLaunchProperties-" + System.currentTimeMillis() + "-" + folder.list().length);
    }

    public JWLaunchProperties(File folder) {
        if (folder != null) {
            this.file = new File(folder, "JWLaunchProperties-" + System.currentTimeMillis() + "-" + folder.list().length);
        }
    }

    private JWLaunchProperties() {
    }

    public static void addAllProperties(Properties target, Properties from) {
        Object[] keys = from.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            target.setProperty(key, from.getProperty(key));
        }
    }

    public static Properties getAsProperties() {
        if (INSTANCE == null) {
            return null;
        }
        boolean isDynamicURL = JWLaunchProperties.isDynamicUpdateURL();
        Properties tmp = new Properties();
        Properties mine = INSTANCE.getProps();
        Object[] keys = mine.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = (String)keys[i];
            String value = mine.getProperty(key);
            String subkey = key.substring(7);
            if (key.startsWith("jwstat")) {
                if (subkey.equals(PROP_UPDATE_URL) && value.equals("D")) {
                    if (tmp.containsKey(subkey)) continue;
                    tmp.setProperty(subkey, value);
                    continue;
                }
                tmp.setProperty(subkey, value);
                continue;
            }
            if (subkey.equals(PROP_UPDATE_URL) && isDynamicURL) {
                tmp.setProperty(subkey, value);
                continue;
            }
            if (tmp.containsKey(subkey)) continue;
            tmp.setProperty(subkey, value);
        }
        return tmp;
    }

    public static boolean isJWrapperSetup() {
        return INSTANCE != null;
    }

    public static void deleteProperty(String name) {
        if (INSTANCE != null) {
            INSTANCE.getProps().remove("jwstat_" + name);
            INSTANCE.getProps().remove("jwdyna_" + name);
        }
    }

    public static void overrideProperty(String name, String value) {
        if (INSTANCE == null) {
            // empty if block
        }
        INSTANCE.addStaticProperty(name, value);
    }

    public static void overrideDynamicProperty(String name, String value) {
        if (INSTANCE == null) {
            // empty if block
        }
        INSTANCE.addDynamicProperty(name, value);
    }

    public static String getProperty(String name) {
        String result = JWLaunchProperties.getPropertyPossiblyNull(name);
        if (result == null) {
            return "";
        }
        return result;
    }

    public static boolean isDynamicUpdateURL() {
        String value = INSTANCE.getProps().getProperty("jwstat_update_url");
        if (value == null) {
            return false;
        }
        return value.equals("D");
    }

    public static String normaliseUpdateURL(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String getPropertyPossiblyNull(String name) {
        if (INSTANCE == null) {
            return "ERROR: JWLaunchProperties not set up, call 'argsToNormalArgs(...)'";
        }
        String value = INSTANCE.getProps().getProperty("jwstat_" + name);
        if (value == null) {
            value = INSTANCE.getProps().getProperty("jwdyna_" + name);
        } else if (name.equals(PROP_UPDATE_URL) && value.equals("D") && INSTANCE.getProps().getProperty("jwdyna_" + name) != null) {
            value = INSTANCE.getProps().getProperty("jwdyna_" + name);
        }
        return value;
    }

    public static Properties getRawProps() {
        return INSTANCE.getProps();
    }

    public static String getAsString() {
        return INSTANCE.toString();
    }

    public static void cleanDir(File dir) {
        long hoursAgo = System.currentTimeMillis() - 0x6DDD00L;
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file1 : files) {
                if (!file1.getName().startsWith("JWLaunchProperties-") || file1.lastModified() >= hoursAgo) continue;
                file1.delete();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] keys = this.getProps().keySet().toArray();
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            String key = String.valueOf(keys[i]);
            String value = this.getProps().getProperty((String)keys[i]);
            if (value != null && value.length() > 100) {
                value = value.substring(0, 99) + "...";
            }
            if (key.toLowerCase().contains("password")) {
                sb.append("[JWrapperLaunchProperty] ").append(key).append("=[").append("xxxxxxxx").append("]").append(OS.NEWLINE);
                continue;
            }
            sb.append("[JWrapperLaunchProperty] ").append(key).append("=[").append(value).append("]").append(OS.NEWLINE);
        }
        return sb.toString();
    }

    public static JWLaunchProperties setUpTestProperties() {
        INSTANCE = new JWLaunchProperties();
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] argsToNormalArgs(String[] args) {
        try {
            String loc = args[0];
            System.out.println("[JWrapper] loading props from " + loc);
            File argumentsFile = new File(loc);
            INSTANCE = new JWLaunchProperties();
            int maxAttempts = 5;
            int attemptCount = 0;
            boolean propertiesRead = false;
            while (!propertiesRead && attemptCount < maxAttempts) {
                try {
                    byte[] dat = FileUtil.readFile(argumentsFile);
                    dat = OptionalEncrypt.decryptIfEncrypted(dat, "zxghjsadgj213687479823198hjkasnkjdbjhw139r0934588923y21ug3hbj");
                    JWLaunchProperties.INSTANCE.rootprops = CFriendlyProperties.decode(dat);
                    propertiesRead = true;
                    if (!argumentsFile.exists() || !Switches.SH_deleteLaunchPropFileAfterRead) continue;
                    argumentsFile.delete();
                }
                catch (FileNotFoundException t) {
                    t.printStackTrace();
                    if (attemptCount + 1 == maxAttempts) {
                        throw t;
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    ++attemptCount;
                }
            }
            System.out.println(INSTANCE);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        String[] tmp = new String[args.length - 1];
        if (tmp.length > 0) {
            System.arraycopy(args, 1, tmp, 0, tmp.length);
        }
        return tmp;
    }
}

