/*
 * Decompiled with CFR 0.152.
 */
package jwrapper.pack200;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;

public class Pack200Decompressor {
    private Pack200.Unpacker unpacker = Pack200.newUnpacker();

    public static void main(String[] args) {
        long start = System.currentTimeMillis();
        new Pack200Decompressor().decompressDirectorySafe(new File("/Users/gchristelis/Desktop/jre"));
        System.out.println("Decompression took " + (System.currentTimeMillis() - start) + "ms");
    }

    public static Pack200Decompressor initDecompressor() {
        return new Pack200Decompressor();
    }

    public void decompressFile(InputStream in, JarOutputStream out) throws IOException {
        this.unpacker.unpack(in, out);
    }

    public void decompressDirectorySafe(File directory) {
        try {
            this.decompressDirectory(directory, true);
        }
        catch (IOException x) {
            x.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decompressDirectory(File directory, boolean hideExceptions) throws IOException {
        if (directory.isFile()) {
            File file = directory;
            if (!file.getName().endsWith(".p2")) return;
            try {
                System.out.println("[Pack200Decompressor] Decompressing " + file.getName());
                File parent = file.getParentFile();
                String newName = file.getName().substring(0, file.getName().lastIndexOf(46));
                File newTarget = new File(parent, newName + ".jar");
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(file));
                JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(newTarget)));
                try {
                    this.unpacker.unpack((InputStream)bin, jout);
                }
                catch (IOException ex) {
                    if (!newTarget.exists()) throw ex;
                    newTarget.delete();
                    throw ex;
                }
                finally {
                    System.out.println("[Pack200Decompressor] Closing streams...");
                    try {
                        bin.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        jout.close();
                    }
                    catch (Throwable throwable) {}
                }
                file.delete();
                return;
            }
            catch (Throwable t) {
                System.out.println("[Pack200Util] Couldn't decompress " + file.getAbsolutePath() + " (" + hideExceptions + ")");
                t.printStackTrace();
                if (hideExceptions) return;
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                IOException tmp = new IOException("Couldn't decompress " + file.getAbsolutePath());
                tmp.initCause(t);
                throw tmp;
            }
        }
        File[] children = directory.listFiles();
        for (int i = 0; i < children.length; ++i) {
            this.decompressDirectory(children[i], hideExceptions);
        }
    }
}

