/*
 * Decompiled with CFR 0.152.
 */
package jwrapper;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.security.Security;
import jwrapper.jwutils.JWJreVerifierApp;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.network.JWNet;
import jwrapper.updater.GenericUpdater;
import utils.files.AtomicRenamer;
import utils.ostools.OS;
import utils.switches.Switches;

public class JWrapperJreCheckShim {
    public static String JRE_CHECK_NOTE = "JWAppNote-JWrapperJreCompatibilityApp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block28: {
            System.setProperty("java.util.Arrays.useLegacyMergeSort", "true");
            System.setProperty("sun.net.client.defaultConnectTimeout", "30000");
            System.setProperty("sun.net.client.defaultReadTimeout", "30000");
            try {
                Security.setProperty("networkaddress.cache.ttl", "30");
                Security.setProperty("networkaddress.cache.negative.ttl", "10");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                JWNet.tryForceHttpAgentUnrestrictive();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.out.println("[JreShim] Fetching OS archives");
            try {
                GenericUpdater.fetchOsArchive(new File(".").getCanonicalFile());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                File master = JWSystem.getMyJreHome().getParentFile();
                File[] files = master.listFiles();
                if (files != null) {
                    for (File file : files) {
                        File cacerts;
                        if (!file.getName().startsWith("JWrapper-JWrapper") || !(cacerts = new File(file, "cacerts")).exists()) continue;
                        System.out.println("[JreShim] Clearing previous cacerts: " + cacerts + " (result: " + cacerts.delete() + ")");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("[JreShim] Checking that JRE archive includes a native launcher");
            if (OS.isWindows()) {
                File nativeLauncher = JWSystem.getNativeJavaLauncher();
                System.out.println("[JreShim] Windows detected. Launcher exists? " + (nativeLauncher != null && nativeLauncher.exists()));
                if (nativeLauncher == null || !nativeLauncher.exists()) {
                    JWrapperJreCheckShim.rejectJRE();
                }
                try {
                    File jreFolder = JWSystem.getMyJreHome();
                    if (jreFolder != null && (jreFolder.getName().contains("Windows64JRE-00042108830") || jreFolder.getName().contains("Windows32JRE-00042108806"))) {
                        System.out.println("[JreShim] Old broken distribution detected.");
                        JWrapperJreCheckShim.rejectJRE();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            System.out.println("[JreShim] Checking for app JRE verifier class");
            try {
                File file = new File(JRE_CHECK_NOTE);
                if (!file.exists()) {
                    System.out.println("[JreShim] No app-specified JRE check found, refusing the JRE update");
                    JWrapperJreCheckShim.rejectJRE();
                    break block28;
                }
                FileInputStream fin = new FileInputStream(file);
                try {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] buf = new byte[50000];
                    int n = 0;
                    while (n != -1) {
                        n = fin.read(buf);
                        if (n <= 0) continue;
                        bout.write(buf, 0, n);
                    }
                    fin.close();
                    String mainClass = new String(bout.toByteArray(), "UTF8");
                    System.out.println("[JreShim] App-specified JRE check found - " + mainClass);
                    Class<?> cl = Class.forName(mainClass);
                    Method method = cl.getMethod("main", String[].class);
                    int retcode = (Integer)method.invoke(null, new Object[]{args});
                    System.out.println("[JreShim] App-specified JRE check returned " + retcode);
                    if (JWJreVerifierApp.isExitCodeNotSupported(retcode)) {
                        JWrapperJreCheckShim.rejectJRE();
                    } else {
                        System.exit(retcode);
                    }
                }
                finally {
                    try {
                        fin.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception x) {
                x.printStackTrace();
                System.out.println("[JreShim] Error in app-specified JRE check " + x + ", refusing the JRE update");
                JWrapperJreCheckShim.rejectJRE();
            }
        }
    }

    private static void rejectJRE() {
        try {
            JWrapperJreCheckShim.doDirectJreUpdate();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        JWJreVerifierApp.exitJvm_JreIsNotSupported();
    }

    public static void doDirectJreUpdate() {
        if (Switches.SH_updateJreInShimToFixPack200) {
            System.out.println("[JreShim] Attempting to update JRE directly.");
            try {
                File atomicUpdateInstructions = new File("jrechuckshim-atomicupdate");
                if (atomicUpdateInstructions.exists()) {
                    atomicUpdateInstructions.delete();
                }
                GenericUpdater.atomicUpdate = new AtomicRenamer(atomicUpdateInstructions);
                GenericUpdater.CACertsSource source = null;
                GenericUpdater.forceUpdateJreNow(source);
                GenericUpdater.atomicUpdate.performAtomicMultiRenameNow();
                JWJreVerifierApp.exitJvm_JreIsNotSupported();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            System.out.println("[JreShim] Direct JRE update disabled.");
        }
    }
}

