/*
 * Decompiled with CFR 0.152.
 */
package utils.ostools;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import utils.progtools.JavaVersionUtil;
import utils.string.CharStack;

public class OS {
    public static final int BASE_WINDOWS = 0;
    public static final int BASE_MACOS = 1;
    public static final int BASE_LINUX = 2;
    public static final int BASE_UNKNOWN = 3;
    public static final int BASE_ALL = -1;
    public static final int VARIANT_WINDOWS_VISTA = 1;
    public static final int VARIANT_UNKNOWN = 2;
    public static final int VARIANT_WINDOWS_XP = 3;
    public static final int VARIANT_WINDOWS_2003 = 4;
    public static final int VARIANT_WINDOWS_PREXP = 5;
    public static final int VARIANT_WINDOWS_8_OR_ABOVE = 6;
    public static final int VARIANT_WINDOWS_7 = 7;
    public static final int VARIANT_LINUX_X86 = 1;
    public static final int VARIANT_LINUX_ARM = 2;
    private static int[] OSXBuild = new int[]{0, 0, 0};
    public static int base_type = -1;
    public static int variant = -1;
    public static int linux_arch = -1;
    public static int mac_arch = -1;
    public static final int ARCH_32 = 1;
    public static final int ARCH_64 = 2;
    public static final String NEWLINE = System.getProperty("line.separator");
    private static Boolean isRetina = null;

    public static boolean isVariantVistaOrAbove(int variant) {
        return variant == 1 || variant == 6 || variant == 7;
    }

    public static boolean isVariantWindows8OrAbove(int variant) {
        return variant == 6;
    }

    public static boolean isVariantWindows7OrAbove(int variant) {
        return variant == 7 || variant == 6;
    }

    public static boolean isVariantWindowsXPOrAbove(int variant) {
        return OS.isVariantVistaOrAbove(variant) || variant == 3 || variant == 4;
    }

    private static int[] getMajorMinorVersionNumber(String version) {
        int[] result = new int[2];
        CharStack stack = new CharStack(version);
        result[0] = (int)stack.popInteger();
        if (stack.peek() == '.') {
            stack.pop();
            result[1] = (int)stack.popInteger();
        }
        return result;
    }

    public static void detect() {
        OS.detect(false);
    }

    public static void detect(boolean silent) {
        block53: {
            if (base_type != -1) {
                return;
            }
            String osname = System.getProperty("os.name");
            if (osname == null) {
                osname = "";
            }
            osname = osname.toLowerCase().trim();
            String osver = System.getProperty("os.version");
            if (osver == null) {
                osver = "";
            }
            osver = osver.toLowerCase().trim();
            if (osname.indexOf("win") != -1 && osname.indexOf("darwin") == -1) {
                base_type = 0;
                try {
                    int[] version = OS.getMajorMinorVersionNumber(osver);
                    if (!silent) {
                        System.out.println("[OS] Stripped version " + Arrays.toString(version));
                    }
                    if (version[0] == 6 && version[1] == 0) {
                        variant = 1;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows Vista (" + osname + ", " + osver + ")");
                        }
                    } else if (version[0] == 6 && version[1] == 1) {
                        variant = 7;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows 7 (" + osname + ", " + osver + ")");
                        }
                    } else if (version[0] >= 6) {
                        variant = 6;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows >= 8 (" + osname + ", " + osver + ")");
                        }
                    } else if (version[0] == 3 || version[0] == 4 || version[0] == 5 && version[1] == 0) {
                        variant = 5;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows < XP  (" + osname + ", " + osver + ")");
                        }
                    } else if (version[0] == 5 && osname.contains("2003")) {
                        variant = 4;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows 2003  (" + osname + ", " + osver + ")");
                        }
                    } else if (version[0] == 5) {
                        variant = 3;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows XP  (" + osname + ", " + osver + ")");
                        }
                    }
                    break block53;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (osver.startsWith("6") || osver.startsWith("7") || osver.startsWith("8") || osver.startsWith("9") || osver.startsWith("10")) {
                        if (osver.equals("6.0")) {
                            variant = 1;
                            if (!silent) {
                                System.out.println("[OS] Detected Windows Vista (" + osname + ", " + osver + ")");
                            }
                        } else if (osver.equals("6.1")) {
                            variant = 7;
                            if (!silent) {
                                System.out.println("[OS] Detected Windows 7 (" + osname + ", " + osver + ")");
                            }
                        } else {
                            variant = 6;
                            if (!silent) {
                                System.out.println("[OS] Detected Windows >= 8 (" + osname + ", " + osver + ")");
                            }
                        }
                    } else if (osver.startsWith("3") || osver.startsWith("4") || osver.startsWith("5.0")) {
                        variant = 5;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows < XP  (" + osname + ", " + osver + ")");
                        }
                    } else if (osname.contains("2003")) {
                        variant = 4;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows 2003  (" + osname + ", " + osver + ")");
                        }
                    } else {
                        variant = 3;
                        if (!silent) {
                            System.out.println("[OS] Detected Windows XP  (" + osname + ", " + osver + ")");
                        }
                    }
                    break block53;
                }
            }
            if (osname.indexOf("mac") != -1 || osname.indexOf("darwin") != -1) {
                base_type = 1;
                String[] versionSplit = osver.split("\\.");
                try {
                    for (int i = 0; i < versionSplit.length; ++i) {
                        OS.OSXBuild[i] = Integer.parseInt(versionSplit[i]);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    variant = 2;
                }
                if (!silent) {
                    System.out.println("[OS] Detected MacOS  (" + osname + ", " + osver + ")");
                }
            } else if (osname.indexOf("lin") != -1) {
                base_type = 2;
                if (OS.isARM()) {
                    variant = 2;
                    if (!silent) {
                        System.out.println("[OS] Detected Linux ARM (" + osname + ", " + osver + ")");
                    }
                } else {
                    variant = 1;
                    if (!silent) {
                        System.out.println("[OS] Detected Linux X86 (" + osname + ", " + osver + ")");
                    }
                }
            } else {
                base_type = 3;
                variant = 2;
                if (!silent) {
                    System.out.println("[OS] Detected Unknown OS (" + osname + ", " + osver + ")");
                }
            }
        }
    }

    public static boolean isWindows() {
        OS.detect();
        return base_type == 0;
    }

    public static boolean isLinux() {
        OS.detect();
        return base_type == 2;
    }

    public static boolean isMacOS() {
        OS.detect();
        return base_type == 1;
    }

    public static boolean isWindowsVistaOrAbove() {
        OS.detect();
        return OS.isWindows() && OS.isVariantVistaOrAbove(variant);
    }

    public static boolean isWindows8OrAbove() {
        OS.detect();
        return OS.isWindows() && OS.isVariantWindows8OrAbove(variant);
    }

    public static boolean isWindows7OrAbove() {
        OS.detect();
        return OS.isWindows() && OS.isVariantWindows7OrAbove(variant);
    }

    public static boolean isWindowsXpOr2003() {
        OS.detect();
        return OS.isWindows() && (variant == 3 || variant == 4);
    }

    public static boolean isWindows2003() {
        OS.detect();
        return OS.isWindows() && variant == 4;
    }

    public static boolean isWindowsPreXp() {
        OS.detect();
        return OS.isWindows() && variant == 5;
    }

    public static boolean isMacOS64bit() {
        OS.detect();
        if (!OS.isMacOS()) {
            return false;
        }
        if (mac_arch == -1) {
            String output;
            try {
                Process p = Runtime.getRuntime().exec("uname -m");
                p.getErrorStream().close();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream in = p.getInputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while (n != -1) {
                    n = in.read(buf);
                    if (n <= 0) continue;
                    bout.write(buf, 0, n);
                }
                output = new String(bout.toByteArray());
            }
            catch (Exception x) {
                try {
                    Process p = Runtime.getRuntime().exec("arch");
                    p.getErrorStream().close();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream in = p.getInputStream();
                    byte[] buf = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        n = in.read(buf);
                        if (n <= 0) continue;
                        bout.write(buf, 0, n);
                    }
                    output = new String(bout.toByteArray());
                }
                catch (Exception xx) {
                    System.out.println("[OS] Failed to detect MacOS architecture: " + xx);
                    Object output2 = null;
                    mac_arch = 2;
                    return true;
                }
            }
            output = output.toLowerCase();
            mac_arch = output.indexOf("x86_64") != -1 ? 2 : (output.indexOf("x86_64") != -1 ? 2 : 1);
        }
        return mac_arch == 2;
    }

    public static boolean isLinux64bit() {
        OS.detect();
        if (!OS.isLinux()) {
            return false;
        }
        if (linux_arch == -1) {
            String output;
            try {
                Process p = Runtime.getRuntime().exec("uname -a");
                p.getErrorStream().close();
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                InputStream in = p.getInputStream();
                byte[] buf = new byte[1024];
                int n = 0;
                while (n != -1) {
                    n = in.read(buf);
                    if (n <= 0) continue;
                    bout.write(buf, 0, n);
                }
                output = new String(bout.toByteArray());
            }
            catch (Exception x) {
                try {
                    Process p = Runtime.getRuntime().exec("arch");
                    p.getErrorStream().close();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    InputStream in = p.getInputStream();
                    byte[] buf = new byte[1024];
                    int n = 0;
                    while (n != -1) {
                        n = in.read(buf);
                        if (n <= 0) continue;
                        bout.write(buf, 0, n);
                    }
                    output = new String(bout.toByteArray());
                }
                catch (Exception xx) {
                    System.out.println("[OS] Failed to detect Linux architecture: " + xx);
                    Object output2 = null;
                    linux_arch = 2;
                    return true;
                }
            }
            output = output.toLowerCase();
            linux_arch = output.indexOf("x86_64") != -1 ? 2 : (output.indexOf("x86_64") != -1 ? 2 : 1);
        }
        return linux_arch == 2;
    }

    public static boolean isMacOS1073OrLater() {
        if (!OS.isMacOS()) {
            return false;
        }
        if (OSXBuild[0] > 10) {
            return true;
        }
        if (OSXBuild[0] < 10) {
            return false;
        }
        if (OSXBuild[1] < 7) {
            return false;
        }
        if (OSXBuild[1] > 7) {
            return true;
        }
        return OSXBuild[2] >= 3;
    }

    public static boolean isMacOS_10_8_OrLater() {
        if (!OS.isMacOS()) {
            return false;
        }
        if (OSXBuild[0] > 10) {
            return true;
        }
        if (OSXBuild[0] < 10) {
            return false;
        }
        return OSXBuild[1] >= 8;
    }

    public static boolean isMacOS_10_11_OrLater() {
        if (!OS.isMacOS()) {
            return false;
        }
        if (OSXBuild[0] > 10) {
            return true;
        }
        if (OSXBuild[0] < 10) {
            return false;
        }
        return OSXBuild[1] >= 11;
    }

    public static boolean isOSXRetina() {
        if (isRetina != null) {
            return isRetina;
        }
        if (!OS.isMacOS()) {
            return false;
        }
        String javaVersion = System.getProperty("java.version");
        boolean is1740orLater = JavaVersionUtil.isJavaVersionOrLater((int)8) || OS.compareVersionNumbers(javaVersion, "1.7.0_40") >= 0;
        isRetina = Boolean.FALSE;
        if (is1740orLater) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                GraphicsDevice device = env.getDefaultScreenDevice();
                try {
                    if (JavaVersionUtil.isJava9OrLater()) {
                        GraphicsConfiguration gfxConfig = device.getDefaultConfiguration();
                        AffineTransform transform = gfxConfig.getDefaultTransform();
                        isRetina = !transform.isIdentity();
                    } else {
                        Field field = device.getClass().getDeclaredField("scale");
                        if (field != null) {
                            field.setAccessible(true);
                            Object scale = field.get(device);
                            if (scale instanceof Integer && (Integer)scale == 2) {
                                isRetina = Boolean.TRUE;
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        if (isRetina.booleanValue()) {
            System.out.println("[OS] Retina check: yes");
        } else {
            System.out.println("[OS] Retina check: no");
        }
        return isRetina;
    }

    public static int compareVersionNumbers(String v1, String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    public static boolean isARM() {
        return System.getProperty("os.arch").toLowerCase().indexOf("arm") != -1;
    }
}

