/*
 * Decompiled with CFR 0.152.
 */
package utils.vnc.authentication;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import utils.stream.StreamUtils;
import utils.vnc.exceptions.FailedSecurityException;

public class VNCAuthentication {
    public static void authenticate(InputStream in, OutputStream out, String password) throws FailedSecurityException {
        try {
            int i;
            if (password.length() > 8) {
                password = password.substring(0, 8);
            }
            byte[] challenge = StreamUtils.readBytes((InputStream)in, (int)16);
            byte[] keyAsBytesPadded = new byte[8];
            byte[] keyBytes = password.getBytes(StandardCharsets.ISO_8859_1);
            for (i = 0; i < keyAsBytesPadded.length; ++i) {
                keyAsBytesPadded[i] = i < keyBytes.length ? keyBytes[i] : (byte)0;
            }
            for (i = 0; i < keyAsBytesPadded.length; ++i) {
                keyAsBytesPadded[i] = VNCAuthentication.reverseBits(keyAsBytesPadded[i]);
            }
            DESKeySpec keySpec = new DESKeySpec(keyAsBytesPadded);
            SecretKey generatedSecret = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
            Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
            ecipher.init(1, generatedSecret);
            byte[] encryptedData = ecipher.doFinal(challenge);
            out.write(encryptedData);
            out.flush();
        }
        catch (Exception ex) {
            System.out.println("VNC Authentication Failed.");
            throw new FailedSecurityException(ex);
        }
    }

    public static byte reverseBits(byte b) {
        int input = b & 0xFF;
        int output = 0;
        for (int i = 0; i < 8; ++i) {
            output <<= 1;
            if ((input & 1) != 0) {
                output |= 1;
            }
            input >>= 1;
        }
        return (byte)output;
    }
}

