/*
 * Decompiled with CFR 0.152.
 */
package utils.udp;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import utils.stream.StreamUtils;
import utils.switches.LocalSwitches;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPReader;
import utils.udp.bidirectional.UDPResponder;
import utils.udp.util.UDPWrapUtil;

public class Acculog
implements UDPListener {
    public static String JVM = "UnknownJVM";
    private static boolean ready = false;
    private static DatagramSocket statsock;
    private static InetAddress target;
    private static UDPWrapUtil util;
    private static Object LOCK;
    private static final int ACCULOG_PORT = 10101;
    PrintStream pout;
    long lastMessage = System.currentTimeMillis();

    public static void setJVM(String name) {
        JVM = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(String line) {
        if (!ready) {
            ready = true;
            try {
                statsock = new DatagramSocket();
                target = InetAddress.getByName(LocalSwitches.DEV_acculogHost);
                util = new UDPWrapUtil();
                LOCK = new Object();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        if (statsock != null) {
            line = "[" + JVM + "] " + line;
            try {
                Object x = LOCK;
                synchronized (x) {
                    DatagramPacket dp = util.wrap(line.getBytes(StandardCharsets.UTF_8));
                    dp.setAddress(target);
                    dp.setPort(10101);
                    statsock.send(dp);
                }
            }
            catch (Exception x) {
                System.out.println("[Acculog] Error - " + x);
            }
        }
    }

    public Acculog() throws Exception {
        DatagramSocket dsock = new DatagramSocket(10101);
        UDPReader reader = new UDPReader(new Object(), dsock, 65536, this, null);
        reader.start();
        this.pout = new PrintStream(new FileOutputStream(LocalSwitches.DEV_acculogFile));
    }

    public static void main(String[] args) throws Exception {
        Acculog log = new Acculog();
        try {
            Thread.sleep(500L);
            Acculog.log("Date: " + new Date());
            Acculog.log("Acculog is ready!");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        while (true) {
            String input = StreamUtils.readLineAsStringUTF8((InputStream)System.in);
            String marker = "\n***********************************\n ACCULOG MARKER " + new Date() + "\n***********************************\n";
            System.out.println(marker);
            log.pout.println(marker);
        }
    }

    @Override
    public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteIPAddress) {
        try {
            String line = new String(dat, StandardCharsets.UTF_8);
            long T = System.currentTimeMillis();
            long delta = T - this.lastMessage;
            this.lastMessage = T;
            String padded = "" + delta;
            while (padded.length() < 6) {
                padded = " " + padded;
            }
            String tolog = T + " +[" + padded + "] " + line;
            System.out.println(tolog);
            this.pout.println(tolog);
        }
        catch (Exception x) {
            System.out.println(x);
        }
    }
}

