/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.systemtray;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;

public class TrayNotifier {
    private Image image;
    private TrayIcon trayIcon;

    public static Dimension getTrayIconSize() {
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            return SystemTray.getSystemTray().getTrayIconSize();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public void setToolTip(String tooltip) {
        if (tooltip == null) {
            tooltip = "";
        }
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIcon.setToolTip(tooltip);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setImageAutoSize(boolean size) {
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIcon.setImageAutoSize(size);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean isSupported() {
        return SystemTray.isSupported();
    }

    public TrayNotifier(Image initialImage) throws TrayIconNotSupportedException {
        this.image = initialImage;
        try {
            if (!TrayNotifier.isSupported()) {
                throw new TrayIconNotSupportedException();
            }
            this.trayIcon = new TrayIcon(this.image);
            SystemTray.getSystemTray().add(this.trayIcon);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new TrayIconNotSupportedException();
        }
    }

    public void setPopupMenu(PopupMenu menu) {
        if (this.trayIcon != null && menu != null) {
            try {
                this.trayIcon.setPopupMenu(menu);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void removeTrayIcon() {
        if (this.trayIcon != null) {
            try {
                SystemTray.getSystemTray().remove(this.trayIcon);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void setImage(Image image) {
        this.image = image;
        if (this.trayIcon != null && image != null) {
            try {
                this.trayIcon.setImage(image);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void displayError(String string, String string2) {
        this.displayMessage(string, string2, TrayIcon.MessageType.ERROR);
    }

    public void displayWarning(String string, String string2) {
        this.displayMessage(string, string2, TrayIcon.MessageType.WARNING);
    }

    public void displayInfo(String string, String string2) {
        this.displayMessage(string, string2, TrayIcon.MessageType.INFO);
    }

    public void displayMessage(String string, String string2) {
        this.displayMessage(string, string2, TrayIcon.MessageType.NONE);
    }

    private void displayMessage(String string, String string2, TrayIcon.MessageType messageType) {
        if (this.trayIcon != null && string != null && string2 != null && messageType != null) {
            try {
                this.trayIcon.displayMessage(string, string2, messageType);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static class TrayIconNotSupportedException
    extends Exception {
    }
}

