/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.pagedproperties;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public abstract class PropertiesPanel
extends JPanel
implements MouseListener,
PageListener {
    private static final Color BORDER_COLOR = SHStyle.BORDER_COLOR;
    private static final Border empty = SHBorderFactory.createEmptyBorder((int)6, (int)6, (int)6, (int)6);
    private final Border darkLine = SHBorderFactory.createLineBorder((Color)BORDER_COLOR, (int)0);
    private final Border lightLine = SHBorderFactory.createLineBorder((Color)SHStyle.SELECTION_BACKGROUND, (int)0);
    protected JToolBar buttonPanel;
    private Dimension buttonPanelButtonSize = null;
    private final JPanel contentPanel;
    private JButton selectedButton = null;
    protected final ArrayList<PropertiesPage> panels = new ArrayList();
    protected Properties currentProperties = new Properties();

    protected void initButtonPanel() {
        this.buttonPanel = new JToolBar(1);
        this.buttonPanel.setUI(new BasicToolBarUI());
        this.buttonPanel.setRollover(true);
        this.buttonPanel.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)0, (int)1, (Color)BORDER_COLOR));
        this.buttonPanel.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.buttonPanel.setFloatable(false);
        this.buttonPanel.setVisible(false);
    }

    protected PropertiesPanel() {
        System.out.println("[PropertiesPanel] Initialising...");
        this.initButtonPanel();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new CardLayout());
        this.contentPanel.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)0, (int)0, (int)0));
        this.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)0));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.buttonPanel, "West");
        this.add((Component)this.contentPanel, "Center");
    }

    public void addPropertiesPage(String test, Icon icon, Icon errorIcon, PropertiesPage target) {
        this.panels.add(target);
        if (this.contentPanel.getComponentCount() > 0) {
            this.buttonPanel.setVisible(true);
        }
        JButton button1 = new JButton(test, icon);
        button1.setVerticalTextPosition(3);
        button1.setHorizontalTextPosition(0);
        button1.setBorder(empty);
        target.setIcon(button1, icon, errorIcon);
        button1.setUI(new BasicButtonUI(){

            @Override
            public void paint(Graphics g, JComponent c) {
                g.setColor(c.getBackground());
                g.fillRect(0, 0, c.getBounds().width, c.getBounds().height);
                super.paint(g, c);
            }
        });
        button1.addMouseListener(this);
        this.buttonPanel.add(button1);
        if (this.buttonPanelButtonSize == null || button1.getPreferredSize().width > this.buttonPanelButtonSize.width) {
            this.buttonPanelButtonSize = button1.getPreferredSize();
            for (int i = 0; i < this.buttonPanel.getComponentCount(); ++i) {
                Component component = this.buttonPanel.getComponent(i);
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(this.buttonPanelButtonSize);
                component.setMinimumSize(this.buttonPanelButtonSize);
                component.setMaximumSize(this.buttonPanelButtonSize);
            }
        } else {
            button1.setPreferredSize(this.buttonPanelButtonSize);
            button1.setMinimumSize(this.buttonPanelButtonSize);
            button1.setMaximumSize(this.buttonPanelButtonSize);
        }
        this.contentPanel.add((Component)target, button1.getText());
        if (this.contentPanel.getComponentCount() == 1) {
            this.selectButton(button1);
        } else {
            this.drawBorder(button1);
        }
        target.load(this.currentProperties);
    }

    private void selectButton(JButton button) {
        if (this.selectedButton != null) {
            if (button == this.selectedButton) {
                return;
            }
            this.selectedButton.setSelected(false);
            this.drawBorder(this.selectedButton);
            this.selectedButton.setForeground(UIManager.getColor("Button.foreground"));
        }
        button.setSelected(true);
        button.setForeground(Color.white);
        this.selectedButton = button;
        this.drawBorder(button);
        this.buttonPanel.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void drawBorder(JButton button) {
        if (button.isSelected()) {
            button.setBorder(this.lightLine);
            button.setBackground(SHStyle.SELECTION_BACKGROUND);
        } else {
            button.setBorder(empty);
            button.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        }
        button.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button;
        if (e.getSource() instanceof JButton && !(button = (JButton)e.getSource()).isSelected()) {
            button.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
            button.setBorder(this.darkLine);
            button.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        JButton button;
        if (e.getSource() instanceof JButton && !(button = (JButton)e.getSource()).isSelected()) {
            this.drawBorder(button);
            button.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JButton button = (JButton)e.getSource();
        this.selectButton(button);
        CardLayout contentCardLayout = (CardLayout)this.contentPanel.getLayout();
        contentCardLayout.show(this.contentPanel, button.getText());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void contentChanged(boolean enableSave) {
        if (enableSave) {
            boolean valid = true;
            for (PropertiesPage panel : this.panels) {
                if (panel.checkIfValid()) continue;
                valid = false;
                break;
            }
        }
    }

    public void reloadProperties() {
        this.loadProperties();
        for (PropertiesPage page : this.panels) {
            try {
                page.load(this.currentProperties);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected abstract void loadProperties();

    public abstract void saveProperties();
}

