/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.mouse;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;

public abstract class SafeMouseAdapter
extends MouseAdapter {
    private static Timer commonTimer = new Timer("MouseClicker");
    private MouseReleasedHandler handleMousePressedTask;

    public abstract void safeMouseReleased(MouseEvent var1);

    public abstract void safeMouseClicked(MouseEvent var1);

    @Override
    public final void mouseClicked(MouseEvent e) {
        if (this.handleMousePressedTask != null) {
            this.handleMousePressedTask.cancelMousePressed();
        }
        this.safeMouseClicked(e);
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        this.handleMousePressedTask = new MouseReleasedHandler(e);
        commonTimer.schedule((TimerTask)this.handleMousePressedTask, 0L);
    }

    class MouseReleasedHandler
    extends TimerTask {
        private boolean cancel = false;
        private MouseEvent e;

        public MouseReleasedHandler(MouseEvent e) {
            this.e = e;
        }

        public void cancelMousePressed() {
            this.cancel = true;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            SafeMouseAdapter.this.handleMousePressedTask = null;
            if (!this.cancel) {
                SafeMouseAdapter.this.safeMouseReleased(this.e);
            }
        }
    }
}

