/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview.mining;

import java.util.ArrayList;
import java.util.regex.Pattern;
import utils.string.FastMatch;
import utils.string.SimpleRegex;
import utils.swing.logview.LogEntry;
import utils.swing.logview.mining.LogEntity;

public class MultiLogEntity
extends LogEntity {
    boolean USE_PATTERNS = false;
    public boolean DEBUG = false;
    ArrayList<FastMatch> matches = new ArrayList();
    ArrayList<Pattern> patterns = new ArrayList();
    boolean hide = false;
    private String name;
    int matched = 0;

    public MultiLogEntity(String name, String[] regex, boolean hide) {
        this(name, regex, hide, null);
    }

    public MultiLogEntity(String name, String[] regex, boolean hide, LogEntity parent) {
        this.name = name;
        this.hide = hide;
        this.parent = parent;
        for (String reg : regex) {
            this.add(reg);
        }
        if (!hide) {
            this.enabled = false;
        }
    }

    public MultiLogEntity(String name, boolean hide) {
        this.name = name;
        this.hide = hide;
        if (!hide) {
            this.enabled = false;
        }
    }

    public void add(String regex) {
        if (this.USE_PATTERNS) {
            if (!regex.contains("*")) {
                System.out.println(this.getName() + " pattern *" + regex + "*");
                this.patterns.add(SimpleRegex.simpleToPattern("*" + regex + "*", false));
            } else {
                System.out.println(this.getName() + " pattern " + regex);
                this.patterns.add(SimpleRegex.simpleToPattern(regex, false));
            }
        } else {
            if (!regex.startsWith("*")) {
                regex = "*" + regex;
            }
            if (!regex.endsWith("*")) {
                regex = regex + "*";
            }
            this.matches.add(new FastMatch(regex, true));
        }
    }

    public void setHide(boolean b) {
        this.hide = b;
    }

    @Override
    public String getName() {
        if (this.hide) {
            return "(Hide) " + this.name;
        }
        return this.name;
    }

    @Override
    public boolean matchesLine(LogEntry entry) {
        if (this.USE_PATTERNS) {
            for (Pattern pattern : this.patterns) {
                if (!pattern.matcher(entry.value).matches()) continue;
                return true;
            }
        } else {
            for (FastMatch match : this.matches) {
                if (this.DEBUG) {
                    System.out.println("Matching against " + match + ": " + entry.getLowercase());
                }
                if (!match.matchesLowercase(entry.getLowercase())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isHideFilter() {
        return this.hide;
    }

    public boolean equals(Object o) {
        if (o instanceof MultiLogEntity) {
            MultiLogEntity ent = (MultiLogEntity)o;
            return ent.name.equals(this.name);
        }
        return false;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile(".*JWrapperLaunchProperty.*");
        System.out.println(pattern);
        System.out.println(SimpleRegex.simpleToRegex("*JWrapperLaunchProperty*"));
        System.out.println(pattern.matcher("[JWrapperLaunchProperty] jwdyna_app_dir=[C:\\ProgramData\\JWrapper-Remote Access\\JWrapper-JWrapper-00044117588-complete]").matches());
        System.out.println(SimpleRegex.simpleToPattern("*JWrapperLaunchProperty*", false).matcher("[JWrapperLaunchProperty] jwdyna_app_dir=[C:\\ProgramData\\JWrapper-Remote Access\\JWrapper-JWrapper-00044117588-complete]").matches());
    }
}

