/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.logview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import utils.swing.JTextLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.icons.colorproviders.PastelColorProvider;
import utils.swing.logview.LogModel;

public class LogRenderer
extends DefaultTableCellRenderer {
    Color bgwhite = new Color(250, 250, 250);
    static Color bgdark = new Color(80, 80, 80);
    static Color bgwarn = new Color(161, 137, 20);
    static Color bgbad = new Color(190, 62, 39);
    static Color bgages = new Color(130, 62, 130);
    Font tablefont = new Font("monospaced", 0, 11);
    JScrollPane master;
    JTable table;
    JTextLabel normal = new JTextLabel("");
    boolean shading = true;
    JTextLabel overwrite = new JTextLabel(""){

        @Override
        public void paintComponent(Graphics g) {
            this.setSize(new Dimension(LogRenderer.this.table.getWidth() - this.getLocation().x, this.getSize().height));
            Rectangle clip = g.getClipBounds();
            clip.width = LogRenderer.this.table.getWidth() - this.getLocation().x;
            g.setClip(clip);
            super.paintComponent(g);
        }
    };

    public LogRenderer(JScrollPane master, JTable table) {
        this.master = master;
        this.table = table;
        this.normal.setFont(table.getFont());
        this.overwrite.setFont(table.getFont());
        table.setBackground(this.bgwhite);
    }

    public void setShadingEnabled(boolean b) {
        this.shading = b;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean hasData;
        LogModel model = (LogModel)table.getModel();
        JLabel orig = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        String text = orig.getText();
        JTextLabel label = this.normal;
        int twidth = table.getWidth();
        boolean bl = hasData = text.length() > 0 && !text.equals("...");
        if (column == 0) {
            label.setOpaque(true);
        } else if (hasData) {
            label = this.overwrite;
            label.setOpaque(true);
        } else {
            label.setOpaque(false);
        }
        label.setFont(this.tablefont);
        Highlighter high = label.getHighlighter();
        high.removeAllHighlights();
        label.setText(text);
        label.setForeground(Color.black);
        label.setBackground(this.bgwhite);
        label.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)2, (int)0, (int)0));
        if (column == 0) {
            if (label.getText().length() > 0) {
                label.setText(row + "  +" + label.getText());
            } else {
                label.setText(row + "");
            }
            boolean isCT = model.isCentralTime(row);
            label.setBackground(bgdark);
            label.setForeground(Color.white);
            if (text.indexOf("sec") != -1) {
                label.setBackground(bgwarn);
            } else if (text.indexOf("min") != -1) {
                label.setBackground(bgbad);
            } else if (text.indexOf("hr") != -1) {
                label.setBackground(bgages);
            } else if (text.indexOf("day") != -1) {
                label.setBackground(bgages);
            }
            if (!isCT) {
                label.setBorder(new LineBorder(SHStyle.ERROR_TEXT_COLOR, 1));
            }
        } else if (hasData) {
            if (isSelected) {
                label.setBackground(bgdark);
                label.setForeground(Color.white);
            } else if (!this.shading) {
                label.setBackground(new Color(255, 255, 255));
            } else {
                double similarity = model.calculateSimilarity(row);
                similarity *= 255.0;
                if ((similarity -= 60.0) < 0.0) {
                    similarity = 0.0;
                }
                int simcol = (int)similarity;
                label.setBackground(new Color(255 - simcol, 255 - simcol, 255 - simcol));
            }
            String search = label.getText();
            search = search.toLowerCase();
            ArrayList<String> ans = model.getAnnotations();
            for (String note : ans) {
                System.out.println("Searching for " + note);
                note = note.toLowerCase();
                int start = search.indexOf(note);
                int end = start + note.length();
                if (start == -1) continue;
                try {
                    high.addHighlight(start, end, new DefaultHighlighter.DefaultHighlightPainter(new PastelColorProvider(note).nextColor()));
                    System.out.println("Added highlighter " + start + ", " + end);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        return label;
    }
}

