/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.keysample;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JButton;

public class KeySampleButton
extends JButton
implements ActionListener,
KeyListener {
    String instructionText;
    String pressToSampleText;
    String sampledText;
    int keycode = 0;
    private ArrayList<ActionListener> keyPressedListeners = new ArrayList();

    public static String getUsKeyNameForKeycode(int keycode) {
        Field[] fields = KeyEvent.class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                if (((Number)fields[i].get(null)).intValue() != keycode) continue;
                String text = fields[i].getName();
                if (text.startsWith("VK_")) {
                    text = text.substring(3);
                }
                text = text.replace('_', ' ').trim();
                text = text.toLowerCase();
                char[] cs = text.toCharArray();
                boolean upper = false;
                for (int k = 0; k < cs.length; ++k) {
                    if (k == 0) {
                        cs[k] = Character.toUpperCase(cs[k]);
                    }
                    if (upper) {
                        cs[k] = Character.toUpperCase(cs[k]);
                        upper = false;
                    }
                    if (cs[k] != ' ') continue;
                    upper = true;
                }
                return new String(cs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "?";
    }

    public KeySampleButton() {
        this("Click to enter a key", "Press any key...", "Key Code: ");
    }

    public KeySampleButton(String instructionText, String pressToSampleText, String sampledText) {
        this.instructionText = instructionText;
        this.pressToSampleText = pressToSampleText;
        this.sampledText = sampledText;
        this.setText(instructionText);
        this.addActionListener(this);
    }

    public void addKeyPressedActionListener(ActionListener listener) {
        this.keyPressedListeners.add(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.addKeyListener(this);
        this.setText(this.pressToSampleText);
    }

    public int getSampledKeycode() {
        return this.keycode;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.removeKeyListener(this);
        this.keycode = e.getKeyCode();
        this.setText(this.sampledText + "" + this.keycode + " (US " + KeySampleButton.getUsKeyNameForKeycode(this.keycode) + ")");
        for (ActionListener listener : this.keyPressedListeners) {
            listener.actionPerformed(null);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

