/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class PNGChunkRemover {
    private static final long SIGNATURE = -8552249625308161526L;
    private static final int IHDR = 1229472850;
    private static final int IDAT = 1229209940;
    private static final int IEND = 1229278788;
    private static final int PLTE = 1347179589;
    private static String[] KEYS = new String[]{"TRNS", "GAMA", "CHRM", "SRGB", "ICCP", "TEXT", "ZTXT", "ITXT", "BKGD", "PHYS", "SBIT", "SPLT", "HIST", "TIME"};
    private static int[] VALUES = new int[]{1951551059, 1732332865, 1665684045, 1934772034, 1766015824, 1950701684, 2052348020, 1767135348, 1649100612, 1883789683, 1933723988, 1934642260, 1749635924, 1950960965};
    private static HashMap TRUNK_TYPES = new HashMap(){
        {
            for (int i = 0; i < KEYS.length; ++i) {
                this.put(KEYS[i], new Integer(VALUES[i]));
            }
        }
    };
    private static HashMap REVERSE_TRUNK_TYPES = new HashMap(){
        {
            for (int i = 0; i < KEYS.length; ++i) {
                this.put(new Integer(VALUES[i]), KEYS[i]);
            }
        }
    };
    private static Set REMOVABLE = new HashSet();

    public static void remove(InputStream is, OutputStream out) throws Exception {
        REMOVABLE = REVERSE_TRUNK_TYPES.keySet();
        int data_len = 0;
        int chunk_type = 0;
        byte[] buf = null;
        DataOutputStream ds = new DataOutputStream(out);
        long signature = PNGChunkRemover.readLong(is);
        if (signature != -8552249625308161526L) {
            System.out.println("[PNGChunkRemover] --- NOT A PNG IMAGE ---");
            return;
        }
        ds.writeLong(-8552249625308161526L);
        if (PNGChunkRemover.readInt(is) != 13 || PNGChunkRemover.readInt(is) != 1229472850) {
            System.out.println("[PNGChunkRemover] --- NOT A PNG IMAGE ---");
            return;
        }
        ds.writeInt(13);
        ds.writeInt(1229472850);
        buf = new byte[17];
        is.read(buf, 0, 17);
        ds.write(buf);
        while (true) {
            data_len = PNGChunkRemover.readInt(is);
            chunk_type = PNGChunkRemover.readInt(is);
            if (chunk_type == 1229278788) break;
            if (REMOVABLE.contains(new Integer(chunk_type))) {
                System.out.println("[PNGChunkRemover] Processed chunk " + REVERSE_TRUNK_TYPES.get(new Integer(chunk_type)));
                is.skip(data_len + 4);
                continue;
            }
            buf = new byte[data_len + 4];
            is.read(buf, 0, data_len + 4);
            ds.writeInt(data_len);
            ds.writeInt(chunk_type);
            ds.write(buf);
        }
        ds.writeInt(data_len);
        ds.writeInt(1229278788);
        int crc = PNGChunkRemover.readInt(is);
        ds.writeInt(crc);
        is.close();
        ds.close();
    }

    private static int readInt(InputStream is) throws Exception {
        byte[] buf = new byte[4];
        int bytes_read = is.read(buf, 0, 4);
        if (bytes_read < 0) {
            return 1229278788;
        }
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    private static long readLong(InputStream is) throws Exception {
        byte[] buf = new byte[8];
        int bytes_read = is.read(buf, 0, 8);
        if (bytes_read < 0) {
            return 1229278788L;
        }
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    public static void main(String[] args) throws Exception {
        args = new String[]{new File("/Users/gchristelis/Desktop/image.png").getAbsolutePath(), "all"};
        if (args.length > 0) {
            File[] files = new File[]{new File(args[0])};
            File dir = new File(".");
            if (files[0].isDirectory()) {
                dir = files[0];
                files = files[0].listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.getName().toLowerCase().endsWith("png");
                    }
                });
            }
            if (args.length > 1) {
                FileInputStream fs = null;
                if (args[1].equalsIgnoreCase("all")) {
                    REMOVABLE = REVERSE_TRUNK_TYPES.keySet();
                } else {
                    String key = "";
                    for (int i = 1; i < args.length; ++i) {
                        key = args[i].toUpperCase();
                        if (!TRUNK_TYPES.containsKey(key)) continue;
                        REMOVABLE.add(TRUNK_TYPES.get(key));
                    }
                }
                for (int i = files.length - 1; i >= 0; --i) {
                    String outFileName = files[i].getName();
                    outFileName = outFileName.substring(0, outFileName.lastIndexOf(46)) + "_slim.png";
                    System.out.println("<<" + files[i].getName());
                    fs = new FileInputStream(files[i]);
                    PNGChunkRemover.remove(fs, new FileOutputStream(new File(dir, outFileName)));
                    System.out.println(">>" + outFileName);
                    System.out.println("************************");
                }
            }
        }
    }
}

