/*
 * Decompiled with CFR 0.152.
 */
package utils.swing.images;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import utils.swing.images.ImageHelper;

public class ColorSnapFilter
extends RGBImageFilter {
    int levels;

    public ColorSnapFilter(int mod) {
        this.levels = mod;
    }

    @Override
    public int filterRGB(int x, int y, int rgb) {
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        red -= red % this.levels;
        green -= green % this.levels;
        blue -= blue % this.levels;
        return rgb & 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static void main(String[] args) throws Exception {
        BufferedImage msplash = ImageHelper.scaleDownToFitInside((BufferedImage)ImageIO.read(new File("mushroom.png")), (int)300, (int)200);
        int width = msplash.getWidth();
        ImageHelper.applyReplacingFilter((BufferedImage)msplash, (Rectangle)new Rectangle(0, 0, msplash.getWidth(), msplash.getHeight()), (ImageFilter)new ColorSnapFilter(16));
        msplash = ImageHelper.toBufferedImageType((Image)msplash, (int)4);
        ImageIO.write((RenderedImage)msplash, "JPEG", new File("mushroom-colorsnapped.jpg"));
        System.out.println(new File("mushroom-colorsnapped.jpg").length());
    }
}

